/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRootItem;

public class DTreeRangeSet
implements Cloneable {
    private DTreeRange[] _ranges;
    private int _itemCount;

    public final void addRange(DTreeRange dTreeRange) {
        DTreeRange[] dTreeRangeArray = new DTreeRange[]{dTreeRange};
        this.addRanges(dTreeRangeArray);
    }

    public void addRanges(DTreeRange[] dTreeRangeArray) {
        int n;
        DTreeRange[] dTreeRangeArray2 = null;
        int n2 = 0;
        int n3 = n = dTreeRangeArray == null ? 0 : dTreeRangeArray.length;
        if (this._ranges == null) {
            dTreeRangeArray2 = dTreeRangeArray;
            n2 = n;
        } else {
            int n4 = this.getCount();
            n2 = n + n4;
            dTreeRangeArray2 = new DTreeRange[n2];
            System.arraycopy(dTreeRangeArray, 0, dTreeRangeArray2, 0, n);
            System.arraycopy(this._ranges, 0, dTreeRangeArray2, n, this._ranges.length);
        }
        dTreeRangeArray2 = this._normalizeRanges(dTreeRangeArray2, n2);
        this._ranges = dTreeRangeArray2;
        this._itemCount = this._countItems();
    }

    public Object clone() {
        DTreeRangeSet dTreeRangeSet = new DTreeRangeSet();
        dTreeRangeSet.addRanges(this._ranges);
        return dTreeRangeSet;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTreeRangeSet)) {
            return false;
        }
        DTreeRangeSet dTreeRangeSet = (DTreeRangeSet)object;
        if (dTreeRangeSet.getCount() != this.getCount()) {
            return false;
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            if (this._ranges[i].equals(dTreeRangeSet.getRange(i))) continue;
            return false;
        }
        return true;
    }

    public final DTreeItem[] getAncestorItems() {
        return this.getAncestorRanges().getItems();
    }

    public final DTreeRangeSet getAncestorRanges() {
        Object object;
        int n = this.getCount();
        Object object2 = new DTreeRange[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            object = this.getRange(i);
            DTreeItem dTreeItem = ((DTreeRange)object).getParent();
            boolean bl = false;
            for (int j = 0; j < i; ++j) {
                if (!this.getRange(j).isItemDescendent(dTreeItem)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object2[n2++] = object;
        }
        if (((DTreeRange[])object2).length > n2) {
            object = new DTreeRange[n2];
            System.arraycopy(object2, 0, object, 0, n2);
            object2 = object;
        }
        object = new DTreeRangeSet();
        ((DTreeRangeSet)object).addRanges((DTreeRange[])object2);
        return object;
    }

    public int getCount() {
        return this._ranges == null ? 0 : this._ranges.length;
    }

    public final DTreeItem getFirstItem() {
        if (this.getItemCount() == 0) {
            return null;
        }
        DTreeRange dTreeRange = this.getRange(0);
        return dTreeRange.getParent().getItem(dTreeRange.getStartIndex());
    }

    public final int getItemCount() {
        return this._itemCount;
    }

    public final DTreeItem[] getItems() {
        DTreeItem[] dTreeItemArray;
        DTreeItem[] dTreeItemArray2 = new DTreeItem[1];
        int n = 0;
        for (int i = 0; i < this.getCount(); ++i) {
            dTreeItemArray = this.getRange(i);
            DTreeItem dTreeItem = dTreeItemArray.getParent();
            int n2 = dTreeItemArray.getStartIndex();
            int n3 = dTreeItemArray.getCount();
            int n4 = n2;
            while (n4 < n2 + n3) {
                DTreeItem dTreeItem2 = dTreeItem.getItem(n4);
                if (n == dTreeItemArray2.length) {
                    DTreeItem[] dTreeItemArray3 = new DTreeItem[n * 2];
                    System.arraycopy(dTreeItemArray2, 0, dTreeItemArray3, 0, n);
                    dTreeItemArray2 = dTreeItemArray3;
                }
                dTreeItemArray2[n] = dTreeItem2;
                ++n4;
                ++n;
            }
        }
        if (n < dTreeItemArray2.length) {
            dTreeItemArray = new DTreeItem[n];
            System.arraycopy(dTreeItemArray2, 0, dTreeItemArray, 0, n);
            dTreeItemArray2 = dTreeItemArray;
        }
        return dTreeItemArray2;
    }

    public DTreeRange getRange(int n) {
        return this._ranges[n];
    }

    public final boolean isItemDescendent(DTreeItem dTreeItem) {
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getRange(i).isItemDescendent(dTreeItem)) continue;
            return true;
        }
        return false;
    }

    void __itemsAdded(DTreeItem dTreeItem, int n, int n2) {
        int n3 = this.getCount();
        DTreeRange[] dTreeRangeArray = new DTreeRange[n3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            DTreeRange dTreeRange = this.getRange(i);
            DTreeItem dTreeItem2 = dTreeRange.getParent();
            if (dTreeItem == dTreeItem2 && (n4 = dTreeRange.getStartIndex()) >= n) {
                dTreeRange = new DTreeRange(dTreeItem, n4 + n2, dTreeRange.getCount());
            }
            dTreeRangeArray[i] = dTreeRange;
        }
        this._ranges = null;
        this.addRanges(dTreeRangeArray);
    }

    void __itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
        DTreeRange[] dTreeRangeArray;
        int n3 = n + n2 - 1;
        DTree dTree = dTreeItem.getTree();
        DTreeRootItem dTreeRootItem = dTree.getRoot();
        int n4 = this.getCount();
        DTreeRange[] dTreeRangeArray2 = new DTreeRange[n4];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            dTreeRangeArray = this.getRange(i);
            DTreeItem dTreeItem2 = dTreeRangeArray.getParent();
            if (dTreeItem2 == dTreeItem) {
                int n6;
                int n7 = dTreeRangeArray.getStartIndex();
                int n8 = n7 + (n6 = dTreeRangeArray.getCount()) - 1;
                if (n > n8) {
                    dTreeRangeArray2[n5++] = dTreeRangeArray;
                    continue;
                }
                if (n3 < n7) {
                    dTreeRangeArray2[n5++] = new DTreeRange(dTreeItem, n7 - n2, n6);
                    continue;
                }
                if (n <= n7) {
                    if (n3 >= n8) continue;
                    dTreeRangeArray2[n5++] = new DTreeRange(dTreeItem, n, n8 - n3);
                    continue;
                }
                int n9 = n - n7;
                if (n3 < n8) {
                    n9 += n8 - n3;
                }
                dTreeRangeArray2[n5++] = new DTreeRange(dTreeItem, n7, n9);
                continue;
            }
            if (dTreeItem2.getTree() == null || !DTree.isItemDescendent(dTreeItem2, dTreeRootItem)) continue;
            dTreeRangeArray2[n5++] = dTreeRangeArray;
        }
        if (n5 < dTreeRangeArray2.length) {
            dTreeRangeArray = new DTreeRange[n5];
            System.arraycopy(dTreeRangeArray2, 0, dTreeRangeArray, 0, n5);
            dTreeRangeArray2 = dTreeRangeArray;
        }
        this._ranges = null;
        this.addRanges(dTreeRangeArray2);
    }

    private DTreeRange[] _normalizeRanges(DTreeRange[] dTreeRangeArray, int n) {
        Object object;
        int n2;
        DTreeRange[] dTreeRangeArray2 = new DTreeRange[n];
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n4;
            object = dTreeRangeArray[n2];
            DTreeItem dTreeItem = ((DTreeRange)object).getParent();
            for (n4 = 0; n4 < n3; ++n4) {
                DTreeRange dTreeRange = dTreeRangeArray2[n4];
                DTreeItem dTreeItem2 = dTreeRange.getParent();
                if (dTreeItem == dTreeItem2) {
                    if (((DTreeRange)object).getStartIndex() >= dTreeRange.getStartIndex()) continue;
                    System.arraycopy(dTreeRangeArray2, n4, dTreeRangeArray2, n4 + 1, n3 - n4);
                    dTreeRangeArray2[n4] = object;
                    ++n3;
                    break;
                }
                if (!DTree.isItemBefore(dTreeItem, dTreeItem2)) continue;
                System.arraycopy(dTreeRangeArray2, n4, dTreeRangeArray2, n4 + 1, n3 - n4);
                dTreeRangeArray2[n4] = object;
                ++n3;
                break;
            }
            if (n4 != n3) continue;
            dTreeRangeArray2[n4] = object;
            ++n3;
        }
        n2 = 0;
        while (n2 < n3) {
            DTreeRange dTreeRange = dTreeRangeArray2[n2];
            object = dTreeRange.getParent();
            int n5 = dTreeRange.getStartIndex();
            int n6 = dTreeRange.getCount();
            if (n6 <= 0) {
                System.arraycopy(dTreeRangeArray2, n2 + 1, dTreeRangeArray2, n2, n3 - (n2 + 1));
                --n3;
                continue;
            }
            int n7 = n2 + 1;
            while (n7 < n3 && object == dTreeRangeArray2[n7].getParent()) {
                DTreeRange dTreeRange2 = dTreeRangeArray2[n7];
                int n8 = dTreeRange2.getStartIndex();
                int n9 = dTreeRange2.getCount();
                if (n8 > n5 + n6) break;
                n6 = Math.max(n6, n8 + n9 - n5);
                dTreeRangeArray2[n2] = new DTreeRange((DTreeItem)object, n5, n6);
                System.arraycopy(dTreeRangeArray2, n7 + 1, dTreeRangeArray2, n7, n3 - (n7 + 1));
                --n3;
            }
            ++n2;
        }
        if (n3 < dTreeRangeArray2.length) {
            DTreeRange[] dTreeRangeArray3 = new DTreeRange[n3];
            System.arraycopy(dTreeRangeArray2, 0, dTreeRangeArray3, 0, n3);
            dTreeRangeArray2 = dTreeRangeArray3;
        }
        return dTreeRangeArray2;
    }

    private int _countItems() {
        int n = 0;
        int n2 = this.getCount();
        for (int i = 0; i < n2; ++i) {
            DTreeRange dTreeRange = this.getRange(i);
            n += dTreeRange.getCount();
        }
        return n;
    }
}

