/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dateEditor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.access.OracleAccessibleRole;
import oracle.ewt.button.SpinAccelerator;
import oracle.ewt.button.SpinButton;
import oracle.ewt.button.SpinButtonEvent;
import oracle.ewt.button.SpinButtonListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.DateEditorUI;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;

public class DateEditor
extends LWContainer {
    public static final String PROPERTY_DATE = "date";
    static final String _RESOURCE_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    static final String _INCREMENT_KEY = "INCREMENT";
    static final String _DECREMENT_KEY = "DECREMENT";
    static final String _LEFT_KEY = "NAVIGATE_LEFT";
    static final String _RIGHT_KEY = "NAVIGATE_RIGHT";
    static final String _AM_PM_KEY = "AM_PM";
    static final String _ZONE_OFFSET_KEY = "ZONE_OFFSET";
    static final String _YEAR_KEY = "YEAR";
    static final String _MONTH_KEY = "MONTH";
    static final String _DAY_OF_MONTH_KEY = "DAY_OF_MONTH";
    static final String _HOUR_OF_DAY_KEY = "HOUR_OF_DAY";
    static final String _MINUTE_KEY = "MINUTE";
    static final String _SECOND_KEY = "SECOND";
    static final String _MILLISECOND_KEY = "MILLISECOND";
    static final String _DAY_OF_WEEK_KEY = "DAY_OF_WEEK";
    private static final int _AM_PM = 0;
    private static final int _ZONE = 1;
    private static final int _YEAR = 2;
    private static final int _MONTH = 3;
    private static final int _DAY = 4;
    private static final int _HOUR_OF_DAY0 = 5;
    private static final int _HOUR1 = 6;
    private static final int _MINUTE = 7;
    private static final int _SECOND = 8;
    private static final int _MILLISECOND = 9;
    private static final int _HOUR_OF_DAY1 = 10;
    private static final int _HOUR0 = 11;
    private static final int _DAY_OF_WEEK = 12;
    private static int[] _constantArray;
    private static final int[] _DATE_FORMAT_ARRAY;
    private static final int[] _CALENDAR_ARRAY;
    private static final int _LEFT_MARGIN = 2;
    private static final int _GAP = 1;
    private PropertyChangeSupport _propertySupport;
    private Calendar _calendar;
    private DateFormat _dateFormat;
    private Date _date;
    private Date _maximum;
    private Date _minimum;
    private SpinButton _spinButton;
    private int _currentField;
    private int _fieldCount;
    private int[] _fields = new int[13];
    private int[] _formatFields = new int[13];
    private int _textXOffset;
    private boolean _defaultDateFormat;
    private boolean _defaultCalendar;
    private boolean _nullDate;

    public DateEditor() {
        this(new Date());
    }

    public DateEditor(Date date) {
        this(date, Calendar.getInstance(), DateFormat.getInstance());
        this._defaultDateFormat = true;
        this._defaultCalendar = true;
    }

    public DateEditor(Date date, Calendar calendar, DateFormat dateFormat) {
        if (!(dateFormat instanceof SimpleDateFormat)) {
            throw new IllegalArgumentException("DateFormat must be a SimpleDateFormat");
        }
        this._nullDate = date == null;
        this._calendar = calendar;
        this._dateFormat = dateFormat;
        this._date = date;
        if (!this._nullDate) {
            this._calendar.setTime(date);
        }
        this._dateFormat.setCalendar(calendar);
        this._spinButton = new SpinButton(true, false);
        this._spinButton.addSpinButtonListener(new SpinListener());
        this.setLayout(null);
        this.add(this._spinButton);
        this._currentField = -1;
        this._parseDateFormat();
        long l = 28L;
        this.enableEvents(l);
    }

    public Object getUIClassID() {
        return "DateEditorUI";
    }

    public void setCalendar(Calendar calendar) {
        Date date;
        Date date2 = date = this._calendar == null ? null : this._calendar.getTime();
        if (calendar == null) {
            calendar = Calendar.getInstance(this._getLocale());
            this._defaultCalendar = true;
        } else {
            this._defaultCalendar = false;
        }
        this._setCalendar(calendar);
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", date, this._date);
        }
    }

    public Calendar getCalendar() {
        return this._calendar;
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateTimeInstance(3, 3, this._getLocale());
            this._defaultDateFormat = true;
        } else {
            this._defaultDateFormat = false;
        }
        this._setDateFormat(dateFormat);
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public void setDate(Date date) {
        AccessibleContext accessibleContext;
        this._nullDate = date == null;
        Date date2 = this._date;
        this._date = date;
        if (!this._nullDate) {
            this._date = this._checkMinMax(this._date, true);
        }
        if ((accessibleContext = this.accessAccessibleContext()) != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", date2, this._date);
        }
        this._firePropertyChanged(PROPERTY_DATE, date2, this._date);
        this.repaint();
    }

    public Date getDate() {
        return this._date;
    }

    public void setMinimumDate(Date date) {
        Date date2 = this._minimum;
        this._minimum = date;
        if (this._minimum != null && this._maximum != null && this._minimum.after(this._maximum)) {
            this._minimum = this._maximum;
        }
        this._firePropertyChanged("minimumDate", date2, this._minimum);
        this.setDate(this._date);
    }

    public Date getMinimumDate() {
        return this._minimum;
    }

    public void setMaximumDate(Date date) {
        Date date2 = this._maximum;
        this._maximum = date;
        if (this._maximum != null && this._minimum != null && this._maximum.before(this._minimum)) {
            this._maximum = this._minimum;
        }
        this._firePropertyChanged("maximumDate", date2, this._maximum);
        this.setDate(this._date);
    }

    public Date getMaximumDate() {
        return this._maximum;
    }

    public String getDateString() {
        return this._nullDate ? null : this.getDateFormat().format(this.getDate());
    }

    public void setDateString(String string) throws ParseException {
        this.setDate(this.getDateFormat().parse(string));
    }

    public Dimension getPreferredSize() {
        DateEditorUI dateEditorUI = (DateEditorUI)this.getUI();
        Painter painter = dateEditorUI.getTextPainter(this);
        Dimension dimension = painter.getPreferredSize(this.getPaintContext());
        Dimension dimension2 = this._spinButton.getPreferredSize();
        dimension.width += 10;
        ImmInsets immInsets = this.getBorderInsets();
        ImmInsets immInsets2 = dateEditorUI.getSpinButtonInsets(this);
        int n = immInsets.top + immInsets.bottom;
        return new Dimension(dimension2.width + dimension.width + 1 + immInsets.left + immInsets.right + immInsets2.left + immInsets2.right, Math.max(dimension.height + n, dimension2.height + n + immInsets2.top + immInsets2.bottom));
    }

    public Dimension getMinimumSize() {
        DateEditorUI dateEditorUI = (DateEditorUI)this.getUI();
        Painter painter = dateEditorUI.getTextPainter(this);
        Dimension dimension = painter.getMinimumSize(this.getPaintContext());
        Dimension dimension2 = this._spinButton.getMinimumSize();
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        dimension.width += dimension2.width;
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width *= 2;
        return dimension;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._spinButton.setEnabled(bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected Date getDefaultDate() {
        return new Date();
    }

    public int getRepaintFlags() {
        return super.getRepaintFlags() | 1 | 4 | 0x20 | 0x80 | 0x100 | 0x200 | 0x4000 | 0x400;
    }

    public int getInvalidateFlags() {
        return super.getRepaintFlags() | 0x4000 | 0x80;
    }

    public void paintInterior(Graphics graphics) {
        DateEditorUI dateEditorUI = (DateEditorUI)this.getUI();
        this._paintText(graphics, dateEditorUI.getTextPainter(this));
        if (this._currentField != -1 && this.isEnabled()) {
            this._paintCurrentField(graphics);
        }
    }

    public void doLayout() {
        Dimension dimension = this.getInnerSize();
        Dimension dimension2 = this._spinButton.getPreferredSize();
        DateEditorUI dateEditorUI = (DateEditorUI)this.getUI();
        ImmInsets immInsets = this.getBorderInsets();
        ImmInsets immInsets2 = dateEditorUI.getSpinButtonInsets(this);
        int n = dimension.height - (immInsets2.top + immInsets2.bottom);
        int n2 = this._spinButton.getPreferredSize().width - (immInsets2.left + immInsets2.right);
        if (this.getActualReadingDirection() == 1) {
            this._spinButton.setBounds(dimension.width - dimension2.width + immInsets.left + immInsets2.left, immInsets2.top + immInsets.top, n2, n);
            this._textXOffset = 2;
        } else {
            this._spinButton.setBounds(immInsets.left + immInsets2.left, immInsets2.top + immInsets.top, n2, n);
            this._textXOffset = immInsets2.left + n2 + 2;
        }
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        if (this._defaultCalendar) {
            Calendar calendar = Calendar.getInstance(locale);
            boolean bl = this._nullDate;
            if (!bl) {
                calendar.setTime(this.getDate());
            }
            this._setCalendar(calendar);
            this._nullDate = bl;
        }
        if (this._defaultDateFormat) {
            this._setDateFormat(DateFormat.getDateTimeInstance(3, 3, locale));
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (mouseEvent.getID() != 501 || !InputEventUtils.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.requestFocus();
        int n = this._getFieldAt(mouseEvent.getX());
        if (n != -1) {
            this._setCurrentField(n);
            if (this.hasFocus()) {
                this.repaint();
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        int n = keyEvent.getID();
        int n2 = keyEvent.getKeyCode();
        if (n == 401 && n2 != 38 && n2 != 40) {
            this._spinButton.setIncrementArmed(false);
            this._spinButton.setDecrementArmed(false);
        }
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (keyEvent.isAltDown()) {
            return;
        }
        if (n == 401) {
            this._processKeyPressed(keyEvent);
        } else if (n == 400) {
            this._processKeyTyped(keyEvent);
        } else if (n == 402) {
            this._processKeyReleased(keyEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        AccessibleContext accessibleContext;
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            this._spinButton.setIncrementArmed(false);
            this._spinButton.setDecrementArmed(false);
        }
        if ((accessibleContext = this.accessAccessibleContext()) != null) {
            accessibleContext.firePropertyChange("AccessibleState", this.hasFocus() ? AccessibleState.FOCUSED : null, this.hasFocus() ? null : AccessibleState.FOCUSED);
            if (this._currentField != -1) {
                accessibleContext.getAccessibleChild(this._currentField).getAccessibleContext().firePropertyChange("AccessibleState", this.hasFocus() ? AccessibleState.FOCUSED : null, this.hasFocus() ? null : AccessibleState.FOCUSED);
            }
        }
        if (this._nullDate) {
            this._resetDate();
        }
        if (this._currentField == -1) {
            this._setCurrentField(0);
        }
    }

    protected Object getPaintData(Object object) {
        if ("GapX".equals(object)) {
            Rectangle rectangle = this._spinButton.getBounds();
            if (this.getActualReadingDirection() == 1) {
                return IntegerUtils.getInteger((int)(rectangle.x - 1));
            }
            return IntegerUtils.getInteger((int)(rectangle.x + rectangle.width));
        }
        if (object == PaintContext.LABEL_KEY) {
            return this.getDateString();
        }
        return super.getPaintData(object);
    }

    void rollCurrentField(boolean bl) {
        if (this._nullDate) {
            return;
        }
        if (this._currentField == -1) {
            this._setCurrentField(0);
        }
        int n = this._fields[this._currentField];
        Calendar calendar = this.getCalendar();
        Integer n2 = IntegerUtils.getInteger((int)calendar.get(n));
        boolean bl2 = this._isIntegerField(this._currentField);
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        AccessibleContext accessibleContext2 = accessibleContext == null ? null : accessibleContext.getAccessibleChild(this._currentField).getAccessibleContext();
        String string = accessibleContext2 == null ? null : accessibleContext2.getAccessibleName();
        switch (n) {
            case 9: {
                int n3 = calendar.get(11);
                int n4 = calendar.get(12);
                int n5 = calendar.get(1);
                int n6 = calendar.get(2);
                int n7 = calendar.get(5);
                n3 = calendar.get(9) == 0 ? (n3 += 12) : (n3 -= 12);
                calendar.set(n5, n6, n7, n3, n4);
                break;
            }
            case 15: {
                int n8;
                String string2 = calendar.getTimeZone().getID();
                String[] stringArray = TimeZone.getAvailableIDs();
                int n9 = stringArray.length;
                for (n8 = 0; n8 < n9 && !string2.equals(stringArray[n8]); ++n8) {
                }
                int n10 = n8;
                n10 = n10 == 0 && bl ? n9 - 1 : (n10 == n9 - 1 && !bl ? 0 : (bl ? --n10 : ++n10));
                TimeZone timeZone = TimeZone.getTimeZone(stringArray[n10]);
                calendar.setTimeZone(timeZone);
                break;
            }
            default: {
                calendar.roll(n, bl);
            }
        }
        Date date = this._date;
        this._date = calendar.getTime();
        this._nullDate = this._date == null;
        this._date = this._checkMinMax(this._date, false);
        this._firePropertyChanged(PROPERTY_DATE, date, this._date);
        if (bl2) {
            Integer n11 = IntegerUtils.getInteger((int)calendar.get(n));
            this._fireAccessibleValue(n2, n11);
        } else if (accessibleContext2 != null) {
            accessibleContext2.firePropertyChange("AccessibleName", string, accessibleContext2.getAccessibleName());
        }
        this.repaint();
    }

    static String getDescription(int n, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(locale));
        String string = null;
        switch (n) {
            case 9: {
                string = resourceBundle.getString(_AM_PM_KEY);
                break;
            }
            case 15: {
                string = resourceBundle.getString(_ZONE_OFFSET_KEY);
                break;
            }
            case 1: {
                string = resourceBundle.getString(_YEAR_KEY);
                break;
            }
            case 2: {
                string = resourceBundle.getString(_MONTH_KEY);
                break;
            }
            case 5: {
                string = resourceBundle.getString(_DAY_OF_MONTH_KEY);
                break;
            }
            case 11: {
                string = resourceBundle.getString(_HOUR_OF_DAY_KEY);
                break;
            }
            case 12: {
                string = resourceBundle.getString(_MINUTE_KEY);
                break;
            }
            case 13: {
                string = resourceBundle.getString(_SECOND_KEY);
                break;
            }
            case 14: {
                string = resourceBundle.getString(_MILLISECOND_KEY);
                break;
            }
            case 7: {
                string = resourceBundle.getString(_DAY_OF_WEEK_KEY);
            }
        }
        return string;
    }

    private void _resetDate() {
        this.setDate(this.getDefaultDate());
    }

    private Locale _getLocale() {
        return LocaleUtils.getDefaultableLocale(this);
    }

    private void _setCalendar(Calendar calendar) {
        Calendar calendar2 = this._calendar;
        if (!calendar2.equals(calendar)) {
            this._calendar = calendar;
            this._date = this._calendar.getTime();
            this._nullDate = this._date == null;
            this.getDateFormat().setCalendar(calendar);
            this._firePropertyChanged("calendar", calendar2, calendar);
            if (!this._nullDate) {
                if (this._minimum != null && this._date.before(this._minimum)) {
                    this.setDate(this._minimum);
                }
                if (this._maximum != null && this._date.after(this._maximum)) {
                    this.setDate(this._maximum);
                }
            }
            this.repaint();
        }
    }

    private void _setDateFormat(DateFormat dateFormat) {
        DateFormat dateFormat2 = this._dateFormat;
        if (!dateFormat2.equals(dateFormat)) {
            if (!(dateFormat instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("DateFormat must be a SimpleDateFormat");
            }
            dateFormat.setCalendar(this.getCalendar());
            this._dateFormat = dateFormat;
            this._parseDateFormat();
            this._firePropertyChanged("dateFormat", dateFormat2, dateFormat);
            this._currentField = -1;
            this.repaint();
        }
    }

    private void _paintText(Graphics graphics, Painter painter) {
        Dimension dimension = this.getInnerSize();
        DateEditorUI dateEditorUI = (DateEditorUI)this.getUI();
        PaintContext paintContext = this.getPaintContext();
        dimension.width -= this._spinButton.getSize().width;
        Dimension dimension2 = painter.getPreferredSize(paintContext);
        int n = this.getActualReadingDirection() == 1 ? 0 : this._textXOffset;
        painter.paint(paintContext, graphics, n, 0, dimension.width, dimension.height);
    }

    private int _getFieldAt(int n) {
        int n2 = this.getSize().height / 2;
        for (int i = 0; i < this._fieldCount; ++i) {
            Rectangle rectangle = this._getFieldBounds(i);
            if (!rectangle.contains(n, n2 + 1)) continue;
            return i;
        }
        return -1;
    }

    private FieldPosition _getFieldPosition(StringBuffer stringBuffer, int n) {
        DateFormat dateFormat = this.getDateFormat();
        Date date = this.getDate();
        FieldPosition fieldPosition = new FieldPosition(this._formatFields[n]);
        if (!this._nullDate) {
            stringBuffer = dateFormat.format(date, stringBuffer, fieldPosition);
        }
        return fieldPosition;
    }

    private Rectangle _getFieldBounds(int n) {
        if (this._nullDate) {
            return new Rectangle(0, 0, 0, 0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = this._getFieldPosition(stringBuffer, n);
        DateEditorUI dateEditorUI = (DateEditorUI)this.getUI();
        PaintContext paintContext = this.getPaintContext();
        String string = stringBuffer.toString();
        string = StringUtils.getDisplayString(string, this.getLocale(), 1);
        Font font = paintContext.getPaintFont();
        FontMetrics fontMetrics = paintContext.getFontMetrics(font);
        int n2 = fieldPosition.getBeginIndex();
        int n3 = n2 != 0 ? fontMetrics.stringWidth(string.substring(0, n2)) : 0;
        int n4 = fontMetrics.stringWidth(string.substring(n2, fieldPosition.getEndIndex()));
        Painter painter = dateEditorUI.getTextPainter(this);
        Dimension dimension = this.getInnerSize();
        Dimension dimension2 = painter.getPreferredSize(paintContext);
        if (this.getActualReadingDirection() == 2) {
            n3 = dimension.width - (n3 + n4);
        } else if (n2 != 0) {
            n3 += this._textXOffset;
        } else {
            n4 += this._textXOffset;
        }
        return new Rectangle(n3, 0, n4, dimension.height);
    }

    private void _paintCurrentField(Graphics graphics) {
        DateEditorUI dateEditorUI = (DateEditorUI)this.getUI();
        Rectangle rectangle = this._getFieldBounds(this._currentField);
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Painter painter = dateEditorUI.getSelectionTextPainter(this);
        this._paintText(graphics, painter);
    }

    private void _processKeyPressed(KeyEvent keyEvent) {
        int n;
        int n2 = n = this._currentField;
        int n3 = keyEvent.getKeyCode();
        if (this.getActualReadingDirection() == 2) {
            if (n3 == 37) {
                n3 = 39;
            } else if (n3 == 39) {
                n3 = 37;
            }
        }
        switch (n3) {
            case 38: {
                if (!this._spinButton.isIncrementEnabled()) break;
                this._spinButton.setIncrementArmed(true);
                this.rollCurrentField(true);
                break;
            }
            case 40: {
                if (!this._spinButton.isDecrementEnabled()) break;
                this._spinButton.setDecrementArmed(true);
                this.rollCurrentField(false);
                break;
            }
            case 37: {
                if (n == -1) {
                    n2 = 0;
                    break;
                }
                if (n == 0) break;
                n2 = n - 1;
                break;
            }
            case 39: {
                if (n == -1) {
                    n2 = 0;
                    break;
                }
                if (n == this._fieldCount - 1) break;
                n2 = n + 1;
            }
        }
        if (n2 != n) {
            this._setCurrentField(n2);
            this.repaint();
        }
    }

    private void _processKeyTyped(KeyEvent keyEvent) {
        String string;
        int n;
        int n2;
        String string2;
        char c = keyEvent.getKeyChar();
        if (c < '0' || c > '9') {
            return;
        }
        if (this._currentField == -1) {
            this._setCurrentField(0);
        }
        if (!this._isIntegerField(this._currentField)) {
            return;
        }
        int n3 = this._fields[this._currentField];
        Calendar calendar = this.getCalendar();
        int n4 = calendar.get(n3);
        int n5 = calendar.getMinimum(n3);
        int n6 = calendar.getMaximum(n3);
        Integer n7 = IntegerUtils.getInteger((int)n4);
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = this._getFieldPosition(stringBuffer, this._currentField);
        int n8 = fieldPosition.getEndIndex() - fieldPosition.getBeginIndex();
        if (n8 == 1) {
            ++n8;
        }
        if (n3 == 2) {
            if (n5 == 0) {
                ++n5;
                ++n6;
                ++n4;
            }
        } else if (n3 == 11) {
            if (this._fieldUsed(9) && calendar.get(9) == 1 && n4 >= 12) {
                n4 -= 12;
            }
            ++n6;
        } else if (n3 == 1 && n8 == 2) {
            n5 = 0;
        }
        String string3 = String.valueOf(c);
        String string4 = IntegerUtils.getString((int)n4);
        int n9 = string4.length();
        if (n9 < n8) {
            string2 = "";
            n2 = n8 - n9;
            for (int i = 0; i < n2; ++i) {
                string2 = string2 + "0";
            }
            string4 = string2.concat(string4);
        }
        if ((n = this._checkString(string = (string2 = string4.concat(string3)).substring(n2 = string2.length() - n8), n5, n6)) == -1 && (n = this._checkString(string3, n5, n6)) == -1) {
            return;
        }
        int n10 = calendar.get(11);
        int n11 = calendar.get(12);
        int n12 = calendar.get(13);
        int n13 = calendar.get(1);
        int n14 = calendar.get(2);
        int n15 = calendar.get(5);
        switch (n3) {
            case 11: {
                if (this._fieldUsed(9)) {
                    if (calendar.get(9) == 1) {
                        if (n == 24) {
                            n = 0;
                        }
                        if (n == 0) {
                            calendar.set(9, 0);
                        } else if (n <= 12) {
                            n += 12;
                        }
                    } else if (n == 12) {
                        n = 0;
                    }
                }
                n10 = n;
                break;
            }
            case 12: {
                n11 = n;
                break;
            }
            case 1: {
                if (n8 == 2) {
                    int n16 = this.getDate().getYear();
                    int n17 = 1900 + n16 / 100 * 100;
                    int n18 = n16 % 100;
                    if (n18 < 50) {
                        n17 -= 100;
                    }
                    n = n >= 50 ? n17 + n : n17 + 100 + n;
                }
                n13 = n;
                break;
            }
            case 2: {
                if (n != 0) {
                    n14 = n - 1;
                    break;
                }
                n14 = n;
                break;
            }
            case 5: {
                n15 = n;
                break;
            }
            case 13: {
                n12 = n;
            }
        }
        Date date = this._date;
        calendar.set(n13, n14, n15, n10, n11, n12);
        this._date = calendar.getTime();
        this._nullDate = this._date == null;
        this._date = this._checkMinMax(this._date, false);
        this._firePropertyChanged(PROPERTY_DATE, date, this._date);
        Integer n19 = IntegerUtils.getInteger((int)calendar.get(n3));
        this._fireAccessibleValue(n7, n19);
        this.repaint();
    }

    private void _processKeyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this._spinButton.setIncrementArmed(false);
                break;
            }
            case 40: {
                this._spinButton.setDecrementArmed(false);
            }
        }
    }

    private Date _checkMinMax(Date date, boolean bl) {
        if (this._minimum != null && (date.before(this._minimum) || date.equals(this._minimum))) {
            date = this._minimum;
            bl = true;
            this._spinButton.setDecrementEnabled(false);
        } else if (!this._spinButton.isDecrementEnabled()) {
            this._spinButton.setDecrementEnabled(true);
        }
        if (this._maximum != null && (date.after(this._maximum) || date.equals(this._maximum))) {
            date = this._maximum;
            bl = true;
            this._spinButton.setIncrementEnabled(false);
        } else if (!this._spinButton.isIncrementEnabled()) {
            this._spinButton.setIncrementEnabled(true);
        }
        if (this._minimum != null && this._maximum != null && this._minimum.equals(this._maximum)) {
            date = this._minimum;
            bl = true;
            this._spinButton.setDecrementEnabled(false);
            this._spinButton.setIncrementEnabled(false);
        }
        if (bl) {
            this._calendar.setTime(date);
        }
        return date;
    }

    private int _checkString(String string, int n, int n2) {
        int n3 = -1;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (n3 < n || n3 > n2) {
            return -1;
        }
        return n3;
    }

    private boolean _isIntegerField(int n) {
        DateFormat dateFormat = this.getDateFormat();
        Date date = this.getDate();
        FieldPosition fieldPosition = new FieldPosition(this._formatFields[n]);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = dateFormat.format(date, stringBuffer, fieldPosition);
        String string = stringBuffer.toString().substring(fieldPosition.getBeginIndex(), fieldPosition.getEndIndex());
        try {
            int n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private void _parseDateFormat() {
        int n = 0;
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.getDateFormat();
        String string = simpleDateFormat.toPattern();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i] = -1;
            this._formatFields[i] = -1;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            switch (c) {
                case 'a': {
                    if (bl8) break;
                    this._fields[n] = 9;
                    this._formatFields[n] = DateEditor.getConstant(0);
                    ++n;
                    bl8 = true;
                    break;
                }
                case 'z': {
                    if (bl9) break;
                    this._fields[n] = 15;
                    this._formatFields[n] = DateEditor.getConstant(1);
                    ++n;
                    bl9 = true;
                    break;
                }
                case 'y': {
                    if (bl) break;
                    this._fields[n] = 1;
                    this._formatFields[n] = DateEditor.getConstant(2);
                    ++n;
                    bl = true;
                    break;
                }
                case 'M': {
                    if (bl2) break;
                    this._fields[n] = 2;
                    this._formatFields[n] = DateEditor.getConstant(3);
                    ++n;
                    bl2 = true;
                    break;
                }
                case 'd': {
                    if (bl3) break;
                    this._fields[n] = 5;
                    this._formatFields[n] = DateEditor.getConstant(4);
                    ++n;
                    bl3 = true;
                    break;
                }
                case 'h': {
                    if (bl4) break;
                    this._fields[n] = 11;
                    this._formatFields[n] = DateEditor.getConstant(6);
                    ++n;
                    bl4 = true;
                    break;
                }
                case 'H': {
                    if (bl10) break;
                    this._fields[n] = 11;
                    this._formatFields[n] = DateEditor.getConstant(5);
                    ++n;
                    bl10 = true;
                    break;
                }
                case 'k': {
                    if (bl11) break;
                    this._fields[n] = 11;
                    this._formatFields[n] = DateEditor.getConstant(10);
                    ++n;
                    bl11 = true;
                    break;
                }
                case 'K': {
                    if (bl12) break;
                    this._fields[n] = 11;
                    this._formatFields[n] = DateEditor.getConstant(11);
                    ++n;
                    bl12 = true;
                    break;
                }
                case 'm': {
                    if (bl5) break;
                    this._fields[n] = 12;
                    this._formatFields[n] = DateEditor.getConstant(7);
                    ++n;
                    bl5 = true;
                    break;
                }
                case 's': {
                    if (bl6) break;
                    this._fields[n] = 13;
                    this._formatFields[n] = DateEditor.getConstant(8);
                    ++n;
                    bl6 = true;
                    break;
                }
                case 'S': {
                    if (bl7) break;
                    this._fields[n] = 14;
                    this._formatFields[n] = DateEditor.getConstant(9);
                    ++n;
                    bl7 = true;
                    break;
                }
                case 'E': {
                    if (bl13) break;
                    this._fields[n] = 7;
                    this._formatFields[n] = DateEditor.getConstant(12);
                    ++n;
                    bl13 = true;
                    break;
                }
                case '\'': {
                    while ((c = stringCharacterIterator.next()) != '\'') {
                    }
                    break;
                }
            }
            c = stringCharacterIterator.next();
        }
        this._fieldCount = n;
        this._createAccessibleChildren();
    }

    private boolean _fieldUsed(int n) {
        for (int i = 0; i < this._fieldCount; ++i) {
            if (this._fields[i] != n) continue;
            return true;
        }
        return false;
    }

    private void _firePropertyChanged(String string, Object object, Object object2) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(string, object, object2);
        }
    }

    int getPreviousField(int n) {
        if (n == -1) {
            return 0;
        }
        if (n != 0) {
            return n - 1;
        }
        return n;
    }

    int getNextField(int n) {
        if (n == -1) {
            return 0;
        }
        if (n != this._fieldCount - 1) {
            return n + 1;
        }
        return n;
    }

    void _setCurrentField(int n) {
        Calendar calendar = this.getCalendar();
        int n2 = this._currentField;
        Integer n3 = this._currentField == -1 ? null : IntegerUtils.getInteger((int)calendar.get(this._fields[this._currentField]));
        this._currentField = n;
        Integer n4 = null;
        if (this._currentField != -1) {
            int n5 = this._fields[this._currentField];
            int n6 = calendar.getMinimum(n5);
            int n7 = calendar.getMaximum(n5);
            SpinAccelerator spinAccelerator = SpinAccelerator.createDefaultAccelerator(n7 - n6 + 1);
            this._spinButton.setAccelerator(spinAccelerator);
            n4 = IntegerUtils.getInteger((int)calendar.get(n5));
        }
        this._fireAccessibleSelection(n2, this._currentField);
        this._fireAccessibleActive(n2, this._currentField);
        this._fireAccessibleFocus(n2, this._currentField);
    }

    private void _fireAccessibleSelection(int n, int n2) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleSelection", n == -1 ? Boolean.FALSE : Boolean.TRUE, n2 == -1 ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    private void _fireAccessibleActive(int n, int n2) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleActiveDescendant", n == -1 ? null : accessibleContext.getAccessibleChild(n), n2 == -1 ? null : accessibleContext.getAccessibleChild(n2));
        }
    }

    private void _fireAccessibleFocus(int n, int n2) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            if (n != -1) {
                accessibleContext.getAccessibleChild(n).getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
            if (n2 != -1) {
                accessibleContext.getAccessibleChild(n2).getAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }
    }

    private void _fireAccessibleValue(Number number, Number number2) {
        AccessibleContext accessibleContext;
        if (this._currentField != -1 && (accessibleContext = this.accessAccessibleContext()) != null) {
            accessibleContext.getAccessibleChild(this._currentField).getAccessibleContext().firePropertyChange("AccessibleValue", number, number2);
        }
    }

    private void _createAccessibleChildren() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null && accessibleContext instanceof Access) {
            Access access = (Access)accessibleContext;
            access.__createChildren();
        }
    }

    private static int getConstant(int n) {
        if (_constantArray == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("h:mm a");
            Calendar calendar = Calendar.getInstance();
            FieldPosition fieldPosition = new FieldPosition(14);
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(calendar.getTime(), stringBuffer, fieldPosition);
            _constantArray = fieldPosition.getBeginIndex() == 0 ? _CALENDAR_ARRAY : _DATE_FORMAT_ARRAY;
        }
        return _constantArray[n];
    }

    static {
        _DATE_FORMAT_ARRAY = new int[]{14, 17, 1, 2, 3, 5, 15, 6, 7, 8, 4, 16, 9};
        _CALENDAR_ARRAY = new int[]{9, 15, 1, 2, 5, 11, 10, 12, 13, 14, 11, 10, 7};
    }

    private class SpinListener
    implements SpinButtonListener {
        private SpinListener() {
        }

        public void spinButtonSpinning(SpinButtonEvent spinButtonEvent) {
            boolean bl;
            boolean bl2 = DateEditor.this._nullDate;
            if (!DateEditor.this.hasFocus()) {
                DateEditor.this.requestFocus();
            }
            if (bl2) {
                return;
            }
            switch (spinButtonEvent.getType()) {
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = false;
                    break;
                }
                default: {
                    return;
                }
            }
            DateEditor.this.rollCurrentField(bl);
        }
    }

    private class AccessibleDateField
    extends AccessibleContext
    implements Accessible,
    AccessibleAction,
    AccessibleValue,
    AccessibleComponent {
        private int _field;
        private int _index;
        private ListenerManager _focusListeners;

        public AccessibleDateField(int n, int n2) {
            this._field = n;
            this._index = n2;
        }

        public Accessible getAccessibleParent() {
            return DateEditor.this;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string != null) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = DateEditor.this._getFieldPosition(stringBuffer, this._index);
            string = stringBuffer.toString();
            if (string == null || fieldPosition.getBeginIndex() == -1 || fieldPosition.getEndIndex() == -1) {
                return null;
            }
            return string.substring(fieldPosition.getBeginIndex(), fieldPosition.getEndIndex());
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string != null) {
                return string;
            }
            return DateEditor.getDescription(this._field, LocaleUtils.getDefaultableLocale(DateEditor.this));
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = this.getAccessibleParent().getAccessibleContext().getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (this._field == DateEditor.this._currentField) {
                accessibleStateSet.add(AccessibleState.SELECTED);
                if (DateEditor.this.hasFocus()) {
                    accessibleStateSet.add(AccessibleState.FOCUSED);
                }
            } else if (accessibleStateSet.contains(AccessibleState.FOCUSED)) {
                accessibleStateSet.remove(AccessibleState.FOCUSED);
            }
            if (accessibleStateSet.contains(AccessibleState.ENABLED)) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }

        public int getAccessibleIndexInParent() {
            return this._index;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return DateEditor.this.getLocale();
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 2;
        }

        public String getAccessibleActionDescription(int n) {
            Locale locale = LocaleUtils.getDefaultableLocale(DateEditor.this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(DateEditor._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(locale));
            switch (n) {
                case 0: {
                    return resourceBundle.getString(DateEditor._INCREMENT_KEY);
                }
                case 1: {
                    return resourceBundle.getString(DateEditor._DECREMENT_KEY);
                }
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            switch (n) {
                case 0: {
                    if (!DateEditor.this._spinButton.isIncrementEnabled()) {
                        return false;
                    }
                    DateEditor.this._setCurrentField(this._index);
                    DateEditor.this.rollCurrentField(true);
                    break;
                }
                case 1: {
                    if (!DateEditor.this._spinButton.isDecrementEnabled()) {
                        return false;
                    }
                    DateEditor.this._setCurrentField(this._index);
                    DateEditor.this.rollCurrentField(false);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            if (!DateEditor.this._isIntegerField(this._index)) {
                return null;
            }
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger((int)DateEditor.this.getCalendar().get(this._field));
        }

        public boolean setCurrentAccessibleValue(Number number) {
            DateEditor.this.getCalendar().set(this._field, number.intValue());
            DateEditor.this.repaint();
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger((int)DateEditor.this.getCalendar().getMinimum(this._field));
        }

        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger((int)DateEditor.this.getCalendar().getMaximum(this._field));
        }

        public Color getBackground() {
            return DateEditor.this.getBackground();
        }

        public void setBackground(Color color) {
            DateEditor.this.setBackground(color);
        }

        public Color getForeground() {
            return DateEditor.this.getForeground();
        }

        public void setForeground(Color color) {
            DateEditor.this.setForeground(color);
        }

        public Cursor getCursor() {
            Cursor cursor = DateEditor.this.getCursor();
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            return cursor;
        }

        public void setCursor(Cursor cursor) {
            DateEditor.this.setCursor(cursor);
        }

        public Font getFont() {
            return DateEditor.this.getFont();
        }

        public void setFont(Font font) {
            DateEditor.this.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return DateEditor.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return DateEditor.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            DateEditor.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return DateEditor.this.isVisible();
        }

        public void setVisible(boolean bl) {
            DateEditor.this.setVisible(bl);
        }

        public boolean isShowing() {
            return DateEditor.this.isShowing();
        }

        public boolean contains(Point point) {
            return this.getBounds().contains(point);
        }

        public Point getLocationOnScreen() {
            Point point = DateEditor.this.getLocationOnScreen();
            if (point != null) {
                Point point2 = this.getLocation();
                point.x += point2.x;
                point.y += point2.y;
            }
            return point;
        }

        public Point getLocation() {
            Rectangle rectangle = this.getFieldBounds();
            return rectangle.getLocation();
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            return this.getFieldBounds();
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getFieldBounds();
            return rectangle.getSize();
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return DateEditor.this.isFocusTraversable();
        }

        public void requestFocus() {
            DateEditor.this._setCurrentField(this._index);
        }

        public void addFocusListener(FocusListener focusListener) {
            if (this._focusListeners == null) {
                this._focusListeners = new ListenerManager();
            }
            this._focusListeners.addListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            if (this._focusListeners != null) {
                this._focusListeners.removeListener(focusListener);
            }
        }

        private Rectangle getFieldBounds() {
            ImmInsets immInsets = DateEditor.this.getBorderInsets();
            Rectangle rectangle = DateEditor.this._getFieldBounds(this._index);
            rectangle.width += immInsets.left + immInsets.right;
            rectangle.height += immInsets.top + immInsets.bottom;
            return rectangle;
        }
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleSelection,
    AccessibleAction {
        private Accessible[] _children;

        public Access() {
            super(DateEditor.this);
            this.__createChildren();
        }

        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.DATE_EDITOR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (DateEditor.this.hasFocus()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (accessibleStateSet.contains(AccessibleState.ENABLED)) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }

        public int getAccessibleChildrenCount() {
            return DateEditor.this._fieldCount;
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return this._children[n];
        }

        public int getAccessibleSelectionCount() {
            return DateEditor.this._currentField == -1 ? 0 : 1;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n >= this.getAccessibleSelectionCount()) {
                return null;
            }
            return this._children[DateEditor.this._currentField];
        }

        public boolean isAccessibleChildSelected(int n) {
            return DateEditor.this._currentField == n;
        }

        public void addAccessibleSelection(int n) {
            DateEditor.this._setCurrentField(n);
        }

        public void removeAccessibleSelection(int n) {
            if (DateEditor.this._currentField == n) {
                DateEditor.this._setCurrentField(-1);
            }
        }

        public void clearAccessibleSelection() {
            DateEditor.this._setCurrentField(-1);
        }

        public void selectAllAccessibleSelection() {
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 4;
        }

        public String getAccessibleActionDescription(int n) {
            Locale locale = LocaleUtils.getDefaultableLocale(DateEditor.this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(DateEditor._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(locale));
            switch (n) {
                case 0: {
                    return resourceBundle.getString(DateEditor._INCREMENT_KEY);
                }
                case 1: {
                    return resourceBundle.getString(DateEditor._DECREMENT_KEY);
                }
                case 2: {
                    return resourceBundle.getString(DateEditor._LEFT_KEY);
                }
                case 3: {
                    return resourceBundle.getString(DateEditor._RIGHT_KEY);
                }
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            switch (n) {
                case 0: {
                    if (!DateEditor.this._spinButton.isIncrementEnabled()) {
                        return false;
                    }
                    DateEditor.this.rollCurrentField(true);
                    break;
                }
                case 1: {
                    if (!DateEditor.this._spinButton.isDecrementEnabled()) {
                        return false;
                    }
                    DateEditor.this.rollCurrentField(false);
                    break;
                }
                case 2: {
                    DateEditor.this._setCurrentField(DateEditor.this.getPreviousField(DateEditor.this._currentField));
                    break;
                }
                case 3: {
                    DateEditor.this._setCurrentField(DateEditor.this.getNextField(DateEditor.this._currentField));
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        void __createChildren() {
            int n;
            Accessible[] accessibleArray = this._children;
            if (accessibleArray != null && accessibleArray.length != 0) {
                for (n = 0; n < accessibleArray.length; ++n) {
                    this.firePropertyChange("AccessibleChild", this._children[n], null);
                }
            }
            n = DateEditor.this._fieldCount;
            this._children = new Accessible[n];
            for (int i = 0; i < n; ++i) {
                this._children[i] = new AccessibleDateField(DateEditor.this._fields[i], i);
                this.firePropertyChange("AccessibleChild", null, this._children[i]);
            }
        }
    }
}

