/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.font;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.UIManager;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.font.FontPane;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;

class FontDialog
extends BufferedDialog {
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final int _BORDER_INSET = 6;
    private static final BorderPainter _sBorder = new FixedBorderPainter(6, 6, 6, 6);
    private static final String _RESOURCE = "oracle.ewt.font.resource.FontBundle";
    private static final String _KEY_TITLE = "FONTDIALOG.TITLE";
    private static final String _KEY_OK = "OK";
    private static final String _KEY_CANCEL = "CANCEL";
    private static final String _KEY_HELP = "HELP";
    private Component _centerOver;
    private FontPane _fontPane;
    private boolean _cancelled;
    private ActionListener _listener;
    private LWContainer _fontPaneContainer;

    public FontDialog(FontPane fontPane, String string, Component component) {
        super(WindowUtils.parentFrame(component), string);
        this.setResizable(false);
        this.setModal(true);
        Locale locale = LocaleUtils.getDefaultableLocale(this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(locale));
        if (this.getTitle() == null) {
            this.setTitle(resourceBundle.getString(_KEY_TITLE));
        }
        this._listener = new UIListener();
        this._fontPaneContainer = new LWContainer(new BorderLayout());
        LWContainer lWContainer = new LWContainer(new BorderLayout());
        lWContainer.add("Center", this._fontPaneContainer);
        String string2 = resourceBundle.getString(_KEY_OK);
        LWButton lWButton = new LWButton(StringUtils.stripMnemonic(string2));
        lWButton.setMnemonicIndex(StringUtils.getMnemonicIndex(string2));
        lWButton.setActionCommand(_KEY_OK);
        lWButton.addActionListener(this._listener);
        lWButton.setDefault(true);
        string2 = resourceBundle.getString(_KEY_CANCEL);
        LWButton lWButton2 = new LWButton(StringUtils.stripMnemonic(string2));
        lWButton2.setMnemonicIndex(StringUtils.getMnemonicIndex(string2));
        lWButton2.setActionCommand(_KEY_CANCEL);
        lWButton2.addActionListener(this._listener);
        string2 = resourceBundle.getString(_KEY_HELP);
        LWButton lWButton3 = new LWButton(StringUtils.stripMnemonic(string2));
        lWButton3.setMnemonicIndex(StringUtils.getMnemonicIndex(string2));
        lWButton3.setActionCommand(_KEY_HELP);
        lWButton3.addActionListener(this._listener);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add(lWButton);
        buttonBar.add(lWButton2);
        buttonBar.add(lWButton3);
        LWContainer lWContainer2 = new LWContainer(new BorderLayout(0, 6));
        lWContainer2.setBorderPainter(_sBorder);
        lWContainer2.add("Center", lWContainer);
        lWContainer2.add("South", buttonBar);
        this.setLayout(new BorderLayout());
        this.add("Center", lWContainer2);
        Color color = UIManager.getColor("EWTDialog.background");
        if (color != null) {
            this.setBackground(color);
        }
        this.enableEvents(64L);
        this.setCenterOver(component);
        this._fontPane = fontPane;
        this._fontPaneContainer.setBorderPainter(_sBorder);
        this._fontPaneContainer.add("Center", this._fontPane);
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public boolean runDialog() {
        this.pack();
        Component component = this.getCenterOver();
        if (component == null) {
            component = this.getParent();
        }
        WindowUtils.centerWindow(this, component);
        this._cancelled = false;
        this.setVisible(true);
        return !this._cancelled;
    }

    public FontPane getFontPane() {
        return this._fontPane;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dismissDialog(true);
        }
    }

    void dismissDialog(boolean bl) {
        this._cancelled = bl;
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    void fireHelpEvent() {
        this.showHelp();
    }

    public void postProcessKey(KeyEvent keyEvent) {
        super.postProcessKey(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled() || keyEvent.getID() != 401) {
            return;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 27: {
                this.dismissDialog(true);
                keyEvent.consume();
                break;
            }
            case 112: 
            case 156: {
                this.fireHelpEvent();
                keyEvent.consume();
            }
        }
    }

    private class UIListener
    implements ActionListener {
        private UIListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (FontDialog._KEY_OK.equals(string)) {
                FontDialog.this.dismissDialog(false);
            } else if (FontDialog._KEY_CANCEL.equals(string)) {
                FontDialog.this.dismissDialog(true);
            } else if (FontDialog._KEY_HELP.equals(string)) {
                FontDialog.this.fireHelpEvent();
            }
        }
    }
}

