/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.Point;
import oracle.ewt.grid.Grid;
import oracle.ewt.timer.Timer;

class GridAutoScroller
implements Runnable {
    private static final int _INITIAL_SCROLLING_DELAY = 200;
    private static final int _REPEAT_SCROLLING_DELAY = 100;
    private static GridAutoScroller _sAutoScroller;
    private Timer _timer = new Timer((Runnable)this, "GridAutoScroller");
    private Grid _scrollee;
    private boolean _hDecrease;
    private boolean _vDecrease;
    private boolean _horizontal;
    private boolean _vertical;
    private boolean _cancel;
    private boolean _scheduled;

    public static GridAutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new GridAutoScroller();
        }
        return _sAutoScroller;
    }

    public void schedule(Grid grid, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._scrollee = grid;
        this._horizontal = bl;
        this._vertical = bl3;
        this._hDecrease = bl2;
        this._vDecrease = bl4;
        this._cancel = false;
        if (this._scheduled) {
            return;
        }
        this._scheduled = true;
        this._timer.schedule(200L);
    }

    public void cancel() {
        this._timer.cancel();
        this._scheduled = false;
        this._cancel = true;
    }

    public void cancel(Grid grid) {
        if (this._scrollee == grid) {
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl;
        boolean bl2;
        block22: {
            if (this._cancel) {
                return;
            }
            Point point = this._scrollee.getCanvasOrigin();
            bl2 = false;
            bl = false;
            this._scrollee.freezeRepaints();
            try {
                int n;
                int n2;
                if (this._horizontal) {
                    n2 = -1;
                    if (this._hDecrease) {
                        n2 = this._scrollee.getColumnAt(-point.x);
                        if (n2 != -1) {
                            n2 = this._scrollee.getPreviousVisibleColumn(n2);
                        }
                    } else {
                        n = -point.x + this._scrollee.getInnerSize().width;
                        n2 = this._scrollee.getColumnAt(n);
                        if (n2 != -1) {
                            n2 = this._scrollee.getNextVisibleColumn(n2);
                        }
                    }
                    if (n2 != -1) {
                        Object object = this._scrollee.__paintLock;
                        synchronized (object) {
                            this._scrollee.scrollColumnIntoView(n2);
                            this._scrollee.growSelection(true, n2);
                        }
                        bl2 = true;
                    }
                }
                if (!this._vertical) break block22;
                n2 = -1;
                if (this._vDecrease) {
                    n2 = this._scrollee.getRowAt(-point.y);
                    if (n2 != -1) {
                        n2 = this._scrollee.getPreviousVisibleRow(n2);
                    }
                } else {
                    n = -point.y + this._scrollee.getInnerSize().height;
                    n2 = this._scrollee.getRowAt(n);
                    if (n2 != -1) {
                        n2 = this._scrollee.getNextVisibleRow(n2);
                    }
                }
                if (n2 == -1) break block22;
                Object object = this._scrollee.__paintLock;
                synchronized (object) {
                    this._scrollee.scrollRowIntoView(n2);
                    this._scrollee.growSelection(false, n2);
                }
                bl = true;
            }
            finally {
                this._scrollee.unfreezeRepaints();
            }
        }
        if (bl2 || bl) {
            this._timer.schedule(100L);
        } else {
            this._scheduled = false;
        }
    }

    private GridAutoScroller() {
    }
}

