/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridKeyNavigator;
import oracle.ewt.util.InputEventUtils;

final class GridKeyAdapter
extends KeyAdapter {
    private Grid _grid;

    GridKeyAdapter(Grid grid) {
        this._grid = grid;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        GridKeyNavigator gridKeyNavigator = this._grid.getGridKeyNavigator();
        Cell cell = this._grid.getFocusCell();
        Cell cell2 = null;
        boolean bl = InputEventUtils.isOnlyShiftDown(keyEvent);
        switch (n) {
            case 27: {
                this._grid.cancelCellEdit();
                break;
            }
            case 10: {
                cell2 = gridKeyNavigator.enter(this._grid, cell, keyEvent, bl);
                break;
            }
            case 9: {
                cell2 = gridKeyNavigator.tab(this._grid, cell, keyEvent, bl);
                break;
            }
            default: {
                return;
            }
        }
        keyEvent.consume();
        if (cell2 != null) {
            this._grid.commitCellEdit();
            this._grid.processNewFocusCell(cell2, keyEvent, false);
        }
    }
}

