/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.iterator;

import java.util.NoSuchElementException;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.iterator.Iterator;
import oracle.ewt.iterator.Range;

public class NumericIterator
implements Iterator {
    private int _count;
    private Range _range;
    private boolean _forward;
    private boolean _iteratedOnce;

    public NumericIterator(Range range) {
        if (range == null) {
            throw new NullPointerException();
        }
        this._range = range;
        this._forward = true;
        this._count = range.getLowerLimit();
        this._iteratedOnce = false;
    }

    public Range getRange() {
        return this._range;
    }

    public void setValue(int n) {
        if (!this.getRange().inRange(n)) {
            throw new IllegalArgumentException();
        }
        this._count = n;
        this._iteratedOnce = false;
    }

    public int getValue() {
        return this._count;
    }

    public final Object nextElement() {
        return this.skip(1);
    }

    public void setIteratingForward(boolean bl) {
        this._forward = bl;
    }

    public boolean isIteratingForward() {
        return this._forward;
    }

    public final boolean hasMoreElements() {
        return this.remainingElements(1) == 1;
    }

    public Object skip(int n) {
        if (n == 0) {
            return IntegerUtils.getInteger((int)this._count);
        }
        boolean bl = this.isIteratingForward();
        if (this.remainingElements(n) == n) {
            if (!this._iteratedOnce) {
                this._iteratedOnce = true;
                --n;
            }
            this._count = this.isIteratingForward() ? (this._count += n) : (this._count -= n);
            return IntegerUtils.getInteger((int)this._count);
        }
        throw new NoSuchElementException();
    }

    public int remainingElements(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < 0) {
            boolean bl = this.isIteratingForward();
            this.setIteratingForward(!bl);
            int n2 = -this.remainingElements(-n);
            this.setIteratingForward(bl);
            return n2;
        }
        int n3 = this._count;
        Range range = this._range;
        int n4 = this.isIteratingForward() ? range.getUpperLimit() - n3 : n3 - range.getLowerLimit();
        if (!this._iteratedOnce) {
            ++n4;
        }
        if (n < n4) {
            n4 = n;
        }
        return n4;
    }
}

