/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.KeyEvent;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.ewt.alert.AlertRowLayout;
import oracle.ewt.alert.BaseAlertPane;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.plaf.AlertUI;
import oracle.ewt.util.ImmInsets;

public class GenericAlertUI
extends BasicComponentUI
implements AlertUI {
    private LWComponent _buttonContainer;
    private static Comparator _sCompComparator;
    private static final int _MESSAGE_ICON_DELTA = 10;
    private static final ImmInsets _MESSAGE_INSETS;

    public GenericAlertUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public Image getStopIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getImage("Alert.errorImage");
    }

    public Image getCautionIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getImage("Alert.warningImage");
    }

    public Image getNoteIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getImage("Alert.informationImage");
    }

    public ImmInsets getMessageInsets(LWComponent lWComponent) {
        return _MESSAGE_INSETS;
    }

    public int getMessageIconDelta(LWComponent lWComponent) {
        return 10;
    }

    public LWComponent createButtonContainer(BaseAlertPane baseAlertPane) {
        this._buttonContainer = new LWComponent(){

            public void postProcessKey(KeyEvent keyEvent) {
                super.postProcessKey(keyEvent);
                if (!keyEvent.isConsumed() && keyEvent.getID() == 401 && keyEvent.getComponent().getParent() == this) {
                    boolean bl = true;
                    boolean bl2 = false;
                    switch (keyEvent.getKeyCode()) {
                        case 37: {
                            break;
                        }
                        case 39: {
                            bl2 = true;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    if (bl) {
                        int n;
                        if (this.getActualReadingDirection() == 2) {
                            bl2 = !bl2;
                        }
                        Component[] componentArray = this._getSortedChilderen();
                        int n2 = componentArray.length;
                        for (n = n2 - 1; n >= 0 && componentArray[n] != keyEvent.getComponent(); --n) {
                        }
                        Component component = null;
                        if (bl2) {
                            while (++n < n2) {
                                Component component2 = componentArray[n];
                                if (!component2.isShowing() || !component2.isEnabled()) continue;
                                component = component2;
                                break;
                            }
                        } else {
                            while (--n >= 0) {
                                Component component3 = componentArray[n];
                                if (!component3.isShowing() || !component3.isEnabled()) continue;
                                component = component3;
                                break;
                            }
                        }
                        if (component != null) {
                            component.requestFocus();
                            keyEvent.consume();
                        }
                    }
                }
            }

            private Component[] _getSortedChilderen() {
                Object[] objectArray = this.getComponents();
                Sort.qSort((Object[])objectArray, (int)objectArray.length, (Comparator)GenericAlertUI._sGetCompComparator());
                return objectArray;
            }
        };
        this._buttonContainer.setLayout(new AlertRowLayout());
        return this._buttonContainer;
    }

    public void addUserButton(LWComponent lWComponent, String string, Component component) {
        this._buttonContainer.add(string, component);
    }

    public void removeUserButton(LWComponent lWComponent, Component component) {
        this._buttonContainer.remove(component);
    }

    public void removeAllButtons(LWComponent lWComponent) {
        this._buttonContainer.removeAll();
    }

    public Dimension getButtonCellSize(boolean bl) {
        AlertRowLayout alertRowLayout = (AlertRowLayout)this._buttonContainer.getLayout();
        Dimension dimension = alertRowLayout.getNaturalCellSize(this._buttonContainer, bl);
        dimension.width = (int)((double)dimension.width * 1.5);
        return dimension;
    }

    private static Comparator _sGetCompComparator() {
        if (_sCompComparator == null) {
            _sCompComparator = new CompPositionComparator();
        }
        return _sCompComparator;
    }

    static {
        _MESSAGE_INSETS = new ImmInsets(0, 0, 5, 0);
    }

    private static class CompPositionComparator
    implements Comparator {
        private CompPositionComparator() {
        }

        public int compare(Object object, Object object2) {
            Component component = (Component)object;
            Component component2 = (Component)object2;
            if (component.getLocation().x < component2.getLocation().x) {
                return -1;
            }
            if (component.getLocation().x > component2.getLocation().x) {
                return 1;
            }
            return 0;
        }
    }
}

