/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Graphics;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.generic.GenericButtonPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AbstractWrappingPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FGBGColorChange;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.FixedAlignmentPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.SpinButtonUI;
import oracle.ewt.scrolling.arrowBox.ArrowBox;
import oracle.ewt.util.ImmInsets;

public class GenericArrowBoxUI
extends BasicComponentUI
implements SpinButtonUI {
    private static final String[] _IMAGE_NAMES = new String[]{"SpinButton.leftArrow", "SpinButton.rightArrow", "SpinButton.downArrow", "SpinButton.upArrow"};
    private static final Painter _FILLED_PAINTER = new FGBGColorChange(FilledRectPainter.getPainter());
    private static Painter[] _sArrowPainters = new Painter[4];

    public GenericArrowBoxUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public Painter getIncrementPainter(LWComponent lWComponent) {
        return this._getCachedPainter(lWComponent, true);
    }

    public Painter getDecrementPainter(LWComponent lWComponent) {
        return this._getCachedPainter(lWComponent, false);
    }

    private Painter _getCachedPainter(LWComponent lWComponent, boolean bl) {
        Painter painter;
        ArrowBox arrowBox = (ArrowBox)lWComponent;
        boolean bl2 = arrowBox.getOrientation() == 1;
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            n += 2;
        }
        if ((painter = _sArrowPainters[n]) == null) {
            UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
            int n2 = 1;
            int n3 = 2;
            if (bl2) {
                n2 = 2;
                n3 = 1;
            }
            FixedBorderPainter fixedBorderPainter = new FixedBorderPainter(new ImageSetPainter(new SynthesizingImageSet(uIDefaults.getImage(_IMAGE_NAMES[n]), 1)), n2, n3, 2, 2);
            GenericArrowBoxUI._sArrowPainters[n] = painter = new BorderFill(new GenericButtonPainter(new FixedAlignmentPainter(fixedBorderPainter)), _FILLED_PAINTER);
        }
        return painter;
    }

    private static class BorderFill
    extends AbstractWrappingPainter {
        private BorderPainter _border;
        private Painter _fill;

        public BorderFill(BorderPainter borderPainter, Painter painter) {
            super(borderPainter);
            this._border = borderPainter;
            this._fill = painter;
        }

        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            ImmInsets immInsets = this._border.getFillInsets(paintContext);
            this._fill.paint(paintContext, graphics, n + immInsets.left, n2 + immInsets.top, n3 - (immInsets.left + immInsets.right), n4 - (immInsets.top + immInsets.bottom));
            this._border.paint(paintContext, graphics, n, n2, n3, n4);
        }

        public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
            if (n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
                return this;
            }
            return null;
        }
    }
}

