/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.header.Header;
import oracle.ewt.laf.basic.DisablingPainter;
import oracle.ewt.laf.basic.GridFocusPainter;
import oracle.ewt.laf.oracle.HeaderExtraCanvasPainter;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.laf.oracle.OracleComponentUI;
import oracle.ewt.laf.oracle.OracleHeaderItemPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TruncatingTextPainter;
import oracle.ewt.plaf.TableHeaderUI;
import oracle.ewt.util.ImmInsets;

public class OracleTableHeaderUI
extends OracleComponentUI
implements TableHeaderUI {
    private static BorderPainter[] _sExtraCanvasPainters = new BorderPainter[4];
    private static Painter _sDefaultPainter;
    private static BorderPainter[] _sBorderPainters;
    private static final ImmInsets _ITEM_INSETS;

    public OracleTableHeaderUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public void installUI(LWComponent lWComponent) {
        Header header = (Header)lWComponent;
        header.setDrawSelected(false);
        boolean bl = header.isFirstEdge();
        boolean bl2 = header.isLastEdge();
        boolean bl3 = header.isHorizontal();
        int n = !bl3 & bl ? 2 : 0;
        int n2 = bl3 & bl ? 2 : 0;
        int n3 = !bl3 & bl2 ? 2 : 0;
        int n4 = bl3 & bl2 ? 2 : 0;
        header.setHScrollInsets(n2, n4);
        header.setVScrollInsets(n, n3);
    }

    public BorderPainter getFocusItemPainter(LWComponent lWComponent) {
        return GridFocusPainter.getBorderPainter();
    }

    public BorderPainter getFirstItemBorderPainter(LWComponent lWComponent) {
        Header header = (Header)lWComponent;
        return OracleTableHeaderUI._getBorderPainter(header.isHorizontal(), header.isFirstEdge(), false);
    }

    public BorderPainter getLastItemBorderPainter(LWComponent lWComponent) {
        Header header = (Header)lWComponent;
        return OracleTableHeaderUI._getBorderPainter(header.isHorizontal(), false, header.isLastEdge());
    }

    public BorderPainter getHeaderItemBorderPainter(LWComponent lWComponent) {
        Header header = (Header)lWComponent;
        return OracleTableHeaderUI._getBorderPainter(header.isHorizontal(), false, false);
    }

    public Painter getDefaultPainter(LWComponent lWComponent) {
        return OracleTableHeaderUI._getDefaultPainter();
    }

    public Painter getExtraCanvasPainter(LWComponent lWComponent) {
        Header header = (Header)lWComponent;
        return OracleTableHeaderUI._getExtraCanvasPainter(header.isHorizontal(), header.isLastEdge());
    }

    public Appearance getDefaultAppearance(LWComponent lWComponent) {
        Header header = (Header)lWComponent;
        Appearance appearance = new Appearance();
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        appearance.setForeground(uIDefaults.getColor(OracleColorScheme.HEADER_TEXT));
        appearance.setBackground(uIDefaults.getColor(OracleColorScheme.HEADER));
        appearance.setSelectForeground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
        appearance.setSelectBackground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT));
        appearance.setVerticalJustify(0);
        appearance.setHorizontalJustify(0);
        appearance.setInsets(_ITEM_INSETS);
        return appearance;
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("DefaultHeaderPainter".equals(object)) {
            return OracleTableHeaderUI._getDefaultPainter();
        }
        return null;
    }

    private static BorderPainter _getBorderPainter(boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        if (!bl) {
            n += 4;
        }
        if (!bl2) {
            n += 2;
        }
        if (!bl3) {
            ++n;
        }
        if (_sBorderPainters[n] == null) {
            OracleTableHeaderUI._sBorderPainters[n] = new OracleHeaderItemPainter(bl, bl2, bl3);
        }
        return _sBorderPainters[n];
    }

    private static BorderPainter _getExtraCanvasPainter(boolean bl, boolean bl2) {
        int n = 0;
        if (!bl) {
            n += 2;
        }
        if (!bl2) {
            ++n;
        }
        if (_sExtraCanvasPainters[n] == null) {
            OracleTableHeaderUI._sExtraCanvasPainters[n] = new HeaderExtraCanvasPainter(bl, bl2);
        }
        return _sExtraCanvasPainters[n];
    }

    private static Painter _getDefaultPainter() {
        if (_sDefaultPainter == null) {
            _sDefaultPainter = new DisablingPainter(new TruncatingTextPainter(PaintContext.LABEL_KEY, false));
        }
        return _sDefaultPainter;
    }

    static {
        _sBorderPainters = new BorderPainter[8];
        _ITEM_INSETS = new ImmInsets(2, 2, 2, 2);
    }
}

