/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.MenuUtils;
import oracle.ewt.util.ComponentUtils;

final class DragRedispatcher
extends MouseAdapter
implements MouseMotionListener {
    private Component _pressedComponent;
    private LWMenuItem _overItem;
    private Component _rootComponent;
    private MouseGrabProvider _mouseGrabProvider;
    private Point _pressedComponentOffset;
    private static DragRedispatcher _sInstance;

    private DragRedispatcher() {
    }

    public static DragRedispatcher getInstance() {
        if (_sInstance == null) {
            _sInstance = new DragRedispatcher();
        }
        return _sInstance;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._pressedComponent != null) {
            return;
        }
        this._startDrag(mouseEvent);
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        LWMenuItem lWMenuItem;
        if (this._pressedComponent == null) {
            this._startDrag(mouseEvent);
        }
        if ((lWMenuItem = this._getMenuItemAt(mouseEvent)) != this._overItem) {
            if (this._overItem != null && this._overItem != this._pressedComponent) {
                this._fireEvent(505, this._overItem, mouseEvent);
            }
            if (lWMenuItem != null && lWMenuItem != this._pressedComponent) {
                this._fireEvent(504, lWMenuItem, mouseEvent);
            }
            this._overItem = lWMenuItem;
        }
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._pressedComponent == null || this._pressedComponent != mouseEvent.getSource()) {
            return;
        }
        LWMenuItem lWMenuItem = this._getMenuItemAt(mouseEvent);
        if (lWMenuItem != null && lWMenuItem != this._pressedComponent) {
            this._fireEvent(502, lWMenuItem, mouseEvent);
        }
        this._pressedComponent = null;
        this._rootComponent = null;
        this._overItem = null;
        this._mouseGrabProvider = null;
        this._pressedComponentOffset = null;
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _fireEvent(int n, LWMenuItem lWMenuItem, MouseEvent mouseEvent) {
        Point point = null;
        Object object = lWMenuItem.getTreeLock();
        synchronized (object) {
            if (!this._isDescendent(lWMenuItem, (Component)((Object)this._mouseGrabProvider))) {
                return;
            }
            point = ComponentUtils.translatePoint(lWMenuItem, (Component)((Object)this._mouseGrabProvider), 0, 0);
        }
        object = new MouseEvent(lWMenuItem, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + this._pressedComponentOffset.x - point.x, mouseEvent.getY() + this._pressedComponentOffset.y - point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        this._mouseGrabProvider.processMouseGrabs((MouseEvent)object);
        lWMenuItem.redispatchEvent((AWTEvent)object);
    }

    private LWMenuItem _getMenuItemAt(MouseEvent mouseEvent) {
        Component component = ComponentUtils.getTargetComponent((Component)((Object)this._mouseGrabProvider), new Point(mouseEvent.getX() + this._pressedComponentOffset.x, mouseEvent.getY() + this._pressedComponentOffset.y));
        if (component != null && component instanceof LWMenuItem && MenuUtils.isMenuDescendent(component, this._rootComponent)) {
            return (LWMenuItem)component;
        }
        return null;
    }

    private boolean _isDescendent(Component component, Component component2) {
        while (component != null) {
            if (component == component2) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    private void _startDrag(MouseEvent mouseEvent) {
        this._pressedComponent = (Component)mouseEvent.getSource();
        this._rootComponent = (Component)((Object)MenuUtils.getRootMenuItemContainer(this._pressedComponent));
        if (this._rootComponent == null) {
            this._rootComponent = this._pressedComponent;
        }
        this._overItem = null;
        this._mouseGrabProvider = TrackingUtils.getMouseGrabProvider(this._pressedComponent);
        this._pressedComponentOffset = ComponentUtils.translatePoint(this._pressedComponent, (Component)((Object)this._mouseGrabProvider), 0, 0);
    }
}

