/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.lwAWT.lwText.AccessibleLWTextComponent;
import oracle.ewt.lwAWT.lwText.BIDIFilter;
import oracle.ewt.lwAWT.lwText.CursorUtils;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.Paragraph;
import oracle.ewt.lwAWT.lwText.ParagraphPosition;
import oracle.ewt.lwAWT.lwText.TabbedFontMetrics;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.lwAWT.lwText.displayFilter.DisplayStringFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.Range;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.textWrapper.NoWrapper;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;

public class LWTextArea
extends LWCommonText {
    public static final int ALIGNMENT_DEFAULT = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 3;
    private static final int _DEFAULT_ROWS = 1;
    private static final int _DRAW_INSERTION_HACK = 0;
    private static final int _MINSIZE_COLUMNS = 10;
    private static final int _NOWRAP_COLUMNS = 200;
    private static final int _DEFAULT_TAB_STOP = 4;
    private static final BorderPainter _SCROLLED_BORDER_PAINTER = new FixedBorderPainter(1, 1, 1, 1);
    private int _numChars;
    private int _rowCount;
    private int _preferredRows;
    private Paragraph[] _paragraphs;
    private int _paragraphCount;
    private int _tabStop;
    private ParagraphPosition _cachedPosition;
    private Adjustable _vAdjustable;
    private boolean _mouseDown;
    private boolean _tabPressed;
    private int _wrapValidCount;
    private TextWrapper _wrapper;
    private FontMetrics _metrics;
    private int _highWaterWidth;
    private boolean _bidiEnabled;
    private BIDIFilter _bidiFilter;
    private boolean _mightDrag;
    private int _globalPaintStart = -1;

    public LWTextArea() {
        this("");
    }

    public LWTextArea(String string) {
        this._init(string, 1);
    }

    public LWTextArea(String string, int n, int n2) {
        super(n2);
        this._init(string, n);
    }

    public Object getUIClassID() {
        return "TextAreaUI";
    }

    public void setRows(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        if (this._preferredRows != n) {
            this._preferredRows = n;
            this.invalidate();
        }
    }

    public int getRows() {
        return this._preferredRows;
    }

    public int getTextLength() {
        return this._numChars;
    }

    public TextWrapper getTextWrapper() {
        return this._wrapper;
    }

    public void setTextWrapper(TextWrapper textWrapper) {
        if (textWrapper == null) {
            textWrapper = NoWrapper.getTextWrapper();
        }
        if (this._wrapper != textWrapper) {
            this._wrapper = textWrapper;
            this._highWaterWidth = 0;
            this._invalidateWrapping();
            this.repaintInterior();
        }
    }

    public int getTabStop() {
        return this._tabStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabStop(int n) {
        LWTextArea lWTextArea = this;
        synchronized (lWTextArea) {
            if (this._tabStop == n) {
                return;
            }
            this._tabStop = n;
        }
        this._metrics = null;
        this._invalidateWrapping();
        this.repaintInterior();
    }

    public synchronized String getText() {
        StringBuffer stringBuffer = new StringBuffer(this.getTextLength());
        for (int i = 0; i < this._paragraphCount; ++i) {
            stringBuffer.append(this._getParagraph(i).getText());
        }
        return new String(stringBuffer);
    }

    public synchronized int nextValidCursorIndex(int n) {
        if (!LWTextArea.isSurrogatePairSupportEnabled()) {
            return n + 1;
        }
        int n2 = 0;
        for (int i = 0; i < this._paragraphCount; ++i) {
            Paragraph paragraph = this._getParagraph(i);
            int n3 = paragraph.getTextLength();
            if (n < n3) {
                return n2 + LWTextArea.nextValidCursorIndex(paragraph.getText(), n);
            }
            n2 += n3;
            n -= n3;
        }
        throw new IndexOutOfBoundsException();
    }

    public synchronized int prevValidCursorIndex(int n) {
        if (!LWTextArea.isSurrogatePairSupportEnabled()) {
            return n - 1;
        }
        int n2 = 0;
        for (int i = 0; i < this._paragraphCount; ++i) {
            Paragraph paragraph = this._getParagraph(i);
            int n3 = paragraph.getTextLength();
            if (n <= n3) {
                return n2 + LWTextArea.prevValidCursorIndex(paragraph.getText(), n);
            }
            n2 += n3;
            n -= n3;
        }
        throw new IndexOutOfBoundsException();
    }

    public Dimension getPreferredSize() {
        return this._rowsAndColumnsToSize(this.getRows(), this.getColumns());
    }

    public Dimension getMinimumSize() {
        int n = this.getColumns();
        int n2 = n <= 10 ? n : 10;
        return this._rowsAndColumnsToSize(1, n2);
    }

    public boolean isVScrollable() {
        return true;
    }

    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        if (!this.isVScrollable() || this._vAdjustable != null) {
            throw new ScrollableException();
        }
        this._vAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (adjustable == this._vAdjustable) {
            this._vAdjustable = null;
        } else {
            super.detachAdjustable(adjustable);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._highWaterWidth = 0;
        this._invalidateWrapping();
        this.invalidateCanvas();
    }

    public BorderPainter getBorderPainter() {
        if (this.getHAdjustable() == null && this.getVAdjustable() == null) {
            return super.getBorderPainter();
        }
        return _SCROLLED_BORDER_PAINTER;
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        if (this._isBIDIEnabled()) {
            this._bidiFilter = new BIDIFilter(this.getActualReadingDirection(), locale);
        }
    }

    protected void updateReadingDirection(int n) {
        super.updateReadingDirection(n);
        if (n == 2) {
            this._enableBIDI();
        }
        if (this._isBIDIEnabled()) {
            if (this._bidiFilter == null) {
                this._bidiFilter = new BIDIFilter(this.getActualReadingDirection(), LocaleUtils.getDefaultableLocale(this));
            } else {
                this._bidiFilter.setReadingDirection(this.getActualReadingDirection());
            }
        }
    }

    protected void updateAlignment(int n) {
        super.updateAlignment(n);
        this._updateCanvasOrigin();
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = paintContext.getFontMetrics(this.getFont());
        int n5 = fontMetrics.getHeight();
        int n6 = (n2 + n4) / n5 * n5;
        int n7 = n6 - n2;
        int n8 = Math.max(n3, this.getCanvasWidth());
        return new Rectangle(n8, n7, n3, n7);
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        this._paintText(graphics, false);
    }

    void setGlobalPaintStart(int n) {
        this._globalPaintStart = n;
    }

    int getGlobalPaintStart() {
        return this._globalPaintStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _paintText(Graphics graphics, boolean bl) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            FontMetrics fontMetrics;
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            Color color = null;
            if (!this.isEnabled()) {
                color = this.__getDisabledTextColor();
            }
            if ((fontMetrics = graphics.getFontMetrics()) == null) {
                return;
            }
            int n = fontMetrics.getHeight();
            int n2 = rectangle.y / n;
            int n3 = (rectangle.y + rectangle.height + (n - 1)) / n;
            int n4 = n2 * n + fontMetrics.getAscent() + fontMetrics.getLeading();
            int n5 = 0;
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    this._paintTextParagraphs(graphics, n5, n4, n2, n3, n, color, bl);
                }
            } else {
                this._paintTextParagraphs(graphics, n5, n4, n2, n3, n, color, bl);
            }
        }
    }

    private synchronized void _paintTextParagraphs(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        Object object;
        Object object2;
        Color color2 = null;
        if (!this.isEnabled()) {
            color2 = graphics.getColor();
            graphics.setColor(color);
        }
        ParagraphPosition paragraphPosition = this._relativeRowToPosition(n3, null);
        ParagraphPosition paragraphPosition2 = this._relativeRowToPosition(n4 - n3, paragraphPosition);
        int n6 = paragraphPosition.paragraph;
        this.setGlobalPaintStart(paragraphPosition.globalIndex);
        if (n6 == paragraphPosition2.paragraph) {
            if (paragraphPosition.column == 0) {
                object2 = this._getParagraph(n6);
                ((Paragraph)object2).paintText(graphics, n, n2, n5, paragraphPosition.row, paragraphPosition2.row);
            }
        } else {
            int n7 = paragraphPosition.row;
            while (n6 < paragraphPosition2.paragraph) {
                n2 = this._getParagraph(n6++).paintText(graphics, n, n2, n5, n7, Integer.MAX_VALUE);
                n7 = 0;
            }
            this._getParagraph(paragraphPosition2.paragraph).paintText(graphics, n, n2, n5, 0, paragraphPosition2.row);
        }
        if (color2 != null) {
            graphics.setColor(color2);
        }
        if ((object2 = (ParagraphPosition)this.getDropPosition()) != null) {
            object = this._getParagraph(((ParagraphPosition)object2).paragraph);
            ((Paragraph)object).paintInsertionPoint(graphics, 0, ((ParagraphPosition)object2).globalRow * n5, ((ParagraphPosition)object2).row, ((ParagraphPosition)object2).column);
        }
        if (bl && this.hasWindowFocus()) {
            object = (ParagraphPosition)this.getSelectionStartPos();
            ParagraphPosition paragraphPosition3 = (ParagraphPosition)this.getSelectionEndPos();
            if (paragraphPosition.globalIndex <= paragraphPosition3.globalIndex && paragraphPosition2.globalIndex >= ((ParagraphPosition)object).globalIndex) {
                if (((ParagraphPosition)object).globalIndex == paragraphPosition3.globalIndex) {
                    if (this.hasGlobalFocus()) {
                        this._getParagraph(((ParagraphPosition)object).paragraph).paintInsertionPoint(graphics, 0, ((ParagraphPosition)object).globalRow * n5, ((ParagraphPosition)object).row, ((ParagraphPosition)object).column);
                    }
                } else {
                    if (paragraphPosition.paragraph > ((ParagraphPosition)object).paragraph) {
                        object = paragraphPosition;
                    }
                    if (paragraphPosition2.paragraph < paragraphPosition3.paragraph) {
                        paragraphPosition3 = paragraphPosition2;
                    }
                    n2 = ((ParagraphPosition)object).globalRow * n5;
                    UIDefaults uIDefaults = this.getUIDefaults();
                    Object object3 = this.hasGlobalFocus() ? LookAndFeel.TEXT_HIGHLIGHT : LookAndFeel.SECONDARY_TEXT_HIGHLIGHT;
                    Color color3 = uIDefaults.getColor(object3);
                    Color color4 = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT);
                    for (int i = ((ParagraphPosition)object).paragraph; i <= paragraphPosition3.paragraph; ++i) {
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        if (i == ((ParagraphPosition)object).paragraph) {
                            n11 = ((ParagraphPosition)object).row;
                            n10 = ((ParagraphPosition)object).column;
                        } else {
                            n11 = 0;
                            n10 = 0;
                        }
                        if (i == paragraphPosition3.paragraph) {
                            n9 = paragraphPosition3.row;
                            n8 = paragraphPosition3.column;
                        } else {
                            n9 = Integer.MAX_VALUE;
                            n8 = Integer.MAX_VALUE;
                        }
                        n2 = this._getParagraph(i).paintSelectionRange(graphics, 0, n2, n5, n11, n9, n10, n8, color4, color3);
                    }
                }
            }
        }
    }

    protected void paintCanvasInterior(Graphics graphics) {
        this._paintText(graphics, this._isOKToDrawSelection);
    }

    protected Dimension layoutCanvas() {
        return this._calculateCanvasSize();
    }

    protected int getVOffsetOfValue(int n) {
        FontMetrics fontMetrics = this._getFontMetrics();
        if (fontMetrics != null) {
            return -(n * fontMetrics.getHeight());
        }
        return 0;
    }

    protected int getVMaximum() {
        return this._getRowCount();
    }

    protected int getVValueOfOffset(int n) {
        FontMetrics fontMetrics = this._getFontMetrics();
        if (fontMetrics != null) {
            return -n / fontMetrics.getHeight();
        }
        return 0;
    }

    protected int getNoWrapColumnCount() {
        return 200;
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected String paramString() {
        String string = super.paramString();
        string = string + ", " + this.getRows() + " rows";
        return string;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            Point point = this.getInnerOrigin();
            Point point2 = this.getCanvasOrigin();
            int n = mouseEvent.getX() - point.x - point2.x;
            int n2 = mouseEvent.getY() - point.y - point2.y;
            switch (mouseEvent.getID()) {
                case 501: {
                    int n3;
                    int n4;
                    if (!this.getInnerBounds().contains(mouseEvent.getX(), mouseEvent.getY()) || mouseEvent.getClickCount() != 1) break;
                    ParagraphPosition paragraphPosition = this._canvasPixelToPosition(n, n2);
                    if (this.getEWTDropTarget() != null && (n4 = this.getSelectionStart()) != (n3 = this.getSelectionEnd()) && paragraphPosition.getIndex() >= n4 && paragraphPosition.getIndex() <= n3) {
                        this._mightDrag = true;
                    }
                    if (!this._mightDrag) {
                        this._moveCursorAbsolute(paragraphPosition, mouseEvent.isShiftDown());
                        this._mouseDown = true;
                    }
                    this.requestFocus();
                    break;
                }
                case 502: {
                    this._mouseDown = false;
                    if (!this._mightDrag) break;
                    ParagraphPosition paragraphPosition = this._canvasPixelToPosition(n, n2);
                    this._moveCursorAbsolute(paragraphPosition, mouseEvent.isShiftDown());
                    this._mightDrag = false;
                    break;
                }
                case 500: {
                    int n5 = mouseEvent.getClickCount();
                    if (n5 <= 1) break;
                    if (n5 == 2) {
                        this._selectWord(this._canvasPixelToPosition(n, n2));
                    } else {
                        int n6 = this._canvasYToRow(n2);
                        if (n6 < 0) {
                            n6 = 0;
                        } else {
                            int n7 = this._getRowCount();
                            if (n6 >= n7) {
                                n6 = n7 - 1;
                            }
                        }
                        this._selectRow(n6);
                    }
                    this._mightDrag = false;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && this._mouseDown && mouseEvent.getID() == 506 && this.getDropPosition() == null) {
            Point point = this.getInnerOrigin();
            Point point2 = this.getCanvasOrigin();
            int n = mouseEvent.getX() - point.x - point2.x;
            int n2 = mouseEvent.getY() - point.y - point2.y;
            this.growSelection(this._canvasPixelToPosition(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isAltDown()) {
            return;
        }
        int n = keyEvent.getID();
        boolean bl = n == 402;
        int n2 = keyEvent.getKeyCode();
        if (bl && n2 == 9) {
            this._tabPressed = false;
        }
        if (!keyEvent.isConsumed()) {
            boolean bl2 = n == 401;
            boolean bl3 = true;
            switch (n2) {
                case 35: 
                case 36: {
                    TextPosition textPosition;
                    if (!bl2) break;
                    if (!keyEvent.isControlDown()) {
                        LWTextArea lWTextArea = this;
                        synchronized (lWTextArea) {
                            ParagraphPosition paragraphPosition = (ParagraphPosition)(this.isSelectionAnchoredAtStart() ? this.getSelectionEndPos() : this.getSelectionStartPos());
                            Paragraph paragraph = this._getParagraph(paragraphPosition.paragraph);
                            int n3 = n2 == 36 ? paragraph.getRowStart(paragraphPosition.row) : paragraph.getRowDisplayEnd(paragraphPosition.row);
                            ParagraphPosition paragraphPosition2 = (ParagraphPosition)paragraphPosition.clone();
                            int n4 = n3 - paragraphPosition.index;
                            paragraphPosition2.column += n4;
                            paragraphPosition2.index += n4;
                            paragraphPosition2.globalIndex += n4;
                            textPosition = paragraphPosition2;
                        }
                    } else {
                        textPosition = this.getPosition(n2 == 36 ? 0 : this.getTextLength());
                    }
                    this._moveCursorAbsolute(textPosition, keyEvent.isShiftDown());
                    break;
                }
                case 9: {
                    if (!bl2) break;
                    boolean bl4 = this.isEditable();
                    boolean bl5 = FocusUtils.areNewFocusAPIsAvailable();
                    boolean bl6 = keyEvent.isShiftDown();
                    boolean bl7 = keyEvent.isControlDown();
                    if (!(bl7 || !bl4 && bl5)) {
                        if (!bl6 && bl4) {
                            this._tabPressed = true;
                            break;
                        }
                        if (bl5) {
                            bl3 = true;
                            FocusUtils.transferFocus(this, !bl6);
                            break;
                        }
                        bl3 = false;
                        break;
                    }
                    bl3 = true;
                    FocusUtils.transferFocus(this, !bl6);
                    break;
                }
                case 33: 
                case 34: {
                    if (!bl2) break;
                    this._scrollByPage(n2 == 34);
                    break;
                }
                case 38: 
                case 40: {
                    if (!bl2) break;
                    int n5 = n2 == 38 ? -1 : 1;
                    this._moveCursorYRelative(n5, keyEvent.isShiftDown());
                    break;
                }
                default: {
                    bl3 = false;
                }
            }
            if (bl3) {
                keyEvent.consume();
            }
        }
    }

    protected void setCanvasSize(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.getCanvasSize().width != n;
        if (bl) {
            this.freezeRepaints();
        }
        super.setCanvasSize(n, n2);
        if (bl) {
            this._invalidateWrapping();
            this._updateCanvasOrigin();
            this.repaintInterior();
            this.unfreezeRepaints();
        }
    }

    synchronized int findWordBoundary(int n, boolean bl) {
        ParagraphPosition paragraphPosition = this._relativeIndexToPosition(n, null);
        Range range = this._getParagraph(paragraphPosition.paragraph).findWord(paragraphPosition.index);
        if (!bl) {
            range.start += paragraphPosition.getParagraphStartIndex();
            if (range.start == n && n > 0) {
                return this.findWordBoundary(this.prevValidCursorIndex(n), bl);
            }
            return range.start;
        }
        range.end += paragraphPosition.getParagraphStartIndex();
        if (range.end == n && n < this.getTextLength()) {
            return this.findWordBoundary(this.nextValidCursorIndex(n), bl);
        }
        return range.end;
    }

    int _getWrapValidCount() {
        return this._wrapValidCount;
    }

    private void _enableBIDI() {
        this._bidiEnabled = true;
    }

    boolean _isBIDIEnabled() {
        return this._bidiEnabled;
    }

    DisplayStringFilter _getBIDIFilter() {
        if (this._bidiFilter == null) {
            this._bidiFilter = new BIDIFilter(this.getActualReadingDirection(), LocaleUtils.getDefaultableLocale(this));
        }
        return this._bidiFilter;
    }

    TextPosition canvasToPosition(int n, int n2) {
        return this._canvasPixelToPosition(n, n2);
    }

    public TextPosition getPosition(int n) {
        if (n == 0) {
            return new ParagraphPosition();
        }
        return this._relativeIndexToPosition(n, null);
    }

    synchronized Rectangle replaceRangeValue(String object, int n, int n2) {
        Object object2;
        int n3;
        if (!this._isBIDIEnabled() && StringUtils.containsRightToLeft((String)object)) {
            this._enableBIDI();
        }
        if (this._paragraphs == null || n == 0 && n2 >= this.getTextLength()) {
            this._paragraphs = Paragraph.createParagraphs(this, (String)object, true);
            this._paragraphCount = this._paragraphs.length;
            this._setTextLength(((String)object).length());
            this._invalidateWrapping();
            Dimension dimension = this.getCanvasSize();
            return new Rectangle(0, 0, dimension.width, dimension.height);
        }
        boolean bl = this._rowCount >= 0;
        ParagraphPosition paragraphPosition = this._relativeIndexToPosition(n, null);
        ParagraphPosition paragraphPosition2 = n == n2 ? paragraphPosition : this._relativeIndexToPosition(n2 - n, paragraphPosition);
        this._cachedPosition = paragraphPosition;
        if (paragraphPosition.index != 0) {
            this._cachedPosition = (ParagraphPosition)paragraphPosition.clone();
            this._cachedPosition.globalIndex -= paragraphPosition.index;
            this._cachedPosition.index = 0;
            this._cachedPosition.globalRow -= paragraphPosition.row;
            this._cachedPosition.row = 0;
            this._cachedPosition.column = 0;
        }
        this._setTextLength(this.getTextLength() + (n - n2) + ((String)object).length());
        Paragraph paragraph = this._getParagraph(paragraphPosition.paragraph);
        boolean bl2 = false;
        int n4 = paragraph.getRowCount();
        if (bl) {
            this._rowCount -= n4;
        }
        if (paragraphPosition.paragraph == paragraphPosition2.paragraph) {
            if (paragraph.removeText(paragraphPosition.index, paragraphPosition2.index)) {
                if (paragraphPosition.paragraph < this._paragraphCount - 1) {
                    this._removeParagraphs(paragraphPosition.paragraph, 1);
                }
            } else {
                bl2 = true;
            }
        } else {
            paragraph.removeText(paragraphPosition.index, Integer.MAX_VALUE);
            Paragraph paragraph2 = this._paragraphs[paragraphPosition2.paragraph];
            if (bl) {
                this._rowCount -= this._addRowCount(paragraphPosition.paragraph + 1, paragraphPosition2.paragraph);
            }
            this._removeParagraphs(paragraphPosition.paragraph + 1, paragraphPosition2.paragraph - paragraphPosition.paragraph);
            paragraph.insertText(paragraph2.getText(paragraphPosition2.index, Integer.MAX_VALUE), Integer.MAX_VALUE);
        }
        if ((n3 = ((String)object).indexOf(10, 0)) < 0) {
            paragraph.insertText((String)object, paragraphPosition.index);
        } else {
            object2 = paragraph.getText(paragraphPosition.index, Integer.MAX_VALUE);
            if (((String)object2).length() > 0) {
                paragraph.removeText(paragraphPosition.index, Integer.MAX_VALUE);
            }
            paragraph.insertText(((String)object).substring(0, n3 + 1), paragraphPosition.index);
            object = ((String)object).length() == n3 + 1 ? object2 : ((String)object).substring(n3 + 1) + (String)object2;
            Paragraph[] paragraphArray = Paragraph.createParagraphs(this, (String)object, paragraphPosition.paragraph == this._paragraphCount - 1);
            this._insertParagraphs(paragraphPosition.paragraph + 1, paragraphArray);
            if (bl) {
                this._rowCount += this._addRowCount(paragraphPosition.paragraph + 1, paragraphPosition.paragraph + paragraphArray.length);
            }
            bl2 = false;
        }
        if (bl) {
            this._rowCount += paragraph.getRowCount();
        }
        int n5 = 0;
        if (this.isShowing()) {
            object2 = this._calculateCanvasSize();
            this.setCanvasSize(((Dimension)object2).width, ((Dimension)object2).height);
            FontMetrics fontMetrics = this._getFontMetrics();
            if (fontMetrics != null) {
                int n6 = fontMetrics.getHeight();
                int n7 = paragraphPosition.globalRow;
                int n8 = paragraphPosition.row;
                if (n8 > 0) {
                    --n8;
                    --n7;
                }
                n5 = n7 * n6;
                ((Dimension)object2).height = bl2 && paragraph.getRowCount() == n4 ? (n4 - n8 + 1) * n6 : (((Dimension)object2).height -= n5);
            }
        } else {
            object2 = this.getCanvasSize();
        }
        return new Rectangle(0, n5, ((Dimension)object2).width, ((Dimension)object2).height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point scrollSelectionIntoView(TextPosition textPosition) {
        Font font = this.getFont();
        if (font != null) {
            int n;
            Serializable serializable;
            int n2;
            int n3;
            Point point = this._positionToCanvasPixel((ParagraphPosition)textPosition);
            Point point2 = this.getCanvasOrigin();
            Dimension dimension = this.getInnerSize();
            int n4 = n3 = this._doesWrap() ? 0 : point.x + point2.x;
            if (n3 > 0) {
                ++n3;
                if ((n3 -= dimension.width) < 0) {
                    n3 = 0;
                }
            }
            if ((n2 = point.y + point2.y) > 0 && (serializable = this.getFontMetrics(font)) != null && (n2 -= dimension.height - (n = serializable.getHeight())) < 0) {
                n2 = 0;
            }
            if (n3 == 0 && n2 == 0) {
                return null;
            }
            serializable = new Point(point2.x - n3, point2.y - n2);
            Dimension dimension2 = this.getCanvasSize();
            if (-((Point)serializable).y > dimension2.height - dimension.height) {
                ((Point)serializable).y = -(dimension2.height - dimension.height);
            }
            boolean bl = false;
            if (-((Point)serializable).x > dimension2.width - dimension.width) {
                this._highWaterWidth = -((Point)serializable).x + dimension.width;
                bl = true;
            } else if (((Point)serializable).x > 0) {
                this._highWaterWidth = dimension2.width + ((Point)serializable).x;
                bl = true;
            }
            if (bl) {
                this.freezeRepaints();
                try {
                    this.setCanvasSize(this._highWaterWidth, dimension2.height);
                    this.setCanvasOrigin(point2.x, point2.y);
                }
                finally {
                    this.unfreezeRepaints();
                }
            }
            return serializable;
        }
        return null;
    }

    synchronized Rectangle getChangedSelectionBounds(TextPosition textPosition, TextPosition textPosition2) {
        TextPosition textPosition3;
        TextPosition textPosition4 = this.getSelectionStartPos();
        if (!textPosition4.equals(textPosition3 = this.getSelectionEndPos()) && !textPosition.equals(textPosition2)) {
            if (textPosition4.equals(textPosition)) {
                if (textPosition2.getIndex() < textPosition3.getIndex()) {
                    return this.getSelectionBounds(textPosition2, textPosition3);
                }
                return this.getSelectionBounds(textPosition3, textPosition2);
            }
            if (textPosition3.equals(textPosition2)) {
                if (textPosition.getIndex() < textPosition4.getIndex()) {
                    return this.getSelectionBounds(textPosition, textPosition4);
                }
                return this.getSelectionBounds(textPosition4, textPosition);
            }
        }
        return super.getChangedSelectionBounds(textPosition, textPosition2);
    }

    public synchronized Rectangle getSelectionBounds(TextPosition textPosition, TextPosition textPosition2) {
        ParagraphPosition paragraphPosition = (ParagraphPosition)textPosition;
        ParagraphPosition paragraphPosition2 = (ParagraphPosition)textPosition2;
        FontMetrics fontMetrics = this._getFontMetrics();
        if (fontMetrics == null) {
            return null;
        }
        int n = fontMetrics.getHeight();
        int n2 = paragraphPosition.globalRow * n;
        if (paragraphPosition.globalIndex == paragraphPosition2.globalIndex) {
            int n3 = CursorUtils.getcaretWidth();
            int n4 = 0;
            n4 += this._getParagraph(paragraphPosition.paragraph).measureWidth(fontMetrics, paragraphPosition.row, paragraphPosition.column);
            return new Rectangle(n4 += this._getParagraph(paragraphPosition.paragraph)._getRowAlignmentOffset(paragraphPosition.row), n2, n3, n);
        }
        return new Rectangle(0, n2, this.getCanvasSize().width, (paragraphPosition2.globalRow - paragraphPosition.globalRow + 1) * n);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this._updateCanvasOrigin();
    }

    char translateKeyChar(char c) {
        if (c == '\r') {
            return '\n';
        }
        if (c == '\t') {
            if (this._tabPressed) {
                return c;
            }
            return StringUtils.CHAR_UNDEFINED;
        }
        return super.translateKeyChar(c);
    }

    FontMetrics _getFontMetrics() {
        FontMetrics fontMetrics = this._metrics;
        Font font = this.getFont();
        if ((fontMetrics == null || fontMetrics.getFont() != font) && font != null) {
            this._metrics = fontMetrics = new TabbedFontMetrics(this.getFontMetrics(font), this.getTabStop());
        }
        return fontMetrics;
    }

    int _getNextTab(int n, boolean bl) {
        return ((TabbedFontMetrics)this._getFontMetrics()).getNextTab(n, bl);
    }

    int _getWrapWidth() {
        int n = this.getCanvasSize().width;
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    private int _canvasYToRow(int n) {
        int n2;
        if (n <= 0) {
            return -1;
        }
        FontMetrics fontMetrics = this._getFontMetrics();
        if (fontMetrics == null) {
            return 0;
        }
        int n3 = n / fontMetrics.getHeight();
        if (n3 > (n2 = this._getRowCount())) {
            n3 = n2;
        }
        return n3;
    }

    private ParagraphPosition _relativeRowToPosition(int n, ParagraphPosition paragraphPosition) {
        int n2;
        int n3;
        Paragraph paragraph;
        int n4;
        int n5;
        int n6;
        ParagraphPosition paragraphPosition2 = this._cachedPosition;
        if (paragraphPosition2 != null) {
            n6 = paragraphPosition2.globalRow - paragraphPosition2.row;
            int n7 = n5 = paragraphPosition == null ? 0 : paragraphPosition.globalRow;
            if (Math.abs(n6 - (n5 + n)) < n) {
                n -= paragraphPosition2.globalRow - n5;
                paragraphPosition = paragraphPosition2;
            }
        }
        if (paragraphPosition == null) {
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else {
            n4 = paragraphPosition.paragraph;
            n5 = paragraphPosition.globalRow - paragraphPosition.row;
            n += paragraphPosition.row;
            n6 = paragraphPosition.globalIndex - paragraphPosition.index;
        }
        if (n < 0) {
            while (--n4 >= 0) {
                Paragraph paragraph2 = this._getParagraph(n4);
                int n8 = paragraph2.getRowCount();
                int n9 = paragraph2.getTextLength();
                n5 -= n8;
                n6 -= n9;
                if ((n += n8) < 0) continue;
                int n10 = paragraph2.getRowStart(n);
                return new ParagraphPosition(n4, n6 + n10, n10, n5 + n, n, 0);
            }
            return new ParagraphPosition();
        }
        while (n4 < this._paragraphCount) {
            paragraph = this._getParagraph(n4);
            n3 = paragraph.getRowCount();
            n2 = paragraph.getTextLength();
            if (n3 > n) {
                int n11 = paragraph.getRowStart(n);
                return new ParagraphPosition(n4, n6 + n11, n11, n5 + n, n, 0);
            }
            n -= n3;
            n5 += n3;
            n6 += n2;
            ++n4;
        }
        paragraph = this._getParagraph(--n4);
        n3 = paragraph.getTextLength();
        n2 = paragraph.getRowCount();
        return new ParagraphPosition(n4, n6, n3, n5 - 1, n2 - 1, n3 - paragraph.getRowStart(n2 - 1));
    }

    private ParagraphPosition _relativeIndexToPosition(int n, ParagraphPosition paragraphPosition) {
        int n2;
        int n3;
        Paragraph paragraph;
        int n4;
        int n5;
        int n6;
        ParagraphPosition paragraphPosition2 = this._cachedPosition;
        if (paragraphPosition2 != null) {
            n6 = paragraphPosition2.getParagraphStartIndex();
            int n7 = n5 = paragraphPosition == null ? 0 : paragraphPosition.globalIndex;
            if (Math.abs(n6 - (n5 + n)) < n) {
                n -= paragraphPosition2.globalIndex - n5;
                paragraphPosition = paragraphPosition2;
            }
        }
        if (n == 0 && paragraphPosition != null) {
            return (ParagraphPosition)paragraphPosition.clone();
        }
        if (paragraphPosition == null) {
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else {
            n4 = paragraphPosition.paragraph;
            n5 = paragraphPosition.globalRow - paragraphPosition.row;
            n6 = paragraphPosition.globalIndex - paragraphPosition.index;
            n += paragraphPosition.index;
        }
        if (n < 0) {
            while (--n4 >= 0) {
                Paragraph paragraph2 = this._getParagraph(n4);
                int n8 = paragraph2.getRowCount();
                int n9 = paragraph2.getTextLength();
                n5 -= n8;
                n6 -= n9;
                if ((n += n9) < 0) continue;
                Point point = paragraph2.indexToRowAndColumn(n);
                return new ParagraphPosition(n4, n6 + n, n, n5 + point.y, point.y, point.x);
            }
            return new ParagraphPosition();
        }
        while (n4 < this._paragraphCount) {
            paragraph = this._getParagraph(n4);
            n3 = paragraph.getRowCount();
            n2 = paragraph.getTextLength();
            if (n2 > n) {
                Point point = paragraph.indexToRowAndColumn(n);
                return new ParagraphPosition(n4, n6 + n, n, n5 + point.y, point.y, point.x);
            }
            n5 += n3;
            n6 += n2;
            n -= n2;
            ++n4;
        }
        paragraph = this._getParagraph(--n4);
        n3 = paragraph.getTextLength();
        n2 = paragraph.getRowCount();
        if (this.getFont() != null) {
            return new ParagraphPosition(n4, n6, n3, n5 - 1, n2 - 1, n3 - paragraph.getRowStart(n2 - 1));
        }
        return new ParagraphPosition(n4, n6, n3, 0, 0, 0);
    }

    private Point _positionToCanvasPixel(ParagraphPosition paragraphPosition) {
        FontMetrics fontMetrics = this._getFontMetrics();
        if (fontMetrics == null) {
            return new Point();
        }
        Paragraph paragraph = this._getParagraph(paragraphPosition.paragraph);
        int n = paragraph._getRowAlignmentOffset(paragraphPosition.row);
        return new Point(paragraph.measureWidth(fontMetrics, paragraphPosition.row, paragraphPosition.column) + n, paragraphPosition.globalRow * fontMetrics.getHeight());
    }

    private ParagraphPosition _canvasPixelToPosition(int n, int n2) {
        int n3 = this._canvasYToRow(n2);
        if (n3 < 0) {
            return new ParagraphPosition();
        }
        ParagraphPosition paragraphPosition = this._relativeRowToPosition(n3, null);
        if (paragraphPosition.column == 0) {
            Paragraph paragraph = this._getParagraph(paragraphPosition.paragraph);
            int n4 = paragraph.pixelToIndex(this._getFontMetrics(), n, paragraphPosition.row) - paragraphPosition.index;
            paragraphPosition = new ParagraphPosition(paragraphPosition.paragraph, paragraphPosition.globalIndex + n4, paragraphPosition.index + n4, paragraphPosition.globalRow, paragraphPosition.row, paragraphPosition.column + n4);
        }
        this._cachedPosition = paragraphPosition;
        return paragraphPosition;
    }

    private void _selectWord(ParagraphPosition paragraphPosition) {
        Range range = this._getParagraph(paragraphPosition.paragraph).findWord(paragraphPosition.index);
        this.select(paragraphPosition.getParagraphStartIndex() + range.start, paragraphPosition.getParagraphStartIndex() + range.end);
    }

    private void _selectRow(int n) {
        ParagraphPosition paragraphPosition = this._relativeRowToPosition(n, null);
        Paragraph paragraph = this._getParagraph(paragraphPosition.paragraph);
        this.select(paragraphPosition.globalIndex, paragraphPosition.globalIndex - paragraphPosition.index + paragraph.getRowEnd(paragraphPosition.row));
    }

    private void _setTextLength(int n) {
        this._numChars = n;
    }

    private void _moveCursorYRelative(int n, boolean bl) {
        ParagraphPosition paragraphPosition;
        ParagraphPosition paragraphPosition2 = (ParagraphPosition)(this.isSelectionAnchoredAtStart() ? this.getSelectionEndPos() : this.getSelectionStartPos());
        if (n < 0 && paragraphPosition2.globalRow == 0) {
            paragraphPosition = new ParagraphPosition();
        } else {
            FontMetrics fontMetrics = this._getFontMetrics();
            if (fontMetrics != null) {
                int n2 = fontMetrics.getHeight();
                Paragraph paragraph = this._getParagraph(paragraphPosition2.paragraph);
                int n3 = paragraph.measureWidth(fontMetrics, paragraphPosition2.row, paragraphPosition2.column);
                int n4 = (paragraphPosition2.globalRow + n) * n2;
                paragraphPosition = this._canvasPixelToPosition(n3 += paragraph._getRowAlignmentOffset(paragraphPosition2.row), n4);
            } else {
                paragraphPosition = paragraphPosition2;
            }
        }
        this._moveCursorAbsolute(paragraphPosition, bl);
    }

    private Dimension _rowsAndColumnsToSize(int n, int n2) {
        int n3;
        int n4;
        FontMetrics fontMetrics = this._getFontMetrics();
        if (fontMetrics == null) {
            n4 = 0;
            n3 = 0;
        } else {
            n4 = FontUtils.getAverageWidth(fontMetrics) * n2;
            n3 = fontMetrics.getHeight() * n;
        }
        return this.convertInnerToOuterSize(n4, n3);
    }

    private int _getRowCount() {
        int n = this._rowCount;
        if (n < 0) {
            this._rowCount = n = this._addRowCount(0, this._paragraphCount - 1);
        }
        return n;
    }

    private Paragraph _getParagraph(int n) {
        return this._paragraphs[n];
    }

    private int _addRowCount(int n, int n2) {
        if (!this._doesWrap()) {
            return n2 - n + 1;
        }
        int n3 = 0;
        while (n <= n2) {
            n3 += this._getParagraph(n++).getRowCount();
        }
        return n3;
    }

    private void _insertParagraphs(int n, Paragraph[] paragraphArray) {
        Paragraph[] paragraphArray2;
        int n2 = this._paragraphCount;
        Paragraph[] paragraphArray3 = this._paragraphs;
        if (n2 + paragraphArray.length > paragraphArray3.length) {
            paragraphArray2 = new Paragraph[n2 + paragraphArray.length + 4];
            System.arraycopy(paragraphArray3, 0, paragraphArray2, 0, n);
            this._paragraphs = paragraphArray2;
        } else {
            paragraphArray2 = this._paragraphs;
        }
        System.arraycopy(paragraphArray3, n, paragraphArray2, n + paragraphArray.length, n2 - n);
        System.arraycopy(paragraphArray, 0, paragraphArray2, n, paragraphArray.length);
        this._paragraphCount = n2 + paragraphArray.length;
    }

    private void _removeParagraphs(int n, int n2) {
        Paragraph[] paragraphArray = this._paragraphs;
        int n3 = this._paragraphCount;
        System.arraycopy(paragraphArray, n + n2, paragraphArray, n, n3 - (n + n2));
        for (int i = n3 - n2; i < n3; ++i) {
            paragraphArray[i] = null;
        }
        this._paragraphCount = n3 - n2;
    }

    private Dimension _calculateCanvasSize() {
        Dimension dimension = this.getInnerSize();
        int n = -this.getVOffsetOfValue(this.getVMaximum());
        if (n < dimension.height) {
            n = dimension.height;
        }
        int n2 = dimension.width - 1;
        if (!this._doesWrap()) {
            FontMetrics fontMetrics = this._getFontMetrics();
            if (fontMetrics != null) {
                n2 = this.getNoWrapColumnCount() * FontUtils.getAverageWidth(fontMetrics);
            }
            if (n2 < this._highWaterWidth) {
                n2 = this._highWaterWidth;
            }
        }
        return new Dimension(n2, n);
    }

    private boolean _doesWrap() {
        return !(this.getTextWrapper() instanceof NoWrapper);
    }

    private synchronized void _invalidateWrapping() {
        if (this._paragraphs != null) {
            ++this._wrapValidCount;
            this._rowCount = -1;
            this._cachedPosition = null;
            TextPosition textPosition = this.getPosition(this.getSelectionStartPos().getIndex());
            TextPosition textPosition2 = this.getSelectionEndPos();
            textPosition2 = textPosition2.getIndex() == textPosition.getIndex() ? textPosition : this.getPosition(textPosition2.getIndex());
            this.changeSelection(textPosition, textPosition2);
            if (this.isShowing()) {
                Dimension dimension = this._calculateCanvasSize();
                this.setCanvasSize(dimension.width, dimension.height);
            }
        }
    }

    private void _updateCanvasOrigin() {
        Point point = this.getCanvasOrigin();
        int n = this.getActualAlignment();
        if (n == 1) {
            point.x = 0;
        } else {
            point.x = this.getInnerSize().width - this.getCanvasSize().width;
            if (n == 3) {
                point.x /= 2;
            }
        }
        this.setCanvasOrigin(point.x, point.y);
    }

    private void _scrollByPage(boolean bl) {
        int n;
        FontMetrics fontMetrics = this._getFontMetrics();
        if (fontMetrics == null) {
            return;
        }
        Dimension dimension = this.getInnerSize();
        Dimension dimension2 = this.getCanvasSize();
        if (dimension2.height <= dimension.height) {
            return;
        }
        Point point = this.getCanvasOrigin();
        int n2 = fontMetrics.getHeight();
        int n3 = (dimension.height / n2 - 1) * n2;
        if (bl) {
            n3 = -n3;
        }
        point.y += n3;
        if (-point.y < 0) {
            point.y = 0;
        }
        if (point.y < (n = this.getVOffsetOfValue(this.getVMaximum()) - n3)) {
            point.y = n;
        }
        this.setCanvasOrigin(point.x, point.y);
    }

    private void _init(String string, int n) {
        this._wrapper = NoWrapper.getTextWrapper();
        this.replaceRangeValue(this.replaceRangeFilter(string, 0, 0), 0, 0);
        if (n < 0) {
            throw new IllegalArgumentException("rows must be >= 0");
        }
        this._preferredRows = n;
        this._rowCount = -1;
        this._tabStop = 4;
        this.enableEvents(56L);
        FocusUtils.setFocusTraversalKeysEnabled(this, false);
    }

    private class Access
    extends AccessibleLWTextComponent {
        public Access() {
            super(LWTextArea.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }

        public int getIndexAtPoint(Point point) {
            point = LWTextArea.this.convertOuterToCanvas(point.x, point.y);
            return LWTextArea.this._canvasPixelToPosition(point.x, point.y).getIndex();
        }

        public Rectangle getCharacterBounds(int n) {
            if (n < 0 || n >= LWTextArea.this.getTextLength()) {
                return new Rectangle();
            }
            try {
                Rectangle rectangle = LWTextArea.this.getSelectionBounds(LWTextArea.this.getPosition(n), LWTextArea.this.getPosition(n + 1));
                Point point = LWTextArea.this.getCanvasOrigin();
                ImmInsets immInsets = LWTextArea.this.getBorderInsets();
                rectangle.x += point.x + immInsets.left;
                rectangle.y += point.y + immInsets.top;
                return rectangle;
            }
            catch (Exception exception) {
                return new Rectangle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getAtIndex(int n, int n2) {
            if (n == 1) {
                Access access = this;
                synchronized (access) {
                    if (n2 < 0 || n2 >= LWTextArea.this.getTextLength()) {
                        return null;
                    }
                    ParagraphPosition paragraphPosition = (ParagraphPosition)LWTextArea.this.getPosition(n2);
                    Paragraph paragraph = LWTextArea.this._getParagraph(paragraphPosition.paragraph);
                    return paragraph.getText(n2 -= paragraphPosition.getParagraphStartIndex(), n2 + 1);
                }
            }
            return super.getAtIndex(n, n2);
        }
    }
}

