/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.DesktopEvent;
import oracle.ewt.lwAWT.lwWindow.DesktopListener;
import oracle.ewt.lwAWT.lwWindow.LWWindow;

public class DesktopValidater
implements DesktopListener,
ComponentListener {
    private Desktop _desktop;
    private Component _comp;
    private boolean _enabled = true;

    public DesktopValidater(Desktop desktop, Component component) {
        this._desktop = desktop;
        this._comp = component;
        this._desktop.addDesktopListener(this);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        if (this._enabled != bl) {
            this._enabled = bl;
            if (bl) {
                this._validate();
            }
        }
    }

    public void windowAdded(DesktopEvent desktopEvent) {
        this._validate();
        LWWindow lWWindow = desktopEvent.getWindow();
        lWWindow.addComponentListener(this);
    }

    public void windowRemoved(DesktopEvent desktopEvent) {
        this._validate();
        LWWindow lWWindow = desktopEvent.getWindow();
        lWWindow.removeComponentListener(this);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this._validate();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this._validate();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this._validate();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this._validate();
    }

    public void desktopAdded(DesktopEvent desktopEvent) {
    }

    public void desktopRemoved(DesktopEvent desktopEvent) {
    }

    private void _validate() {
        if (this.isEnabled()) {
            this._comp.validate();
        }
    }
}

