/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import oracle.ewt.lwAWT.AbstractPainterComponent;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.VirtualComponent;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.DesktopValidater;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.MDIRootPaneUI;
import oracle.ewt.scrolling.scrollBox.ScrollBox;

public class MDIRootPane
extends LWComponent {
    public static final Painter DEFAULT_LOGO_PAINTER = new NullPainter();
    private Desktop _desktop;
    private Component _menuBar;
    private Component _horzToolBar;
    private Component _vertToolBar;
    private Component _statusBar;
    private ScrollBox _scrollBox;
    private Component _logoComp;
    private LWContainer _statusBarPane;
    private LWContainer _horzToolBarPane;
    private LWContainer _vertToolBarPane;
    private LWContainer _desktopPane;
    private LWComponent _menuPane;
    private Painter _logoPainter = DEFAULT_LOGO_PAINTER;

    public MDIRootPane() {
        this._scrollBox = new ScrollBox(null, 0, 0);
        this._logoComp = new LogoComponent();
        this._menuPane = new LWComponent();
        this._menuPane.setLayout(new MenuLayout());
        this._menuPane.add(this._logoComp);
        this._statusBarPane = new LWContainer();
        this._statusBarPane.setLayout(new BorderLayout());
        this._horzToolBarPane = new LWContainer();
        this._horzToolBarPane.setLayout(new BorderLayout());
        this._vertToolBarPane = new LWContainer();
        this._vertToolBarPane.setLayout(new BorderLayout());
        this._statusBarPane.setVisible(false);
        this._horzToolBarPane.setVisible(false);
        this._vertToolBarPane.setVisible(false);
        this._menuPane.setVisible(false);
        this._desktopPane = new LWContainer();
        this._desktopPane.setLayout(new BorderLayout());
        this._desktopPane.add("West", this._vertToolBarPane);
        this._desktopPane.add("Center", this._scrollBox);
        LWComponent lWComponent = new LWComponent();
        lWComponent.setLayout(new BorderLayout());
        lWComponent.add("North", this._horzToolBarPane);
        lWComponent.add("Center", this._desktopPane);
        this.setLayout(new BorderLayout());
        this.add("North", this._menuPane);
        this.add("Center", lWComponent);
        this.add("South", this._statusBarPane);
        this.updateUI(MDIRootPane.class);
    }

    public Desktop getDesktop() {
        return this._desktop;
    }

    public Painter getLogoPainter() {
        if (this._logoPainter == DEFAULT_LOGO_PAINTER) {
            MDIRootPaneUI mDIRootPaneUI = (MDIRootPaneUI)this.getUI();
            return mDIRootPaneUI.getDefaultLogoPainter(this);
        }
        return this._logoPainter;
    }

    public Component getMenuBar() {
        return this._menuBar;
    }

    public ScrollBox getScrollBox() {
        return this._scrollBox;
    }

    public Component getStatusBar() {
        return this._statusBar;
    }

    public Component getHorizontalToolBar() {
        return this._horzToolBar;
    }

    public Component getVerticalToolBar() {
        return this._vertToolBar;
    }

    public void setDesktop(Desktop desktop) {
        if (this._desktop != desktop) {
            this._desktop = desktop;
            this._scrollBox.setContent(this._desktop.getDesktopComponent());
            new DesktopValidater(this._desktop, this._scrollBox);
        }
    }

    public void setLogoPainter(Painter painter) {
        if (this._logoPainter != painter) {
            this._logoPainter = painter;
            this._logoComp.invalidate();
            this._logoComp.repaint();
        }
    }

    public void setMenuBar(Component component) {
        if (this._menuBar != component) {
            if (this._menuBar != null) {
                this._menuPane.setVisible(false);
                this._menuPane.remove(this._menuBar);
            }
            this._menuBar = component;
            if (this._menuBar != null) {
                this._menuPane.add(this._menuBar);
                this._menuPane.setVisible(true);
            }
        }
    }

    public void setStatusBar(Component component) {
        if (this._statusBar != component) {
            if (this._statusBar != null) {
                this._statusBarPane.setVisible(false);
                this._statusBarPane.remove(this._statusBar);
            }
            this._statusBar = component;
            if (this._statusBar != null) {
                this._statusBarPane.add("Center", this._statusBar);
                this._statusBarPane.setVisible(true);
            }
        }
    }

    public void setHorizontalToolBar(Component component) {
        if (this._horzToolBar != component) {
            if (this._horzToolBar != null) {
                this._horzToolBarPane.setVisible(false);
                this._horzToolBarPane.remove(this._horzToolBar);
            }
            this._horzToolBar = component;
            if (this._horzToolBar != null) {
                this._horzToolBarPane.add("Center", this._horzToolBar);
                this._horzToolBarPane.setVisible(true);
            }
        }
    }

    public void setVerticalToolBar(Component component) {
        if (this._vertToolBar != component) {
            if (this._vertToolBar != null) {
                this._vertToolBarPane.setVisible(false);
                this._vertToolBarPane.remove(this._vertToolBar);
            }
            this._vertToolBar = component;
            if (this._vertToolBar != null) {
                this._vertToolBarPane.add("Center", this._vertToolBar);
                this._vertToolBarPane.setVisible(true);
            }
        }
    }

    public Object getUIClassID() {
        return "MDIRootPaneUI";
    }

    protected void updateUI(Class clazz) {
        if (clazz == MDIRootPane.class) {
            this.updateUI();
        }
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        MDIRootPaneUI mDIRootPaneUI = (MDIRootPaneUI)componentUI;
        this._statusBarPane.setBorderPainter(mDIRootPaneUI.getStatusBarBorder(this));
        this._horzToolBarPane.setBorderPainter(mDIRootPaneUI.getHorizontalToolBarBorder(this));
        this._vertToolBarPane.setBorderPainter(mDIRootPaneUI.getVerticalToolBarBorder(this));
        this._desktopPane.setBorderPainter(mDIRootPaneUI.getDesktopBorder(this));
    }

    Component __getLogoComponent() {
        return this._logoComp;
    }

    Component __getStatusBarPane() {
        return this._statusBarPane;
    }

    Component __getHorizontalToolBarPane() {
        return this._horzToolBarPane;
    }

    Component __getVerticalalToolBarPane() {
        return this._vertToolBarPane;
    }

    private class MenuLayout
    implements LayoutManager {
        private MenuLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Component component = MDIRootPane.this.getMenuBar();
            if (component != null && component.isVisible()) {
                Component component2 = MDIRootPane.this.__getLogoComponent();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = component2.getPreferredSize();
                dimension.width = Math.max(dimension2.width + dimension3.width, dimension.width);
                dimension.height += Math.max(dimension2.height, dimension3.height);
            }
            this._addInsets(dimension, container);
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Component component = MDIRootPane.this.getMenuBar();
            if (component != null && component.isVisible()) {
                Component component2 = MDIRootPane.this.__getLogoComponent();
                Dimension dimension2 = component.getMinimumSize();
                Dimension dimension3 = component2.getMinimumSize();
                dimension.width = Math.max(dimension2.width + dimension3.width, dimension.width);
                dimension.height += Math.max(dimension2.height, dimension3.height);
            }
            this._addInsets(dimension, container);
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = insets.top;
            int n2 = dimension.height - insets.bottom;
            int n3 = insets.left;
            int n4 = dimension.width - insets.right;
            int n5 = n4 - n3;
            Component component = MDIRootPane.this.getMenuBar();
            Component component2 = MDIRootPane.this.__getLogoComponent();
            if (component != null && component.isVisible()) {
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = component2.getPreferredSize();
                if (dimension3.width + dimension2.width > n5) {
                    component2.setVisible(false);
                    component.setBounds(n, n3, n5, dimension2.height);
                    n += dimension2.height;
                } else {
                    component2.setVisible(true);
                    int n6 = Math.max(dimension2.height, dimension3.height);
                    int n7 = n + (n6 - dimension2.height) / 2;
                    int n8 = n + (n6 - dimension3.height) / 2;
                    int n9 = n3;
                    int n10 = n4 - dimension3.width;
                    if (this._isRightToLeft(container)) {
                        n9 = n4 - dimension2.width;
                        n10 = n3;
                    }
                    component.setBounds(n9, n7, dimension2.width, dimension2.height);
                    component2.setBounds(n10, n8, dimension3.width, dimension3.height);
                    n += n6;
                }
            } else {
                component2.setVisible(false);
            }
        }

        private void _addInsets(Dimension dimension, Container container) {
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }

        private boolean _isRightToLeft(Component component) {
            return component instanceof VirtualComponent && ((VirtualComponent)((Object)component)).getActualReadingDirection() == 2;
        }
    }

    private class LogoComponent
    extends AbstractPainterComponent {
        private LogoComponent() {
        }

        public Painter getPainter() {
            Painter painter = MDIRootPane.this.getLogoPainter();
            if (painter == null) {
                painter = NullPainter.getPainter();
            }
            return painter;
        }
    }
}

