/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.event.KeyStroke;
import oracle.ewt.layout.DirectionalBorderLayout;
import oracle.ewt.layout.MaximumBorderLayout;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuInvoker;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuSeparator;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuEvent;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuListener;
import oracle.ewt.lwAWT.lwMenu.MousePopupListener;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.laf.KeyWindowMover;
import oracle.ewt.lwAWT.lwWindow.laf.KeyWindowResizer;
import oracle.ewt.lwAWT.lwWindow.laf.MouseWindowMover;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.TitleBarUI;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarButton;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarPainterItem;
import oracle.ewt.util.ComponentUtils;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;

public final class TitleBar
extends LWComponent
implements PropertyChangeListener,
WindowListener {
    private LWWindow _window;
    private LWMenuBar _systemMenuBar;
    private LWLabel _titleLabel;
    private LWComponent _captionTile;
    private ToolBar _toolbar;
    private ToolBarButton _minimizeButton;
    private ToolBarButton _maximizeButton;
    private ToolBarButton _restoreButton;
    private ToolBarButton _closeButton;
    private FlatSeparator _closeSeparator;
    private SystemMenu _systemMenu;
    private boolean _armed;
    private Window _hwWindow;
    private boolean _hwActive;
    private MousePopupListener _popupListener;
    private static final int _MINIMUM_WIDTH = 150;
    private static LWPopupMenu _sSystemPopup;
    private static LWWindow _sSystemPopupOwner;
    private static KeyStroke _sCloseShortcut;
    private static final String _SYSTEM_MENU_BUNDLE_NAME = "oracle.ewt.lwAWT.lwWindow.laf.resource.SystemMenuBundle";
    private static final String _RESTORE_KEY = "RESTORE";
    private static final String _MOVE_KEY = "MOVE";
    private static final String _RESIZE_KEY = "RESIZE";
    private static final String _MINIMIZE_KEY = "MINIMIZE";
    private static final String _MAXIMIZE_KEY = "MAXIMIZE";
    private static final String _CLOSE_KEY = "CLOSE";
    private static final int _MAX_DEFAULT_ICON_SIZE = 18;

    public TitleBar(LWWindow lWWindow) {
        this._window = lWWindow;
        this._hwActive = true;
        this._createComponents();
        this._updateIcons();
        this._updateButtons();
        this._updateCaptionFill();
        this._updateFrameIcon();
        this._updateTitle();
        this._addListeners();
        this._updateActiveState();
        this._updateEnabledState();
    }

    public final LWWindow getLWWindow() {
        return this._window;
    }

    public boolean isActive() {
        return this.getLWWindow().isActive() && this._hwActive;
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void setArmed(boolean bl) {
        if (bl != this._armed) {
            this._armed = bl;
            this.repaint();
        }
    }

    public Object getUIClassID() {
        return "TitleBarUI";
    }

    public LWMenuBar getSystemMenuBar() {
        return this._systemMenuBar;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("active")) {
            this._updateActiveState();
        } else if (string.equals("enabled")) {
            this._updateEnabledState();
        } else if (string.equals("title")) {
            this._updateTitle();
            bl = true;
        } else if (string.equals("frameIcon")) {
            this._updateFrameIcon();
            bl = true;
        } else if (string.equals("movable")) {
            this._updateCaptionFill();
        } else if (string.equals("type")) {
            this._updateCaptionFill();
            this._updateActiveState();
            this._updateIcons();
            bl = true;
        } else if (string.equals("closable") || string.equals("maximizable") || string.equals("maximized") || string.equals("minimizable") || string.equals("minimized")) {
            this._updateButtons();
            bl = true;
        }
        if (bl) {
            this.validate();
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width = 150;
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        Dimension dimension2 = this.getPreferredSize();
        dimension.height = dimension2.height;
        return dimension;
    }

    public void addNotify() {
        super.addNotify();
        if (this._hwWindow == null) {
            this._hwWindow = WindowUtils.getWindow(this);
            if (this._hwWindow != null) {
                this._hwWindow.addWindowListener(this);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._hwWindow != null) {
            this._hwWindow.removeWindowListener(this);
            this._hwWindow = null;
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this._hwActive = false;
        this._updateActiveState();
    }

    public void windowActivated(WindowEvent windowEvent) {
        this._hwActive = true;
        this._updateActiveState();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    protected void updateReadingDirection(int n) {
        super.updateReadingDirection(n);
        if (this._titleLabel != null) {
            this._titleLabel.invalidate();
        }
    }

    private void _createComponents() {
        TitleBarUI titleBarUI = (TitleBarUI)this.getUI();
        this._systemMenuBar = this._createMenuBar();
        this._titleLabel = new LWLabel();
        this._captionTile = new CaptionComp();
        LWComponent lWComponent = new LWComponent();
        lWComponent.setLayout(new DirectionalBorderLayout());
        lWComponent.add("West", this._titleLabel);
        lWComponent.add("Center", this._captionTile);
        this._toolbar = new ToolBar();
        this._toolbar.setReadingDirection(1);
        this._toolbar.setButtonBorderPainter(titleBarUI.getButtonBorderPainter(this));
        this._toolbar.setBorderPainter(null);
        this._minimizeButton = new ToolBarButton();
        this._restoreButton = new ToolBarButton();
        this._maximizeButton = new ToolBarButton();
        this._closeButton = new ToolBarButton();
        this._closeSeparator = new FlatSeparator(titleBarUI.getCloseButtonSpacing(this));
        this.setLayout(new MaximumBorderLayout());
        this.add("West", this._systemMenuBar);
        this.add("Center", lWComponent);
        this.add("East", this._toolbar);
    }

    private LWMenuBar _createMenuBar() {
        SystemMenuBar systemMenuBar = new SystemMenuBar();
        this._systemMenu = new SystemMenu(this._window.getFrameIcon());
        this._systemMenu.setMnemonicChar('-');
        this._systemMenu.setReadingDirection(1);
        systemMenuBar.setFill(NullPainter.getPainter());
        this._systemMenu.setFill(NullPainter.getPainter());
        systemMenuBar.add(this._systemMenu);
        return systemMenuBar;
    }

    private void _updateActiveState() {
        UIDefaults uIDefaults = this.getUIDefaults();
        boolean bl = this.isActive();
        Color color = bl ? uIDefaults.getColor(LookAndFeel.ACTIVE_CAPTION) : uIDefaults.getColor(LookAndFeel.INACTIVE_CAPTION);
        this.setBackground(color);
        this._toolbar.setBackground(color);
        this._titleLabel.setBackground(color);
        uIDefaults = this.getUIDefaults();
        Color color2 = bl ? uIDefaults.getColor(LookAndFeel.ACTIVE_CAPTION_TEXT) : uIDefaults.getColor(LookAndFeel.INACTIVE_CAPTION_TEXT);
        this._titleLabel.setForeground(color2);
    }

    private void _updateButtons() {
        LWWindow lWWindow = this.getLWWindow();
        boolean bl = lWWindow.isMinimized();
        boolean bl2 = lWWindow.isMaximized();
        this._toolbar.removeAll();
        if (bl) {
            this._toolbar.addItem(this._restoreButton);
            if (lWWindow.isMaximizable()) {
                this._toolbar.addItem(this._maximizeButton);
            }
        } else if (bl2) {
            if (lWWindow.isMinimizable()) {
                this._toolbar.addItem(this._minimizeButton);
            }
            this._toolbar.addItem(this._restoreButton);
        } else {
            if (lWWindow.isMinimizable()) {
                this._toolbar.addItem(this._minimizeButton);
            }
            if (lWWindow.isMaximizable()) {
                this._toolbar.addItem(this._maximizeButton);
            }
        }
        if (lWWindow.isClosable()) {
            this._toolbar.addItem(this._closeSeparator);
            this._toolbar.addItem(this._closeButton);
        }
        this._toolbar.setVisible(this._toolbar.getItemCount() != 0);
    }

    private void _updateCaptionFill() {
        BorderPainter borderPainter;
        LWWindow lWWindow = this.getLWWindow();
        TitleBarUI titleBarUI = (TitleBarUI)this.getUI();
        Painter painter = borderPainter = lWWindow.isMovable() ? titleBarUI.getCaptionFill(this) : NullPainter.getPainter();
        if (borderPainter != this._captionTile.getFill()) {
            this._captionTile.setFill(borderPainter);
        }
    }

    private void _updateEnabledState() {
        LWWindow lWWindow = this.getLWWindow();
        if (lWWindow.isEnabled()) {
            this._toolbar.setEnabled(true);
            this._titleLabel.setEnabled(true);
            this._systemMenu.setEnabled(true);
        } else {
            this._toolbar.setEnabled(false);
            this._titleLabel.setEnabled(false);
            this._systemMenu.setEnabled(false);
        }
    }

    private void _updateFrameIcon() {
        LWWindow lWWindow = this.getLWWindow();
        Image image = lWWindow.getFrameIcon();
        this._systemMenu.setImage(image);
        this._systemMenuBar.setVisible(image != null);
    }

    private void _updateIcons() {
        TitleBarUI titleBarUI = (TitleBarUI)this.getUI();
        this._minimizeButton.setPainter(titleBarUI.getMinimizeIcon(this));
        this._restoreButton.setPainter(titleBarUI.getRestoreIcon(this));
        this._maximizeButton.setPainter(titleBarUI.getMaximizeIcon(this));
        this._closeButton.setPainter(titleBarUI.getCloseIcon(this));
    }

    private void _updateTitle() {
        LWWindow lWWindow = this.getLWWindow();
        String string = lWWindow.getTitle();
        if (string != this._titleLabel.getText()) {
            this._titleLabel.setText(string);
        }
    }

    private void _addListeners() {
        LWWindow lWWindow = this.getLWWindow();
        lWWindow.addPropertyChangeListener(this);
        MouseWindowMover mouseWindowMover = new MouseWindowMover(lWWindow, this);
        this._titleLabel.addMouseListener(mouseWindowMover);
        this._titleLabel.addMouseMotionListener(mouseWindowMover);
        this._captionTile.addMouseListener(mouseWindowMover);
        this._captionTile.addMouseMotionListener(mouseWindowMover);
        this.addMouseListener(mouseWindowMover);
        this.addMouseMotionListener(mouseWindowMover);
        ActionHandler actionHandler = new ActionHandler();
        this._titleLabel.addMouseListener(actionHandler);
        this._captionTile.addMouseListener(actionHandler);
        this.addMouseListener(actionHandler);
        this._maximizeButton.addToolBarActionListener(actionHandler);
        this._minimizeButton.addToolBarActionListener(actionHandler);
        this._restoreButton.addToolBarActionListener(actionHandler);
        this._closeButton.addToolBarActionListener(actionHandler);
        this._systemMenu.addMouseListener(actionHandler);
    }

    static LWWindow __getSystemPopupOwner() {
        return _sSystemPopupOwner;
    }

    static void __setSystemPopupOwner(LWWindow lWWindow) {
        _sSystemPopupOwner = lWWindow;
    }

    static KeyStroke __getCloseShortcut() {
        if (_sCloseShortcut == null) {
            _sCloseShortcut = new KeyStroke(115, 2);
        }
        return _sCloseShortcut;
    }

    private static LWPopupMenu _getSystemPopupMenu() {
        if (_sSystemPopup == null) {
            _sSystemPopup = new LWPopupMenu();
            _sSystemPopup.addPopupMenuListener(new SMHandler());
        }
        return _sSystemPopup;
    }

    private static class SMHandler
    implements LWPopupMenuListener,
    ActionListener {
        private static LWMenuItem _sRestoreItem;
        private static LWMenuItem _sMoveItem;
        private static LWMenuItem _sResizeItem;
        private static LWMenuItem _sMinimizeItem;
        private static LWMenuItem _sMaximizeItem;
        private static LWMenuItem _sCloseItem;
        private static Locale _sSystemPopupLocale;

        private SMHandler() {
        }

        public void menuPoppingUp(LWPopupMenuEvent lWPopupMenuEvent) {
            Component component;
            LWMenuInvoker lWMenuInvoker = lWPopupMenuEvent.getMenuInvoker();
            for (component = lWMenuInvoker.getInvokerComponent(); component != null && !(component instanceof LWWindow); component = component.getParent()) {
            }
            if (component == null) {
                return;
            }
            LWWindow lWWindow = (LWWindow)component;
            this._createItems();
            this._updateItems(lWWindow);
            this._loadMessages(lWWindow);
            TitleBar.__setSystemPopupOwner(lWWindow);
        }

        public void menuPoppedUp(LWPopupMenuEvent lWPopupMenuEvent) {
        }

        public void menuPoppedDown(LWPopupMenuEvent lWPopupMenuEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LWWindow lWWindow = TitleBar.__getSystemPopupOwner();
            Component component = (Component)actionEvent.getSource();
            if (component == _sRestoreItem) {
                if (lWWindow.isMaximized()) {
                    lWWindow.setMaximized(false);
                } else if (lWWindow.isMinimized()) {
                    lWWindow.setMinimized(false);
                }
            } else if (component == _sMinimizeItem) {
                lWWindow.setMinimized(true);
            } else if (component == _sMaximizeItem) {
                lWWindow.setMaximized(true);
            } else if (component == _sCloseItem) {
                lWWindow.close();
            }
        }

        private void _createItems() {
            if (_sCloseItem != null) {
                return;
            }
            LWPopupMenu lWPopupMenu = TitleBar._getSystemPopupMenu();
            _sRestoreItem = new LWMenuItem();
            lWPopupMenu.add(_sRestoreItem);
            _sMoveItem = new LWMenuItem();
            lWPopupMenu.add(_sMoveItem);
            _sResizeItem = new LWMenuItem();
            lWPopupMenu.add(_sResizeItem);
            _sMinimizeItem = new LWMenuItem();
            lWPopupMenu.add(_sMinimizeItem);
            _sMaximizeItem = new LWMenuItem();
            lWPopupMenu.add(_sMaximizeItem);
            lWPopupMenu.add(new LWMenuSeparator());
            _sCloseItem = new LWMenuItem();
            _sCloseItem.setAccelerator(TitleBar.__getCloseShortcut());
            lWPopupMenu.add(_sCloseItem);
            _sMoveItem.addActionListener(new KeyWindowMover(null));
            _sResizeItem.addActionListener(new KeyWindowResizer(null));
            _sMaximizeItem.addActionListener(this);
            _sMinimizeItem.addActionListener(this);
            _sRestoreItem.addActionListener(this);
            _sCloseItem.addActionListener(this);
        }

        private void _updateItems(LWWindow lWWindow) {
            boolean bl = lWWindow.isMinimized();
            boolean bl2 = lWWindow.isMaximized();
            _sRestoreItem.setEnabled(bl || bl2);
            _sMoveItem.setEnabled(lWWindow.isMovable());
            _sResizeItem.setEnabled(lWWindow.isResizable() && !bl && !bl2);
            _sMinimizeItem.setEnabled(lWWindow.isMinimizable() && !bl);
            _sMaximizeItem.setEnabled(lWWindow.isMaximizable() && !bl2);
            _sCloseItem.setEnabled(lWWindow.isClosable());
        }

        private void _loadMessages(LWWindow lWWindow) {
            ResourceBundle resourceBundle;
            Locale locale = lWWindow.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (!locale.equals(_sSystemPopupLocale) && (resourceBundle = ResourceBundle.getBundle(TitleBar._SYSTEM_MENU_BUNDLE_NAME, LocaleUtils.getTranslationLocale(locale))) != null) {
                this._loadMessage(resourceBundle, _sRestoreItem, TitleBar._RESTORE_KEY);
                this._loadMessage(resourceBundle, _sMoveItem, TitleBar._MOVE_KEY);
                this._loadMessage(resourceBundle, _sResizeItem, TitleBar._RESIZE_KEY);
                this._loadMessage(resourceBundle, _sMinimizeItem, TitleBar._MINIMIZE_KEY);
                this._loadMessage(resourceBundle, _sMaximizeItem, TitleBar._MAXIMIZE_KEY);
                this._loadMessage(resourceBundle, _sCloseItem, TitleBar._CLOSE_KEY);
                _sSystemPopupLocale = locale;
            }
        }

        private void _loadMessage(ResourceBundle resourceBundle, LWMenuItem lWMenuItem, String string) {
            String string2 = resourceBundle.getString(string);
            if (string2 != null) {
                int n = StringUtils.getMnemonicIndex(string2);
                if (n != -1) {
                    string2 = StringUtils.stripMnemonic(string2);
                    lWMenuItem.setMnemonicIndex(n);
                }
                lWMenuItem.setLabel(string2);
            }
        }
    }

    private class CaptionComp
    extends LWComponent {
        private CaptionComp() {
        }

        public Dimension getMinimumSize() {
            Painter painter = this.getFill();
            Dimension dimension = super.getMinimumSize();
            dimension.height = painter.getMinimumSize((PaintContext)this.getPaintContext()).height;
            return dimension;
        }

        protected int getPaintState() {
            int n = super.getPaintState();
            if (TitleBar.this.isArmed()) {
                n |= 2;
            }
            return n;
        }
    }

    private class FlatSeparator
    extends ToolBarPainterItem {
        private int _size;

        public FlatSeparator(int n) {
            this._size = n;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this._size, this._size);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        protected BorderPainter getBorderPainter() {
            return NullPainter.getPainter();
        }

        protected Painter getPainter() {
            return NullPainter.getPainter();
        }
    }

    private class ActionHandler
    extends MouseAdapter
    implements ToolBarActionListener {
        private ActionHandler() {
        }

        public void toolBarItemActionPerformed(ToolBarEvent toolBarEvent) {
            ToolBarItem toolBarItem = toolBarEvent.getItem();
            LWWindow lWWindow = TitleBar.this.getLWWindow();
            if (toolBarItem == TitleBar.this._minimizeButton) {
                lWWindow.setMinimized(true);
            } else if (toolBarItem == TitleBar.this._maximizeButton) {
                lWWindow.setMaximized(true);
            } else if (toolBarItem == TitleBar.this._restoreButton) {
                if (lWWindow.isMaximized()) {
                    lWWindow.setMaximized(false);
                } else if (lWWindow.isMinimized()) {
                    lWWindow.setMinimized(false);
                }
            } else if (toolBarItem == TitleBar.this._closeButton) {
                lWWindow.close();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            LWWindow lWWindow = TitleBar.this.getLWWindow();
            if (lWWindow.isEnabled()) {
                if (mouseEvent.isPopupTrigger()) {
                    this._popupSystemMenu(mouseEvent);
                } else if (mouseEvent.getClickCount() == 2 && InputEventUtils.isLeftMouseButton(mouseEvent)) {
                    Component component = mouseEvent.getComponent();
                    if (component == TitleBar.this._systemMenu) {
                        TitleBar.this._systemMenu.dismissMenu();
                        lWWindow.close();
                    } else if (lWWindow.isMinimized()) {
                        lWWindow.setMinimized(false);
                    } else if (lWWindow.isMaximized()) {
                        lWWindow.setMaximized(false);
                    } else if (lWWindow.isMaximizable()) {
                        lWWindow.setMaximized(true);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (TitleBar.this.getLWWindow().isEnabled() && mouseEvent.isPopupTrigger()) {
                this._popupSystemMenu(mouseEvent);
            }
        }

        private void _popupSystemMenu(MouseEvent mouseEvent) {
            Point point = ComponentUtils.translatePoint(mouseEvent.getComponent(), TitleBar.this, mouseEvent.getX(), mouseEvent.getY());
            TitleBar._getSystemPopupMenu().popup((Component)TitleBar.this, point.x, point.y);
        }
    }

    private class SystemMenuBar
    extends LWMenuBar {
        private SystemMenuBar() {
        }

        public void postProcessMenuBarKey(KeyEvent keyEvent) {
            LWWindow lWWindow;
            if (keyEvent.getKeyCode() == 18 && (InputEventUtils.getMods(keyEvent) & 0xFFFFFFF7) == 0) {
                return;
            }
            if (keyEvent.getID() == 401 && TitleBar.__getCloseShortcut().equals(keyEvent) && (lWWindow = TitleBar.this.getLWWindow()).isClosable() && lWWindow.isEnabled()) {
                lWWindow.close();
                keyEvent.consume();
            }
            super.postProcessMenuBarKey(keyEvent);
        }
    }

    private static class SystemMenu
    extends LWMenu {
        private static Painter _sPainter = new FixedBorderPainter(new ImageSetPainter(), 0, 0, 0, 2);

        public SystemMenu(Image image) {
            super(null, null);
            this.setImage(image);
        }

        public void activate() {
            if (this.getSubMenu() == null) {
                this.setSubMenu(TitleBar._getSystemPopupMenu());
            }
            super.activate();
        }

        public void setSubMenuDisplayed(boolean bl, int n, boolean bl2) {
            if (this.getSubMenu() == null) {
                this.setSubMenu(TitleBar._getSystemPopupMenu());
            }
            super.setSubMenuDisplayed(bl, n, bl2);
        }

        protected Painter getPainter() {
            return _sPainter;
        }

        protected Rectangle getPopupOverBounds() {
            Dimension dimension = this.getSize();
            return new Rectangle(-2, -1, dimension.width + 4, dimension.height + 2);
        }
    }
}

