/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class ImageSetPainter
extends AbstractPainter {
    private ImageSet _imageSet;

    public ImageSetPainter() {
        this(null);
    }

    public ImageSetPainter(ImageSet imageSet) {
        this._imageSet = imageSet;
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        return this.getMinimumSize(paintContext);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        ImageSet imageSet = this.getImageSet(paintContext);
        return imageSet != null ? imageSet.getSize() : new Dimension(0, 0);
    }

    public Dimension getMaximumSize(PaintContext paintContext) {
        return this.getMinimumSize(paintContext);
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        ImageSet imageSet = this.getImageSet(paintContext);
        if (imageSet != null) {
            imageSet.paintImage(this.getPaintState(paintContext) & 0x9F, graphics, n, n2, paintContext.getImageObserver());
        }
    }

    public boolean isTransparent(PaintContext paintContext) {
        ImageSet imageSet = this.getImageSet(paintContext);
        return imageSet != null ? imageSet.isTransparent() : false;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        ImageSet imageSet = this.getImageSet(paintContext);
        return imageSet != null ? imageSet.getAvailableImageFlags() : 0;
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        ImageSet imageSet = this.getImageSet(paintContext);
        if (imageSet != null && imageSet.contains(n3, n4)) {
            return this;
        }
        return null;
    }

    protected ImageSet getImageSet(PaintContext paintContext) {
        return this._imageSet != null ? this._imageSet : (ImageSet)paintContext.getPaintData(PaintContext.IMAGESET_KEY);
    }

    protected int getPaintState(PaintContext paintContext) {
        return paintContext.getPaintState();
    }
}

