/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class PainterJoiner
extends AbstractPainter {
    public static final int ALIGN_TOP_DEFAULT = 9;
    public static final int ALIGN_CENTER_DEFAULT = 10;
    public static final int ALIGN_BOTTOM_DEFAULT = 11;
    public static final int ALIGN_TOP_ANTIDEFAULT = 12;
    public static final int ALIGN_CENTER_ANTIDEFAULT = 13;
    public static final int ALIGN_BOTTOM_ANTIDEFAULT = 14;
    public static final int ALIGN_TOP_LEFT = 0;
    public static final int ALIGN_CENTER_LEFT = 1;
    public static final int ALIGN_BOTTOM_LEFT = 2;
    public static final int ALIGN_TOP_CENTER = 3;
    public static final int ALIGN_CENTER_CENTER = 4;
    public static final int ALIGN_BOTTOM_CENTER = 5;
    public static final int ALIGN_TOP_RIGHT = 6;
    public static final int ALIGN_CENTER_RIGHT = 7;
    public static final int ALIGN_BOTTOM_RIGHT = 8;
    private static final int _MAIN_INDEX = 0;
    private static final int _SECOND_INDEX = 1;
    private boolean _fill;
    private int _align;
    private Painter _main;
    private Painter _second;

    public PainterJoiner(Painter painter, Painter painter2) {
        this(painter, painter2, 5, false);
    }

    public PainterJoiner(Painter painter, Painter painter2, int n) {
        this(painter, painter2, n, false);
    }

    public PainterJoiner(Painter painter, Painter painter2, int n, boolean bl) {
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        if (painter2 == null) {
            painter2 = NullPainter.getPainter();
        }
        this._main = painter;
        this._second = painter2;
        this._align = n;
        this._fill = bl;
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        Rectangle[] rectangleArray = this._getPainterBounds(paintContext, 0, 0, n, n2);
        return this._getCombinedSize(paintContext, new Dimension(rectangleArray[0].width, rectangleArray[0].height), new Dimension(rectangleArray[1].width, rectangleArray[1].height), true);
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        return this._getCombinedSize(paintContext, this._main.getPreferredSize(paintContext), this._second.getPreferredSize(paintContext), true);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        return this._getCombinedSize(paintContext, this._main.getMinimumSize(paintContext), this._second.getMinimumSize(paintContext), true);
    }

    public Dimension getMaximumSize(PaintContext paintContext) {
        return this._getCombinedSize(paintContext, this._main.getMaximumSize(paintContext), this._second.getMaximumSize(paintContext), false);
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle[] rectangleArray = this._getPainterBounds(paintContext, n, n2, n3, n4);
        Rectangle rectangle = rectangleArray[0];
        if (rectangle.width > 0 && rectangle.height > 0) {
            this._main.paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Rectangle rectangle2 = rectangleArray[1];
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            this._second.paint(paintContext, graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Rectangle[] rectangleArray = this._getPainterBounds(paintContext, 0, 0, n, n2);
        Rectangle rectangle = rectangleArray[1];
        Painter painter2 = this._second.getPainterAt(paintContext, rectangle.width, rectangle.height, n3 - rectangle.x, n4 - rectangle.y, painter);
        if (painter2 == null) {
            Rectangle rectangle2 = rectangleArray[0];
            painter2 = this._main.getPainterAt(paintContext, rectangle2.width, rectangle2.height, n3 - rectangle2.x, n4 - rectangle2.y, painter);
        }
        if (painter == this && painter2 != null) {
            painter2 = this;
        }
        return painter2;
    }

    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        int n = this._main.getRepaintFlags(paintContext) | this._second.getRepaintFlags(paintContext);
        if (this._align >= 9) {
            n |= 0x4000;
        }
        return n;
    }

    public int getInvalidateFlags(PaintContext paintContext) {
        return this._main.getInvalidateFlags(paintContext) | this._second.getInvalidateFlags(paintContext);
    }

    private int _getActualAlignment(PaintContext paintContext) {
        int n = this._align;
        if (n >= 9) {
            boolean bl;
            int n2 = paintContext.getReadingDirection();
            boolean bl2 = bl = n >= 12;
            if (n2 == 2) {
                bl = !bl;
            }
            n %= 3;
            if (bl) {
                n += 6;
            }
        }
        return n;
    }

    private Dimension _getCombinedSize(PaintContext paintContext, Dimension dimension, Dimension dimension2, boolean bl) {
        int n = this._getActualAlignment(paintContext);
        if (n % 3 == 1) {
            if (bl) {
                if (dimension2.height > dimension.height) {
                    dimension.height = dimension2.height;
                }
            } else if (dimension2.height < dimension.height) {
                dimension.height = dimension2.height;
            }
        } else {
            dimension.height += dimension2.height;
        }
        if (n / 3 == 1) {
            if (bl) {
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
            } else if (dimension2.width < dimension.width) {
                dimension.width = dimension2.width;
            }
        } else {
            dimension.width += dimension2.width;
        }
        return dimension;
    }

    private Rectangle[] _getPainterBounds(PaintContext paintContext, int n, int n2, int n3, int n4) {
        Rectangle[] rectangleArray = new Rectangle[2];
        Dimension dimension = this._main.getPreferredSize(paintContext);
        Dimension dimension2 = this._second.getPreferredSize(paintContext);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        rectangleArray[0] = rectangle;
        rectangleArray[1] = rectangle2;
        rectangle.x = n;
        rectangle.y = n2;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        rectangle2.x = n;
        rectangle2.y = n2;
        int n5 = this._getActualAlignment(paintContext);
        switch (n5 % 3) {
            case 0: {
                rectangle2.height = n4 - rectangle.height;
                if (!this._fill && rectangle2.height > dimension2.height) {
                    rectangle2.height = dimension2.height;
                }
                rectangle.y += rectangle2.height;
                break;
            }
            case 1: {
                if (this._fill) {
                    rectangle.height = n4;
                    rectangle2.height = n4;
                    break;
                }
                rectangle2.y += (n4 - dimension2.height) / 2;
                rectangle.y += (n4 - rectangle.height) / 2;
                rectangle2.height = dimension2.height;
                break;
            }
            case 2: {
                rectangle2.y += rectangle.height;
                rectangle2.height = n4 - rectangle.height;
                if (this._fill || rectangle2.height <= dimension2.height) break;
                rectangle2.height = dimension2.height;
            }
        }
        switch (n5 / 3) {
            case 0: {
                rectangle2.width = n3 - rectangle.width;
                if (!this._fill && rectangle2.width > dimension2.width) {
                    rectangle2.width = dimension2.width;
                }
                rectangle.x += rectangle2.width;
                break;
            }
            case 1: {
                if (this._fill) {
                    rectangle.width = n3;
                    rectangle2.width = n3;
                    break;
                }
                rectangle2.x += (n3 - dimension2.width) / 2;
                rectangle.x += (n3 - rectangle.width) / 2;
                rectangle2.width = dimension2.width;
                break;
            }
            case 2: {
                rectangle2.x += rectangle.width;
                rectangle2.width = n3 - rectangle.width;
                if (this._fill || rectangle2.width <= dimension2.width) break;
                rectangle2.width = dimension2.width;
            }
        }
        if (!this._fill) {
            if (rectangle.width > n3) {
                rectangle.width = n3;
            }
            if (rectangle.height > n4) {
                rectangle.height = n4;
            }
        }
        return rectangleArray;
    }
}

