/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.popup.PopupOwner;

public class PopupHandler
implements LayoutManager2 {
    private boolean _dontInvalidate;
    private LayoutManager _wrappedLayout;
    private Vector _popups = new Vector(1);

    public static boolean isSwingPopup(Component component) {
        Class<?>[] classArray = component.getClass().getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!"javax.swing.JPopupMenu$Popup".equals(classArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    public void setLayout(LayoutManager layoutManager) {
        this._wrappedLayout = layoutManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPopup(Container container, Component component) {
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                this._popups.addElement(component);
                if (!PopupHandler.isSwingPopup(component)) {
                    component.setVisible(false);
                }
                this._dontInvalidate = true;
                container.add(component, this._getPopupIndex(container));
                this._dontInvalidate = false;
            }
        }
    }

    public synchronized boolean isPopup(PopupOwner popupOwner, Component component) {
        return this._popups.contains(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopup(Container container, Component component, int n, int n2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                Dimension dimension = container.getSize();
                Dimension dimension2 = component.getSize();
                if (n + dimension2.width > dimension.width) {
                    n = dimension.width - dimension2.width;
                }
                if (n < 0) {
                    n = 0;
                }
                if (n2 + dimension2.height > dimension.height) {
                    n2 = dimension.height - dimension2.height;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                this._dontInvalidate = true;
                component.setLocation(n, n2);
                component.setVisible(true);
                this._dontInvalidate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePopup(Container container, Component component) {
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                if (this._popups.contains(component)) {
                    this._popups.removeElement(component);
                    Rectangle rectangle = component.getBounds();
                    this._dontInvalidate = true;
                    container.remove(component);
                    this._dontInvalidate = false;
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPopupBounds(Container container, Component component, int n, int n2, int n3, int n4) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this._dontInvalidate = true;
            component.setBounds(n, n2, n3, n4);
            this._dontInvalidate = false;
        }
    }

    public boolean shouldInvalidate() {
        return !this._dontInvalidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showProxyComponent(Container container, Component component) {
        if (component == null) {
            return;
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                this._dontInvalidate = true;
                if (container.getComponent(0) != component) {
                    container.add(component, 0);
                }
                Dimension dimension = container.getSize();
                Rectangle rectangle = component.getBounds();
                if (rectangle.x != 0 || rectangle.y != 0 || rectangle.width != dimension.width || rectangle.height != dimension.height) {
                    component.setVisible(false);
                    component.setBounds(0, 0, dimension.width, dimension.height);
                    component.setVisible(true);
                }
                this._dontInvalidate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideProxyComponent(Container container, Component component) {
        if (component == null) {
            return;
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                this._dontInvalidate = true;
                component.setVisible(false);
                this._dontInvalidate = false;
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
        if (!this._popups.contains(component) && !this._isProxyComponent(component) && this._wrappedLayout != null) {
            this._wrappedLayout.addLayoutComponent(string, component);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (!this._popups.contains(component) && this._wrappedLayout != null) {
            this._wrappedLayout.removeLayoutComponent(component);
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this._wrappedLayout != null) {
            Component component = this._removeProxy(container);
            Dimension dimension = this._wrappedLayout.preferredLayoutSize(container);
            if (component != null) {
                this.showProxyComponent(container, component);
            }
            return dimension;
        }
        return container.getSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this._wrappedLayout != null) {
            Component component = this._removeProxy(container);
            Dimension dimension = this._wrappedLayout.minimumLayoutSize(container);
            if (component != null) {
                this.showProxyComponent(container, component);
            }
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public void layoutContainer(Container container) {
        if (this._wrappedLayout != null) {
            this._removeAllPopups(container);
            Component component = this._removeProxy(container);
            this._wrappedLayout.layoutContainer(container);
            if (component != null) {
                this.showProxyComponent(container, component);
            }
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!this._popups.contains(component) && !this._isProxyComponent(component) && this._wrappedLayout != null) {
            if (this._wrappedLayout instanceof LayoutManager2) {
                ((LayoutManager2)this._wrappedLayout).addLayoutComponent(component, object);
            } else {
                this.addLayoutComponent((String)object, component);
            }
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        if (this._wrappedLayout instanceof LayoutManager2) {
            Component component = this._removeProxy(container);
            Dimension dimension = ((LayoutManager2)this._wrappedLayout).maximumLayoutSize(container);
            if (component != null) {
                this.showProxyComponent(container, component);
            }
            return dimension;
        }
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        if (this._wrappedLayout instanceof LayoutManager2) {
            return ((LayoutManager2)this._wrappedLayout).getLayoutAlignmentX(container);
        }
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        if (this._wrappedLayout instanceof LayoutManager2) {
            return ((LayoutManager2)this._wrappedLayout).getLayoutAlignmentY(container);
        }
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        if (this._wrappedLayout instanceof LayoutManager2) {
            ((LayoutManager2)this._wrappedLayout).invalidateLayout(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _getPopupIndex(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (container instanceof MouseGrabProvider && container.getComponentCount() > 0 && ((MouseGrabProvider)((Object)container)).getProxyComponent() == container.getComponent(0)) {
                return 1;
            }
        }
        return 0;
    }

    private boolean _isProxyComponent(Component component) {
        Container container = component.getParent();
        return container instanceof MouseGrabProvider && ((MouseGrabProvider)((Object)container)).getProxyComponent() == component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeAllPopups(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            PopupHandler popupHandler = this;
            synchronized (popupHandler) {
                this._dontInvalidate = true;
                int n = this._popups.size();
                for (int i = 0; i < n; ++i) {
                    container.remove((Component)this._popups.elementAt(i));
                }
                this._popups.removeAllElements();
                this._dontInvalidate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component _removeProxy(Container container) {
        Component component;
        if (container instanceof MouseGrabProvider && (component = ((MouseGrabProvider)((Object)container)).getProxyComponent()) != null) {
            Object object = container.getTreeLock();
            synchronized (object) {
                PopupHandler popupHandler = this;
                synchronized (popupHandler) {
                    if (component.getParent() == container) {
                        this._dontInvalidate = true;
                        container.remove(component);
                        this._dontInvalidate = false;
                        if (component.isVisible()) {
                            return component;
                        }
                    }
                }
            }
        }
        return null;
    }
}

