/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.statusBar;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.UIDefaults;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.access.OracleAccessibleRole;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.StatusBarUI;
import oracle.ewt.statusBar.StatusBarComponentItem;
import oracle.ewt.statusBar.StatusBarItem;
import oracle.ewt.statusBar.StatusBarToolTip;

public class StatusBar
extends LWContainer {
    private int _numItems;
    private StatusBarItem[] _items;
    private int _lastFillWidth;
    private transient int _itemSplitWidth;
    private int _leftCandidate;
    private int _rightCandidate;
    private int _resizeLeft;
    private int _resizeRight;
    private int _resizer;
    private int _dragX;
    private boolean _direction;
    private boolean _canResize;
    private boolean _firstLayout = true;
    private transient int _itemSpacing;
    private static final int _MINIMUM_WIDTH = 10;

    public StatusBar() {
        this(4);
    }

    public StatusBar(int n) {
        this._items = new StatusBarItem[n];
        long l = 48L;
        this.enableEvents(l);
        this.setToolTipValue(new StatusBarToolTip(this));
        this._canResize = true;
    }

    public final void addItem(StatusBarItem statusBarItem) {
        this.addItem(statusBarItem, null);
    }

    public final void addItem(StatusBarItem statusBarItem, int n) {
        StatusBarItem statusBarItem2 = null;
        if (n != -1 && n < this._numItems) {
            statusBarItem2 = this.getItem(n);
        }
        this.addItem(statusBarItem, statusBarItem2);
    }

    public void addItem(StatusBarItem statusBarItem, StatusBarItem statusBarItem2) {
        Object object;
        if (statusBarItem.getParent() != null) {
            statusBarItem.getParent().removeItem(statusBarItem);
        }
        int n = statusBarItem2 != null ? this.getItemIndex(statusBarItem2) : -1;
        statusBarItem.setParent(this);
        if (this._numItems == this._items.length) {
            object = new StatusBarItem[this._numItems * 2];
            System.arraycopy(this._items, 0, object, 0, this._numItems);
            this._items = object;
        }
        if (n == -1) {
            this._items[this._numItems] = statusBarItem;
        } else {
            System.arraycopy(this._items, n, this._items, n + 1, this._numItems - n);
            this._items[n] = statusBarItem;
        }
        ++this._numItems;
        if (statusBarItem.isVisible()) {
            this.invalidate();
            this.repaint();
        }
        if (this.__getItemAccessible(statusBarItem) == statusBarItem && (object = this.accessAccessibleContext()) != null) {
            ((AccessibleContext)object).firePropertyChange("AccessibleChild", null, statusBarItem);
        }
    }

    public int getItemCount() {
        return this._numItems;
    }

    public StatusBarItem getItem(int n) {
        return this._items[n];
    }

    public int getItemIndex(StatusBarItem statusBarItem) {
        for (int i = 0; i < this._numItems; ++i) {
            if (statusBarItem != this._items[i]) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public synchronized StatusBarItem[] getItems() {
        StatusBarItem[] statusBarItemArray = new StatusBarItem[this._numItems];
        System.arraycopy(this._items, 0, statusBarItemArray, 0, this._numItems);
        return statusBarItemArray;
    }

    public StatusBarItem getItemAt(int n, int n2) {
        Point point = this.convertOuterToInterior(n, n2);
        for (int i = 0; i < this._numItems; ++i) {
            if (!this._items[i].contains(point.x, point.y)) continue;
            return this._items[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(StatusBarItem statusBarItem) {
        Object object;
        if (this.__getItemAccessible(statusBarItem) == statusBarItem && (object = this.accessAccessibleContext()) != null) {
            ((AccessibleContext)object).firePropertyChange("AccessibleChild", statusBarItem, null);
        }
        object = this;
        synchronized (object) {
            statusBarItem.setParent(null);
            int n = this.getItemIndex(statusBarItem);
            this._items[n] = null;
            --this._numItems;
            if (n < this._numItems) {
                System.arraycopy(this._items, n + 1, this._items, n, this._numItems - n);
            }
            this._items[this._numItems] = null;
        }
        if (statusBarItem.isVisible()) {
            this.invalidate();
            this.repaint();
        }
    }

    public synchronized void removeAll() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        for (int i = 0; i < this._numItems; ++i) {
            if (accessibleContext != null && this.__getItemAccessible(this._items[i]) == this._items[i]) {
                accessibleContext.firePropertyChange("AccessibleChild", this._items[i], null);
            }
            this._items[i].setParent(null);
            this._items[i] = null;
        }
        this._numItems = 0;
        this.invalidate();
        this.repaint();
    }

    public Object getUIClassID() {
        return "StatusBarUI";
    }

    public void setItemResizeAllowed(boolean bl) {
        if (bl != this._canResize) {
            this._itemSplitWidth = bl ? this._getSplitterWidth() : 0;
            this._canResize = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isItemResizeAllowed() {
        return this._canResize;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    protected int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x800 | 0x4000;
    }

    protected int getRepaintFlags() {
        return super.getRepaintFlags() | 0x800 | 0x4000;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        if (!this.isItemResizeAllowed()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 506: {
                this._handleMouseDragged(mouseEvent);
                break;
            }
            case 503: {
                this._handleMouseMoved(mouseEvent);
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        if (!this.isItemResizeAllowed()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this._handleMousePressed(mouseEvent);
                break;
            }
            case 502: {
                this._handleMouseReleased(mouseEvent);
            }
            case 505: {
                this._handleMouseExited(mouseEvent);
            }
        }
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        if (componentUI != null) {
            this._itemSplitWidth = this._getSplitterWidth();
            this._itemSpacing = this.getStatusBarUI().getItemSpacing(this);
        }
    }

    protected Object getPaintData(Object object) {
        Object object2 = null;
        if (object == StatusBarUI.RESIZABLE_SPLITTERS_KEY) {
            object2 = this._getSplitters(true);
        } else if (object == StatusBarUI.NONRESIZABLE_SPLITTERS_KEY) {
            object2 = this._getSplitters(false);
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this._numItems;
        boolean bl = this.getStatusBarUI().getStaticSplitterPainter(this) != null;
        for (int i = 0; i < n4; ++i) {
            StatusBarItem statusBarItem = this._items[i];
            if (!statusBarItem.isVisible()) continue;
            Dimension dimension = statusBarItem.getMinimumSize();
            n += dimension.width;
            if (dimension.height > n2) {
                n2 = dimension.height;
            }
            if (!statusBarItem.isExpanding() && !bl) continue;
            ++n3;
        }
        if (n4 > 0) {
            if (n3 > 0 && this.isItemResizeAllowed()) {
                if (this._items[n4 - 1].isExpanding() || bl) {
                    --n3;
                }
                n += n3 * (this._itemSplitWidth + this._itemSpacing);
            }
            n += (n4 - 1) * this._itemSpacing;
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void doLayout() {
        int n;
        Dimension dimension = this.getInnerSize();
        int n2 = this._numItems;
        boolean bl = this.getStatusBarUI().getStaticSplitterPainter(this) != null;
        int n3 = this.getActualReadingDirection();
        int n4 = n3 == 1 ? 0 : dimension.width;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n = 0; n < n2; ++n) {
            StatusBarItem statusBarItem = this._items[n];
            if (!statusBarItem.isVisible()) continue;
            Dimension dimension2 = statusBarItem.getMinimumSize();
            n5 += dimension2.width;
            if (dimension2.height > n6) {
                n6 = dimension2.height;
            }
            if ((statusBarItem.isExpanding() || bl) && this.isItemResizeAllowed() && n < n2 - 1) {
                ++n9;
            }
            if (!statusBarItem.isExpanding()) continue;
            ++n7;
        }
        n = n8 = dimension.width - (n5 += n9 * (this._itemSplitWidth + this._itemSpacing) + (n2 - 1) * this._itemSpacing) > 0 ? dimension.width - n5 : 0;
        int n10 = n7;
        if (this._lastFillWidth <= 0) {
            this._lastFillWidth = dimension.width - n5 > 1 ? dimension.width - n5 : 1;
        }
        for (int i = 0; i < n2; ++i) {
            StatusBarItem statusBarItem = this._items[i];
            if (!statusBarItem.isVisible()) continue;
            Dimension dimension3 = statusBarItem.getSize();
            if (dimension3.width <= 0 || dimension3.height <= 0) {
                dimension3 = statusBarItem.getMinimumSize();
            }
            if (statusBarItem.isExpanding() || i == n2 - 1) {
                int n11 = 0;
                if (--n7 <= 0) {
                    n11 = n;
                } else if (this._firstLayout) {
                    n11 = n8 / n10;
                } else {
                    float f = (float)(dimension3.width - statusBarItem.getMinimumWidth()) / (float)this._lastFillWidth;
                    n11 = (int)(f * (float)n8);
                    if (n11 > n) {
                        n11 = n;
                    }
                }
                dimension3.width = statusBarItem.getMinimumWidth() + n11;
                n -= n11;
            }
            statusBarItem.setSize(dimension3.width, dimension.height);
            if (n3 == 2) {
                statusBarItem.setLocation(n4 -= dimension3.width, 0);
                if (!bl && !statusBarItem.isExpanding() || i >= n2 - 1) continue;
                n4 -= this._itemSplitWidth + 2 * this._itemSpacing;
                continue;
            }
            statusBarItem.setLocation(n4, 0);
            n4 += dimension3.width + this._itemSpacing;
            if (!bl && !statusBarItem.isExpanding() || i >= n2 - 1) continue;
            n4 += this._itemSplitWidth + this._itemSpacing;
        }
        this._lastFillWidth = n8;
        this._firstLayout = false;
    }

    public void paintInterior(Graphics graphics) {
        int n = this._numItems;
        if (n == 0) {
            return;
        }
        if (this._firstLayout) {
            this.doLayout();
        }
        UIDefaults uIDefaults = this.getStatusBarUI().getUIDefaults(this);
        Dimension dimension = this.getInnerSize();
        int n2 = this.getActualReadingDirection();
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl = this.isItemResizeAllowed();
        int n3 = n2 == 2 ? -this._itemSpacing - this._itemSplitWidth : this._itemSpacing;
        StatusBarItem statusBarItem = this._items[0];
        boolean bl2 = bl && statusBarItem.isExpanding() && n > 1;
        int n4 = 0;
        while (statusBarItem != null) {
            Rectangle rectangle2;
            StatusBarItem statusBarItem2 = statusBarItem;
            boolean bl3 = bl2;
            if (++n4 < n) {
                statusBarItem = this._items[n4];
                bl2 = bl && statusBarItem.isExpanding();
            } else {
                statusBarItem = null;
                bl2 = false;
            }
            if (!(rectangle2 = statusBarItem2.getBounds()).intersects(rectangle)) continue;
            statusBarItem2.paint(graphics);
            StatusBarUI statusBarUI = this.getStatusBarUI();
            Painter painter = bl3 ? (bl2 ? statusBarUI.getCenterSplitterPainter(this) : (n2 != 2 ? statusBarUI.getLeftSplitterPainter(this) : statusBarUI.getRightSplitterPainter(this))) : statusBarUI.getStaticSplitterPainter(this);
            if (painter == null) continue;
            int n5 = rectangle2.x + n3;
            if (n2 != 2) {
                n5 += rectangle2.width;
            }
            painter.paint(statusBarItem2, graphics, n5, 0, this._itemSplitWidth, dimension.height);
        }
    }

    protected final StatusBarUI getStatusBarUI() {
        return (StatusBarUI)this.getUI();
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private void _recalculateSlides(int n, int n2) {
        int n3;
        StatusBarItem statusBarItem;
        int n4;
        int n5 = this.getActualReadingDirection();
        if (n > -1) {
            this._resizeLeft = 0;
            this._leftCandidate = -1;
            for (n4 = n; n4 >= 0; --n4) {
                statusBarItem = this._items[n4];
                if (!statusBarItem.isExpanding() || (n3 = statusBarItem.getSize().width - statusBarItem.getMinimumWidth()) <= 0) continue;
                this._resizeLeft = n3;
                this._leftCandidate = n4;
                break;
            }
            if (this._leftCandidate < 0) {
                this._leftCandidate = this._resizer;
            }
        }
        if (n2 > -1) {
            this._resizeRight = 0;
            this._rightCandidate = -1;
            for (n4 = n2 + 1; n4 < this._numItems; ++n4) {
                statusBarItem = this._items[n4];
                if (!statusBarItem.isExpanding() || (n3 = statusBarItem.getSize().width - statusBarItem.getMinimumWidth()) <= 0) continue;
                this._resizeRight = n3;
                this._rightCandidate = n4;
                break;
            }
            if (this._rightCandidate == -1) {
                StatusBarItem statusBarItem2 = this._items[this._numItems - 1];
                this._resizeRight = n5 == 2 ? statusBarItem2.getSize().width - statusBarItem2.getMinimumWidth() : this.getInnerBounds().width - (statusBarItem2.getLocation().x + statusBarItem2.getMinimumWidth());
                this._rightCandidate = this._numItems - 1;
            }
        }
    }

    private void _handleMousePressed(MouseEvent mouseEvent) {
        Point point = this.convertOuterToInterior(mouseEvent.getX(), mouseEvent.getY());
        this._resizer = this._getResizeCandidate(point.x);
        this._recalculateSlides(this._resizer, this._resizer);
        this._dragX = point.x;
        this._direction = true;
    }

    private void _handleMouseReleased(MouseEvent mouseEvent) {
        this._rightCandidate = -1;
        this._leftCandidate = -1;
        this._resizer = -1;
        this._dragX = 0;
        this._resizeRight = 0;
        this._resizeLeft = 0;
    }

    private void _handleMouseExited(MouseEvent mouseEvent) {
        this._restoreCursor();
    }

    private void _handleMouseDragged(MouseEvent mouseEvent) {
        Point point;
        int n;
        if (this._leftCandidate < 0 && this._rightCandidate < 0 || this._resizer < 0) {
            return;
        }
        int n2 = this.getActualReadingDirection();
        int n3 = this._leftCandidate;
        int n4 = this._rightCandidate;
        Point point2 = this.convertOuterToInterior(mouseEvent.getX(), mouseEvent.getY());
        StatusBarItem statusBarItem = n3 >= 0 ? this._items[n3] : null;
        StatusBarItem statusBarItem2 = n4 >= 0 ? this._items[n4] : null;
        StatusBarItem statusBarItem3 = this._items[this._resizer];
        int n5 = -1;
        int n6 = -1;
        int n7 = n = n2 == 2 ? this._dragX - point2.x : point2.x - this._dragX;
        if (n <= 0) {
            if (this._direction) {
                int n8 = this._numItems - 1;
                for (int i = this._resizer + 1; i < this._numItems - 1; ++i) {
                    if (!this._items[i].isExpanding()) continue;
                    n8 = i;
                    break;
                }
                n4 = n8;
                StatusBarItem statusBarItem4 = this._items[n8];
                this._resizeRight = statusBarItem4.getSize().width - statusBarItem4.getMinimumWidth();
                statusBarItem2 = statusBarItem4;
                n4 = this._rightCandidate = n8;
            }
            if (this._resizeLeft < -n) {
                n7 = -this._resizeLeft;
                n5 = n3 - 1;
            }
            if (n7 != 0) {
                int n9;
                Dimension dimension = statusBarItem.getSize();
                statusBarItem.setSize(dimension.width + n7, dimension.height);
                if (n2 == 2) {
                    for (n9 = n3; n9 < n4; ++n9) {
                        point = this._items[n9].getLocation();
                        this._items[n9].setLocation(point.x - n7, point.y);
                    }
                } else {
                    for (n9 = n4; n9 > n3; --n9) {
                        point = this._items[n9].getLocation();
                        this._items[n9].setLocation(point.x + n7, point.y);
                    }
                }
            }
        } else if (n > 0) {
            if (!this._direction) {
                n5 = this._resizer;
            }
            if (this._resizeRight < n) {
                n7 = this._resizeRight;
                n6 = n4 + 1;
            }
            Dimension dimension = statusBarItem3.getSize();
            statusBarItem3.setSize(dimension.width + n7, dimension.height);
            if (n2 == 2) {
                for (int i = n4 - 1; i >= this._resizer; --i) {
                    point = this._items[i].getLocation();
                    this._items[i].setLocation(point.x - n7, point.y);
                }
            } else {
                for (int i = this._resizer + 1; i <= n4; ++i) {
                    point = this._items[i].getLocation();
                    this._items[i].setLocation(point.x + n7, point.y);
                }
            }
        }
        Dimension dimension = statusBarItem2.getSize();
        statusBarItem2.setSize(dimension.width - n7, dimension.height);
        this._resizeLeft += n7;
        this._resizeRight -= n7;
        int n10 = 0;
        int n11 = 0;
        if (n2 == 2) {
            n10 = this._items[n4].getLocation().x;
            n11 = this._items[n3].getLocation().x + this._items[n3].getSize().width;
        } else {
            n10 = this._items[n3].getLocation().x;
            n11 = this._items[n4].getLocation().x + this._items[n4].getSize().width;
        }
        int n12 = this.getSize().height;
        int n13 = this.getBorderInsets().left;
        this.paintImmediate(n10 + n13, 0, n11 + n13, n12);
        if (n5 > -1 || n6 > -1) {
            this._recalculateSlides(n5, n6);
        }
        if (n7 != 0) {
            this._dragX += n2 == 2 ? -n7 : n7;
        }
        this._direction = n > 0;
    }

    private void _handleMouseMoved(MouseEvent mouseEvent) {
        Point point = this.convertOuterToInterior(mouseEvent.getX(), mouseEvent.getY());
        if (this._getResizeCandidate(point.x) < 0) {
            this._restoreCursor();
        } else {
            int n = this.getActualReadingDirection();
            Rectangle rectangle = this.getInnerBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            if (n == 2) {
                int n2 = this._items[this._numItems - 1].getLocation().x;
                if (!rectangle.contains(point.x, point.y) || point.x < n2) {
                    return;
                }
            } else {
                int n3 = this._items[this._numItems - 1].getLocation().x + this._items[this._numItems - 1].getSize().width;
                if (!rectangle.contains(point.x, point.y) || point.x >= n3) {
                    return;
                }
            }
            this._showResizeCursor();
        }
    }

    private int _getResizeCandidate(int n) {
        int n2 = 0;
        if (this._numItems < 2) {
            return -1;
        }
        Rectangle rectangle = this.getInnerBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        int n3 = (rectangle.y + rectangle.height) / 2;
        int n4 = this.getActualReadingDirection();
        if (n4 == 2) {
            for (int i = 1; i < this._numItems; ++i) {
                Point point = this._items[i].getLocation();
                n2 = point.x + this._items[i].getSize().width;
                if (n2 >= n) continue;
                StatusBarItem statusBarItem = this._items[i - 1];
                if (statusBarItem.contains(n, n3) || !statusBarItem.isExpanding()) {
                    return -1;
                }
                return i - 1;
            }
        } else {
            for (int i = 1; i < this._numItems; ++i) {
                Point point = this._items[i].getLocation();
                n2 = point.x;
                if (n2 <= n) continue;
                StatusBarItem statusBarItem = this._items[i - 1];
                if (statusBarItem.contains(n, n3) || !statusBarItem.isExpanding()) {
                    return -1;
                }
                return i - 1;
            }
        }
        return -1;
    }

    private void _showResizeCursor() {
        this.setCursor(Cursor.getPredefinedCursor(10));
    }

    private void _restoreCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int _getSplitterWidth() {
        Painter painter = this.getStatusBarUI().getCenterSplitterPainter(this);
        return painter == null ? 0 : painter.getMinimumSize((PaintContext)this.getPaintContext()).width;
    }

    private int[] _getSplitters(boolean bl) {
        if (!this.isItemResizeAllowed()) {
            return new int[0];
        }
        int n = this.getActualReadingDirection();
        int n2 = n == 2 ? -this._itemSpacing - this._itemSplitWidth : this._itemSpacing;
        int n3 = this.getBorderInsets().left;
        int n4 = 0;
        int[] nArray = new int[this._numItems];
        for (int i = 0; i < this._numItems - 1; ++i) {
            StatusBarItem statusBarItem = this._items[i];
            if (bl != statusBarItem.isExpanding()) continue;
            Rectangle rectangle = statusBarItem.getBounds();
            int n5 = rectangle.x + n2 + n3;
            if (n != 2) {
                n5 += rectangle.width;
            }
            nArray[n4] = n5;
            ++n4;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    Accessible __getItemAccessible(StatusBarItem statusBarItem) {
        Component component;
        if (statusBarItem instanceof StatusBarComponentItem && (component = ((StatusBarComponentItem)statusBarItem).__getComponent()) instanceof Accessible) {
            return (Accessible)((Object)component);
        }
        return statusBarItem;
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(StatusBar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.STATUS_BAR;
        }

        public int getAccessibleChildrenCount() {
            return StatusBar.this.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n > this.getAccessibleChildrenCount()) {
                return null;
            }
            return StatusBar.this.__getItemAccessible(StatusBar.this.getItem(n));
        }

        public Accessible getAccessibleAt(Point point) {
            return StatusBar.this.__getItemAccessible(StatusBar.this.getItemAt(point.x, point.y));
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.HORIZONTAL);
            return accessibleStateSet;
        }
    }
}

