/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.statusBar;

import java.awt.Component;
import java.awt.Container;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.statusBar.StatusBarItem;
import oracle.ewt.util.ImmInsets;

public class StatusBarComponentItem
extends StatusBarItem {
    private Component _comp;
    private int _minWidth;

    public StatusBarComponentItem(Component component) {
        this(component, -1, true);
    }

    public StatusBarComponentItem(Component component, int n, boolean bl) {
        super(n, bl);
        if (component == null) {
            throw new IllegalArgumentException();
        }
        this._comp = component;
        this._minWidth = n;
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            this._comp.setVisible(bl);
            super.setVisible(bl);
        }
    }

    public void setParent(StatusBar statusBar) {
        super.setParent(statusBar);
        Container container = this._comp.getParent();
        if (statusBar == null) {
            if (container != null) {
                container.remove(this._comp);
            }
        } else if (container != statusBar) {
            statusBar.add(this._comp);
        }
    }

    public int getMinimumWidth() {
        int n = this._minWidth != -1 ? this._minWidth : this._comp.getMinimumSize().width;
        return this.getOuterSize(n, true);
    }

    public int getMinimumHeight() {
        int n = this._comp.getMinimumSize().height;
        return this.getOuterSize(n, false);
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        LWComponent lWComponent = (LWComponent)this._comp.getParent();
        ImmInsets immInsets = lWComponent.getBorderInsets();
        ImmInsets immInsets2 = this._getBorderInsets();
        this._comp.setLocation((n += immInsets2.left) + immInsets.left, (n2 += immInsets2.top) + immInsets.top);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        ImmInsets immInsets = this._getBorderInsets();
        this._comp.setSize(n -= immInsets.left + immInsets.right, n2 -= immInsets.top + immInsets.bottom);
        this._comp.invalidate();
        this._comp.validate();
    }

    public void setMinimumWidth(int n) {
        super.setMinimumWidth(n);
        this._minWidth = n;
    }

    protected Painter getPainter() {
        return NullPainter.getPainter();
    }

    Component __getComponent() {
        return this._comp;
    }

    private ImmInsets _getBorderInsets() {
        BorderPainter borderPainter = this.getBorderPainter();
        if (borderPainter != null) {
            return borderPainter.getInsets(this);
        }
        return ImmInsets.getEmptyInsets();
    }
}

