/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabPanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabPanel.TabPanel;

public class TabPanelPage
implements Accessible {
    private Component _content;
    private TabPanel _parentTabPanel;
    private TabBarItem _item;
    private AccessibleContext _accessibleContext;

    public TabPanelPage(Component component, String string) {
        this.setPageContent(component);
        this._item = new TabBarItem(string);
    }

    public void setLabel(String string) {
        AccessibleContext accessibleContext = this._accessibleContext;
        String string2 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
        String string3 = this.getLabel();
        this._item.setLabel(string);
        TabPanel tabPanel = this.getParent();
        if (tabPanel != null) {
            this.getParent()._setLabel(string, this);
        }
        if (accessibleContext != null) {
            String string4;
            if (string3 != string) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", string3, string);
            }
            if ((string4 = accessibleContext.getAccessibleName()) != string2) {
                accessibleContext.firePropertyChange("AccessibleName", string2, string4);
            }
        }
    }

    public String getLabel() {
        return this._item.getLabel();
    }

    public int getIndex() {
        return this._item.indexOf();
    }

    public void setContent(Component component) {
        Component component2 = this.getContent();
        TabPanel tabPanel = this.getParent();
        if (tabPanel != null) {
            tabPanel.setContent(component, this);
        } else {
            this.setPageContent(component);
        }
    }

    public Component getContent() {
        return this._content;
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            this._item.setEnabled(bl);
            this.getContent().setEnabled(bl);
            AccessibleContext accessibleContext = this._accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleState", bl ? AccessibleState.ENABLED : null, bl ? null : AccessibleState.ENABLED);
            }
        }
    }

    public boolean isEnabled() {
        return this._item.isEnabled();
    }

    public void setSelected(boolean bl) {
        this._item.setSelected(bl);
        if (bl && this.getParent() != null) {
            this.getParent()._displaySelectedContents();
        }
    }

    public boolean isSelected() {
        return this._item.isSelected();
    }

    public final void setIcon(Image image) {
        ImageSet imageSet = this.getImageSet();
        this._item.setIcon(image);
        this._fireImageSetChanged(imageSet, this.getImageSet());
    }

    public ImageSet getImageSet() {
        return this._item.getImageSet();
    }

    public void setImageSet(ImageSet imageSet) {
        ImageSet imageSet2 = this.getImageSet();
        this._item.setImageSet(imageSet);
        this._fireImageSetChanged(imageSet2, imageSet);
    }

    public void setMnemonicIndex(int n) {
        this._item.setMnemonicIndex(n);
    }

    public void setMnemonicChar(char c) {
        this._item.setMnemonicChar(c);
    }

    public int getMnemonicIndex() {
        return this._item.getMnemonicIndex();
    }

    public char getMnemonicChar() {
        return this._item.getMnemonicChar();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            AccessibleContext accessibleContext;
            this._item.setVisible(bl);
            TabPanel tabPanel = this.getParent();
            if (tabPanel != null) {
                tabPanel.__fireVisibleDataChanged();
            }
            if ((accessibleContext = this._accessibleContext) != null) {
                accessibleContext.firePropertyChange("AccessibleState", bl ? null : AccessibleState.VISIBLE, bl ? AccessibleState.VISIBLE : null);
            }
        }
    }

    public boolean isVisible() {
        return this._item.isVisible();
    }

    public TabPanel getParent() {
        return this._parentTabPanel;
    }

    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new Access();
            Component component = this.getContent();
            if (component instanceof Accessible) {
                ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
            }
        }
        return this._accessibleContext;
    }

    protected void setPageContent(Component component) {
        Component component2 = this._content;
        if (component2 != component) {
            AccessibleContext accessibleContext = this._accessibleContext;
            if (accessibleContext != null && component2 instanceof Accessible) {
                ((Accessible)((Object)component2)).getAccessibleContext().setAccessibleParent(null);
                accessibleContext.firePropertyChange("AccessibleChild", component2, null);
            }
            this._content = component;
            if (accessibleContext != null && component instanceof Accessible) {
                ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
                accessibleContext.firePropertyChange("AccessibleChild", null, component);
            }
        }
    }

    protected TabBarItem getTabBarItem() {
        return this._item;
    }

    void setParent(TabPanel tabPanel) {
        this._parentTabPanel = tabPanel;
    }

    private void _fireImageSetChanged(ImageSet imageSet, ImageSet imageSet2) {
        AccessibleContext accessibleContext = this._accessibleContext;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", imageSet, imageSet2);
        }
    }

    private class Access
    extends AccessibleContext
    implements AccessibleComponent {
        private Access() {
        }

        public Accessible getAccessibleParent() {
            return TabPanelPage.this.getParent();
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return TabPanelPage.this.getLabel();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = TabPanelPage.this.getParent().getAccessibleContext().getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (TabPanelPage.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        public int getAccessibleIndexInParent() {
            return TabPanelPage.this.getParent().getIndexOf(TabPanelPage.this);
        }

        public int getAccessibleChildrenCount() {
            return TabPanelPage.this.getContent() instanceof Accessible ? 1 : 0;
        }

        public Accessible getAccessibleChild(int n) {
            if (n != 0) {
                return null;
            }
            Component component = TabPanelPage.this.getContent();
            if (component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }

        public Locale getLocale() {
            return TabPanelPage.this.getParent().getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return TabPanelPage.this.getParent().getBackground();
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            return TabPanelPage.this.getParent().getForeground();
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            Cursor cursor = TabPanelPage.this.getParent().getCursor();
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            return cursor;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return TabPanelPage.this.getParent().getFont();
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return TabPanelPage.this.getParent().getFontMetrics(font);
        }

        public boolean isEnabled() {
            return TabPanelPage.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            TabPanelPage.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return TabPanelPage.this.isVisible();
        }

        public void setVisible(boolean bl) {
            TabPanelPage.this.setVisible(bl);
        }

        public boolean isShowing() {
            return this.isVisible() && TabPanelPage.this.getParent().isShowing();
        }

        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return false;
            }
            return rectangle.contains(point);
        }

        public Point getLocationOnScreen() {
            if (!this.isShowing()) {
                return null;
            }
            Point point = TabPanelPage.this.getParent().getLocationOnScreen();
            Point point2 = this.getLocation();
            point2.translate(point.x, point.y);
            return point2;
        }

        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return null;
            }
            return new Point(rectangle.x, rectangle.y);
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            TabBarItem tabBarItem = TabPanelPage.this.getTabBarItem();
            Rectangle rectangle = tabBarItem.getOuterBounds();
            Point point = TabPanelPage.this.getParent().getTabBar().getLocation();
            rectangle.x += point.x;
            rectangle.y += point.y;
            return rectangle;
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return null;
            }
            return new Dimension(rectangle.width, rectangle.height);
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            Component component = TabPanelPage.this.getContent();
            if (component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }
    }
}

