/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabPanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.layout.NamelessCardLayout;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.plaf.TabbedPaneUI;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.util.ImmInsets;

class TabPanelSheet
extends LWComponent {
    private int _orientation = 0;
    private TabPanel _parent;
    private static final int _INSET_WIDTH = 5;

    public TabPanelSheet(TabPanel tabPanel) {
        this.setLayout(NamelessCardLayout.getLayoutManager());
        this._parent = tabPanel;
    }

    public void setOrientation(int n) {
        if (this._orientation != n) {
            this._orientation = n;
            this.repaint();
        }
    }

    public void setTabPanel(TabPanel tabPanel) {
        this._parent = tabPanel;
    }

    public TabPanel getTabPanel() {
        return this._parent;
    }

    public void repaintAllItems() {
        ImmInsets immInsets = this.getBorderInsets();
        Dimension dimension = this.getSize();
        if (this._orientation == 0) {
            this.repaint(0, 0, dimension.width, immInsets.top);
        } else if (this._orientation == 1) {
            this.repaint(0, dimension.height - immInsets.bottom, dimension.width, immInsets.bottom);
        } else if (this._orientation == 2) {
            this.repaint(0, 0, immInsets.left, dimension.height);
        } else {
            this.repaint(dimension.width - immInsets.right, 0, immInsets.right, dimension.height);
        }
    }

    public void repaintItemBorder(TabBarItem tabBarItem) {
        if (tabBarItem != null) {
            ImmInsets immInsets = this.getBorderInsets();
            Rectangle rectangle = tabBarItem.getOuterBounds();
            rectangle.x += this.getTabPanel().getTabBar().getLocation().x;
            rectangle.y += this.getTabPanel().getTabBar().getLocation().y;
            if (this._orientation == 0) {
                this.repaint(rectangle.x, 0, rectangle.width, immInsets.top);
            } else if (this._orientation == 1) {
                this.repaint(rectangle.x, this.getSize().height - immInsets.bottom, rectangle.width, immInsets.bottom);
            } else if (this._orientation == 2) {
                this.repaint(0, rectangle.y, immInsets.left, rectangle.height);
            } else {
                this.repaint(this.getSize().width - immInsets.right, rectangle.y, immInsets.right, rectangle.height);
            }
        }
    }

    public BorderPainter getBorderPainter() {
        TabPanel tabPanel = this.getTabPanel();
        return ((TabbedPaneUI)tabPanel.getUI()).getSheetBorderPainter(tabPanel);
    }

    public void displayContents(Component component) {
        NamelessCardLayout.flipToComponent(component);
    }

    protected void validateTree() {
        super.validateTree();
        this.repaint();
    }

    protected Object getPaintData(Object object) {
        Rectangle rectangle;
        TabBar tabBar = this.getTabPanel().getTabBar();
        if (object.equals("TabBar")) {
            return tabBar;
        }
        TabBarItem tabBarItem = tabBar.getSelectedItem();
        if (tabBarItem != null) {
            rectangle = tabBarItem.getOuterBounds();
            rectangle.x += tabBar.getLocation().x;
            rectangle.y += tabBar.getLocation().y;
        } else {
            rectangle = null;
        }
        if (object.equals("LeftGap")) {
            if (rectangle != null) {
                return IntegerUtils.getInteger((int)rectangle.x);
            }
            return new Integer(Integer.MAX_VALUE);
        }
        if (object.equals("RightGap")) {
            if (rectangle != null) {
                return IntegerUtils.getInteger((int)(rectangle.x + rectangle.width - 1));
            }
            return IntegerUtils.getInteger((int)Integer.MIN_VALUE);
        }
        if (object.equals("TopGap")) {
            if (rectangle != null) {
                return IntegerUtils.getInteger((int)rectangle.y);
            }
            return new Integer(Integer.MAX_VALUE);
        }
        if (object.equals("BottomGap")) {
            if (rectangle != null) {
                return IntegerUtils.getInteger((int)(rectangle.y + rectangle.height - 1));
            }
            return IntegerUtils.getInteger((int)Integer.MIN_VALUE);
        }
        return super.getPaintData(object);
    }
}

