/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.table;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.EwtComponent;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.separator.Separator;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridCellSelectListener;
import oracle.ewt.grid.GridColSelectListener;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridFocusListener;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridScrollListener;
import oracle.ewt.header.Header;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.TableUI;
import oracle.ewt.print.PrinterUtils;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.table.TableAccessibleGrid;
import oracle.ewt.table.TableAccessibleHeader;
import oracle.ewt.table.TableCellSelectListener;
import oracle.ewt.table.TableColSelectListener;
import oracle.ewt.table.TableEditListener;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableFocusListener;
import oracle.ewt.table.TableGridAdapter;
import oracle.ewt.table.TableHeaderAdapter;
import oracle.ewt.table.TableLayoutManager;
import oracle.ewt.table.TableMoveListener;
import oracle.ewt.table.TableResizeListener;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.table.TableScrollListener;
import oracle.ewt.table.TableValidateEvent;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;

public class SpreadTable
extends EwtComponent {
    public static final Object DUPLICATE_COLUMN_HEADERS = "table.dupColHeaders";
    public static final Object DUPLICATE_ROW_HEADERS = "table.dupRowHeaders";
    public static final Object DISPLAY_COLUMN_HEADERS = "table.dispColHeaders";
    public static final Object DISPLAY_ROW_HEADERS = "table.dispRowHeaders";
    public static final Object PRINT_RAISED = "spreadTable.printRaised";
    private Header _columnHeader;
    private Header _rowHeader;
    private Grid _grid;
    private boolean _rowSet;
    private boolean _columnSet;
    private DSListen _dsListener;
    private boolean _displayRowHeader;
    private boolean _displayColumnHeader;
    private int _columnHeaderHeight = -1;
    private int _rowHeaderWidth = -1;
    private TableLayoutManager _layoutManager;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private ListenerManager _cellSelectListeners;
    private ListenerManager _colSelectListeners;
    private ListenerManager _rowSelectListeners;
    private ListenerManager _focusListeners;
    private ListenerManager _editListeners;
    private ListenerManager _scrollListeners;
    private ListenerManager _resizeListeners;
    private ListenerManager _moveListeners;
    private boolean _drawRaised = true;

    public SpreadTable() {
        this(null, null, null);
    }

    public SpreadTable(TwoDDataSource twoDDataSource, OneDDataSource oneDDataSource, OneDDataSource oneDDataSource2) {
        Object object;
        super.setLayout(new TableLayoutManager());
        this._grid = this.createGrid(twoDDataSource);
        twoDDataSource = this._grid.getDataSource();
        if (this._grid.getAccessibleGrid() == null) {
            object = new TableAccessibleGrid(this);
        }
        this._dsListener = new DSListen();
        this.add(this._grid, "grid", 0);
        this.setDataSources(twoDDataSource, oneDDataSource, oneDDataSource2);
        object = new TableGridAdapter(this);
        this._grid.addCellSelectListener((GridCellSelectListener)object);
        this._grid.addColSelectListener((GridColSelectListener)object);
        this._grid.addRowSelectListener((GridRowSelectListener)object);
        this._grid.addFocusListener((GridFocusListener)object);
        this._grid.addEditListener((GridEditListener)object);
        this._grid.addScrollListener((GridScrollListener)object);
        long l = 20L;
        this.enableEvents(l);
        this.updateUI(SpreadTable.class);
    }

    public void setDrawRaised(boolean bl) {
        if (this._drawRaised != bl) {
            this._drawRaised = bl;
            this.repaint();
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    protected void updateUI(Class clazz) {
        if (clazz == SpreadTable.class) {
            this.updateUI();
        }
    }

    public Object getUIClassID() {
        return "TableUI";
    }

    public synchronized void addCellSelectListener(TableCellSelectListener tableCellSelectListener) {
        if (this._cellSelectListeners == null) {
            this._cellSelectListeners = new ListenerManager();
        }
        this._cellSelectListeners.addListener(tableCellSelectListener);
    }

    public synchronized void removeCellSelectListener(TableCellSelectListener tableCellSelectListener) {
        if (this._cellSelectListeners != null) {
            this._cellSelectListeners.removeListener(tableCellSelectListener);
        }
    }

    public synchronized void addColSelectListener(TableColSelectListener tableColSelectListener) {
        if (this._colSelectListeners == null) {
            this._colSelectListeners = new ListenerManager();
        }
        this._colSelectListeners.addListener(tableColSelectListener);
    }

    public synchronized void removeColSelectListener(TableColSelectListener tableColSelectListener) {
        if (this._colSelectListeners != null) {
            this._colSelectListeners.removeListener(tableColSelectListener);
        }
    }

    public synchronized void addRowSelectListener(TableRowSelectListener tableRowSelectListener) {
        if (this._rowSelectListeners == null) {
            this._rowSelectListeners = new ListenerManager();
        }
        this._rowSelectListeners.addListener(tableRowSelectListener);
    }

    public synchronized void removeRowSelectListener(TableRowSelectListener tableRowSelectListener) {
        if (this._rowSelectListeners != null) {
            this._rowSelectListeners.removeListener(tableRowSelectListener);
        }
    }

    public synchronized void addFocusListener(TableFocusListener tableFocusListener) {
        if (this._focusListeners == null) {
            this._focusListeners = new ListenerManager();
        }
        this._focusListeners.addListener(tableFocusListener);
    }

    public synchronized void removeFocusListener(TableFocusListener tableFocusListener) {
        if (this._focusListeners != null) {
            this._focusListeners.removeListener(tableFocusListener);
        }
    }

    public synchronized void addEditListener(TableEditListener tableEditListener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener(tableEditListener);
    }

    public synchronized void removeEditListener(TableEditListener tableEditListener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener(tableEditListener);
        }
    }

    public synchronized void addScrollListener(TableScrollListener tableScrollListener) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new ListenerManager();
        }
        this._scrollListeners.addListener(tableScrollListener);
    }

    public synchronized void removeScrollListener(TableScrollListener tableScrollListener) {
        if (this._scrollListeners != null) {
            this._scrollListeners.removeListener(tableScrollListener);
        }
    }

    public synchronized void addResizeListener(TableResizeListener tableResizeListener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener(tableResizeListener);
    }

    public synchronized void removeResizeListener(TableResizeListener tableResizeListener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener(tableResizeListener);
        }
    }

    public synchronized void addMoveListener(TableMoveListener tableMoveListener) {
        if (this._moveListeners == null) {
            this._moveListeners = new ListenerManager();
        }
        this._moveListeners.addListener(tableMoveListener);
    }

    public synchronized void removeMoveListener(TableMoveListener tableMoveListener) {
        if (this._moveListeners != null) {
            this._moveListeners.removeListener(tableMoveListener);
        }
    }

    public int getOnScreenRowCount() {
        return this._grid.getOnScreenRowCount();
    }

    public int getOnScreenColumnCount() {
        return this._grid.getOnScreenColumnCount();
    }

    public int getFirstRowOnScreen() {
        return this._grid.getFirstRowOnScreen();
    }

    public void setFirstRowOnScreen(int n) {
        this._grid.setFirstRowOnScreen(n);
        if (this.isRowHeaderVisible()) {
            this._rowHeader.setFirstItemOnScreen(n);
        }
        int n2 = this.getScrollByRow() ? n : this.getGrid().getRowPosition(n);
        this.updateVScrollBarValue(n2);
    }

    public int getFirstColumnOnScreen() {
        return this._grid.getFirstColumnOnScreen();
    }

    public void setFirstColumnOnScreen(int n) {
        this._grid.setFirstColumnOnScreen(n);
        if (this.isColumnHeaderVisible()) {
            this._columnHeader.setFirstItemOnScreen(n);
        }
    }

    public Grid getGrid() {
        return this._grid;
    }

    public void setRowHeaderVisible(boolean bl) {
        if (bl && this._rowHeader == null) {
            throw new IllegalStateException();
        }
        if (this.isRowHeaderVisible() != bl) {
            this._displayRowHeader = bl;
            this._updateUI();
            this.invalidateCanvas();
        }
    }

    public boolean isRowHeaderVisible() {
        return this._displayRowHeader;
    }

    public void setColumnHeaderVisible(boolean bl) {
        if (bl && this._columnHeader == null) {
            throw new IllegalStateException();
        }
        if (this.isColumnHeaderVisible() != bl) {
            this._displayColumnHeader = bl;
            this._updateUI();
            this.invalidateCanvas();
        }
    }

    public boolean isColumnHeaderVisible() {
        return this._displayColumnHeader;
    }

    public void setColumnHeaderHeight(int n) {
        if (n != this._columnHeaderHeight) {
            this._columnHeaderHeight = n;
            if (this._columnHeader != null) {
                Dimension dimension = this._columnHeader.getSize();
                this._columnHeader.setSize(dimension.width, n);
                this.invalidateCanvas();
            }
        }
    }

    public void setCanvasOrigin(int n, int n2) {
        int n3 = this.getFirstColumnOnScreen();
        int n4 = this.getFirstRowOnScreen();
        super.setCanvasOrigin(n, n2);
        int n5 = this.getFirstColumnOnScreen();
        int n6 = this.getFirstRowOnScreen();
        if (n3 != n5) {
            this.fireColumnEvent(2020, n5);
        }
        if (n4 != n6) {
            this.fireRowEvent(2022, n6);
        }
    }

    public int getColumnHeaderHeight() {
        return this._columnHeaderHeight;
    }

    public Header getColumnHeader() {
        return this._columnHeader;
    }

    public void setRowHeaderWidth(int n) {
        if (n != this._rowHeaderWidth) {
            this._rowHeaderWidth = n;
            if (this._rowHeader != null) {
                Dimension dimension = this._rowHeader.getSize();
                this._rowHeader.setSize(n, dimension.height);
                this.invalidateCanvas();
            }
        }
    }

    public int getRowHeaderWidth() {
        return this._rowHeaderWidth;
    }

    public Header getRowHeader() {
        return this._rowHeader;
    }

    public void handleHScroll(int n, int n2) {
        int n3 = this.getFirstColumnOnScreen();
        this._grid.handleHScroll(n, n2);
        if (this._columnHeader != null) {
            this._columnHeader.handleHScroll(n, n2);
        }
        this.getHAdjustable().setValue(n);
        this.storeCanvasOrigin(this.getHOffsetOfValue(n), this.getCanvasOrigin().y);
        int n4 = this.getFirstColumnOnScreen();
        if (n3 != n4) {
            this.fireColumnEvent(2020, n4);
        }
    }

    public void handleVScroll(int n, int n2) {
        int n3 = this.getFirstRowOnScreen();
        this._grid.handleVScroll(n, n2);
        if (this._rowHeader != null) {
            this._rowHeader.handleVScroll(n, n2);
        }
        this.getVAdjustable().setValue(n);
        this.storeCanvasOrigin(this.getCanvasOrigin().x, this.getVOffsetOfValue(n));
        int n4 = this.getFirstRowOnScreen();
        if (n3 != n4) {
            this.fireRowEvent(2022, n4);
        }
    }

    public void setHorizontalSeparatorsVisible(boolean bl) {
        if (this._grid.getHorizontalSeparatorsVisible() != bl) {
            this._grid.setHorizontalSeparatorsVisible(bl);
            this._updateHorizontalSizes();
        }
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._grid.getHorizontalSeparatorsVisible();
    }

    public final void setHorizontalSeparator(Separator separator) {
        if (this._grid.getHorizontalSeparator() != separator) {
            this._grid.setHorizontalSeparator(separator);
            this._updateHorizontalSizes();
        }
    }

    public final Separator getHorizontalSeparator() {
        return this._grid.getHorizontalSeparator();
    }

    public void setHorizontalSeparatorPainter(Painter painter) {
        if (this._grid.getHorizontalSeparatorPainter() != painter) {
            this._grid.setHorizontalSeparatorPainter(painter);
            this._updateHorizontalSizes();
        }
    }

    public Painter getHorizontalSeparatorPainter() {
        return this._grid.getHorizontalSeparatorPainter();
    }

    public void setVerticalSeparatorsVisible(boolean bl) {
        if (this._grid.getVerticalSeparatorsVisible() != bl) {
            this._grid.setVerticalSeparatorsVisible(bl);
            this._updateVerticalSizes();
        }
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._grid.getVerticalSeparatorsVisible();
    }

    public final void setVerticalSeparator(Separator separator) {
        if (this._grid.getVerticalSeparator() != separator) {
            this._grid.setVerticalSeparator(separator);
            this._updateVerticalSizes();
        }
    }

    public final Separator getVerticalSeparator() {
        return this._grid.getVerticalSeparator();
    }

    public void setVerticalSeparatorPainter(Painter painter) {
        if (this._grid.getVerticalSeparatorPainter() != painter) {
            this._grid.setVerticalSeparatorPainter(painter);
            this._updateVerticalSizes();
        }
    }

    public Painter getVerticalSeparatorPainter() {
        return this._grid.getVerticalSeparatorPainter();
    }

    public void setDefaultColumnWidth(int n) {
        this._grid.setDefaultColumnWidth(n);
        if (this._columnHeader != null) {
            this._columnHeader.setDefaultItemSize(n += this.getVerticalSeparatorSize());
        }
    }

    public int getDefaultColumnWidth() {
        return this._grid.getDefaultColumnWidth();
    }

    public void setDefaultRowHeight(int n) {
        this._grid.setDefaultRowHeight(n);
        if (this._rowHeader != null) {
            this._rowHeader.setDefaultItemSize(n += this.getHorizontalSeparatorSize());
        }
    }

    public int getDefaultRowHeight() {
        return this._grid.getDefaultRowHeight();
    }

    public synchronized void setColumnVisibleIndex(int n, int n2) {
        this._grid.setColumnVisibleIndex(n, n2);
        if (this._columnHeader != null) {
            this._columnHeader.setItemVisibleIndex(n, n2);
        }
    }

    public synchronized void setRowVisibleIndex(int n, int n2) {
        this._grid.setRowVisibleIndex(n, n2);
        if (this._rowHeader != null) {
            this._rowHeader.setItemVisibleIndex(n, n2);
        }
    }

    public void setColumnVisible(int n, boolean bl) {
        this._grid.setColumnVisible(n, bl);
        if (this._columnHeader != null) {
            this._columnHeader.setItemVisible(n, bl);
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean isColumnVisible(int n) {
        return this._grid.isColumnVisible(n);
    }

    public void setRowVisible(int n, boolean bl) {
        this._grid.setRowVisible(n, bl);
        if (this._rowHeader != null) {
            this._rowHeader.setItemVisible(n, bl);
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean isRowVisible(int n) {
        return this._grid.isRowVisible(n);
    }

    public void setColumnWidth(int n, int n2) {
        this._columnSet = true;
        this._grid.setColumnWidth(n, n2);
        if (this._columnHeader != null) {
            if (n2 != -1) {
                n2 += this.getVerticalSeparatorSize();
            }
            this._columnHeader.setItemSize(n, n2);
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public int getColumnWidth(int n) {
        return this._grid.getColumnWidth(n);
    }

    public void setRowHeight(int n, int n2) {
        this._rowSet = true;
        this._grid.setRowHeight(n, n2);
        if (this._rowHeader != null) {
            if (n2 != -1) {
                n2 += this.getHorizontalSeparatorSize();
            }
            this._rowHeader.setItemSize(n, n2);
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public int getRowHeight(int n) {
        return this._grid.getRowHeight(n);
    }

    public void setDataSources(TwoDDataSource twoDDataSource, OneDDataSource oneDDataSource, OneDDataSource oneDDataSource2) {
        int n;
        boolean bl;
        Grid grid = this.getGrid();
        grid.getDataSource().removeDataSourceListener(this._dsListener);
        if (this._columnHeader != null) {
            bl = oneDDataSource != null;
            this.setColumnHeaderVisible(bl);
            this._columnHeader.setDataSource(oneDDataSource);
        } else if (oneDDataSource != null) {
            this._columnHeader = this.createColumnHeader(oneDDataSource);
            TableHeaderAdapter tableHeaderAdapter = new TableHeaderAdapter(this, this._columnHeader);
            this._columnHeader.addSelectListener(tableHeaderAdapter);
            this._columnHeader.addResizeListener(tableHeaderAdapter);
            this._columnHeader.addMoveListener(tableHeaderAdapter);
            this._columnHeader.addScrollListener(tableHeaderAdapter);
            this._columnHeader.addFocusListener(tableHeaderAdapter);
            this.add(this._columnHeader, "columnHeader", 1);
            this._displayColumnHeader = true;
            n = this._grid.getDefaultColumnWidth();
            if (n != 0) {
                this._columnHeader.setDefaultItemSize(n += this.getVerticalSeparatorSize());
            }
            if (this._columnHeader.getAccessibleHeader() == null) {
                TableAccessibleHeader tableAccessibleHeader = new TableAccessibleHeader(this._columnHeader);
            }
        } else {
            this._displayColumnHeader = false;
        }
        if (this._rowHeader != null) {
            bl = oneDDataSource2 != null;
            this.setRowHeaderVisible(bl);
            this._rowHeader.setDataSource(oneDDataSource2);
        } else if (oneDDataSource2 != null) {
            this._rowHeader = this.createRowHeader(oneDDataSource2);
            TableHeaderAdapter tableHeaderAdapter = new TableHeaderAdapter(this, this._rowHeader);
            this._rowHeader.addSelectListener(tableHeaderAdapter);
            this._rowHeader.addResizeListener(tableHeaderAdapter);
            this._rowHeader.addMoveListener(tableHeaderAdapter);
            this._rowHeader.addScrollListener(tableHeaderAdapter);
            this._rowHeader.addFocusListener(tableHeaderAdapter);
            this._displayRowHeader = true;
            n = this.getComponentCount();
            this.add(this._rowHeader, "rowHeader", n);
            int n2 = this._grid.getDefaultRowHeight();
            if (n2 != 0) {
                this._rowHeader.setDefaultItemSize(n2 += this.getHorizontalSeparatorSize());
            }
            if (this._rowHeader.getAccessibleHeader() == null) {
                TableAccessibleHeader tableAccessibleHeader = new TableAccessibleHeader(this._rowHeader);
            }
        } else {
            this._displayRowHeader = false;
        }
        this._rowSet = false;
        this._columnSet = false;
        grid.setDataSource(twoDDataSource);
        grid.getDataSource().addDataSourceListener(this._dsListener);
        this.invalidateCanvas();
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        Dimension dimension = super.getDocumentSize(paintContext, dictionary);
        return dimension;
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        Object object;
        Font font;
        Serializable serializable;
        Object object2;
        boolean bl;
        int n;
        int n2;
        Shape shape = graphics.getClip();
        Rectangle rectangle = graphics.getClipRect();
        boolean bl2 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_HEADERS, true) && (rectangle.y == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_HEADERS, true));
        boolean bl3 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_HEADERS, true) && (rectangle.x == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_HEADERS, true));
        Header header = bl2 && this.isColumnHeaderVisible() ? this.getColumnHeader() : null;
        Header header2 = bl3 && this.isRowHeaderVisible() ? this.getRowHeader() : null;
        int n3 = header2 != null ? this.getRowHeaderWidth() : 0;
        int n4 = n2 = header != null ? this.getColumnHeaderHeight() : 0;
        if (n2 >= rectangle.height) {
            n = rectangle.height / 8;
            n2 = rectangle.height - n;
        }
        if (n3 >= rectangle.width) {
            n = rectangle.width / 8;
            n3 = rectangle.width - n;
        }
        n = this.getDrawRaised() ? 1 : 0;
        boolean bl4 = PrinterUtils.getPrinterProperty(dictionary, PRINT_RAISED, false);
        this.freezeRepaints();
        this.setDrawRaised(bl4);
        rectangle.width -= n3;
        rectangle.height -= n2;
        if (header != null) {
            header.freezeRepaints();
            bl = header.getDrawRaised();
            header.setDrawRaised(bl4);
            object2 = graphics;
            serializable = ((Graphics)object2).getColor();
            font = ((Graphics)object2).getFont();
            ((Graphics)object2).translate(n3, rectangle.y);
            ((Graphics)object2).setClip(rectangle.x, 0, rectangle.width, n2);
            ((Graphics)object2).setFont(header.getFont());
            ((Graphics)object2).setColor(header.getForeground());
            header.printPage(paintContext, dictionary, (Graphics)object2);
            ((Graphics)object2).translate(-n3, -rectangle.y);
            ((Graphics)object2).setClip(shape);
            ((Graphics)object2).setFont(font);
            ((Graphics)object2).setColor((Color)serializable);
            header.setDrawRaised(bl);
            header.unfreezeRepaints();
        }
        if (header2 != null) {
            header2.freezeRepaints();
            bl = header2.getDrawRaised();
            header2.setDrawRaised(bl4);
            object2 = graphics;
            serializable = ((Graphics)object2).getColor();
            font = ((Graphics)object2).getFont();
            ((Graphics)object2).translate(rectangle.x, n2);
            ((Graphics)object2).setClip(0, rectangle.y, n3, rectangle.height);
            ((Graphics)object2).setFont(header2.getFont());
            ((Graphics)object2).setColor(header2.getForeground());
            header2.printPage(paintContext, dictionary, (Graphics)object2);
            ((Graphics)object2).translate(-rectangle.x, -n2);
            ((Graphics)object2).setClip(shape);
            ((Graphics)object2).setColor((Color)serializable);
            ((Graphics)object2).setFont(font);
            header2.setDrawRaised(bl);
            header2.unfreezeRepaints();
        }
        if ((object = PrinterUtils.getPrinterProperty(dictionary, Grid.DISPLAY_HORIZONTAL_SEPARATOR, null)) == null) {
            object2 = header == null ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, object2);
        }
        if ((object2 = PrinterUtils.getPrinterProperty(dictionary, Grid.DISPLAY_VERTICAL_SEPARATOR, null)) == null) {
            serializable = header2 == null ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_VERTICAL_SEPARATOR, serializable);
        }
        serializable = this.getGrid();
        graphics.translate(n3, n2);
        graphics.setClip(rectangle);
        graphics.setFont(((LWComponent)serializable).getFont());
        graphics.setColor(((LWComponent)serializable).getForeground());
        ((Grid)serializable).printPage(paintContext, dictionary, graphics);
        graphics.translate(-n3, -n2);
        if (n3 != 0 && n2 != 0) {
            graphics.translate(rectangle.x, rectangle.y);
            graphics.setClip(0, 0, n3, n2);
            this._paintTable(paintContext, graphics);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
        graphics.setClip(shape);
        this.setDrawRaised(n != 0);
        this.unfreezeRepaints();
        if (object == null) {
            dictionary.remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
        }
        if (object2 == null) {
            dictionary.remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
        }
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = bl = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_HEADERS, true) && (n2 == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_HEADERS, true));
        if (bl) {
            if (this.isColumnHeaderVisible()) {
                n6 = this.getColumnHeaderHeight();
            }
            if (n6 >= n4) {
                n5 = n4 / 8;
                n6 = n4 - n5;
                n4 = n5;
            } else {
                n4 -= n6;
            }
        }
        int n8 = n5 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_HEADERS, true) && (n == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_HEADERS, true)) ? 1 : 0;
        if (n5 != 0) {
            if (this.isRowHeaderVisible()) {
                n7 = this.getRowHeaderWidth();
            }
            if (n7 >= n3) {
                int n9 = n3 / 8;
                n7 = n3 - n9;
                n3 = n9;
            } else {
                n3 -= n7;
            }
        }
        Rectangle rectangle = this.getGrid().getPageBounds(paintContext, dictionary, n, n2, n3, n4);
        rectangle.width += n7;
        rectangle.height += n6;
        return rectangle;
    }

    public void paintInterior(Graphics graphics) {
        this._paintTable(this.getPaintContext(), graphics);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._grid.setEnabled(bl);
        if (this._columnHeader != null) {
            this._columnHeader.setEnabled(bl);
        }
        if (this._rowHeader != null) {
            this._rowHeader.setEnabled(bl);
        }
    }

    public int getRepaintFlags() {
        return super.getRepaintFlags() | 1 | 4 | 0x80 | 0x4000 | 0x400;
    }

    public void addNotify() {
        int n;
        super.addNotify();
        if (this.getRowHeaderWidth() == -1) {
            this.setRowHeaderWidth(this._grid.getDefaultColumnWidth());
        }
        if (this.getColumnHeaderHeight() == -1) {
            this.setColumnHeaderHeight(this._grid.getDefaultRowHeight());
        }
        if (this._columnHeader != null && (n = this._grid.getDefaultColumnWidth()) != 0) {
            this._columnHeader.setDefaultItemSize(n += this.getVerticalSeparatorSize());
        }
        if (this._rowHeader != null && (n = this._grid.getDefaultRowHeight()) != 0) {
            this._rowHeader.setDefaultItemSize(n += this.getHorizontalSeparatorSize());
        }
        this._updateHorizontalSizes();
        this._updateVerticalSizes();
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    public void setScrollByColumn(boolean bl) {
        if (bl == this.getScrollByColumn()) {
            return;
        }
        this._grid.setScrollByColumn(bl);
        if (this._columnHeader != null) {
            this._columnHeader.setScrollByItem(bl);
        }
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean getScrollByColumn() {
        return this._grid.getScrollByColumn();
    }

    public void setScrollByRow(boolean bl) {
        if (bl == this.getScrollByRow()) {
            return;
        }
        this._grid.setScrollByRow(bl);
        if (this._rowHeader != null) {
            this._rowHeader.setScrollByItem(bl);
        }
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean getScrollByRow() {
        return this._grid.getScrollByRow();
    }

    public final boolean fireCancelableRowEvent(int n, int n2) {
        TableValidateEvent tableValidateEvent = new TableValidateEvent(this, n, -1, n2);
        this.processEvent(tableValidateEvent);
        return tableValidateEvent.isCancelled();
    }

    public final boolean fireCancelableColumnEvent(int n, int n2) {
        TableValidateEvent tableValidateEvent = new TableValidateEvent(this, n, n2, -1);
        this.processEvent(tableValidateEvent);
        return tableValidateEvent.isCancelled();
    }

    public final boolean fireCancelableCellEvent(int n, int n2, int n3) {
        TableValidateEvent tableValidateEvent = new TableValidateEvent(this, n, n2, n3);
        this.processEvent(tableValidateEvent);
        return tableValidateEvent.isCancelled();
    }

    public final void fireRowEvent(int n, int n2) {
        TableEvent tableEvent = new TableEvent(this, n, -1, n2);
        this.processEvent(tableEvent);
    }

    public final void fireColumnEvent(int n, int n2) {
        TableEvent tableEvent = new TableEvent(this, n, n2, -1);
        this.processEvent(tableEvent);
    }

    public final void fireCellEvent(int n, int n2, int n3) {
        TableEvent tableEvent = new TableEvent(this, n, n2, n3);
        this.processEvent(tableEvent);
    }

    public void requestFocus() {
        this.getGrid().requestFocus();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this._grid.getPreferredSize();
        if (this.isColumnHeaderVisible()) {
            dimension.height += this._columnHeader.getPreferredSize().height;
        }
        if (this.isRowHeaderVisible()) {
            dimension.width += this._rowHeader.getPreferredSize().width;
        }
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this._grid.getMinimumSize();
        if (this.isColumnHeaderVisible()) {
            dimension.height += this._columnHeader.getMinimumSize().height;
        }
        if (this.isRowHeaderVisible()) {
            dimension.width += this._rowHeader.getMinimumSize().width;
        }
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateTree() {
        this.freezeRepaints();
        try {
            super.validateTree();
            Point point = this._grid.getCanvasOrigin();
            this.setCanvasOrigin(point.x, point.y);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanvasSize(int n, int n2) {
        this.freezeRepaints();
        try {
            super.setCanvasSize(n, n2);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        this._vAdjustable = adjustable;
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        this._hAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (adjustable == this.getHAdjustable()) {
            this._hAdjustable = null;
        } else if (adjustable == this.getVAdjustable()) {
            this._vAdjustable = null;
        } else {
            super.detachAdjustable(adjustable);
        }
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    public boolean isChildClipped(Component component) {
        return this.isClippedBySibling();
    }

    protected Object getPaintData(Object object) {
        if (TableUI.KEY_DRAW_RAISED.equals(object)) {
            return this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getPaintData(object);
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TableEvent) {
            switch (aWTEvent.getID()) {
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: {
                    this.processCellSelectEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2005: 
                case 2006: 
                case 2007: 
                case 2008: {
                    this.processRowSelectEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2009: 
                case 2010: 
                case 2011: 
                case 2012: {
                    this.processColSelectEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2027: 
                case 2028: {
                    this.processFocusCellEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2019: 
                case 2020: 
                case 2021: 
                case 2022: {
                    this.processScrollEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2017: 
                case 2018: {
                    this.processEditEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2013: 
                case 2014: 
                case 2015: 
                case 2016: {
                    this.processResizeEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2023: 
                case 2024: 
                case 2025: 
                case 2026: {
                    this.processMoveEvent((TableEvent)aWTEvent);
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processColSelectEvent(TableEvent tableEvent) {
        if (this._colSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._colSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2009: {
                while (enumeration.hasMoreElements()) {
                    ((TableColSelectListener)enumeration.nextElement()).columnSelecting(tableEvent);
                }
                break;
            }
            case 2011: {
                while (enumeration.hasMoreElements()) {
                    ((TableColSelectListener)enumeration.nextElement()).columnDeselecting(tableEvent);
                }
                break;
            }
            case 2010: {
                while (enumeration.hasMoreElements()) {
                    ((TableColSelectListener)enumeration.nextElement()).columnSelected(tableEvent);
                }
                break;
            }
            case 2012: {
                while (enumeration.hasMoreElements()) {
                    ((TableColSelectListener)enumeration.nextElement()).columnDeselected(tableEvent);
                }
                break;
            }
        }
    }

    protected void processRowSelectEvent(TableEvent tableEvent) {
        if (this._rowSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._rowSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((TableRowSelectListener)enumeration.nextElement()).rowSelecting(tableEvent);
                }
                break;
            }
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    ((TableRowSelectListener)enumeration.nextElement()).rowDeselecting(tableEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    ((TableRowSelectListener)enumeration.nextElement()).rowSelected(tableEvent);
                }
                break;
            }
            case 2008: {
                while (enumeration.hasMoreElements()) {
                    ((TableRowSelectListener)enumeration.nextElement()).rowDeselected(tableEvent);
                }
                break;
            }
        }
    }

    protected void processCellSelectEvent(TableEvent tableEvent) {
        if (this._cellSelectListeners == null) {
            return;
        }
        Enumeration enumeration = this._cellSelectListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((TableCellSelectListener)enumeration.nextElement()).cellSelecting(tableEvent);
                }
                break;
            }
            case 2003: {
                while (enumeration.hasMoreElements()) {
                    ((TableCellSelectListener)enumeration.nextElement()).cellDeselecting(tableEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((TableCellSelectListener)enumeration.nextElement()).cellSelected(tableEvent);
                }
                break;
            }
            case 2004: {
                while (enumeration.hasMoreElements()) {
                    ((TableCellSelectListener)enumeration.nextElement()).cellDeselected(tableEvent);
                }
                break;
            }
        }
    }

    protected void processFocusCellEvent(TableEvent tableEvent) {
        if (this._focusListeners == null) {
            return;
        }
        Enumeration enumeration = this._focusListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2027: {
                while (enumeration.hasMoreElements()) {
                    ((TableFocusListener)enumeration.nextElement()).focusCellChanging(tableEvent);
                }
                break;
            }
            case 2028: {
                while (enumeration.hasMoreElements()) {
                    ((TableFocusListener)enumeration.nextElement()).focusCellChanged(tableEvent);
                }
                break;
            }
        }
    }

    protected void processEditEvent(TableEvent tableEvent) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumeration = this._editListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2017: {
                while (enumeration.hasMoreElements()) {
                    ((TableEditListener)enumeration.nextElement()).cellEditing(tableEvent);
                }
                break;
            }
            case 2018: {
                while (enumeration.hasMoreElements()) {
                    ((TableEditListener)enumeration.nextElement()).cellEdited(tableEvent);
                }
                break;
            }
        }
    }

    protected void processScrollEvent(TableEvent tableEvent) {
        if (this._scrollListeners == null) {
            return;
        }
        Enumeration enumeration = this._scrollListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2019: {
                while (enumeration.hasMoreElements()) {
                    ((TableScrollListener)enumeration.nextElement()).columnScrolling(tableEvent);
                }
                break;
            }
            case 2021: {
                while (enumeration.hasMoreElements()) {
                    ((TableScrollListener)enumeration.nextElement()).rowScrolling(tableEvent);
                }
                break;
            }
            case 2020: {
                while (enumeration.hasMoreElements()) {
                    ((TableScrollListener)enumeration.nextElement()).columnScrolled(tableEvent);
                }
                break;
            }
            case 2022: {
                while (enumeration.hasMoreElements()) {
                    ((TableScrollListener)enumeration.nextElement()).rowScrolled(tableEvent);
                }
                break;
            }
        }
    }

    protected void processResizeEvent(TableEvent tableEvent) {
        Object object;
        int n = tableEvent.getID();
        if (n == 2014 || n == 2016) {
            object = this._grid.getCanvasSize();
            this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
            Point point = this._grid.getCanvasOrigin();
            if (point.x > 0) {
                point.x = 0;
                this._grid.setCanvasOrigin(point.x, point.y);
            }
            if (n == 2014 && this._columnHeader != null) {
                Point point2 = this._columnHeader.getCanvasOrigin();
                if (point2.x != point.x) {
                    this._columnHeader.setCanvasOrigin(point.x, 0);
                }
            }
            this.setCanvasOrigin(point.x, point.y);
        }
        if (this._resizeListeners == null) {
            return;
        }
        object = this._resizeListeners.getListeners();
        if (object == null) {
            return;
        }
        switch (n) {
            case 2013: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).columnResizing(tableEvent);
                }
                break;
            }
            case 2014: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).columnResized(tableEvent);
                }
                break;
            }
            case 2015: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).rowResizing(tableEvent);
                }
                break;
            }
            case 2016: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).rowResized(tableEvent);
                }
                break;
            }
        }
    }

    protected void processMoveEvent(TableEvent tableEvent) {
        if (this._moveListeners == null) {
            return;
        }
        Enumeration enumeration = this._moveListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2023: {
                while (enumeration.hasMoreElements()) {
                    ((TableMoveListener)enumeration.nextElement()).columnMoving(tableEvent);
                }
                break;
            }
            case 2024: {
                while (enumeration.hasMoreElements()) {
                    ((TableMoveListener)enumeration.nextElement()).columnMoved(tableEvent);
                }
                break;
            }
            case 2025: {
                while (enumeration.hasMoreElements()) {
                    ((TableMoveListener)enumeration.nextElement()).rowMoving(tableEvent);
                }
                break;
            }
            case 2026: {
                while (enumeration.hasMoreElements()) {
                    ((TableMoveListener)enumeration.nextElement()).rowMoved(tableEvent);
                }
                break;
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        boolean bl = InputEventUtils.isLeftMouseButton(mouseEvent);
        int n = mouseEvent.getID();
        if (bl && n == 501 && this.isEnabled()) {
            this.getGrid().requestFocus();
            if (this.isSelectAllEnabled() && mouseEvent.getY() < this.getColumnHeaderHeight()) {
                int n2 = this.getActualReadingDirection();
                int n3 = this.getRowHeaderWidth();
                if (n2 == 1 && mouseEvent.getX() < n3 || n2 == 2 && mouseEvent.getX() > this.getSize().width - n3) {
                    this._grid.getGridSelection().selectAll();
                }
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004) {
            this._grid.requestFocus();
        }
    }

    protected Dimension layoutCanvas() {
        Header header;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Header header2 = this.getRowHeader();
        if (header2 != null && this.isRowHeaderVisible()) {
            header2.validate();
            n = header2.getCanvasWidth();
        }
        if ((header = this.getColumnHeader()) != null && this.isColumnHeaderVisible()) {
            header.validate();
            n2 = header.getCanvasHeight();
        }
        Grid grid = this.getGrid();
        grid.validate();
        n3 = grid.getCanvasWidth();
        n4 = grid.getCanvasHeight();
        return new Dimension(n3 + n, n4 + n2);
    }

    protected boolean isSelectAllEnabled() {
        return this.isColumnHeaderVisible() && this.isRowHeaderVisible();
    }

    protected EwtComponent getProxyConfigurer() {
        return this._grid;
    }

    protected Header createColumnHeader(OneDDataSource oneDDataSource) {
        Header header = new Header(oneDDataSource, true);
        return header;
    }

    protected Header createRowHeader(OneDDataSource oneDDataSource) {
        Header header = new Header(oneDDataSource, false);
        return header;
    }

    protected Grid createGrid(TwoDDataSource twoDDataSource) {
        return new Grid(twoDDataSource);
    }

    protected void updateHScrollBarValue(int n) {
        Adjustable adjustable = this.getHAdjustable();
        if (adjustable == null) {
            return;
        }
        if (this.getReadingDirection() == 2 && this.getScrollByColumn()) {
            n = this._grid.getVisibleColumnCount() - n - 1;
        }
        if (adjustable.getValue() != n) {
            adjustable.setValue(n);
        }
    }

    protected void updateVScrollBarValue(int n) {
        Adjustable adjustable = this.getVAdjustable();
        if (adjustable == null) {
            return;
        }
        if (adjustable.getValue() != n) {
            adjustable.setValue(n);
        }
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    int getHorizontalSeparatorSize() {
        boolean bl = this._grid.getHorizontalSeparatorsVisible();
        Painter painter = this._grid.getHorizontalSeparatorPainter();
        PaintContext paintContext = this._grid.getPaintContext();
        int n = bl ? painter.getPreferredSize((PaintContext)paintContext).height : 0;
        return n;
    }

    int getVerticalSeparatorSize() {
        boolean bl = this._grid.getVerticalSeparatorsVisible();
        Painter painter = this._grid.getVerticalSeparatorPainter();
        PaintContext paintContext = this._grid.getPaintContext();
        int n = bl ? painter.getPreferredSize((PaintContext)paintContext).width : 0;
        return n;
    }

    void internalRowsChanged(TwoDDataSourceEvent twoDDataSourceEvent) {
        if (this.getGrid().getRowCount() == 0) {
            this._rowSet = false;
        }
        this.getGrid().validate();
        Header header = this.getColumnHeader();
        if (header != null && this.isColumnHeaderVisible()) {
            header.validate();
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    void internalColumnsChanged(TwoDDataSourceEvent twoDDataSourceEvent) {
        if (this.getGrid().getColumnCount() == 0) {
            this._columnSet = false;
        }
        this.getGrid().validate();
        Header header = this.getRowHeader();
        if (header != null && this.isRowHeaderVisible()) {
            header.validate();
        }
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    private void _paintTable(PaintContext paintContext, Graphics graphics) {
        if (this.isSelectAllEnabled()) {
            TableUI tableUI = (TableUI)this.getUI();
            int n = this.getRowHeaderWidth();
            int n2 = this.getColumnHeaderHeight();
            Painter painter = tableUI.getCornerPainter(this);
            ImmInsets immInsets = this.getBorderInsets();
            int n3 = 0;
            if (this.getActualReadingDirection() == 2) {
                n3 = this.getSize().width - n - immInsets.right;
            }
            painter.paint(paintContext, graphics, n3, 0, n, n2);
        }
    }

    private void _updateUI() {
        this.getUI().installUI(this);
    }

    private void _updateHorizontalSizes() {
        int n;
        if (this._rowHeader == null) {
            return;
        }
        int n2 = this.getHorizontalSeparatorSize();
        int n3 = this._grid.getDefaultRowHeight();
        if (n3 == 0) {
            n = 0;
        } else {
            n = n3 + n2;
            this._rowHeader.setDefaultItemSize(n);
        }
        if (!this._rowSet) {
            return;
        }
        for (int i = 0; i < this._grid.getRowCount(); ++i) {
            n = this._grid.getRowHeight(i) + n2;
            this._rowHeader.setItemSize(i, n);
        }
    }

    private void _updateVerticalSizes() {
        int n;
        if (this._columnHeader == null) {
            return;
        }
        int n2 = this.getVerticalSeparatorSize();
        int n3 = this._grid.getDefaultColumnWidth();
        if (n3 == 0) {
            n = 0;
        } else {
            n = n3 + n2;
            this._columnHeader.setDefaultItemSize(n);
        }
        if (!this._columnSet) {
            return;
        }
        for (int i = 0; i < this._grid.getColumnCount(); ++i) {
            n = this._grid.getColumnWidth(i) + n2;
            this._columnHeader.setItemSize(i, n);
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(SpreadTable.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }
    }

    private class DSListen
    implements TwoDDataSourceListener {
        private DSListen() {
        }

        public void rowsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            SpreadTable.this.internalRowsChanged(twoDDataSourceEvent);
        }

        public void rowsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            SpreadTable.this.internalRowsChanged(twoDDataSourceEvent);
        }

        public void columnsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            SpreadTable.this.internalColumnsChanged(twoDDataSourceEvent);
        }

        public void columnsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            SpreadTable.this.internalColumnsChanged(twoDDataSourceEvent);
        }

        public void invalidateRows(TwoDDataSourceEvent twoDDataSourceEvent) {
        }

        public void invalidateColumns(TwoDDataSourceEvent twoDDataSourceEvent) {
        }

        public void invalidateCells(TwoDDataSourceEvent twoDDataSourceEvent) {
        }
    }
}

