/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.toolBar.ComponentMouseAdapter;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;

public class ToolBarComponentWrapper
extends ToolBarItem {
    private String _helpText;
    private Component _component;

    public ToolBarComponentWrapper(Component component) {
        this(component, -1);
    }

    public ToolBarComponentWrapper(Component component, int n) {
        this.setID(n);
        new ComponentMouseAdapter(this).attachComponent(component);
        this._component = component;
    }

    public Component getComponent() {
        return this._component;
    }

    public void setSize(int n, int n2) {
        this._component.setSize(n, n2);
        this._component.invalidate();
    }

    public void setSize(Dimension dimension) {
        this._component.setSize(dimension);
        this._component.invalidate();
    }

    public void storeSize(int n, int n2) {
        this._component.setSize(n, n2);
    }

    protected void setParent(ToolBar toolBar) {
    }

    public ToolBar getParent() {
        return (ToolBar)this._component.getParent();
    }

    public void setLocation(int n, int n2) {
        Point point = this.getParent().convertCanvasToOuter(n, n2);
        this._component.setLocation(point.x, point.y);
    }

    public Point getLocation() {
        Point point = this._component.getLocation();
        return this.getParent().convertOuterToCanvas(point.x, point.y);
    }

    public Dimension getSize() {
        return this._component.getSize();
    }

    public Dimension getPreferredSize() {
        return this._component.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this._component.getMinimumSize();
    }

    public boolean inside(int n, int n2) {
        Rectangle rectangle = this._component.getBounds();
        Point point = this.getParent().convertCanvasToOuter(n, n2);
        return point.x >= rectangle.x && point.x < rectangle.x + rectangle.width && point.y >= rectangle.y && point.y < rectangle.y + rectangle.height;
    }

    public boolean isVisible() {
        return this._component.isVisible();
    }

    public void setVisible(boolean bl) {
        this._component.setVisible(bl);
    }

    public boolean isEnabled() {
        return this._component.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this._component.setEnabled(bl);
    }

    public String getHelpText() {
        if (this._component instanceof LWComponent) {
            Object object = ((LWComponent)this._component).getToolTipValue();
            if (object instanceof String) {
                return (String)object;
            }
            return null;
        }
        return this._helpText;
    }

    public void setHelpText(String string) {
        if (this._component instanceof LWComponent) {
            ((LWComponent)this._component).setToolTipValue(string);
        } else {
            this._helpText = string;
        }
    }
}

