/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarRadioGroup;
import oracle.ewt.toolBar.ToolBarToggleButton;

public class ToolBarRadio
extends ToolBarToggleButton {
    ToolBarRadioGroup _group;

    public ToolBarRadio() {
    }

    public ToolBarRadio(int n, Image image) {
        super(n, image);
    }

    public ToolBarRadio(int n, Image image, ToolBarRadioGroup toolBarRadioGroup) {
        super(n, image);
        this._group = toolBarRadioGroup;
    }

    public ToolBarRadio(int n, Image image, ToolBarRadioGroup toolBarRadioGroup, String string) {
        super(n, image, string);
        this._group = toolBarRadioGroup;
    }

    public ToolBarRadio(int n, ImageSet imageSet) {
        super(n, imageSet);
    }

    public ToolBarRadio(int n, ImageSet imageSet, ToolBarRadioGroup toolBarRadioGroup) {
        super(n, imageSet);
        this.setImageSet(imageSet);
    }

    public ToolBarRadio(int n, ImageSet imageSet, ToolBarRadioGroup toolBarRadioGroup, String string) {
        super(n, imageSet, string);
        this.setImageSet(imageSet);
    }

    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.getState()) {
            return true;
        }
        return super.mousePressed(mouseEvent, n, n2);
    }

    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this.getState()) {
            return true;
        }
        return super.mouseDragged(mouseEvent, n, n2);
    }

    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2) {
        if (this.getState()) {
            return true;
        }
        return super.mouseReleased(mouseEvent, n, n2);
    }

    public void activate() {
        if (!this.getState()) {
            this.setState(true);
            super.activate();
        }
    }

    public void setState(boolean bl) {
        super.setState(bl);
        if (bl && (this.getParent() != null || this._group != null)) {
            this._autocoordinate();
        }
    }

    public ToolBarRadioGroup getGroup() {
        return this._group;
    }

    protected void setParent(ToolBar toolBar) {
        super.setParent(toolBar);
        if ((toolBar != null || this._group != null) && this.getState()) {
            this._autocoordinate();
        }
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private void _autocoordinate() {
        ToolBarRadioGroup toolBarRadioGroup = this.getGroup();
        if (toolBarRadioGroup != null) {
            toolBarRadioGroup.setCurrentRadio(this);
        } else {
            int n;
            ToolBar toolBar = this.getParent();
            int n2 = toolBar.getItemCount();
            ToolBarItem[] toolBarItemArray = toolBar.getItems();
            int n3 = toolBar.getItemIndex(this);
            for (n = n3 + 1; n < n2 && toolBarItemArray[n] instanceof ToolBarRadio; ++n) {
                ((ToolBarRadio)toolBarItemArray[n]).setState(false);
            }
            for (n = n3 - 1; n >= 0 && toolBarItemArray[n] instanceof ToolBarRadio; --n) {
                ((ToolBarRadio)toolBarItemArray[n]).setState(false);
            }
        }
    }

    private class Access
    extends ToolBarToggleButton.ToggleAccess {
        private Access() {
            super(ToolBarRadio.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.RADIO_BUTTON;
        }
    }
}

