/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;
import oracle.ewt.button.PushButton;
import oracle.ewt.event.HelpEvent;
import oracle.ewt.event.HelpListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.help.HelpCapable;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.plaf.WizardUI;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.statusBar.StatusBarTextItem;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.WizardRowLayout;

public abstract class BaseWizard
extends LWComponent {
    public static final int MNEMONIC_APPLY = 0;
    public static final int MNEMONIC_CANCEL = 1;
    public static final int MNEMONIC_FINISH = 2;
    public static final int MNEMONIC_NEXT = 3;
    public static final int MNEMONIC_PREVIOUS = 4;
    public static final int MNEMONIC_HELP = 5;
    private boolean _inGetHelpTopic = false;
    private LWComponent _buttonRow;
    PushButton _apply;
    PushButton _cancel;
    PushButton _finish;
    PushButton _next;
    PushButton _previous;
    PushButton _help;
    private Vector _pages;
    private ListenerManager _wizardListeners;
    private ListenerManager _helpListeners;
    private WizardPage _selectedPage;
    private int _customButtons;
    private boolean _finishDefaulted = true;
    private StatusBarTextItem _accessibleLabel;
    private LWComponent _bottomPanel;
    private UpdateAccess _accessTask;
    private static final int _BUTTON_SEPARATION = 8;
    private static final int _BUTTON_CONTENT_DISTANCE = 9;
    private static final String _FINISH_KEY = "FINISH";
    private static final String _APPLY_KEY = "APPLY";
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _PREVIOUS_KEY = "PREV";
    private static final String _NEXT_KEY = "NEXT";
    private static final String _HELP_KEY = "HELP";

    protected BaseWizard() {
        Action action = new Action();
        this.setLayout(new BorderLayout(0, 9));
        this._buttonRow = new LWComponent();
        this._buttonRow.setLayout(new WizardRowLayout(8));
        this._bottomPanel = new LWComponent();
        this._bottomPanel.setLayout(new BorderLayout());
        this._bottomPanel.add("North", this._buttonRow);
        this.add("South", this._bottomPanel);
        this._pages = new Vector();
        PushButton pushButton = this.createButton(action);
        this._buttonRow.add((Component)pushButton, "Cancel");
        pushButton.setLeftmost(true);
        pushButton.setRightmost(true);
        this._cancel = pushButton;
        pushButton = this.createButton(action);
        this._buttonRow.add((Component)pushButton, "Help");
        pushButton.setLeftmost(true);
        pushButton.setRightmost(true);
        this._help = pushButton;
        pushButton = this.createButton(action);
        pushButton.setVisible(false);
        this._buttonRow.add((Component)pushButton, "Apply");
        pushButton.setLeftmost(true);
        pushButton.setRightmost(true);
        this._apply = pushButton;
        pushButton = this.createButton(action);
        pushButton.setEnabled(false);
        pushButton.setLeftmost(true);
        this._buttonRow.add((Component)pushButton, "Back");
        this._previous = pushButton;
        pushButton = this.createButton(action);
        pushButton.setEnabled(false);
        pushButton.setRightmost(true);
        this._buttonRow.add((Component)pushButton, "Next");
        this._next = pushButton;
        pushButton = this.createButton(action);
        pushButton.setEnabled(false);
        this._buttonRow.add((Component)pushButton, "Finish");
        pushButton.setLeftmost(true);
        pushButton.setRightmost(true);
        this._finish = pushButton;
        this.updateReadingDirection(this.getActualReadingDirection());
    }

    public Object getUIClassID() {
        return "WizardUI";
    }

    public void setHelpAvailable(boolean bl) {
        this._help.setVisible(bl);
    }

    public boolean isHelpAvailable() {
        return this._help.isVisible();
    }

    public void setCanApply(boolean bl) {
        this._apply.setVisible(bl);
    }

    public boolean getCanApply() {
        return this._apply.isVisible();
    }

    public void setFinishText(String string) {
        if (string == null || "".equals(string)) {
            if (this._finishDefaulted) {
                return;
            }
            if (!this.isDisplayable()) {
                this._finish.setLabel("");
            } else {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.wizard.resource.WizardBundle", LocaleUtils.getTranslationLocale(LocaleUtils.getDefaultableLocale(this)));
                this.setButtonLabel(this._finish, resourceBundle.getString(_FINISH_KEY));
            }
            this._finishDefaulted = true;
        } else {
            if (this._finishDefaulted) {
                this._finish.setMnemonicIndex(-1);
            }
            this._finish.setLabel(string);
            this._finishDefaulted = false;
        }
    }

    public String getFinishText() {
        return this._finish.getLabel();
    }

    public void setFinishMnemonicIndex(int n) {
        this._finish.setMnemonicIndex(n);
    }

    public int getFinishMnemonicIndex() {
        return this._finish.getMnemonicIndex();
    }

    public char getButtonMnemonicChar(int n) {
        char c = '\u0000';
        switch (n) {
            case 0: {
                c = this._apply.getMnemonicChar();
                break;
            }
            case 1: {
                c = this._cancel.getMnemonicChar();
                break;
            }
            case 2: {
                c = this._finish.getMnemonicChar();
                break;
            }
            case 3: {
                c = this._next.getMnemonicChar();
                break;
            }
            case 4: {
                c = this._previous.getMnemonicChar();
                break;
            }
            case 5: {
                c = this._help.getMnemonicChar();
            }
        }
        return c;
    }

    public final WizardPage addPage(WizardPage wizardPage) {
        return this.addPage(wizardPage, null);
    }

    public synchronized WizardPage addPage(WizardPage wizardPage, WizardPage wizardPage2) {
        if (wizardPage.getParent() != null) {
            wizardPage.getParent().removePage(wizardPage);
        }
        if (wizardPage2 == null) {
            this._pages.addElement(wizardPage);
        } else {
            this._pages.insertElementAt(wizardPage, this._pages.indexOf(wizardPage2));
        }
        wizardPage.setParent(this);
        if (this.getSelectedPage() == null && wizardPage.isEnabled() && wizardPage.isVisible()) {
            this.selectPage(wizardPage, false);
        }
        this.enableButtons();
        return wizardPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPages(BaseWizard baseWizard, WizardPage wizardPage) {
        Object[] objectArray;
        if (baseWizard == this || baseWizard.getPageCount() == 0) {
            return;
        }
        BaseWizard baseWizard2 = baseWizard;
        synchronized (baseWizard2) {
            objectArray = new WizardPage[baseWizard.getPageCount()];
            baseWizard._pages.copyInto(objectArray);
            baseWizard.removeAllPages();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.addPage((WizardPage)objectArray[i], wizardPage);
        }
    }

    public synchronized void removePage(WizardPage wizardPage) {
        if (this._selectedPage == wizardPage) {
            WizardPage wizardPage2 = this.getNextPage(wizardPage);
            if (wizardPage2 == null) {
                wizardPage2 = this.getPreviousPage(wizardPage);
            }
            this.selectPage(wizardPage2, false);
        }
        this._pages.removeElement(wizardPage);
        wizardPage.setParent(null);
        this.enableButtons();
    }

    public synchronized void removeAllPages() {
        int n = this.getPageCount();
        while (--n >= 0) {
            this.getPageAt(n).setParent(null);
        }
        this._pages.removeAllElements();
        this.selectPage(null, false);
        this.enableButtons();
    }

    public int getPageCount() {
        return this._pages.size();
    }

    public WizardPage getPageAt(int n) {
        return (WizardPage)this._pages.elementAt(n);
    }

    public WizardPage getSelectedPage() {
        return this._selectedPage;
    }

    public int getCurrentPageIndex() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return -1;
        }
        return wizardPage.getIndex();
    }

    public void selectPage(WizardPage wizardPage) {
        this.selectPage(wizardPage, true);
    }

    public void restart() {
        if (this.getPageCount() == 0) {
            return;
        }
        WizardPage wizardPage = this.getPageAt(0);
        if (!wizardPage.isEnabled() || !wizardPage.isVisible()) {
            wizardPage = this.getNextPage(wizardPage);
        }
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    public WizardPage getNextPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        int n2 = this.getPageCount();
        while (++n < n2) {
            WizardPage wizardPage2 = this.getPageAt(n);
            if (!wizardPage2.isVisible() || !wizardPage2.isEnabled()) continue;
            return wizardPage2;
        }
        return null;
    }

    public WizardPage getPreviousPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        while (--n >= 0) {
            WizardPage wizardPage2 = this.getPageAt(n);
            if (!wizardPage2.isVisible() || !wizardPage2.isEnabled()) continue;
            return wizardPage2;
        }
        return null;
    }

    public synchronized void addHelpListener(HelpListener helpListener) {
        if (this._helpListeners == null) {
            this._helpListeners = new ListenerManager();
        }
        this._helpListeners.addListener(helpListener);
    }

    public synchronized void removeHelpListener(HelpListener helpListener) {
        this._helpListeners.removeListener(helpListener);
    }

    public synchronized void addWizardListener(WizardListener wizardListener) {
        if (this._wizardListeners == null) {
            this._wizardListeners = new ListenerManager();
        }
        this._wizardListeners.addListener(wizardListener);
    }

    public synchronized void removeWizardListener(WizardListener wizardListener) {
        this._wizardListeners.removeListener(wizardListener);
    }

    public String getHelpTopic() {
        Component component;
        if (this._inGetHelpTopic) {
            return null;
        }
        this._inGetHelpTopic = true;
        String string = null;
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage != null && (component = wizardPage.getContent()) instanceof HelpCapable) {
            string = ((HelpCapable)((Object)component)).getHelpTopic();
        }
        this._inGetHelpTopic = false;
        return string != null ? string : super.getHelpTopic();
    }

    public void addCustomButton(Component component) {
        if (component.getParent() != this._buttonRow) {
            this._buttonRow.add(component, 2 + this._customButtons);
            ++this._customButtons;
        }
    }

    public void removeCustomButton(Component component) {
        if (component.getParent() == this._buttonRow) {
            --this._customButtons;
            this._buttonRow.remove(component);
        }
    }

    public void setReservedButtonSpaces(int n) {
        ((WizardRowLayout)this._buttonRow.getLayout()).setReservedButtonSpaces(n);
    }

    public int getReservedButtonSpaces() {
        return ((WizardRowLayout)this._buttonRow.getLayout()).getReservedButtonSpaces();
    }

    public void setButtonFont(Font font) {
        this._buttonRow.setFont(font);
    }

    public Font getButtonFont() {
        return this._buttonRow.getFont();
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this.loadButtonText(locale);
    }

    protected void updateReadingDirection(int n) {
        super.updateReadingDirection(n);
        if (this._previous != null && this._next != null) {
            boolean bl = n == 2;
            this._previous.setLeftmost(!bl);
            this._next.setLeftmost(bl);
            this._previous.setRightmost(bl);
            this._next.setRightmost(!bl);
            WizardUI wizardUI = (WizardUI)this.getUI();
            if (wizardUI != null) {
                this._previous.setPainter(wizardUI.getPreviousPainter(this));
                this._next.setPainter(wizardUI.getNextPainter(this));
            }
        }
    }

    protected AccessibleContext createAccessibleContext() {
        this._accessibleLabel = new StatusBarTextItem("");
        this._accessTask = new UpdateAccess();
        StatusBar statusBar = new StatusBar();
        statusBar.setVisible(false);
        statusBar.addItem(this._accessibleLabel);
        this._bottomPanel.add("South", statusBar);
        this.validate();
        this._updateAccessibleLabel();
        return super.createAccessibleContext();
    }

    public void addNotify() {
        super.addNotify();
        final Window window = WindowUtils.getWindow(this);
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                BaseWizard.this._resetFocus(BaseWizard.this.getSelectedPage());
                BaseWizard.this._updateAccessibleLabel();
                window.removeWindowListener(this);
            }
        });
        this.loadButtonText(this.getLocale());
        this._resetFocus(this.getSelectedPage());
    }

    public void postProcessKey(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    this._cancel.simulatePush();
                    keyEvent.consume();
                    break;
                }
                case 112: 
                case 156: {
                    if (!this.isHelpAvailable()) break;
                    this._help.simulatePush();
                    keyEvent.consume();
                }
            }
        }
        super.postProcessKey(keyEvent);
    }

    public void enable() {
        super.enable();
        this.enableButtons();
    }

    public void disable() {
        super.disable();
        this.enableButtons();
    }

    protected boolean getMustFinish() {
        return true;
    }

    protected boolean getCanAdvance() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return false;
        }
        return wizardPage.getCanAdvance();
    }

    protected void doCancel() {
        this.processEvent(new WizardEvent(this, 2003, this.getSelectedPage()));
    }

    protected void doApply() {
        if (this.validateSelectedPage()) {
            this.processEvent(new WizardEvent(this, 2002, this.getSelectedPage()));
        }
    }

    protected void doFinish() {
        if (this.validateSelectedPage()) {
            this.processEvent(new WizardEvent(this, 2004, this.getSelectedPage()));
        }
    }

    protected void doNext() {
        WizardPage wizardPage;
        if (this.validateSelectedPage() && (wizardPage = this.getNextPage(this.getSelectedPage())) != null) {
            this.selectPage(wizardPage, false);
        }
    }

    protected void doPrevious() {
        WizardPage wizardPage = this.getPreviousPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    protected void doHelp() {
        WizardPage wizardPage = this.getSelectedPage();
        this.processEvent(new HelpEvent(this, 2000));
        if (wizardPage != null) {
            wizardPage.processHelpEvent(new HelpEvent(wizardPage, 2000));
            Component component = wizardPage.getContent();
            if (component instanceof HelpCapable) {
                ((HelpCapable)((Object)component)).showHelp();
            }
        } else {
            this.showHelp();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof HelpEvent) {
            this.processHelpEvent((HelpEvent)aWTEvent);
        } else if (aWTEvent instanceof WizardEvent) {
            this.processWizardEvent((WizardEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processHelpEvent(HelpEvent helpEvent) {
        Enumeration enumeration;
        int n = helpEvent.getID();
        ListenerManager listenerManager = this._helpListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                HelpListener helpListener = (HelpListener)enumeration.nextElement();
                helpListener.helpRequested(helpEvent);
            }
        }
    }

    protected void processWizardEvent(WizardEvent wizardEvent) {
        Enumeration enumeration;
        int n = wizardEvent.getID();
        ListenerManager listenerManager = this._wizardListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                WizardListener wizardListener = (WizardListener)enumeration.nextElement();
                switch (n) {
                    case 2001: {
                        wizardListener.wizardSelectionChanged(wizardEvent);
                        break;
                    }
                    case 2002: {
                        wizardListener.wizardApplyState(wizardEvent);
                        break;
                    }
                    case 2003: {
                        wizardListener.wizardCanceled(wizardEvent);
                        break;
                    }
                    case 2004: {
                        wizardListener.wizardFinished(wizardEvent);
                        break;
                    }
                }
            }
        }
    }

    protected void loadButtonText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.wizard.resource.WizardBundle", LocaleUtils.getTranslationLocale(locale));
        if (this._finishDefaulted) {
            this.setButtonLabel(this._finish, resourceBundle.getString(_FINISH_KEY));
        }
        this.setButtonLabel(this._apply, resourceBundle.getString(_APPLY_KEY));
        this.setButtonLabel(this._help, resourceBundle.getString(_HELP_KEY));
        this.setButtonLabel(this._previous, resourceBundle.getString(_PREVIOUS_KEY));
        this.setButtonLabel(this._next, resourceBundle.getString(_NEXT_KEY));
        this.setButtonLabel(this._cancel, resourceBundle.getString(_CANCEL_KEY));
    }

    protected String paramString() {
        String string = super.paramString();
        WizardPage wizardPage = this._selectedPage;
        if (wizardPage != null) {
            string = string + ",selected page=" + wizardPage;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableButtons() {
        this.freezeRepaints();
        try {
            WizardPage wizardPage = this._selectedPage;
            WizardPage wizardPage2 = this.getNextPage(wizardPage);
            boolean bl = this.getCanAdvance();
            boolean bl2 = this.getMustFinish();
            boolean bl3 = this.isEnabled();
            this._finish.setVisible(wizardPage2 == null || !bl2);
            this._finish.setEnabled(bl3 && bl);
            this._next.setEnabled(bl3 && bl && wizardPage2 != null);
            this._previous.setEnabled(bl3 && this.getPreviousPage(wizardPage) != null);
            this._apply.setEnabled(bl3 && bl);
            this._cancel.setEnabled(bl3);
            this._help.setEnabled(bl3);
            this._finish.setDefault(wizardPage2 == null);
            this._next.setDefault(wizardPage2 != null);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    protected void selectPage(WizardPage wizardPage, boolean bl) {
        if (wizardPage != this._selectedPage && (!bl || this.validateSelectedPage())) {
            this.setSelectedPage(wizardPage);
            this.processEvent(new WizardEvent(this, 2001, wizardPage));
            this.enableButtons();
            this._resetFocus(wizardPage);
            this._updateAccessibleLabel();
        }
    }

    protected void setSelectedPage(WizardPage wizardPage) {
        this._selectedPage = wizardPage;
    }

    protected boolean validateSelectedPage() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return true;
        }
        return wizardPage.validatePage();
    }

    protected PushButton createButton(ActionListener actionListener) {
        PushButton pushButton = new PushButton("");
        pushButton.addActionListener(actionListener);
        return pushButton;
    }

    protected void setButtonLabel(Component component, String string) {
        PushButton pushButton = (PushButton)component;
        int n = StringUtils.getMnemonicIndex(string);
        if (n != -1) {
            string = StringUtils.stripMnemonic(string);
        }
        pushButton.setLabel(string);
        pushButton.setMnemonicIndex(n);
    }

    int getPageIndex(WizardPage wizardPage) {
        int n = this._pages.indexOf(wizardPage);
        return n;
    }

    private void _updateAccessibleLabel() {
        WizardPage wizardPage;
        if (this._accessibleLabel != null && (wizardPage = this.getSelectedPage()) != null) {
            this._accessTask.setText(wizardPage.getAccessibleDescription());
            TaskScheduler.getDefaultTaskScheduler().schedule((Task)this._accessTask, 100);
        }
    }

    private void _resetFocus(WizardPage wizardPage) {
        LWComponent lWComponent;
        if (wizardPage == null) {
            return;
        }
        Component component = wizardPage.getInitialFocus();
        if (component == null && (lWComponent = LWComponent.getFocusedComponent()) != this._next && lWComponent != this._previous) {
            component = this._finish.isDefault() ? this._finish : this._next;
        }
        if (component != null && component.isEnabled()) {
            component.requestFocus();
        }
    }

    private class UpdateAccess
    implements Task {
        private String _text = "";

        private UpdateAccess() {
        }

        public void setText(String string) {
            this._text = string;
        }

        public void runTask(TaskEvent taskEvent) {
            BaseWizard.this._accessibleLabel.setText(this._text);
        }
    }

    private class Action
    implements ActionListener {
        private Action() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BaseWizard.this._apply) {
                BaseWizard.this.doApply();
            } else if (object == BaseWizard.this._cancel) {
                BaseWizard.this.doCancel();
            } else if (object == BaseWizard.this._finish) {
                BaseWizard.this.doFinish();
            } else if (object == BaseWizard.this._next) {
                BaseWizard.this.doNext();
            } else if (object == BaseWizard.this._previous) {
                BaseWizard.this.doPrevious();
            } else if (object == BaseWizard.this._help) {
                BaseWizard.this.doHelp();
            }
        }
    }
}

