/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmValueConverter;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;

public class MdmDimensionMemberInfo {
    private MdmMetadataProvider _mdmMetadataProvider = null;
    private MdmPrimaryDimension _mdmPrimaryDimension = null;
    private MdmHierarchy _mdmHierarchy = null;
    private MdmLevel _mdmLevel = null;
    private Object _localValue = null;
    private String _uniqueValue = null;

    public MdmDimensionMemberInfo(MdmMetadataProvider mdmMetadataProvider) {
        this._mdmMetadataProvider = mdmMetadataProvider;
    }

    public MdmDimensionMemberInfo(MdmMetadataProvider mdmMetadataProvider, String string) {
        this.setUniqueValue(string);
        this._mdmMetadataProvider = mdmMetadataProvider;
    }

    public MdmDimensionMemberInfo(MdmPrimaryDimension mdmPrimaryDimension, String string) {
        this.setUniqueValue(string);
        this._mdmPrimaryDimension = mdmPrimaryDimension;
        this._mdmMetadataProvider = mdmPrimaryDimension.getMetadataProvider();
    }

    public MdmDimensionMemberInfo(MdmLevel mdmLevel, Object object) {
        this.setLocalValue(object);
        this.setLevel(mdmLevel);
    }

    public MdmDimensionMemberInfo(MdmValueHierarchy mdmValueHierarchy, Object object) {
        this.setLocalValue(object);
        this.setHierarchy(mdmValueHierarchy);
    }

    void clearMdm() {
        this._mdmPrimaryDimension = null;
        this._mdmHierarchy = null;
        this._mdmLevel = null;
    }

    void clearForNewUniqueValue() {
        this._mdmHierarchy = null;
        this._mdmLevel = null;
        this._localValue = null;
    }

    void clearForNewLocalValue() {
        this._uniqueValue = null;
    }

    public void setUniqueValue(String string) {
        this.clearForNewUniqueValue();
        this._uniqueValue = string;
    }

    public void setLocalValue(Object object) {
        this.clearForNewLocalValue();
        this._localValue = object;
    }

    public void setLevel(MdmLevel mdmLevel) {
        this.clearForNewLocalValue();
        if (null != mdmLevel) {
            this.clearMdm();
            this._mdmHierarchy = mdmLevel.getLevelHierarchy();
            this._mdmPrimaryDimension = mdmLevel.getPrimaryDimension();
            this._mdmMetadataProvider = mdmLevel.getMetadataProvider();
        }
        this._mdmLevel = mdmLevel;
    }

    public void setHierarchy(MdmHierarchy mdmHierarchy) {
        if (mdmHierarchy == this._mdmHierarchy) {
            return;
        }
        this.clearForNewLocalValue();
        if (null != mdmHierarchy) {
            this.clearMdm();
            this._mdmPrimaryDimension = mdmHierarchy.getPrimaryDimension();
            this._mdmMetadataProvider = mdmHierarchy.getMetadataProvider();
        }
        this._mdmHierarchy = mdmHierarchy;
    }

    public void setPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this._mdmPrimaryDimension = mdmPrimaryDimension;
        if (null != mdmPrimaryDimension) {
            this._mdmMetadataProvider = mdmPrimaryDimension.getMetadataProvider();
        }
    }

    void populate(MdmObject mdmObject, Object object, String string) {
        this._localValue = object;
        this._uniqueValue = string;
        if (null == mdmObject) {
            return;
        }
        this._mdmMetadataProvider = mdmObject.getMetadataProvider();
        if (mdmObject instanceof MdmDimension) {
            MdmDimension mdmDimension = (MdmDimension)mdmObject;
            this._mdmPrimaryDimension = mdmDimension.getPrimaryDimension();
            if (mdmDimension instanceof MdmHierarchy) {
                this._mdmHierarchy = (MdmHierarchy)mdmDimension;
                this._mdmLevel = null;
            } else if (mdmDimension instanceof MdmLevel) {
                this._mdmLevel = (MdmLevel)mdmDimension;
                this._mdmHierarchy = this._mdmLevel.getLevelHierarchy();
            }
        }
    }

    public MdmLevel getLevel() throws MdmInvalidValueException, MetadataNotFoundException {
        if (null == this._mdmLevel) {
            this.validate();
        }
        return this._mdmLevel;
    }

    public MdmHierarchy getHierarchy() throws MdmInvalidValueException, MetadataNotFoundException {
        if (null == this._mdmHierarchy) {
            this.validate();
        }
        return this._mdmHierarchy;
    }

    public MdmPrimaryDimension getPrimaryDimension() throws MdmInvalidValueException, MetadataNotFoundException {
        if (null == this._mdmPrimaryDimension) {
            this.validate();
        }
        return this._mdmPrimaryDimension;
    }

    public Object getLocalValue() throws MdmInvalidValueException, MetadataNotFoundException {
        if (null == this._localValue) {
            this.validate();
        }
        return this._localValue;
    }

    public String getUniqueValue() throws MdmInvalidValueException, MetadataNotFoundException {
        if (null == this._uniqueValue) {
            this.validate();
        }
        return this._uniqueValue;
    }

    public void validate() throws MdmInvalidValueException, MetadataNotFoundException {
        if (null != this._uniqueValue && null != this._mdmPrimaryDimension) {
            MdmValueConverter mdmValueConverter = this._mdmMetadataProvider.getValueConverter();
            mdmValueConverter.convertUniqueValueToMemberInfo(this._mdmPrimaryDimension, this._uniqueValue, this);
        } else if (null != this._uniqueValue && null != this._mdmMetadataProvider) {
            MdmValueConverter mdmValueConverter = this._mdmMetadataProvider.getValueConverter();
            mdmValueConverter.convertUniqueValueToMemberInfo(this._mdmMetadataProvider, this._uniqueValue, this);
        } else if (null != this._localValue && null != this._mdmLevel) {
            MdmValueConverter mdmValueConverter = this._mdmLevel.getPrimaryDimension().getValueConverter();
            this._mdmHierarchy = this._mdmLevel.getLevelHierarchy();
            this._uniqueValue = mdmValueConverter.convertLocalValueToUniqueValue(this._mdmMetadataProvider, this._mdmLevel, (String)this._localValue);
        } else if (null != this._localValue && null != this._mdmHierarchy && this._mdmHierarchy instanceof MdmValueHierarchy) {
            MdmValueConverter mdmValueConverter = this._mdmHierarchy.getPrimaryDimension().getValueConverter();
            this._uniqueValue = mdmValueConverter.convertLocalValueToUniqueValue(this._mdmMetadataProvider, (MdmValueHierarchy)this._mdmHierarchy, (String)this._localValue);
            this._mdmLevel = null;
        } else if (null != this._localValue && null != this._mdmPrimaryDimension && 0 == this._mdmPrimaryDimension.getHierarchies().size() && this._localValue instanceof String) {
            this._uniqueValue = (String)this._localValue;
            this._mdmLevel = null;
            this._mdmHierarchy = null;
        } else {
            throw new MdmInvalidValueException("Not enough information to validate this MdmDimensionMemberInfo.");
        }
    }
}

