/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.InvalidMetadataException;
import oracle.olapi.session.UserSession;
import oracle.olapi.transaction.ActiveSubtransactionsException;
import oracle.olapi.transaction.BaseTransactionProvider;
import oracle.olapi.transaction.CommitException;
import oracle.olapi.transaction.CommitWarningsException;
import oracle.olapi.transaction.MetadataContext;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.NotPreparedException;
import oracle.olapi.transaction.Participant;
import oracle.olapi.transaction.PersistentMetadataContext;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.TransactionReference;
import oracle.olapi.transaction.TransactionTypeUnavailableException;
import oracle.olapi.transaction.metadataStateManager.IncrementalMetadataStateHolder;
import oracle.olapi.transaction.metadataStateManager.MetadataStateOwner;

public class BaseTransaction
implements Transaction {
    private static final int STATUS_ACTIVE = 0;
    private static final int STATUS_PREPARING = 1;
    private static final int STATUS_PREPARED = 2;
    private static final int STATUS_COMMITTING = 3;
    private static final int STATUS_COMMITTED = 4;
    private static final int STATUS_ROLLING_BACK = 5;
    private static final int STATUS_ROLLED_BACK = 6;
    private static final int ACTION_COMMIT = 0;
    private static final int ACTION_ROLLBACK = 1;
    private static final int ACTION_PREPARE = 2;
    private static final boolean TRANSACTION_DEBUG = false;
    private static final boolean PRINT_STACK_TRACE = false;
    private int m_Status = 0;
    private BaseTransactionProvider m_TransactionProvider = null;
    private UserSession m_UserSession;
    private BaseTransaction m_Parent = null;
    private BaseTransaction m_FirstSubtransaction = null;
    private BaseTransaction m_NextSibling = null;
    private BaseTransaction m_PreparedSubtransaction = null;
    private TransactionReference m_Reference = null;
    private long m_ContextNumber = PersistentMetadataContext.getNextContextNumber();
    private boolean m_IsIncremental = false;
    private DefinitionManager m_DefinitionManager = null;
    private List m_Participants = null;

    private void setStatus(int n) {
        this.m_Status = n;
    }

    public BaseTransactionProvider getBaseTransactionProvider() {
        return this.m_TransactionProvider;
    }

    protected BaseTransaction getFirstSubtransaction() {
        return this.m_FirstSubtransaction;
    }

    private void setFirstSubtransaction(BaseTransaction baseTransaction) {
        this.m_FirstSubtransaction = baseTransaction;
    }

    protected BaseTransaction getNextSibling() {
        return this.m_NextSibling;
    }

    private void setNextSibling(BaseTransaction baseTransaction) {
        this.m_NextSibling = baseTransaction;
    }

    private BaseTransaction getPreparedSubtransaction() {
        return this.m_PreparedSubtransaction;
    }

    private void setPreparedSubtransaction(BaseTransaction baseTransaction) {
        this.m_PreparedSubtransaction = baseTransaction;
    }

    private void validateActiveStatus() {
        if (this.getStatus() == 0 || this.getStatus() == 1 || this.getStatus() == 2 || this.getStatus() == 3) {
            return;
        }
        throw new TransactionInactiveException(this);
    }

    private void checkSubtransactions() {
        if (null == this.getFirstSubtransaction()) {
            return;
        }
        ArrayList<BaseTransaction> arrayList = new ArrayList<BaseTransaction>();
        for (BaseTransaction baseTransaction = this.getFirstSubtransaction(); null != baseTransaction; baseTransaction = baseTransaction.getNextSibling()) {
            arrayList.add(baseTransaction);
        }
        throw new ActiveSubtransactionsException(arrayList);
    }

    private synchronized BaseTransaction createSubtransaction(boolean bl) throws TransactionInactiveException {
        BaseTransaction baseTransaction = new BaseTransaction(this.getBaseTransactionProvider(), this.getUserSession(), this, bl);
        baseTransaction.setNextSibling(this.getFirstSubtransaction());
        this.setFirstSubtransaction(baseTransaction);
        return baseTransaction;
    }

    private List getParticipants(boolean bl) {
        if (null == this.m_Participants && bl) {
            this.m_Participants = new ArrayList();
        }
        return this.m_Participants;
    }

    private void setParticipants(List list) {
        this.m_Participants = list;
    }

    private void notifyParticipants(int n, int n2) throws NotCommittableException {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.getParticipants(false);
        ArrayList arrayList3 = arrayList;
        while (null != arrayList3) {
            this.setParticipants(null);
            for (Participant participant : arrayList3) {
                try {
                    switch (n) {
                        case 1: {
                            participant.rollback();
                            break;
                        }
                        case 0: {
                            participant.commit(this.getParentTransaction());
                            break;
                        }
                        case 2: {
                            participant.prepare(this.getParentTransaction());
                        }
                    }
                }
                catch (NotCommittableException notCommittableException) {
                    this.setParticipants(arrayList);
                    this.setStatus(n2);
                    throw notCommittableException;
                }
                catch (Exception exception) {
                    this.setParticipants(arrayList);
                    this.setStatus(n2);
                    throw new NotCommittableException("NotCommittable", exception.toString());
                }
            }
            if (arrayList3 != arrayList && n == 2) {
                if (arrayList == arrayList2) {
                    arrayList2 = new ArrayList(arrayList);
                }
                arrayList2.addAll(arrayList3);
            }
            arrayList3 = this.getParticipants(false);
        }
        this.setParticipants(arrayList2);
    }

    private final synchronized void doRollback() {
        this.setStatus(5);
        try {
            if (null != this.getParentTransaction()) {
                this.getParentTransaction().rollbackSubtransaction(this);
                if (null != this.getDefinitionManager()) {
                    this.getDefinitionManager().rollback();
                }
            } else if (null == this.getUserSession().getBranch() || !this.getUserSession().getBranch().isClosing()) {
                this.getBaseTransactionProvider().rollbackRootTransaction(this);
            }
            this.notifyParticipants(1, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setStatus(6);
        this.getTransactionReference().transactionRolledBack();
        this.setParticipants(null);
    }

    private final synchronized void rollbackSubtransaction(BaseTransaction baseTransaction) {
        if (null != this.getDefinitionManager()) {
            try {
                this.getDefinitionManager().rollbackSubtransaction(baseTransaction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.removeSubtransaction(baseTransaction);
        if (this.getPreparedSubtransaction() == baseTransaction) {
            this.setPreparedSubtransaction(null);
        }
    }

    private final synchronized void prepareSubtransaction(BaseTransaction baseTransaction) throws NotCommittableException {
        if (null != this.getPreparedSubtransaction()) {
            throw new NotCommittableException("PrepareLock");
        }
        if (null != this.getDefinitionManager()) {
            this.getDefinitionManager().prepareSubtransaction(baseTransaction);
        }
        this.setPreparedSubtransaction(baseTransaction);
    }

    private final synchronized void commitSubtransaction(BaseTransaction baseTransaction) throws NotCommittableException {
        if (null != this.getDefinitionManager()) {
            this.getDefinitionManager().commitSubtransaction();
        }
        this.removeSubtransaction(baseTransaction);
        this.setPreparedSubtransaction(null);
    }

    private void removeSubtransaction(BaseTransaction baseTransaction) {
        BaseTransaction baseTransaction2 = null;
        for (BaseTransaction baseTransaction3 = this.getFirstSubtransaction(); null != baseTransaction3; baseTransaction3 = baseTransaction3.getNextSibling()) {
            if (baseTransaction == baseTransaction3) {
                if (null == baseTransaction2) {
                    this.setFirstSubtransaction(baseTransaction.getNextSibling());
                    break;
                }
                baseTransaction2.setNextSibling(baseTransaction.getNextSibling());
                break;
            }
            baseTransaction2 = baseTransaction3;
        }
        this.getBaseTransactionProvider().replaceTransaction(baseTransaction, this);
    }

    private void printDebug(String string) {
        if (null != this.getParentTransaction()) {
            this.getParentTransaction().printDebug(null);
            for (BaseTransaction baseTransaction = this.getParentTransaction(); null != baseTransaction; baseTransaction = baseTransaction.getParentTransaction()) {
                System.out.print(" ");
            }
        }
        if (null != string) {
            System.out.print(string);
            System.out.print(" ");
        }
        System.out.print("TXN " + this.getContextNumber());
        if (this.isIncremental()) {
            System.out.println(" (Incremental)");
        } else {
            System.out.println();
        }
    }

    protected BaseTransaction(BaseTransactionProvider baseTransactionProvider, UserSession userSession, BaseTransaction baseTransaction, boolean bl) {
        this.m_TransactionProvider = baseTransactionProvider;
        this.m_UserSession = userSession;
        this.m_Parent = baseTransaction;
        this.m_IsIncremental = bl;
        TransactionReference transactionReference = null;
        if (null != baseTransaction) {
            transactionReference = baseTransaction.getTransactionReference();
        }
        this.m_Reference = new TransactionReference(this, transactionReference);
        baseTransactionProvider.registerTransaction(this);
        baseTransactionProvider.fireEvent(baseTransaction, this, 1);
    }

    public void updateParticipantStates() throws NotCommittableException {
        try {
            ArrayList arrayList = new ArrayList();
            HashSet hashSet = new HashSet();
            ArrayList arrayList2 = new ArrayList();
            ArrayList<BaseMetadataObject> arrayList3 = new ArrayList<BaseMetadataObject>();
            this.getModifiedMetadataObjects(arrayList, hashSet, arrayList2);
            HashSet hashSet2 = new HashSet();
            BaseMetadataObject baseMetadataObject = null;
            Object var7_8 = null;
            BaseMetadataObject baseMetadataObject22 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                baseMetadataObject = (BaseMetadataObject)arrayList.get(i);
                var7_8 = arrayList2.get(i);
                hashSet2.clear();
                baseMetadataObject.getDeletedChildren(var7_8, hashSet2);
                for (BaseMetadataObject baseMetadataObject22 : hashSet2) {
                    arrayList3.add(baseMetadataObject22);
                }
            }
            for (BaseMetadataObject baseMetadataObject22 : arrayList3) {
                baseMetadataObject22.updatePersistentState((short)-1);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                baseMetadataObject = (BaseMetadataObject)arrayList.get(i);
                if (baseMetadataObject.isPersistent()) continue;
                baseMetadataObject.updatePersistentState((short)1);
            }
        }
        catch (Exception exception) {
            throw new NotCommittableException("NotCommittable", exception.toString());
        }
    }

    public TransactionReference getTransactionReference() {
        return this.m_Reference;
    }

    public BaseTransaction getParentTransaction() {
        return this.m_Parent;
    }

    public BaseTransaction getIncrementalTransaction() throws TransactionInactiveException {
        if (this.isIncremental()) {
            return this;
        }
        if (this.getBaseTransactionProvider().hideIncrementalTransactions() && null == this.getDefinitionManager()) {
            return this;
        }
        return this.createSubtransaction(true);
    }

    public BaseTransaction getUserTransaction() {
        if (this.isIncremental()) {
            return this.getParentTransaction();
        }
        return this;
    }

    public BaseTransaction getSystemTransaction() {
        if (null != this.getFirstSubtransaction() && this.getFirstSubtransaction().isIncremental() && this.getBaseTransactionProvider().hideIncrementalTransactions()) {
            return this.getFirstSubtransaction();
        }
        return this;
    }

    public final void setDefinitionManager(DefinitionManager definitionManager) {
        this.m_DefinitionManager = definitionManager;
    }

    public final DefinitionManager getDefinitionManager() {
        return this.m_DefinitionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinitionManager findOrCreateDefinitionManager(DataProvider dataProvider) {
        if (null == this.getDefinitionManager()) {
            BaseTransaction baseTransaction = this;
            synchronized (baseTransaction) {
                if (null == this.getDefinitionManager()) {
                    this.setDefinitionManager(new DefinitionManager(this, dataProvider));
                }
            }
        }
        return this.getDefinitionManager();
    }

    public boolean isIncremental() {
        return this.m_IsIncremental;
    }

    public void setUserSession(UserSession userSession) {
        this.m_UserSession = userSession;
    }

    private void getModifiedMetadataObjects(List list, Set set) {
        this.getModifiedMetadataObjects(list, set, null);
    }

    private void getModifiedMetadataObjects(List list, Set hashSet, List list2) {
        if (this.getParticipants(false) == null) {
            return;
        }
        if (hashSet == null) {
            hashSet = new HashSet<MetadataStateOwner>();
        }
        for (Participant participant : this.getParticipants(false)) {
            if (!(participant instanceof IncrementalMetadataStateHolder)) continue;
            IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)participant;
            MetadataStateOwner metadataStateOwner = incrementalMetadataStateHolder.getOwner();
            if (!incrementalMetadataStateHolder.hasState() || metadataStateOwner == null || !(metadataStateOwner instanceof BaseMetadataObject) || hashSet.contains(metadataStateOwner)) continue;
            hashSet.add(metadataStateOwner);
            list.add(metadataStateOwner);
            if (list2 == null) continue;
            list2.add(incrementalMetadataStateHolder.getIncrementalMetadataState(null, false));
        }
    }

    public void getModifiedMetadataObjectsSince(Transaction transaction, List list) {
        HashSet hashSet = new HashSet();
        for (BaseTransaction baseTransaction = this; baseTransaction != null && baseTransaction != transaction; baseTransaction = baseTransaction.getParentTransaction()) {
            baseTransaction.getModifiedMetadataObjects(list, hashSet);
        }
    }

    @Override
    public int getStatus() {
        return this.m_Status;
    }

    @Override
    public TransactionProvider getTransactionProvider() {
        return this.getBaseTransactionProvider();
    }

    @Override
    public synchronized void registerParticipant(Participant participant) throws TransactionInactiveException {
        this.validateActiveStatus();
        this.getParticipants(true).add(participant);
    }

    @Override
    public synchronized void unregisterParticipant(Participant participant) {
        if (this.getStatus() != 0) {
            throw new TransactionInactiveException(this);
        }
        List list = this.getParticipants(false);
        if (null != list) {
            list.remove(participant);
        }
    }

    @Override
    public Transaction getParent() {
        return this.getParentTransaction();
    }

    @Override
    public boolean isAncestorOf(Transaction transaction) {
        for (Transaction transaction2 = transaction; null != transaction2; transaction2 = transaction2.getParent()) {
            if (transaction2 != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized void prepare() throws NotCommittableException, TransactionInactiveException {
        if (this.getStatus() == 2) {
            return;
        }
        this.validateActiveStatus();
        BaseTransaction baseTransaction = this.getSystemTransaction();
        if (this != baseTransaction) {
            baseTransaction.commit();
        }
        this.checkSubtransactions();
        this.setStatus(1);
        List list = this.getParticipants(false);
        try {
            if (null != this.getDefinitionManager()) {
                this.getDefinitionManager().prepare(this.getParentTransaction());
            }
            this.notifyParticipants(2, 0);
            if (null != this.getParentTransaction()) {
                this.getParentTransaction().prepareSubtransaction(this);
            }
        }
        catch (NotCommittableException notCommittableException) {
            this.setParticipants(list);
            this.setStatus(0);
            throw notCommittableException;
        }
        this.setStatus(2);
    }

    @Override
    public final synchronized void commit() throws CommitException, TransactionInactiveException {
        try {
            this.prepare();
        }
        catch (NotCommittableException notCommittableException) {
            throw new CommitException(notCommittableException);
        }
        if (this.getStatus() != 2) {
            throw new NotPreparedException(this);
        }
        this.getBaseTransactionProvider().fireEvent(this, this.getParentTransaction(), 2);
        this.setStatus(3);
        List list = this.getParticipants(false);
        InvalidMetadataException invalidMetadataException = null;
        try {
            if (null != this.getParentTransaction()) {
                this.getParentTransaction().commitSubtransaction(this);
                if (null != this.getDefinitionManager()) {
                    this.getDefinitionManager().commit(this.getParentTransaction());
                }
            } else {
                invalidMetadataException = this.getBaseTransactionProvider().commitRootTransaction(this);
            }
            this.notifyParticipants(0, 0);
        }
        catch (Exception exception) {
            this.setParticipants(list);
            this.setStatus(0);
            if (null != this.getDefinitionManager()) {
                this.getDefinitionManager().rollbackState();
            }
            throw new CommitException(exception);
        }
        this.setStatus(4);
        this.getTransactionReference().transactionCommitted();
        this.setParticipants(null);
        if (null != invalidMetadataException) {
            throw new CommitWarningsException(invalidMetadataException);
        }
    }

    @Override
    public synchronized void rollback() throws ActiveSubtransactionsException, TransactionInactiveException {
        this.validateActiveStatus();
        BaseTransaction baseTransaction = this.getSystemTransaction();
        if (this != baseTransaction) {
            baseTransaction.doRollback();
        }
        this.checkSubtransactions();
        this.getBaseTransactionProvider().fireEvent(this, this.getParentTransaction(), 3);
        this.doRollback();
    }

    @Override
    public Transaction createSubtransaction() throws TransactionInactiveException, TransactionTypeUnavailableException {
        if (this.isIncremental() && this.getBaseTransactionProvider().hideIncrementalTransactions()) {
            throw new TransactionTypeUnavailableException();
        }
        return this.createSubtransaction(this.isIncremental());
    }

    @Override
    public UserSession getUserSession() {
        return this.m_UserSession;
    }

    @Override
    public final long getContextNumber() {
        return this.m_ContextNumber;
    }

    @Override
    public boolean isIsolationContext() {
        return false;
    }

    @Override
    public final MetadataContext getOuterContext() {
        if (null != this.getParentTransaction()) {
            return this.getParentTransaction();
        }
        if (null != this.getUserSession().getBranch()) {
            return this.getUserSession().getBranch();
        }
        return PersistentMetadataContext.INSTANCE;
    }

    public boolean isCommitting() {
        boolean bl = false;
        if (this.getStatus() == 3) {
            bl = true;
        }
        return bl;
    }
}

