/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import oracle.security.spnego.ASNBoolean;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNInteger;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.Any;
import oracle.security.spnego.BitString;
import oracle.security.spnego.GeneralString;
import oracle.security.spnego.IType;
import oracle.security.spnego.Null;
import oracle.security.spnego.ObjectIdentifier;
import oracle.security.spnego.OctetString;
import oracle.security.spnego.SPNEGOProperties;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public class DerDecoder
extends ASNReader {
    BufferedInputStream in;

    public DerDecoder() {
    }

    private DerDecoder(byte[] ba) {
        this.in = new BufferedInputStream(new ByteArrayInputStream(ba), 10240);
    }

    private static final boolean eval(int tClass, int xClass, int tValue, int xValue) {
        if (tClass != xClass) {
            return false;
        }
        if (tClass == 192 || tValue == 64) {
            return tValue == xValue;
        }
        if (tValue == xValue) {
            return true;
        }
        if (xValue > 32) {
            xValue -= 32;
        }
        if (xValue == 19 || xValue == 22 || xValue == 20) {
            return tValue == 19 || tValue == 22 || tValue == 20;
        }
        if (xValue == 16 || xValue == 17) {
            return tValue == 16 || tValue == 17;
        }
        return false;
    }

    private static final String toOID(byte[] buffer) {
        StringBuffer sb = new StringBuffer();
        int length = buffer.length;
        int i = 0;
        if (--length >= 0) {
            int b;
            int first = (b = buffer[i++] & 0xFF) < 40 ? 0 : (b < 80 ? 1 : 2);
            int second = b - first * 40;
            sb.append(first).append(".").append(second);
        }
        while (length > 0) {
            int b;
            sb.append(".");
            int sid = 0;
            do {
                b = buffer[i++] & 0xFF;
                sid = sid << 7 | b & 0x7F;
            } while (--length > 0 && (b & 0x80) == 128);
            sb.append(sid);
        }
        String result = sb.toString();
        return result;
    }

    private static final Boolean toBoolean(byte[] buffer) throws ASNException {
        int length = buffer.length;
        if (length != 1) {
            throw new ASNException(2, new String("Decoding BOOLEAN: Length = " + length));
        }
        Boolean result = new Boolean(buffer[0] != 0);
        return result;
    }

    private static final void toNull(byte[] buffer) throws ASNException {
        int length = buffer.length;
        if (length != 0) {
            throw new ASNException(2, new String("Decoding NULL: Length = " + length));
        }
    }

    @Override
    public void open(InputStream is) {
        if (this.in != null) {
            throw new IllegalStateException();
        }
        this.in = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is, 10240);
    }

    @Override
    public IType decodeAny(String name) throws IOException {
        Tag tag = null;
        try {
            tag = this.readTag();
        }
        catch (EOFException x) {
            throw new ASNException(1, "Decoding ANY");
        }
        int length = this.readLength();
        byte[] buffer = new byte[length];
        int actualLength = this.read(buffer);
        if (actualLength == -1) {
            throw new EOFException();
        }
        if (actualLength != length) {
            throw new ASNException(3, new String("Decoding ANY: expected length = " + length + " actual length = " + actualLength));
        }
        Type result = null;
        if (tag.getClazz() == 0) {
            switch (tag.getValue()) {
                case 1: {
                    result = new ASNBoolean(name, tag, DerDecoder.toBoolean(buffer));
                    break;
                }
                case 2: {
                    result = new ASNInteger(name, tag, new BigInteger(1, buffer));
                    break;
                }
                case 3: {
                    result = new BitString(name, tag, buffer);
                    break;
                }
                case 4: {
                    result = new OctetString(name, tag, buffer);
                    break;
                }
                case 5: {
                    DerDecoder.toNull(buffer);
                    result = new Null(name, tag, new Object());
                    break;
                }
                case 6: {
                    result = new ObjectIdentifier(name, tag, DerDecoder.toOID(buffer));
                    break;
                }
                case 27: {
                    result = new GeneralString(name, tag, new String(buffer, "UTF8"));
                    break;
                }
                case 16: 
                case 17: {
                    ArrayList<IType> values = new ArrayList<IType>();
                    DerDecoder local = new DerDecoder(buffer);
                    try {
                        while (true) {
                            IType it = local.decodeAny("seq");
                            values.add(it);
                        }
                    }
                    catch (IOException it) {
                        result = new Any(name, tag, values);
                        break;
                    }
                }
                default: {
                    result = new Any(name, tag, buffer);
                    break;
                }
            }
        } else if (tag.getClazz() == 128) {
            if (tag.isExplicit()) {
                DerDecoder embedded = new DerDecoder(buffer);
                result = new Any(name, tag, embedded.decodeAny("xxx"));
            } else {
                result = new Any(name, tag, buffer);
            }
        } else {
            result = new Any(name, tag, buffer);
        }
        return result;
    }

    @Override
    public String decodeObjectIdentifier(IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding OBJECT IDENTIFIER");
        Tag tag = obj.tag();
        byte[] buffer = this.readRaw(tag, 6);
        String result = DerDecoder.toOID(buffer);
        return result;
    }

    @Override
    public void decodeNull(IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding NULL");
        Tag tag = obj.tag();
        byte[] buffer = this.readRaw(tag, 5);
        DerDecoder.toNull(buffer);
    }

    @Override
    public Boolean decodeBoolean(IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding BOOLEAN");
        Tag tag = obj.tag();
        byte[] buffer = this.readRaw(tag, 1);
        Boolean result = DerDecoder.toBoolean(buffer);
        return result;
    }

    @Override
    public BigInteger decodeInteger(IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding INTEGER");
        Tag tag = obj.tag();
        byte[] buffer = this.readRaw(tag, 2);
        return new BigInteger(1, buffer);
    }

    @Override
    public BigInteger decodeEnumerated(IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding ENUMERATED");
        Tag tag = obj.tag();
        byte[] buffer = this.readRaw(tag, 10);
        return new BigInteger(1, buffer);
    }

    @Override
    public String decodeString(int tagValue, IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding STRING");
        Tag tag = obj.tag();
        byte[] buffer = this.readRaw(tag, tagValue);
        String result = new String(buffer, "UTF8");
        return result;
    }

    @Override
    public byte[] decodeBitString(IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding BIT STRING");
        Tag tag = obj.tag();
        byte[] tmp = this.readRaw(tag, 3);
        byte[] result = new byte[tmp.length - 1];
        System.arraycopy(tmp, 1, result, 0, result.length);
        return result;
    }

    @Override
    public byte[] decodeOctetString(IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding OCTET STRING");
        Tag tag = obj.tag();
        byte[] result = this.readRaw(tag, 4);
        return result;
    }

    @Override
    public ASNReader decodeStructure(IType obj) throws IOException {
        SPNEGOProperties.trace("Decoding SEQUENCE/SET");
        Tag tag = obj.tag();
        byte[] buffer = this.readRaw(tag, 16);
        DerDecoder result = new DerDecoder(buffer);
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result == -1) {
            throw new EOFException();
        }
        return result & 0xFF;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    private byte[] readRaw(Tag tag, int universalValue) throws IOException {
        byte[] result;
        byte[] buffer = this.readBytes(tag);
        if (tag.isExplicit() && !tag.isUniversal()) {
            DerDecoder local = new DerDecoder(buffer);
            result = local.readBytes(new Tag(universalValue));
        } else {
            result = buffer;
        }
        return result;
    }

    private byte[] readBytes(Tag tag) throws IOException {
        int length = this.readTL(tag);
        byte[] result = new byte[length];
        int actualLength = this.read(result);
        if (actualLength == -1) {
            throw new EOFException();
        }
        if (actualLength != length) {
            throw new ASNException(3, new String("DerDecoder readBytes: expected length = " + length + " actual length = " + actualLength));
        }
        return result;
    }

    private int readTL(Tag tag) throws IOException {
        if (!this.isExpectedTag(tag)) {
            throw new ASNException(4, "DerDecoder readTL: " + tag.toString());
        }
        int result = this.readLength();
        return result;
    }

    private boolean isExpectedTag(Tag tag) throws IOException {
        Tag result = this.getExpectedTag(tag.getClazz(), tag.getValue());
        return result != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tag getExpectedTag(int xClass, int xValue) throws IOException {
        int tClass = -1;
        int tValue = -1;
        Tag result = null;
        try {
            int c = this.read();
            tClass = c & 0xC0;
            boolean tConstructed = (c & 0x20) != 0;
            tValue = c & 0x1F;
            if (tValue == 31) {
                tValue = 0;
                do {
                    c = this.read();
                    tValue += c & 0x3F;
                } while ((c & 0x80) != 0);
            }
            result = new Tag(tClass, tValue, true, tConstructed);
        }
        finally {
            if (!DerDecoder.eval(tClass, xClass, tValue, xValue)) {
                result = null;
            }
        }
        return result;
    }

    private Tag readTag() throws IOException {
        Tag result = null;
        int c = this.read();
        int tClass = c & 0xC0;
        boolean tConstructed = (c & 0x20) != 0;
        int tValue = c & 0x1F;
        if (tValue == 31) {
            c = this.read();
            tValue = c & 0x3F;
            while ((c & 0x80) != 0) {
                c = this.read();
                tValue += c & 0x3F;
            }
        }
        result = new Tag(tClass, tValue, true, tConstructed);
        return result;
    }

    private int readLength() throws IOException {
        int result;
        int limit = this.read();
        if ((limit & 0x80) == 0) {
            result = limit;
        } else {
            if ((limit &= 0x7F) > 4) {
                throw new ASNException(5, "DerDecoder readLength");
            }
            result = 0;
            while (limit-- > 0) {
                result = result << 8 | this.read() & 0xFF;
            }
        }
        return result;
    }
}

