/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class JDevDependencyContext
extends DependencyContext {
    private final Context ideContext;
    private static final Logger _LOGGER = Logger.getLogger(DependencyUtils.class.getName());

    public JDevDependencyContext() {
        this.ideContext = null;
    }

    public JDevDependencyContext(Context ideContext) {
        this.ideContext = ideContext;
    }

    public XmlContext getXmlContext(URL url) {
        return this.getXmlContext(url, null, true);
    }

    public XmlContext getXmlContext(URL url, XmlContext pinToContext, boolean checkExists) {
        JDevXmlContext context = null;
        try {
            Node node = NodeFactory.find((URL)url);
            if (node == null && (!checkExists || URLFileSystem.exists((URL)url))) {
                node = NodeFactory.findOrCreate((URL)url);
            }
            if (node != null) {
                Context newIdeContext = null;
                if (this.ideContext == null) {
                    newIdeContext = Context.newIdeContext((Node)node);
                } else {
                    newIdeContext = new Context(this.ideContext);
                    newIdeContext.setNode(node);
                }
                context = JDevXmlContext.getXmlContext(newIdeContext);
                if (context != null && pinToContext != null && pinToContext instanceof JDevXmlContext) {
                    ((JDevXmlContext)pinToContext).softlyPinRelatedJDevXmlContext(context);
                }
            }
        }
        catch (Exception e) {
            _LOGGER.log(Level.WARNING, "Error creating xmlContext for " + url.toString(), e);
        }
        return context;
    }

    public void gotoDeclRef(XmlContext context, final org.w3c.dom.Node node) {
        if (context instanceof JDevXmlContext) {
            JDevXmlContext xmlContext = (JDevXmlContext)context;
            XmlModel model = xmlContext.getSourceModel();
            XmlGui activeGui = xmlContext.getActiveGui();
            if (activeGui != null) {
                xmlContext.releaseActiveGui(activeGui);
            }
            boolean ok = new NonDomMutationTransactionTask(){

                protected void performTask(AbstractModel model) {
                    org.w3c.dom.Node select;
                    if (node == null) {
                        this.cancelTask();
                    }
                    if (DomUtils.isAttribute((org.w3c.dom.Node)(select = node))) {
                        select = ((Attr)select).getOwnerElement();
                    }
                    model.getSelection().set(select);
                }
            }.run((AbstractModel)model);
            if (activeGui != null) {
                xmlContext.acquireActiveGui(activeGui);
            }
            EditorManager.getEditorManager().openDefaultEditorInFrame(xmlContext.createContext());
        }
    }

    public void gotoDeclRef(URL url) {
        XmlContext context = this.getXmlContext(url);
        if (context != null) {
            Document node = context.getModel().getDocument();
            this.gotoDeclRef(context, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayText(XmlContext context, org.w3c.dom.Node node) {
        String text = "";
        if (context instanceof JDevXmlContext) {
            JDevXmlContext xmlContext = (JDevXmlContext)context;
            XmlModel model = xmlContext.getSourceModel();
            model.acquireReadLock();
            try {
                int[] offsets = new int[2];
                org.w3c.dom.Node parent = null;
                if (node.getNodeType() == 2) {
                    Attr attr = (Attr)node;
                    parent = attr.getOwnerElement();
                } else {
                    parent = node.getParentNode();
                }
                if (parent != null) {
                    node = parent;
                }
                model.getDomModel().getTextOffsets(node, offsets);
                text = offsets[0] < 0 || offsets[1] < 0 ? "" : xmlContext.getIdeDocument().acquireTextBuffer().getString(offsets[0], offsets[1] - offsets[0]);
            }
            finally {
                model.releaseReadLock();
            }
        }
        return text;
    }
}

