/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.jdev.explorer.ExplorerShowRootAction;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerGui;
import oracle.bali.xml.gui.jdev.explorer.JDevXmlTree;
import oracle.bali.xml.gui.jdev.util.AbstractSwingWorkerWrapper;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import org.w3c.dom.Node;

public class JDevExplorerComponent
extends JPanel {
    private SearchField _searchField;
    private JComponent _findComponent;
    private IdeAction localShowRootAction = null;
    private Toolbar _showRootToolbar;
    private JDevExplorerGui _xmlGui;

    public JDevExplorerComponent() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel tempPanel = new JPanel(new BorderLayout());
        tempPanel.setOpaque(false);
        this._findComponent = this.createFindComponent();
        this._findComponent.setVisible(false);
        tempPanel.add((Component)this._findComponent, "North");
        this._showRootToolbar = new Toolbar();
        this._showRootToolbar.setVisible(false);
        tempPanel.add((Component)this._showRootToolbar, "South");
        this.add((Component)tempPanel, "North");
    }

    public void setXmlGui(JDevExplorerGui xmlGui) {
        this._xmlGui = xmlGui;
    }

    public void addScrollPane(JScrollPane scrollPane) {
        this.add((Component)scrollPane, "Center");
    }

    public void setVisibleShowRootButton(boolean visible) {
        if (this.localShowRootAction == null && this._xmlGui != null) {
            IdeAction ideAction = ExplorerShowRootAction.IDEACTION;
            ideAction.setEnabled(true);
            ideAction.putValue("SmallIcon", (Object)ExplorerShowRootAction.ICON);
            this.localShowRootAction = ExplorerShowRootAction.IDEACTION.newLocalAction(this._xmlGui.getOwningJDevView());
            this._showRootToolbar.add((ToggleAction)this.localShowRootAction);
            ideAction.putValue("SmallIcon", (Object)IdeIcons.getIcon((int)23));
        }
        this._showRootToolbar.setVisible(visible);
    }

    public JComponent getFindComponent() {
        return this._findComponent;
    }

    public SearchField getSearchField() {
        return this._searchField;
    }

    protected JComponent createFindComponent() {
        Box findPane = new Box(2);
        SearchField searchField = this.searchField();
        findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        findPane.add((Component)searchField);
        Dimension preferredSize = findPane.getPreferredSize();
        searchField.setMaximumSize(new Dimension(250, preferredSize.height));
        return findPane;
    }

    private SearchField searchField() {
        SearchField searchField;
        this._searchField = searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FIND);
        searchField.setAutoFind(true);
        searchField.setPrompt("");
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent e) {
                final String searchText = e.getSearchText();
                final boolean searchForward = e.getDirection() == SearchEvent.Direction.FORWARD;
                final ArrayList results = new ArrayList();
                new AbstractSwingWorkerWrapper<String, TreePath>(JDevExplorerGui.getTranslatedResource("EXPLORER.FIND_TEXT"), JDevExplorerComponent.this._xmlGui.getOwningJDevView().getGUI()){

                    @Override
                    protected String runDoInBackground() {
                        new NonDomMutationTransactionTask(){

                            protected void performTask(AbstractModel model) {
                                boolean foundNode;
                                XmlTreeModel xmlTreeModel = (XmlTreeModel)JDevExplorerComponent.this._xmlGui.getJTree().getModel();
                                Node currRootNode = xmlTreeModel.getRootDomNode(0);
                                Node startNode = model.getSelection().getFirstSelectedNode();
                                if (startNode == null) {
                                    startNode = currRootNode;
                                }
                                if (foundNode = ((JDevXmlTree)((Object)JDevExplorerComponent.this._xmlGui.getJTree())).selectNodeContainingString(searchText, searchForward, startNode, JDevExplorerComponent.this._xmlGui)) {
                                    results.add(true);
                                }
                                if (!foundNode) {
                                    Node newStartNode = null;
                                    if (searchForward) {
                                        if (startNode != currRootNode) {
                                            newStartNode = currRootNode;
                                        }
                                    } else {
                                        Node lastNode = ((JDevXmlTree)((Object)JDevExplorerComponent.this._xmlGui.getJTree())).findLastNode();
                                        if (lastNode != null && startNode != lastNode) {
                                            newStartNode = lastNode;
                                        }
                                    }
                                    if (newStartNode != null && (foundNode = ((JDevXmlTree)((Object)JDevExplorerComponent.this._xmlGui.getJTree())).selectNodeContainingString(searchText, searchForward, newStartNode, JDevExplorerComponent.this._xmlGui))) {
                                        results.add(true);
                                    }
                                }
                            }
                        }.run((AbstractModel)JDevExplorerComponent.this._xmlGui.getView());
                        return "done";
                    }

                    @Override
                    protected void runDone() {
                        if (results.size() == 0 && searchText.length() > 0) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }.execute();
            }

            public void searchCategoryChanged(SearchEvent e) {
            }
        });
        return searchField;
    }
}

