/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteGroup;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;

class XmlPalettePage
extends PalettePage {
    private final JDevPaletteGui _gui;
    private final CategoryDefinition _categoryDefinitionPalettePage;
    private final Map<CategoryDefinition, XmlPaletteGroup> _groups = new TreeMap<CategoryDefinition, XmlPaletteGroup>((Comparator<CategoryDefinition>)new CategoryDefinition.CategoryDefinitionComparator());
    private final Collection<PaletteGroup> _groupsCollection = Collections.unmodifiableCollection(this._groups.values());

    XmlPalettePage(JDevPaletteGui gui, CategoryDefinition categoryDefinitionPalettePage) {
        this._gui = gui;
        this._categoryDefinitionPalettePage = categoryDefinitionPalettePage;
    }

    public Collection<PaletteGroup> getGroups() {
        return this._groupsCollection;
    }

    public String getName() {
        return this._categoryDefinitionPalettePage.getDisplayName();
    }

    public float getPreferredPageRank() {
        return this._categoryDefinitionPalettePage.getPreferredPageRank();
    }

    public String getDescription() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public Object getData(Object key) {
        return null;
    }

    XmlPaletteItem __addItem(XmlCreatable creatable, CategoryDefinition categoryDefinitionPaletteGroup, CategoryDefinition categoryDefinitionPaletteSection) {
        XmlPaletteGroup group = this._groups.get(categoryDefinitionPaletteGroup);
        if (group == null) {
            group = new XmlPaletteGroup(categoryDefinitionPaletteGroup);
            this._groups.put(categoryDefinitionPaletteGroup, group);
        }
        return group.__addItem(this._gui, creatable, categoryDefinitionPaletteSection);
    }

    void __clearItems() {
        Iterator<XmlPaletteGroup> itor = this._groups.values().iterator();
        while (itor.hasNext()) {
            itor.next().__clearItems();
        }
    }

    void __dispose() {
        Iterator<XmlPaletteGroup> itor = this._groups.values().iterator();
        while (itor.hasNext()) {
            itor.next().__dispose();
        }
    }

    void __trimEmptyContainers() {
        Iterator<XmlPaletteGroup> itor = this._groups.values().iterator();
        while (itor.hasNext()) {
            XmlPaletteGroup group = itor.next();
            group.__trimEmptyContainers();
            if (!group.getSections().isEmpty()) continue;
            itor.remove();
        }
    }

    public String toString() {
        return "{" + this._categoryDefinitionPalettePage.getDisplayName() + "; " + this._groups + "}";
    }

    PaletteItem __findItem(String identifier) {
        for (XmlPaletteGroup group : this._groups.values()) {
            PaletteItem item = group.__findItem(identifier);
            if (item == null) continue;
            return item;
        }
        return null;
    }
}

