/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlHeader;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlHeaderOption;
import oracle.ide.controls.FlatEditorTransparentPanel;

public abstract class AbstractXmlHeader
implements XmlHeader {
    private JPanel _panel;
    private Container _headerContainer;
    private Map<Container, ContainerChildList> _containerChildListMap = new HashMap<Container, ContainerChildList>();

    public AbstractXmlHeader(JPanel panel) {
        this._panel = panel;
    }

    @Override
    public Container getHeaderContainer() {
        return this._headerContainer;
    }

    @Override
    public void setHeaderContainer(JComponent headerContainer) {
        this._headerContainer = headerContainer;
    }

    @Override
    public void add(Object childObject) {
        ContainerChildList containerChildList = this._containerChildListMap.get(this.getHeaderContainer());
        if (containerChildList == null) {
            containerChildList = new ContainerChildList(this.getHeaderContainer(), this._containerChildListMap.size(), new ArrayList<Object>());
            this._containerChildListMap.put(this.getHeaderContainer(), containerChildList);
        }
        containerChildList.add(childObject);
    }

    @Override
    public abstract XmlHeader addHeader(Container var1, XmlHeaderOption var2);

    @Override
    public Container createHeaderContainer(XmlHeaderOption headerOption) {
        FlatEditorTransparentPanel innerPanel = new FlatEditorTransparentPanel();
        innerPanel.setLayout(this.createHeaderLayout(headerOption));
        return innerPanel;
    }

    @Override
    public Object createHeaderConstraint(XmlHeaderOption headerOption) {
        return headerOption.getHeaderConstraint().spanX().growX().pushX().wrap().minWidth("1px");
    }

    @Override
    public LayoutManager createHeaderLayout(XmlHeaderOption headerOption) {
        return headerOption.createHeaderLayout(this);
    }

    @Override
    public List<Object> getChildList() {
        ContainerChildList containerChildList = this._containerChildListMap.get(this.getHeaderContainer());
        if (containerChildList == null) {
            return Collections.emptyList();
        }
        return containerChildList.getList();
    }

    public Map<Container, ContainerChildList> getContainerChildListMap() {
        return this._containerChildListMap;
    }

    @Override
    public boolean handleSelectionChanged(Object selectedObject) {
        boolean selectionHandled = false;
        for (Map.Entry<Container, ContainerChildList> entries : this._containerChildListMap.entrySet()) {
            Container containerkey = entries.getKey();
            ContainerChildList containerChildList = entries.getValue();
            List<Object> childList = containerChildList.getList();
            for (Object child : childList) {
                if (child instanceof XmlComponentWrapper) {
                    XmlComponentWrapper xmlComponentWrapper = (XmlComponentWrapper)child;
                    if (!xmlComponentWrapper.handleSelectionChanged(selectedObject)) continue;
                    this.selectObject(entries.getValue().getContainerIdx());
                    this._scrollToComponent((JComponent)xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent());
                    selectionHandled = true;
                    continue;
                }
                if (!(child instanceof XmlHeader) || !((XmlHeader)child).handleSelectionChanged(selectedObject)) continue;
                this.selectObject(entries.getValue().getContainerIdx());
                selectionHandled = true;
            }
        }
        return selectionHandled;
    }

    @Override
    public abstract void selectObject(int var1);

    private void _scrollToComponent(JComponent c) {
        if (c == null) {
            return;
        }
        Rectangle compBounds = c.getBounds();
        Rectangle visibleRect = this._panel.getVisibleRect();
        Rectangle newCompBounds = SwingUtilities.convertRectangle(c, compBounds, this._panel);
        if (newCompBounds.y < visibleRect.y || newCompBounds.y + newCompBounds.height > visibleRect.y + visibleRect.height) {
            newCompBounds.x = 0;
            newCompBounds.height = visibleRect.height;
            Rectangle r = newCompBounds;
            this._scrollToRect(r);
        }
    }

    private void _scrollToRect(final Rectangle r) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JPanel)AbstractXmlHeader.this._headerContainer).scrollRectToVisible(r);
            }
        });
    }

    public class ContainerChildList {
        private Container _container;
        private int _containerIdx;
        private List<Object> _list;

        public ContainerChildList(Container container, int containerIdx, List<Object> list) {
            this._container = container;
            this._containerIdx = containerIdx;
            this._list = list;
        }

        public Container getContainer() {
            return this._container;
        }

        public int getContainerIdx() {
            return this._containerIdx;
        }

        public void add(Object object) {
            this.getList().add(object);
        }

        public List<Object> getList() {
            return this._list;
        }
    }
}

