/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.xml;

import java.net.URL;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ImmutableList;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.xml.XmlModelAdapter;
import org.w3c.dom.Document;

public class XmlModelType
extends ModelType {
    private final ImmutableList<Class<? extends ModelAdapter>> modelAdapterTypes = new ImmutableList(XmlModelAdapter.class);
    private final ImmutableList<Class<? extends Element>> rootElementTypes = new ImmutableList(XMLSourceNode.class);
    private final ImmutableList<Class<? extends Element>> containedElementTypes = new ImmutableList(XmlSelectionElement.class);
    private final ImmutableList<Class<?>> presentationTypes = new ImmutableList((Object[])new Class[]{Document.class, org.w3c.dom.Element.class});
    private static Icon ELEMENT_ICON;

    public Collection<Class<? extends ModelAdapter>> getModelAdapterTypes() {
        return this.modelAdapterTypes;
    }

    public Collection<Class<? extends Element>> getRootElementTypes() {
        return this.rootElementTypes;
    }

    public Collection<Class<? extends Element>> getContainedElementTypes() {
        return this.containedElementTypes;
    }

    public Collection<Class<?>> getPresentationTypes() {
        return this.presentationTypes;
    }

    public boolean isAuditable(Element element, ContentDirectory directory, Project project, Workspace workspace) {
        return directory != null && workspace != null;
    }

    public ModelAdapter createModelAdapter(ModelFactory factory, Element element, URL url, ContainerModelAdapter directory, ContainerModelAdapter project, ContainerModelAdapter workspace) {
        return new XmlModelAdapter(factory, this, workspace, project, directory, (XMLSourceNode)element, url);
    }

    public String label(Class type) {
        String name = type.getName();
        String label = name.substring(name.lastIndexOf(46) + 1);
        if ("Attr".equals(label)) {
            return "Attribute";
        }
        return label;
    }

    public String summary(Class type) {
        return "XML " + this.label(type) + " construct";
    }

    public Icon icon(Class type) {
        if (type == Document.class) {
            return OracleIcons.getIcon((String)"xmlfile.png");
        }
        if (type == org.w3c.dom.Element.class) {
            if (ELEMENT_ICON == null) {
                URL url = XMLSourceNode.class.getResource("icons/node.gif");
                ELEMENT_ICON = new ImageIcon(url);
            }
            return ELEMENT_ICON;
        }
        return null;
    }
}

