/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.ar.ap;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDoubleMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetMaxLiftQuery
extends SqlBaseModelQuery<Double, OraclePreparedStatement> {
    private ISqlQuery<OraclePreparedStatement> queryGenerator;

    public GetMaxLiftQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlDoubleMapper(), modelDescriptor);
        this.queryGenerator = DbVersionHelper.isDB122Up(version) ? new DB122Query() : new DBOriginalQuery();
    }

    @Override
    public String getSQLCommand() {
        String string = this.queryGenerator.getSQLCommand();
        return string;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class DB122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private DB122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select(" MAX(RULE_LIFT)").from(GetMaxLiftQuery.this.getViewName("DM$VR")).where(Conditional.equals("PARTITION_NAME", GetMaxLiftQuery.this.getPartitionId()));
            String string = sqlBuilder.toString();
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetMaxLiftQuery.this.getPartitionId());
        }
    }

    private class DBOriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private DBOriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = "SELECT t.rule_lift as MAX_LIFT_VALUE \nFROM TABLE( \n  dbms_data_mining.get_association_rules(:model, 1, NULL, NULL, NULL, NULL, NULL,   ORA_MINING_VARCHAR2_NT('RULE_LIFT DESC'), NULL, NULL, NULL)) t";
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetMaxLiftQuery.this.getQualifiedName());
        }
    }
}

