/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.cf;

import java.sql.SQLException;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.cf.GetAttributeImportanceMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.cf.Statistics;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetAttributeImportanceQuery
extends SqlQuery<Statistics, OraclePreparedStatement> {
    private String attrImportanceTable;
    private AttributeType attribute;

    public GetAttributeImportanceQuery(Version version, String string, AttributeType attributeType, Map<String, String> map) {
        super(version, new GetAttributeImportanceMapper(map));
        this.attrImportanceTable = string;
        this.attribute = attributeType;
    }

    @Override
    protected String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select("ATTRIBUTE_NAME", "IMPORTANCE_VALUE", "RANK").from(this.attrImportanceTable).where(Conditional.notEquals("ATTRIBUTE_NAME", this.attribute)).orderBy("RANK");
        return sqlBuilder.toString();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (this.attribute != null) {
            SqlUtils.setStringAtName(oraclePreparedStatement, "ATTRIBUTE_NAME", this.attribute.getName());
        }
    }
}

