/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class NBProbabilitiesQuery
extends ModelDetailsQuery {
    private static final String TARGET_ATTRIBUTE_NAME = "TARGET_ATTRIBUTE_NAME";
    private static final String TARGET_ATTRIBUTE_STR_VALUE = "TARGET_ATTRIBUTE_STR_VALUE";
    private static final String TARGET_ATTRIBUTE_NUM_VALUE = "TARGET_ATTRIBUTE_NUM_VALUE";
    private static final String PRIOR_PROBABILITY = "PRIOR_PROBABILITY";
    private static final String CONDITIONAL_PROBABILITY = "CONDITIONAL_PROBABILITY";

    public NBProbabilitiesQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public NBProbabilitiesQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {TARGET_ATTRIBUTE_NAME, "VARCHAR2"}, {"TARGET_ATTRIBUTE_VALUE", "VARCHAR2"}, {PRIOR_PROBABILITY, "NUMBER"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {CONDITIONAL_PROBABILITY, "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {TARGET_ATTRIBUTE_NAME, "VARCHAR2"}, {TARGET_ATTRIBUTE_STR_VALUE, "VARCHAR2"}, {TARGET_ATTRIBUTE_NUM_VALUE, "NUMBER"}, {PRIOR_PROBABILITY, "NUMBER"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_STR_VALUE", "VARCHAR2"}, {"ATTRIBUTE_NUM_VALUE", "NUMBER"}, {CONDITIONAL_PROBABILITY, "NUMBER"}};
    }

    @Override
    public String getSQLTemplate() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "\nSELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\nCAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\nVV.PARTITION_NAME as \"{$PARTITION_NAME}\",\nVV.TARGET_NAME as \"{$TARGET_ATTRIBUTE_NAME}\",\nVV.TARGET_VALUE as \"{$TARGET_ATTRIBUTE_VALUE}\",\nVP.PRIOR_PROBABILITY as \"{$PRIOR_PROBABILITY}\",\nVV.ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\",\nVV.ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\nVV.ATTRIBUTE_VALUE as \"{$ATTRIBUTE_VALUE}\",\nVV.CONDITIONAL_PROBABILITY as \"{$CONDITIONAL_PROBABILITY}\" \nFROM {$MODEL_SCHEMA_VALUE}.DM$VV{$MODEL_NAME_VALUE} VV INNER JOIN {$MODEL_SCHEMA_VALUE}.DM$VP{$MODEL_NAME_VALUE} VP \nON NVL(VV.PARTITION_NAME, 0) = NVL(VP.PARTITION_NAME, 0) \nAND VV.TARGET_NAME = VP.TARGET_NAME \nAND VV.TARGET_VALUE = VP.TARGET_VALUE";
        }
        return "\n   SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n   CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",  \n   T.TARGET_ATTRIBUTE_NAME as \"{$TARGET_ATTRIBUTE_NAME}\",\n   T.TARGET_ATTRIBUTE_STR_VALUE as \"{$TARGET_ATTRIBUTE_STR_VALUE}\",\n   T.TARGET_ATTRIBUTE_NUM_VALUE as \"{$TARGET_ATTRIBUTE_NUM_VALUE}\",\n   T.PRIOR_PROBABILITY as \"{$PRIOR_PROBABILITY}\",\n   C.ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\",\n   C.ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\n   C.ATTRIBUTE_STR_VALUE as \"{$ATTRIBUTE_STR_VALUE}\",\n   C.ATTRIBUTE_NUM_VALUE as \"{$ATTRIBUTE_NUM_VALUE}\",\n   C.CONDITIONAL_PROBABILITY as \"{$CONDITIONAL_PROBABILITY}\" \nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB('{$GET_MODEL_NAME}')) T,\nTABLE(T.conditionals) C";
    }
}

