/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import oracle.dbtools.migration.parser.analysis.action.TSQLAnalysisAction;
import oracle.dbtools.migration.parser.defaults.DefaultTranslationContext;
import oracle.dbtools.migration.parser.defaults.DefaultVariabletNameTranslator;
import oracle.dbtools.migration.parser.helper.AliasHelper;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.parser.helper.CursorHelper;
import oracle.dbtools.migration.parser.helper.DatatypeDefaultValue;
import oracle.dbtools.migration.parser.helper.DateHelper;
import oracle.dbtools.migration.parser.helper.DependencyManager;
import oracle.dbtools.migration.parser.helper.ExpressionHelper;
import oracle.dbtools.migration.parser.helper.FunctionHelper;
import oracle.dbtools.migration.parser.helper.StatementHelper;
import oracle.dbtools.migration.parser.helper.TableHelper;
import oracle.dbtools.migration.parser.helper.TemplateManager;
import oracle.dbtools.migration.parser.helper.TransactionHelper;
import oracle.dbtools.migration.parser.helper.TranslationLimitationManager;
import oracle.dbtools.migration.parser.helper.TranslationMetaData;
import oracle.dbtools.migration.parser.helper.TriggerHelper;
import oracle.dbtools.migration.parser.plugin.IVariableNameTranslator;
import oracle.dbtools.migration.translation.api.IHierarchicalTranslationNameScope;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.ITranslationMetaData;
import oracle.dbtools.migration.translation.api.TranslationSession;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.translation.api.prefs.ConfigurationOptions;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.translation.util.ASTUtil;

public class TranslationHelper
implements ITranslationMetaData {
    private TranslationDBObject m_sourceDBObject = null;
    private TranslationDBObjectReference m_targetDBObjectRef = null;
    private ITranslationContext m_translationContext = null;
    private ITranslationManager m_translationManager = null;
    private static ITranslationLogging m_logging = null;
    private TranslationSession m_session = null;
    private DependencyManager m_dependencyManager = null;
    private AliasHelper m_aliasHelper = null;
    private TranslationMetaData m_translationMetaData = null;
    private CodeBlockManager m_codeBlockManager = null;
    private TemplateManager m_templateManager = null;
    private ArrayList<String> m_sourceLines = null;
    private ASTUtil m_astUtil = null;
    private IVariableNameTranslator m_variableNameTranslator = null;
    private final HashMap<String, TranslationParameter> m_inParams = new HashMap();
    private TranslationLimitationManager m_limitationManager = null;
    private final ArrayList<TranslationParameter> m_varsToDeclare = new ArrayList();
    private boolean m_createOrReplace = true;
    private DateHelper m_dateHelper = null;
    private TranslationObjectType m_lastReferenceObjectType = null;
    private StatementHelper m_sqlStatementHelper = null;
    private FunctionHelper m_functionHelper = null;
    private TriggerHelper m_triggerHelper = null;
    private TransactionHelper m_transactionHelper = null;
    private ExpressionHelper m_expressionHelper = null;
    private CursorHelper m_cursorHelper = null;
    private TableHelper m_tableHelper = null;
    private ArrayList<String> m_errors = new ArrayList();
    private Stack<IHierarchicalTranslationNameScope> _translationObjNameScope;

    public TranslationObjectType getLastReferenceObjectType() {
        return this.m_lastReferenceObjectType;
    }

    public void setLastReferenceObjectType(TranslationObjectType translationObjectType) {
        this.m_lastReferenceObjectType = translationObjectType;
    }

    public TranslationHelper() {
    }

    public void defaultInit() {
        this.m_translationMetaData = new TranslationMetaData(this);
        this.m_codeBlockManager = new CodeBlockManager();
        this.m_templateManager = new TemplateManager(this);
        this.m_astUtil = new ASTUtil();
        this.m_translationContext = new DefaultTranslationContext();
        this.m_translationManager = null;
        this.m_variableNameTranslator = new DefaultVariabletNameTranslator();
        this.m_dependencyManager = new DependencyManager(this);
        this.m_sourceLines = new ArrayList();
        this.m_limitationManager = new TranslationLimitationManager(this);
        this.m_aliasHelper = new AliasHelper();
        this.m_dateHelper = new DateHelper(this);
        this.m_triggerHelper = new TriggerHelper(this.m_codeBlockManager, this);
        this.m_functionHelper = new FunctionHelper(this.m_codeBlockManager);
        this.m_transactionHelper = new TransactionHelper(this.m_codeBlockManager, this.m_translationMetaData);
        this.m_expressionHelper = new ExpressionHelper(this.m_codeBlockManager);
        this.m_tableHelper = new TableHelper(this.m_codeBlockManager, this.m_translationContext, this);
        this.m_sqlStatementHelper = new StatementHelper(this.m_codeBlockManager, this.m_translationContext, this.m_tableHelper);
        this.m_cursorHelper = new CursorHelper(this.m_codeBlockManager, this.m_translationMetaData);
    }

    public TranslationHelper(TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging, ITranslationManager iTranslationManager, TranslationSession translationSession) {
        this();
        try {
            this.setTargetDBObjectReference(iTranslationContext.getTargetDBObjectReference(translationDBObject.getDBObjectReference(), translationDBObject.getOMWBObj()));
        }
        catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
            this.setTargetDBObjectReference(translationDBObject.getDBObjectReference());
        }
        this.m_translationContext = iTranslationContext != null ? iTranslationContext : new DefaultTranslationContext();
        this.m_translationManager = iTranslationManager != null ? iTranslationManager : null;
        m_logging = iTranslationLogging;
        this.m_sourceDBObject = translationDBObject;
        this.m_session = translationSession;
        this.m_translationMetaData = new TranslationMetaData(this);
        this.m_codeBlockManager = new CodeBlockManager();
        this.m_templateManager = new TemplateManager(this);
        this.m_astUtil = new ASTUtil();
        this.m_variableNameTranslator = new DefaultVariabletNameTranslator();
        this.m_dependencyManager = new DependencyManager(this);
        this.m_sourceLines = new ArrayList();
        this.m_limitationManager = new TranslationLimitationManager(this);
        this.m_aliasHelper = new AliasHelper();
        this.m_dateHelper = new DateHelper(this);
        this.m_dependencyManager = new DependencyManager(this);
        this.m_triggerHelper = new TriggerHelper(this.m_codeBlockManager, this);
        this.m_functionHelper = new FunctionHelper(this.m_codeBlockManager);
        this.m_transactionHelper = new TransactionHelper(this.m_codeBlockManager, this.m_translationMetaData);
        this.m_expressionHelper = new ExpressionHelper(this.m_codeBlockManager);
        this.m_tableHelper = new TableHelper(this.m_codeBlockManager, this.m_translationContext, this);
        this.m_sqlStatementHelper = new StatementHelper(this.m_codeBlockManager, this.m_translationContext, this.m_tableHelper);
        this.m_cursorHelper = new CursorHelper(this.m_codeBlockManager, this.m_translationMetaData);
    }

    public IVariableNameTranslator getVariableNameTranslator() {
        return this.m_variableNameTranslator;
    }

    public void setVariableNameTranslator(IVariableNameTranslator iVariableNameTranslator) {
        this.m_variableNameTranslator = iVariableNameTranslator;
    }

    public void setInputParam(String string, TranslationParameter translationParameter) {
        this.m_inParams.put(string.toLowerCase(), translationParameter);
    }

    public boolean isInputParam(String string) {
        return this.m_inParams.containsKey(string.toLowerCase());
    }

    public void setInputAssignVar(String string) {
        TranslationParameter translationParameter = this.m_inParams.get(string.toLowerCase());
        if (translationParameter != null && !this.m_varsToDeclare.contains(translationParameter)) {
            this.m_varsToDeclare.add(translationParameter);
            String string2 = this.getVariableNameTranslator().translateVariableName(string);
            String string3 = this.getVariableNameTranslator().translateInParamName(string);
            this.getTranslationMetaData().renameParameter(string2, string3);
        }
    }

    public ArrayList<TranslationParameter> getDeclareVars() {
        return this.m_varsToDeclare;
    }

    public CodeBlockManager getCodeBlockManager() {
        return this.m_codeBlockManager;
    }

    public void setCodeBlockManager(CodeBlockManager codeBlockManager) {
        this.m_codeBlockManager = codeBlockManager;
    }

    public static ITranslationLogging getLogging() {
        return m_logging;
    }

    public void setLogging(ITranslationLogging iTranslationLogging) {
        m_logging = iTranslationLogging;
    }

    public TranslationDBObject getSourceDBObject() {
        return this.m_sourceDBObject;
    }

    public void setSourceDBObject(TranslationDBObject translationDBObject) {
        this.m_sourceDBObject = translationDBObject;
    }

    public TemplateManager getTemplateManager() {
        return this.m_templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.m_templateManager = templateManager;
    }

    public ITranslationContext getTranslationContext() {
        return this.m_translationContext;
    }

    public void setTranslationContext(ITranslationContext iTranslationContext) {
        if (iTranslationContext != null) {
            this.m_translationContext = iTranslationContext;
            this.m_dependencyManager = new DependencyManager(this);
        }
    }

    public TranslationMetaData getTranslationMetaData() {
        return this.m_translationMetaData;
    }

    public void setTranslationMetaData(TranslationMetaData translationMetaData) {
        this.m_translationMetaData = translationMetaData;
    }

    public ASTUtil getASTUtil() {
        return this.m_astUtil;
    }

    public void setASTUtil(ASTUtil aSTUtil) {
        this.m_astUtil = aSTUtil;
    }

    public TranslationSession getSession() {
        return this.m_session;
    }

    public void setSession(TranslationSession translationSession) {
        this.m_session = translationSession;
    }

    public DependencyManager getDependencyManager() {
        return this.m_dependencyManager;
    }

    public void setDependencyManager(DependencyManager dependencyManager) {
        this.m_dependencyManager = dependencyManager;
    }

    public void setSourceText(String string) {
        if (string == null) {
            return;
        }
        String string2 = string;
        while (string2.length() > 0) {
            int n = string2.indexOf(10);
            String string3 = n > 0 ? string2.substring(0, n) : string2;
            this.m_sourceLines.add(string3);
            string2 = n != -1 ? string2.substring(n + 1) : "";
        }
    }

    public String getSourceTextAtPosition(int n, int n2, int n3, int n4) {
        return this.getSourceTextAtPosition(n, n2, n3, n4, null);
    }

    public String getSourceTextAtPosition(int n, int n2, int n3, int n4, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_sourceLines.size() < n3) {
            n3 = this.m_sourceLines.size() - 1;
        }
        for (int i = n; i <= n3; ++i) {
            String string2 = this.m_sourceLines.get(i);
            if (i == n && string2 != null && string2.length() > n2) {
                string2 = string2.substring(n2 - 1);
                if (i == n3) {
                    n4 -= n2;
                }
            }
            if (i == n3 && string2 != null && string2.length() > n4 && n4 > 0) {
                string2 = string2.substring(0, n4);
            }
            stringBuffer.append(string2);
        }
        String string3 = stringBuffer.toString();
        if ((string3 = string3.trim()).endsWith(";")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    public boolean isCreateOrReplace() {
        return this.m_createOrReplace;
    }

    public void setCreateOrReplace(boolean bl) {
        this.m_createOrReplace = bl;
    }

    @Override
    public ArrayList<TranslationDBObject> getSourceDependencies() {
        return this.getTranslationMetaData().getSourceDependencies();
    }

    @Override
    public ArrayList<TranslationParameter> getSourceParameters() {
        return this.getTranslationMetaData().getSourceParameters();
    }

    @Override
    public ArrayList<TranslationDBObject> getTargetDependencies() {
        return this.getTranslationMetaData().getTargetDependencies();
    }

    @Override
    public ArrayList<TranslationParameter> getTargetParameters() {
        return this.getTranslationMetaData().getTargetParameters();
    }

    public TranslationDBObjectReference getTargetDBObjectReference() {
        return this.m_targetDBObjectRef;
    }

    public void setTargetDBObjectReference(TranslationDBObjectReference translationDBObjectReference) {
        this.m_targetDBObjectRef = translationDBObjectReference;
    }

    public String getDateFormat() {
        return ConfigurationOptions.getDateFormat();
    }

    public DateHelper getDateHelper() {
        return this.m_dateHelper;
    }

    public void setDateHelper(DateHelper dateHelper) {
        this.m_dateHelper = dateHelper;
    }

    public ITranslationContext getDefaultTranslationContext() {
        return new DefaultTranslationContext();
    }

    public boolean isOwner(AST aST) {
        if (aST == null || this.getTargetDBObjectReference() == null) {
            return true;
        }
        this.getASTUtil();
        String string = ASTUtil.toString(aST);
        return this.getTargetDBObjectReference().getOwnerName().equalsIgnoreCase(string);
    }

    public boolean isStringLiteral(String string) {
        return string.startsWith("'") && string.endsWith("'");
    }

    public TranslationDBObjectReference getTargetDBObjectRef() {
        return this.m_targetDBObjectRef;
    }

    public void setTargetDBObjectRef(TranslationDBObjectReference translationDBObjectReference) {
        this.m_targetDBObjectRef = translationDBObjectReference;
    }

    public ITranslationManager getTranslationManager() {
        return this.m_translationManager;
    }

    public void setTranslationManager(ITranslationManager iTranslationManager) {
        this.m_translationManager = iTranslationManager;
    }

    public TranslationLimitationManager getLimitationManager() {
        return this.m_limitationManager;
    }

    public void setLimitationManager(TranslationLimitationManager translationLimitationManager) {
        this.m_limitationManager = translationLimitationManager;
    }

    @Override
    public Block getBlockInformation() {
        return this.getCodeBlockManager().getTopBlock();
    }

    public AliasHelper getAliasHelper() {
        return this.m_aliasHelper;
    }

    public String getQueryAssignment() {
        TranslationPreferences translationPreferences = this.getTranslationContext().getTranslationPreferences(null);
        if (translationPreferences == null || translationPreferences.getQueryAssignmentPreference() == null) {
            return "SELECT INTO assignment";
        }
        return translationPreferences.getQueryAssignmentPreference();
    }

    public boolean isQuotedIdentifierOnSQLServer() {
        TranslationPreferences translationPreferences = this.getTranslationContext().getTranslationPreferences(null);
        if (translationPreferences == null) {
            return true;
        }
        return translationPreferences.isQuotedIdentifierOnSQLServer();
    }

    public boolean isQuotedIdentifierOnSybase() {
        TranslationPreferences translationPreferences = this.getTranslationContext().getTranslationPreferences(null);
        if (translationPreferences == null) {
            return false;
        }
        return translationPreferences.isQuotedIdentifierOnSybase();
    }

    public boolean isOracle128ByteIdentifier() {
        TranslationPreferences translationPreferences = this.getTranslationContext().getTranslationPreferences(null);
        if (translationPreferences == null) {
            return false;
        }
        return translationPreferences.isOracle128ByteIdentifier();
    }

    public String getFormatMask() {
        TranslationPreferences translationPreferences = this.getTranslationContext().getTranslationPreferences(null);
        if (translationPreferences == null || translationPreferences.getFormatMask() == null) {
            return "MM/DD/YY";
        }
        return translationPreferences.getFormatMask();
    }

    public StatementHelper getStatementHelper() {
        return this.m_sqlStatementHelper;
    }

    public FunctionHelper getFunctionHelper() {
        return this.m_functionHelper;
    }

    public TriggerHelper getTriggerHelper() {
        return this.m_triggerHelper;
    }

    public TransactionHelper getTransactionHelper() {
        return this.m_transactionHelper;
    }

    public ExpressionHelper getExpressionHelper() {
        return this.m_expressionHelper;
    }

    public CursorHelper getCursorHelper() {
        return this.m_cursorHelper;
    }

    public TableHelper getTableHelper() {
        return this.m_tableHelper;
    }

    public DatatypeDefaultValue getDefaultValueClass() {
        return new DatatypeDefaultValue();
    }

    public void saveInfo(TSQLAnalysisAction tSQLAnalysisAction) {
    }

    public IHierarchicalTranslationNameScope getCurrentObjectNameScope() {
        IHierarchicalTranslationNameScope iHierarchicalTranslationNameScope = null;
        if (this._translationObjNameScope != null && !this._translationObjNameScope.isEmpty()) {
            iHierarchicalTranslationNameScope = this._translationObjNameScope.peek();
        }
        return iHierarchicalTranslationNameScope;
    }

    public void pushObjectNameScope(IHierarchicalTranslationNameScope iHierarchicalTranslationNameScope) {
        if (iHierarchicalTranslationNameScope != null) {
            if (this._translationObjNameScope == null) {
                this._translationObjNameScope = new Stack();
            }
            this._translationObjNameScope.push(iHierarchicalTranslationNameScope);
        }
    }

    public IHierarchicalTranslationNameScope popObjectNameScope() {
        IHierarchicalTranslationNameScope iHierarchicalTranslationNameScope = null;
        if (this._translationObjNameScope != null && !this._translationObjNameScope.isEmpty()) {
            iHierarchicalTranslationNameScope = this._translationObjNameScope.pop();
        }
        return iHierarchicalTranslationNameScope;
    }

    public void addError(String string) {
        this.m_errors.add(string);
    }

    public ArrayList<String> getErrors() {
        return this.m_errors;
    }
}

