/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.listener.ui.ListenerUIUtils;

public class ListenerNumericSpinBoxHandler
implements ChangeListener {
    private NumericSpinBox _numericSpinBox;
    private Color _origBGColor;
    private int _globalValue;
    private Color _globalBGColor;
    private boolean _isGlobalDisplay = false;

    ListenerNumericSpinBoxHandler(NumericSpinBox numericSpinBox, int n) {
        this._numericSpinBox = numericSpinBox;
        this._origBGColor = new Color(this._numericSpinBox.getBackground().getRGB());
        this._globalBGColor = ListenerUIUtils.getHighlightBackgroundColor();
        this._globalValue = n;
        this.updateNumericField(this._numericSpinBox.getIntValue());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateNumericField(this._numericSpinBox.getIntValue());
    }

    public void updateGlobalValue(int n) {
        if (this._globalValue != n) {
            this._globalValue = n;
            this.updateNumericField(this._numericSpinBox.getIntValue());
            this._numericSpinBox.revalidate();
            this._numericSpinBox.repaint();
        }
    }

    private void updateNumericField(int n) {
        if (n == this._globalValue) {
            if (!this._isGlobalDisplay) {
                this._numericSpinBox.setBackground(this._globalBGColor);
                this._isGlobalDisplay = true;
            }
        } else if (this._isGlobalDisplay) {
            this._numericSpinBox.setBackground(this._origBGColor);
            this._isGlobalDisplay = false;
        }
    }
}

