/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.ui.ListenerNameTablePanel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerSecurityProceduresPanel
extends ListenerSettings {
    private ListenerNameTablePanel _tablePanel;
    private JCheckBox _exclude;
    private String _type;

    public ListenerSecurityProceduresPanel(String string) {
        this._type = string;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 275));
        StringBuffer stringBuffer = new StringBuffer();
        if (this._type.equalsIgnoreCase("AllowedProcedures")) {
            stringBuffer.append(ListenerArb.getString("ALLOWED_PROCEDURE_DESCRIP"));
        } else if (this._type.equalsIgnoreCase("BlockedProcedures")) {
            stringBuffer.append(ListenerArb.getString("BLOCKED_PROCEDURE_DESCRIP"));
            this._exclude = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._exclude, (String)ListenerArb.getString("DISABLE_EXCLUSION_LIST"));
        }
        stringBuffer.append("  ").append(ListenerArb.getString("WILDCARD_QUESTIONMARK_INFO"));
        this._tablePanel = new ListenerNameTablePanel(stringBuffer.toString(), null);
        int n = 0;
        this.add((Component)this._tablePanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 23, 1, new Insets(8, 8, 8, 8), 0, 0));
        if (this._type.equalsIgnoreCase("BlockedProcedures")) {
            this.add((Component)this._exclude, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 8), 0, 0));
        }
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 0.3, 0.3, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLastRow(n);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, this._type);
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getSecuritySettings() != null && this._type != null) {
            ListenerSecuritySettings listenerSecuritySettings = listenerModel.getSecuritySettings();
            if (this._type.equalsIgnoreCase("AllowedProcedures")) {
                this._tablePanel.setNames(listenerSecuritySettings.getAllowedProcedures());
                if (this._parentModel != null) {
                    this._tablePanel.setParentNames(this._parentModel.getSecuritySettings().getAllowedProcedures());
                }
            } else if (this._type.equalsIgnoreCase("BlockedProcedures")) {
                this._exclude.setSelected(listenerSecuritySettings.isDisableExclusionList());
                this._tablePanel.setNames(listenerSecuritySettings.getBlockedProcedures());
                if (this._parentModel != null) {
                    this._tablePanel.setParentNames(this._parentModel.getSecuritySettings().getBlockedProcedures());
                }
            }
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getSecuritySettings() != null && this._type != null) {
            if (this._tablePanel.getTable() != null && this._tablePanel.getTable().getCellEditor() != null && this._tablePanel.getTable().isEditing()) {
                this._tablePanel.getTable().getCellEditor().stopCellEditing();
            }
            ListenerSecuritySettings listenerSecuritySettings = this._model.getSecuritySettings();
            if (this._type.equalsIgnoreCase("AllowedProcedures")) {
                listenerSecuritySettings.setAllowedProcedures(this._tablePanel.getNames());
            } else if (this._type.equalsIgnoreCase("BlockedProcedures")) {
                listenerSecuritySettings.setBlockedProcedures(this._tablePanel.getNames());
                listenerSecuritySettings.setDisableExclusionList(this._exclude.isSelected());
            }
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        if (listenerModel != null) {
            ListenerSecuritySettings listenerSecuritySettings = listenerModel.getSecuritySettings();
            if (this._tablePanel.getTable() != null && this._tablePanel.getTable().getCellEditor() != null && this._tablePanel.getTable().isEditing()) {
                this._tablePanel.getTable().getCellEditor().stopCellEditing();
            }
            if (this._type.equalsIgnoreCase("BlockedProcedures")) {
                this._tablePanel.setParentNames(listenerSecuritySettings.getBlockedProcedures());
                this.updateCheckBoxHandler(this._exclude, listenerSecuritySettings.isDisableExclusionList());
            } else if (this._type.equalsIgnoreCase("AllowedProcedures")) {
                this._tablePanel.setParentNames(listenerSecuritySettings.getAllowedProcedures());
            }
        }
    }

    @Override
    public boolean resetSettings() {
        if (this._parentModel != null) {
            this._tablePanel.removeAllRows();
            this.assignSettings(this._parentModel);
            return true;
        }
        return false;
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            List<String> list = null;
            if (this._type.equalsIgnoreCase("AllowedProcedures")) {
                list = this._model.getSecuritySettings().getAllowedProcedures();
            } else if (this._type.equalsIgnoreCase("BlockedProcedures")) {
                list = this._model.getSecuritySettings().getBlockedProcedures();
            }
            String string = ListenerUIUtils.getCommaDelimited(list);
            String string2 = ListenerUIUtils.getCommaDelimited(this._tablePanel.getNames());
            if (!string2.equals(string)) {
                return true;
            }
            if (this._type.equalsIgnoreCase("BlockedProcedures") && this._exclude.isSelected() != this._model.getSecuritySettings().isDisableExclusionList()) {
                return true;
            }
        }
        return false;
    }
}

