/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.listener.ListenerArb;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public abstract class ListenerZipFileHandler<V>
implements HttpClientResponseHandler<V> {
    public final V handleResponse(ClassicHttpResponse classicHttpResponse) throws IOException {
        int n = classicHttpResponse.getCode();
        if (n != 200) {
            throw new IOException((Throwable)new SessionException(classicHttpResponse.getReasonPhrase()));
        }
        Header header = classicHttpResponse.getFirstHeader("Content-Type");
        if (header == null) {
            throw new IOException(ListenerArb.getString("MISSING_CONTENT_TYPE"));
        }
        String string = header.getValue();
        if (!"application/zip".equals(string)) {
            throw new IOException("Unexpected Content-Type: " + string);
        }
        HttpEntity httpEntity = null;
        InputStream inputStream = null;
        try {
            httpEntity = classicHttpResponse.getEntity();
            if (httpEntity == null) {
                throw new IOException("Error obtaining the zip file.  Entity is null");
            }
            inputStream = httpEntity.getContent();
            V v = this.load(inputStream);
            return v;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
    }

    protected abstract V load(InputStream var1) throws IOException;
}

