/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.merge;

import java.net.URL;
import oracle.ide.Context;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.compare.SVNPropertiesCompareContributor;
import oracle.jdevimpl.vcs.svn.merge.ListMergeEditor;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNPropertyMergeEditor
extends ListMergeEditor {
    private CompareModel _buffer;

    protected void initializeMergeContextCS(Context context) throws Exception {
        URL url = this.getRealURL();
        if (SVNUtil.isPropertiesConflicted(url)) {
            try {
                ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.CACHE_ADAPTER_CONTEXT_ID);
                SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.getFirstAssociatedRepository(url));
                SVNUrl svnurl = client.getInfoFromWorkingCopy(SVNUtil.toFile(url)).getUrl();
                SVNPropertiesCompareContributor leftcontributor = new SVNPropertiesCompareContributor(SVNUtil.toFile(url), SVNRevision.WORKING, true);
                SVNPropertiesCompareContributor rightcontributor = new SVNPropertiesCompareContributor(svnurl, SVNRevision.HEAD);
                SVNPropertiesCompareContributor ancestorcontributor = leftcontributor;
                SVNClientInteraction.getInstance().endInteraction();
                MergeContext.setFirstContributor((Context)context, (CompareContributor)leftcontributor);
                MergeContext.setSecondContributor((Context)context, (CompareContributor)rightcontributor);
                MergeContext.setAncestorContributor((Context)context, (CompareContributor)ancestorcontributor);
                MergeContext.setMergeEngine((Context)context, (MergeEngine)MergeEngine.getInstance());
            }
            catch (SVNClientException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void initializeMergeModel(CompareModel compareModel) {
        this._buffer = compareModel;
    }

    protected CompareModel getSaveResultForNode() {
        return this._buffer;
    }

    protected boolean isSaveEnabled() {
        return true;
    }

    public String getTabLabel() {
        return Resource.get("PROPERTY_MERGE_TAB_LABEL");
    }
}

