/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.UnLockOptionsCustomizer;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNOperationUnlock
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.unlock";

    public SVNOperationUnlock() {
        super(COMMAND_ID);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        UnLockOptionsCustomizer customizer = new UnLockOptionsCustomizer();
        return customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        DeterminateProgressMonitor progress = new DeterminateProgressMonitor(parentUi, Resource.get("ACTION_UNLOCK_PROGRESS_TITLE"), (Object)Resource.get("ACTION_UNLOCK_PROGRESS_MESSAGE"), "", 0, -1);
        progress.setCancellable(true);
        progress.setCloseOnFinish(true);
        progress.setMillisToDecideToPopup(500);
        boolean forceUnlock = this.getForceUnlock(options);
        URL[] operands = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
        try {
            SVNWCClient client = SVNUtil.getWCClient(repos);
            SVNOperationLogger.getInstance().beginOperation((SVNBasicClient)client, repos);
            progress.setMaximum(operands.length + 1);
            progress.setProgress(0);
            Collection processed = this.getProcessedUrlsNotifier(commandState);
            for (int i = 0; i < operands.length && !progress.isCancelled(); ++i) {
                client.doUnlock(new File[]{SVNUtil.toFile(operands[i])}, forceUnlock);
                processed.add(operands[i]);
                progress.setProgress(processed.size());
            }
            SVNOperationLogger.getInstance().successFinish(Resource.get("OP_UNLOCK"));
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            progress.finish();
        }
        return true;
    }

    private boolean getForceUnlock(Map options) {
        Boolean forceUnlock = (Boolean)options.get("oracle.jdeveloper.subversion.FORCE_LOCKS");
        if (forceUnlock != null) {
            return forceUnlock;
        }
        return false;
    }
}

