/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpSystem;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionListPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;

public class SVNRevisionLister
extends Observable {
    private SVNRevisionListPanel _panel;
    private JEWTDialog _dialog;
    private ISVNLogMessage[] _logMessages;
    private boolean _allowMultipleSelection = false;
    private SVNUrl _url;
    private org.tigris.subversion.svnclientadapter.SVNRevision _revisionStart;
    private org.tigris.subversion.svnclientadapter.SVNRevision _revisionEnd;
    private File _file;

    public SVNRevisionLister(SVNURL url, SVNRevision revisionStart, SVNRevision revisionEnd) {
        this._url = SVNUtil.toSVNUrl(url);
        try {
            this._revisionStart = org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)revisionStart.toString());
            this._revisionEnd = org.tigris.subversion.svnclientadapter.SVNRevision.getRevision((String)revisionEnd.toString());
        }
        catch (ParseException pe) {
            FeedbackManager.reportException((Throwable)pe);
        }
        this._panel = new SVNRevisionListPanel(this._url, this._revisionStart, this._revisionEnd);
        this._dialog = this.createDialog();
    }

    public SVNRevisionLister(File file, org.tigris.subversion.svnclientadapter.SVNRevision revisionStart, org.tigris.subversion.svnclientadapter.SVNRevision revisionEnd) {
        this._file = file;
        this._revisionStart = revisionStart;
        this._revisionEnd = revisionEnd;
        this._panel = new SVNRevisionListPanel(file, revisionStart, revisionEnd);
        this._dialog = this.createDialog();
    }

    public SVNRevisionLister(SVNUrl url, org.tigris.subversion.svnclientadapter.SVNRevision revisionStart, org.tigris.subversion.svnclientadapter.SVNRevision revisionEnd) {
        this._url = url;
        this._revisionStart = revisionStart;
        this._revisionEnd = revisionEnd;
        this._panel = new SVNRevisionListPanel(this._url, revisionStart, revisionEnd);
        this._dialog = this.createDialog();
    }

    public void showLister() {
        this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    if (SVNRevisionLister.this.getSelectedRevision() != null) {
                        SVNRevisionLister.this.setChanged();
                    }
                    SVNRevisionLister.this.notifyObservers(SVNRevisionLister.this.getSelectedRevision());
                }
            }
        });
        try {
            this._dialog.runDialog();
        }
        finally {
            this._dialog.dispose();
        }
    }

    private JEWTDialog createDialog() {
        String title = Resource.get("ACTION_REVISION_LISTER_TITLE");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)this._panel);
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "f1_svnrevisionlister_html");
        return dialog;
    }

    public org.tigris.subversion.svnclientadapter.SVNRevision getSelectedRevision() {
        return this._panel.getSelectedRevision();
    }

    public SVNRevision getSelectRevision() {
        return SVNRevision.parse((String)this._panel.getSelectedRevision().toString());
    }

    public org.tigris.subversion.svnclientadapter.SVNRevisionRange[] getSelectedRevisions() {
        return this._panel.getSelectedRevisions();
    }

    public SVNRevisionRange[] getSelectRevisions() {
        org.tigris.subversion.svnclientadapter.SVNRevisionRange[] revisions;
        ArrayList<SVNRevisionRange> svnRevs = new ArrayList<SVNRevisionRange>();
        for (org.tigris.subversion.svnclientadapter.SVNRevisionRange rev : revisions = this.getSelectedRevisions()) {
            SVNRevisionRange svnRev = new SVNRevisionRange(SVNRevision.parse((String)rev.getFromRevision().toString()), SVNRevision.parse((String)rev.getToRevision().toString()));
            svnRevs.add(svnRev);
        }
        return svnRevs.toArray(new SVNRevisionRange[0]);
    }

    public void setAllowMultipleSelection(boolean allowMultiSelection) {
        this._allowMultipleSelection = allowMultiSelection;
        this._panel.setAllowMultiSelection(allowMultiSelection);
    }

    public boolean isAllowMultipleSelection() {
        return this._allowMultipleSelection;
    }
}

