/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import oracle.jdevimpl.vcs.svn.prefs.SVNClientsPreferences;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNClientsTraversable
extends VCSPreferencesTraversable<SVNClientsPreferences> {
    private final VCSProfile _profile;
    private Component _ui;

    public SVNClientsTraversable() {
        this.setHelpID("f1_svnpreferencesmain_html");
        this._profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        assert (this._profile != null);
    }

    protected SVNClientsPreferences getPreferences(PropertyStorage prefs) {
        return SVNClientsPreferences.getInstance(prefs);
    }

    protected void loadPreferences(SVNClientsPreferences prefs) {
        ((UI)this.getPage()).setSelectedClientType(prefs.getClientType());
    }

    protected void savePreferences(SVNClientsPreferences prefs) {
        prefs.setClientType(((UI)this.getPage()).getSelectedClientType());
    }

    protected Component getPage() {
        if (this._ui == null) {
            this._ui = new UI();
        }
        return this._ui;
    }

    protected void validatePreferences() throws TraversalException {
    }

    private final class UI
    extends JPanel {
        private JLabel _clientsLabel;
        private JWrappedLabel _clientsUnavailableLabel;
        private JLabel _singleClientLabel;
        private ButtonGroup _radioGroup;
        private JRadioButton _cliRadio;
        private JRadioButton _nativeRadio;
        private JRadioButton _svnkitRadio;
        private final int _clientCount;

        private UI() {
            super(new GridBagLayout());
            this._clientCount = this.countClients();
            this.createComponents();
            this.layoutComponents();
        }

        private int getSelectedClientType() {
            switch (this._clientCount) {
                case 0: {
                    return 2;
                }
                case 1: {
                    if (SVNClientRegistry.getInstance().isNativeClientAvailable()) {
                        return 1;
                    }
                    if (SVNClientRegistry.getInstance().isSVNKitClientAvailable()) {
                        return 2;
                    }
                    if (SVNClientRegistry.getInstance().isCLIClientAvailable()) {
                        return 0;
                    }
                    throw new IllegalStateException();
                }
            }
            if (this._cliRadio != null && this._cliRadio.isSelected()) {
                return 0;
            }
            if (this._nativeRadio.isSelected()) {
                return 1;
            }
            if (this._svnkitRadio != null && this._svnkitRadio.isSelected()) {
                return 2;
            }
            throw new IllegalStateException();
        }

        private void setSelectedClientType(int clientType) {
            block0 : switch (this._clientCount) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    switch (clientType) {
                        case 0: {
                            if (this._cliRadio != null) {
                                this._cliRadio.setSelected(true);
                                break block0;
                            }
                            throw new IllegalArgumentException();
                        }
                        case 1: {
                            this._nativeRadio.setSelected(true);
                            break block0;
                        }
                        case 2: {
                            if (this._svnkitRadio != null) {
                                this._svnkitRadio.setSelected(true);
                                break block0;
                            }
                            throw new IllegalArgumentException();
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
        }

        private int countClients() {
            int count = 0;
            SVNClientRegistry reg = SVNClientRegistry.getInstance();
            if (reg.isNativeClientAvailable()) {
                ++count;
            }
            if (reg.isSVNKitClientAvailable()) {
                ++count;
            }
            if (reg.isCLIClientAvailable()) {
                ++count;
            }
            return count;
        }

        private void createComponents() {
            this._clientsLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this._clientsLabel, null, (String)Resource.get("UI_SVN_CLIENTS"));
            switch (this._clientCount) {
                case 0: {
                    this.createNoClientComponents();
                    break;
                }
                case 1: {
                    this.createSingleClientComponents();
                    break;
                }
                default: {
                    this.createMultipleClientComponents();
                }
            }
        }

        private void createNoClientComponents() {
            this._clientsUnavailableLabel = new JWrappedLabel();
            if (PlatformUtils.isWindows()) {
                this._clientsUnavailableLabel.setText(Resource.get("ERROR_MSG_NO_CLIENTS_WIN32"));
            } else if (PlatformUtils.isLinux()) {
                this._clientsUnavailableLabel.setText(Resource.get("ERROR_MSG_NO_CLIENTS_LINUX"));
            } else {
                this._clientsUnavailableLabel.setText(Resource.get("ERROR_MSG_NO_CLIENTS_GENERIC"));
            }
        }

        private void createSingleClientComponents() {
            this._singleClientLabel = new JLabel();
            this._singleClientLabel.setFocusTraversalKeysEnabled(true);
            SVNClientRegistry reg = SVNClientRegistry.getInstance();
            if (reg.isNativeClientAvailable()) {
                ResourceUtils.resLabel((JLabel)this._singleClientLabel, (Component)this._singleClientLabel, (String)this.getNativeClientDisplayValue());
            } else if (reg.isSVNKitClientAvailable()) {
                ResourceUtils.resLabel((JLabel)this._singleClientLabel, (Component)this._singleClientLabel, (String)this.getSVNKitClientDisplayValue());
            } else if (reg.isCLIClientAvailable()) {
                ResourceUtils.resLabel((JLabel)this._singleClientLabel, (Component)this._singleClientLabel, (String)this.getCLIClientDisplayValue());
            } else {
                throw new IllegalStateException();
            }
        }

        private void createMultipleClientComponents() {
            SVNClientRegistry reg = SVNClientRegistry.getInstance();
            this._radioGroup = new ButtonGroup();
            this._nativeRadio = new JRadioButton();
            this._radioGroup.add(this._nativeRadio);
            this._nativeRadio.setEnabled(reg.isNativeClientAvailable());
            ResourceUtils.resButton((AbstractButton)this._nativeRadio, (String)this.getNativeClientDisplayValue());
            if (reg.isSVNKitClientAvailable()) {
                this._svnkitRadio = new JRadioButton();
                this._svnkitRadio.setEnabled(true);
                this._radioGroup.add(this._svnkitRadio);
                this._svnkitRadio.setText(this.getSVNKitClientDisplayValue());
                this._svnkitRadio.setMnemonic('K');
            }
            if (reg.isCLIClientAvailable()) {
                this._cliRadio = new JRadioButton();
                this._radioGroup.add(this._cliRadio);
                this._cliRadio.setEnabled(true);
                ResourceUtils.resButton((AbstractButton)this._cliRadio, (String)this.getCLIClientDisplayValue());
            }
        }

        private String getNativeClientDisplayValue() {
            try {
                return Resource.format("UI_CLIENTS_NATIVE_V", SVNClientRegistry.getInstance().getNativeClient().getSVNVersion());
            }
            catch (SVNClientException ce) {
                return Resource.get("UI_CLIENTS_NATIVE_NV");
            }
        }

        private String getSVNKitClientDisplayValue() {
            try {
                return SVNClientRegistry.getInstance().getSVNKitClient().getSVNVersion();
            }
            catch (SVNClientException ce) {
                return Resource.get("UI_CLIENTS_SVNKIT_NV");
            }
        }

        private String getCLIClientDisplayValue() {
            try {
                return Resource.format("UI_CLIENTS_CLI_V", SVNClientRegistry.getInstance().getCLIClient().getSVNVersion());
            }
            catch (SVNClientException ce) {
                return Resource.get("UI_CLIENTS_CLI_NV");
            }
        }

        private void layoutComponents() {
            this.add((Component)this._clientsLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            switch (this._clientCount) {
                case 0: {
                    this.layoutNoClientComponents();
                    break;
                }
                case 1: {
                    this.layoutSingleClientComponents();
                    break;
                }
                default: {
                    this.layoutMultipleClientComponents();
                }
            }
        }

        private void layoutNoClientComponents() {
            this.add((Component)this._clientsUnavailableLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
        }

        private void layoutSingleClientComponents() {
            this.add((Component)this._singleClientLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
        }

        private void layoutMultipleClientComponents() {
            this.add((Component)this._nativeRadio, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
            if (this._svnkitRadio != null) {
                this.add((Component)this._svnkitRadio, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
            }
            if (this._cliRadio != null) {
                this.add((Component)this._cliRadio, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 26, 0, 0), 0, 0));
            }
        }
    }
}

