/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNBugtraqProperties {
    public static final String EXPRESSION = "([0-9]*[,]?)+$";
    public static final String BUGID = "%BUGID%";
    private static final String BUGTRAQ = "bugtraq";
    private static final String BUGTRAQ_LABEL = "bugtraq:label";
    private static final String BUGTRAQ_MESG = "bugtraq:message";
    private static final String BUGTRAQ_APPEND = "bugtraq:append";
    private static final String BUGTRAQ_WARN = "bugtraq:warnifnoissue";
    private static final String BUGTRAQ_NUMBER = "bugtraq:number";
    private static final String BUGTRAQ_URL = "bugtraq:url";
    private Map<String, String> _bugtraqProp;
    private File path;
    private URL _wkRootURL;

    public SVNBugtraqProperties(URL url) throws SVNClientException {
        if (url != null) {
            this.path = SVNUtil.toFile(url);
            this._wkRootURL = SVNUtil.resolveWorkingCopy(url);
            if (this._wkRootURL == null) {
                ArrayList<URL> svnAdmin = new ArrayList<URL>();
                this.getSVNRootForNoApp(url, svnAdmin);
                if (!svnAdmin.isEmpty()) {
                    this._wkRootURL = (URL)svnAdmin.get(svnAdmin.size() - 1);
                }
            }
        }
    }

    private Map<String, String> getProperties() {
        if (this._bugtraqProp == null) {
            File fpath = this.path;
            this._bugtraqProp = new HashMap<String, String>();
            try {
                boolean search;
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                boolean bl = search = this._wkRootURL != null;
                while (search) {
                    boolean bl2 = search = !this.getBugtraqProperties(client, fpath);
                    if (this._wkRootURL.getPath().startsWith(fpath.getPath())) {
                        search = false;
                    }
                    if (!search) continue;
                    fpath = fpath.getParentFile();
                }
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
            }
        }
        return this._bugtraqProp;
    }

    private boolean getBugtraqProperties(ISVNClientAdapter client, File fpath) throws SVNClientException {
        ISVNProperty[] properties;
        for (ISVNProperty property : properties = client.getProperties(fpath)) {
            if (!property.getName().startsWith(BUGTRAQ)) continue;
            this._bugtraqProp.put(property.getName(), property.getValue());
        }
        return !this._bugtraqProp.isEmpty();
    }

    public boolean exist() {
        if (this.path == null) {
            return false;
        }
        Map<String, String> bugtraq = this.getProperties();
        return bugtraq.containsKey(BUGTRAQ_MESG);
    }

    public String getLabel() {
        Map<String, String> bugtraq = this.getProperties();
        if (!bugtraq.containsKey(BUGTRAQ_LABEL)) {
            return Resource.get("BUGTRAQ_LABEL_DEFAULT");
        }
        return bugtraq.get(BUGTRAQ_LABEL);
    }

    public String getMessage() {
        Map<String, String> bugtraq = this.getProperties();
        return bugtraq.get(BUGTRAQ_MESG);
    }

    public Collection<String> getIssueId(String message) {
        if (this.getMessage() != null) {
            Pattern pattern;
            Matcher matcher;
            String msg = this.getMessage().substring(0, this.getMessage().indexOf(BUGID));
            if (this.isNumber() && (matcher = (pattern = Pattern.compile(msg + EXPRESSION)).matcher(message)).find()) {
                String id = message.substring(msg.length() + matcher.start(), matcher.end()).trim();
                String[] ids = id.split(",");
                ArrayList<String> issues = new ArrayList<String>();
                for (String issue : ids) {
                    issues.add(issue);
                }
                return issues;
            }
        }
        return Collections.emptyList();
    }

    public boolean isAppend() {
        String value;
        Map<String, String> bugtraq = this.getProperties();
        return !bugtraq.containsKey(BUGTRAQ_APPEND) || !(value = bugtraq.get(BUGTRAQ_APPEND)).equalsIgnoreCase("false") && !value.equalsIgnoreCase("no");
    }

    public boolean warnifNoIssue() {
        String value;
        Map<String, String> bugtraq = this.getProperties();
        return bugtraq.containsKey(BUGTRAQ_WARN) && ((value = bugtraq.get(BUGTRAQ_WARN)).equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    public boolean isNumber() {
        String value;
        Map<String, String> bugtraq = this.getProperties();
        return bugtraq.containsKey(BUGTRAQ_NUMBER) && ((value = bugtraq.get(BUGTRAQ_NUMBER)).equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    public URL getURL() {
        Map<String, String> bugtraq = this.getProperties();
        if (bugtraq.containsKey(BUGTRAQ_URL)) {
            String value = bugtraq.get(BUGTRAQ_URL);
            return URLFactory.newURL((String)value);
        }
        return null;
    }

    public URL getIssueURL(String issue) {
        Map<String, String> bugtraq = this.getProperties();
        if (bugtraq.containsKey(BUGTRAQ_URL)) {
            String value = bugtraq.get(BUGTRAQ_URL);
            value = value.replace(BUGID, issue);
            return URLFactory.newURL((String)value);
        }
        return null;
    }

    public String getFormatedLogMessage(String bugtraqNo, String comment) {
        if (bugtraqNo == null || bugtraqNo.isEmpty()) {
            return comment;
        }
        StringBuilder sb = new StringBuilder();
        String issueNo = this.getMessage().replace(BUGID, bugtraqNo);
        if (this.isAppend()) {
            sb.append(comment != null ? comment : "");
            sb.append("\n");
            sb.append(issueNo);
        } else {
            sb.append(issueNo);
            sb.append("\n");
            sb.append(comment != null ? comment : "");
        }
        return sb.toString();
    }

    private void getSVNRootForNoApp(URL url, List<URL> svnAdmin) {
        URL[] child = URLFileSystem.list((URL)url, (URLFilenameFilter)new URLFilenameFilter(){

            public boolean accept(URL url, String name) {
                return name.equals(".svn");
            }
        });
        if (child != null && child.length > 0) {
            svnAdmin.add(url);
            URL parent = URLFileSystem.getParent((URL)url);
            if (parent != null && !parent.getPath().equals(url.getPath())) {
                this.getSVNRootForNoApp(parent, svnAdmin);
            }
        }
    }
}

