/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.externaltools.Availability;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolOptionsEnvironment;
import oracle.ide.externaltools.ExternalToolOptionsPage;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.dialogs.ExceptionDialog;

public class AvailabilityPanel
extends JPanel
implements ExternalToolOptionsPage {
    private static final Icon DEFAULT_ICON = new NullIcon();
    private GridBagLayout gblEnablementPanel = new GridBagLayout();
    private JLabel labHint = new JLabel();
    private JLabel labTitle = new JLabel();
    private JRadioButton rbAlways = new JRadioButton();
    private JRadioButton rbActiveNode = new JRadioButton();
    private JRadioButton rbSpecificType = new JRadioButton();
    private Shuttle typeShuttle = new Shuttle();
    private JLabel labFrom = new JLabel();
    private JList typeFromList = new JList();
    private JLabel labTo = new JLabel();
    private JList typeToList = new JList();
    private boolean _typesHidden = false;

    public AvailabilityPanel() {
        this.jbInit();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbAlways);
        bg.add(this.rbActiveNode);
        bg.add(this.rbSpecificType);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AvailabilityPanel.this.updateControlEnablement();
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)AvailabilityPanel.this, (Throwable)re);
                }
            }
        };
        this.rbAlways.addActionListener(al);
        this.rbActiveNode.addActionListener(al);
        this.rbSpecificType.addActionListener(al);
    }

    @Override
    public String getHelpTopicID() {
        return "f1_idedexternaltools5_html";
    }

    @Override
    public Component getInitialFocus() {
        return this.rbAlways;
    }

    private void updateControlEnablement() {
        this.typeFromList.setEnabled(this.rbSpecificType.isSelected());
        this.typeShuttle.setEnabled(this.rbSpecificType.isSelected());
        this.typeToList.setEnabled(this.rbSpecificType.isSelected());
    }

    private void jbInit() {
        this.setLayout(this.gblEnablementPanel);
        this.labHint.setText("<html>" + ExternalToolsArb.getString(61) + "</html>");
        ResourceUtils.resLabel((JLabel)this.labTitle, (Component)this.rbAlways, (String)ExternalToolsArb.getString(62));
        ResourceUtils.resButton((AbstractButton)this.rbAlways, (String)ExternalToolsArb.getString(63));
        ResourceUtils.resButton((AbstractButton)this.rbActiveNode, (String)ExternalToolsArb.getString(64));
        ResourceUtils.resButton((AbstractButton)this.rbSpecificType, (String)ExternalToolsArb.getString(65));
        ResourceUtils.resLabel((JLabel)this.labFrom, (Component)this.typeFromList, (String)ExternalToolsArb.getString(66));
        ResourceUtils.resLabel((JLabel)this.labTo, (Component)this.typeToList, (String)ExternalToolsArb.getString(67));
        this.add((Component)this.labHint, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.labTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.rbAlways, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this.rbActiveNode, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)this.rbSpecificType, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)this.typeShuttle, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 29, 0, 0), 0, 0));
    }

    private void populateAvailableTypes() {
        Collection extensionsToNodes = FileTypesRecognizer.allMappedExtensionsToNodes();
        if (extensionsToNodes.isEmpty()) {
            if (this._typesHidden) {
                return;
            }
            this._typesHidden = true;
            this.rbSpecificType.setVisible(false);
            this.typeShuttle.setVisible(false);
            this.add((Component)new JPanel(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return;
        }
        HashMap<String, DocRecord> c = new HashMap<String, DocRecord>();
        for (File fileExtension : FileTypesRecognizer.allMappedExtensionsToNodes()) {
            DocRecord record;
            String docClassName = FileTypesRecognizer.getClassNameForExtension((String)fileExtension.getPath());
            if (null == docClassName) {
                System.out.println("No class name for extension: " + fileExtension.getPath());
                Thread.dumpStack();
            }
            if (null == (record = (DocRecord)c.get(docClassName))) {
                c.put(docClassName, new DocRecord(docClassName, fileExtension.getPath(), Recognizer.getDocumentInfo((String)docClassName)));
                continue;
            }
            record.addExtension(fileExtension.getPath());
        }
        ArrayList copy = new ArrayList(c.values());
        Comparator<DocRecord> comparator = new Comparator<DocRecord>(){
            final Collator collator = Collator.getInstance();

            @Override
            public int compare(DocRecord dr1, DocRecord dr2) {
                String label1 = dr1.getLabel();
                String label2 = dr2.getLabel();
                boolean dot1 = label1.startsWith(".");
                boolean dot2 = label2.startsWith(".");
                if (dot1 && dot2 || !dot1 && !dot2) {
                    return this.collator.compare(label1, label2);
                }
                if (dot1) {
                    return 1;
                }
                if (dot2) {
                    return -1;
                }
                return this.collator.compare(label1, label2);
            }
        };
        Collections.sort(copy, comparator);
        SimpleListModel model = new SimpleListModel();
        model.asList().addAll(copy);
        this.typeFromList.setModel(model);
        this.typeToList.setModel(new SimpleListModel());
    }

    @Override
    public void setEnvironment(ExternalToolOptionsEnvironment env) {
        this.typeFromList.setCellRenderer(new TypeListCellRenderer());
        this.typeToList.setCellRenderer(new TypeListCellRenderer());
        this.typeShuttle.setFromPicker((ItemPicker)new ListPicker(this.typeFromList));
        this.typeShuttle.setToPicker((ItemPicker)new ListPicker(this.typeToList));
        this.typeShuttle.add((Component)this.labFrom, (Object)"FromHeader");
        this.typeShuttle.add((Component)this.labTo, (Object)"ToHeader");
    }

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public String getPageName() {
        return ExternalToolsArb.getString(60);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean validateOptions() {
        return true;
    }

    @Override
    public void saveOptions(ExternalTool tool, boolean isCreateMode) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        Availability availability = null;
        if (this.rbActiveNode.isSelected()) {
            availability = Availability.ANY_SELECTION;
        } else if (this.rbAlways.isSelected()) {
            availability = Availability.ALWAYS;
        } else if (this.rbSpecificType.isSelected()) {
            availability = Availability.SELECTED_TYPES;
        }
        props.setAvailability(availability);
        ArrayList<String> l = new ArrayList<String>();
        DefaultListModel model = (DefaultListModel)this.typeToList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            l.add(((DocRecord)model.getElementAt(i)).getDocClassName());
        }
        props.setAvailableTypes(l);
    }

    @Override
    public void loadOptions(ExternalTool tool, boolean isCreateMode) {
        this.populateAvailableTypes();
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        List<String> l = props.getAvailableTypes();
        if (l != null) {
            DefaultListModel fromModel = (DefaultListModel)this.typeFromList.getModel();
            DefaultListModel toModel = (DefaultListModel)this.typeToList.getModel();
            block5: for (String typeClass : l) {
                for (int j = 0; j < fromModel.getSize(); ++j) {
                    DocRecord rec = (DocRecord)fromModel.getElementAt(j);
                    if (!rec.getDocClassName().equals(typeClass)) continue;
                    fromModel.removeElement(rec);
                    toModel.addElement(rec);
                    continue block5;
                }
            }
        }
        switch (props.getAvailability()) {
            case ALWAYS: {
                this.rbAlways.setSelected(true);
                break;
            }
            case SELECTED_TYPES: {
                this.rbSpecificType.setSelected(true);
                break;
            }
            case ANY_SELECTION: {
                this.rbActiveNode.setSelected(true);
            }
        }
        this.updateControlEnablement();
    }

    private static class TypeListCellRenderer
    extends DefaultListCellRenderer {
        private TypeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DocRecord) {
                DocRecord record = (DocRecord)value;
                this.setIcon(record.getIcon());
                this.setText(record.getLabel());
                this.setToolTipText(record.getFileExtsString());
            }
            this.setEnabled(list.isEnabled());
            return this;
        }
    }

    private final class DocRecord {
        private final String _docClassName;
        private final DocumentInfo _info;
        private final Set<String> fileExts = new TreeSet<String>();

        DocRecord(String docClassName, String fileExt, DocumentInfo info) {
            this._docClassName = docClassName;
            this._info = info;
            this.addExtension(fileExt);
        }

        final String getDocClassName() {
            return this._docClassName;
        }

        final String getLabel() {
            String label;
            String string = label = this._info != null ? this._info.getLabel() : null;
            if (null != label) {
                return label;
            }
            return this.getFileExtsString();
        }

        final Icon getIcon() {
            Icon icon = null != this._info ? this._info.getIcon() : DEFAULT_ICON;
            return null != icon ? icon : DEFAULT_ICON;
        }

        private void addExtension(String fileExt) {
            this.fileExts.add(fileExt);
        }

        private String getFileExtsString() {
            StringBuffer buff = new StringBuffer();
            for (String fileExt : this.fileExts) {
                if (0 != buff.length()) {
                    buff.append(", ");
                }
                buff.append(fileExt);
            }
            return buff.toString();
        }
    }
}

