/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolOptionsEnvironment;
import oracle.ide.externaltools.ExternalToolOptionsPage;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.model.Displayable;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.ui.ExternalToolsWizard;
import oracle.javatools.dialogs.ExceptionDialog;

public class ToolTypePanel
extends JPanel
implements ExternalToolOptionsPage {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel m_hintLabel = new JLabel();
    private JLabel m_toolTypeLabel = new JLabel();
    private JComboBox m_toolTypeCombo = new JComboBox();
    private JLabel m_descriptionLabel = new JLabel();
    private boolean m_populated = false;
    private transient ExternalToolsWizard m_wizard;
    private ActionListener comboActionListener;

    public ToolTypePanel() {
        this.jbInit();
        this.comboActionListener = EventHandler.create(ActionListener.class, this, "comboChanged");
        this.m_toolTypeCombo.addActionListener(this.comboActionListener);
        this.m_toolTypeCombo.setRenderer(new DisplayableComboRenderer());
    }

    @Override
    public Component getInitialFocus() {
        return this.m_toolTypeCombo;
    }

    @Override
    public String getHelpTopicID() {
        return "f1_idedexternaltools1_html";
    }

    private void loadTypes() {
        try {
            InitialContext context = new InitialContext();
            ExternalToolManager manager = (ExternalToolManager)context.lookup("jdeveloper/external-tool-manager");
            this.m_toolTypeCombo.removeActionListener(this.comboActionListener);
            Iterator<ExternalToolType> i = manager.getRegisteredTypes();
            while (i.hasNext()) {
                ExternalToolType type = i.next();
                this.m_toolTypeCombo.addItem(type);
            }
            this.m_toolTypeCombo.addActionListener(this.comboActionListener);
        }
        catch (NamingException ne) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)ne);
        }
    }

    public void comboChanged() {
        Object selection = this.m_toolTypeCombo.getSelectedItem();
        if (selection instanceof ExternalToolType) {
            this.m_descriptionLabel.setText("<html>" + ((ExternalToolType)selection).getLongLabel() + "</html>");
            this.m_wizard.removePages();
            this.m_wizard.addPagesForType((ExternalToolType)selection);
        }
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.m_hintLabel.setText(ExternalToolsArb.getString(31));
        ResourceUtils.resLabel((JLabel)this.m_toolTypeLabel, (Component)this.m_toolTypeCombo, (String)ExternalToolsArb.getString(32));
        this.m_descriptionLabel.setVerticalAlignment(1);
        this.add((Component)this.m_hintLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_toolTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.add((Component)this.m_toolTypeCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_descriptionLabel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setEnvironment(ExternalToolOptionsEnvironment env) {
        this.m_wizard = (ExternalToolsWizard)env;
    }

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public String getPageName() {
        return ExternalToolsArb.getString(30);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean validateOptions() {
        return true;
    }

    @Override
    public void saveOptions(ExternalTool tool, boolean isCreateMode) {
        if (isCreateMode) {
            ExternalToolType type = (ExternalToolType)this.m_toolTypeCombo.getSelectedItem();
            if (tool == null || ExternalToolManager.getExternalToolManager().getType(tool) != type) {
                this.m_wizard.setType(type);
                this.m_wizard.setExternalTool(type.createExternalTool());
            }
        }
    }

    @Override
    public void loadOptions(ExternalTool tool, boolean isCreateMode) {
        if (!this.m_populated) {
            this.loadTypes();
            this.m_populated = true;
        }
    }

    void setComboSelection(String typeId) {
        ComboBoxModel model = this.m_toolTypeCombo.getModel();
        int len = model.getSize();
        for (int i = 0; i < len; ++i) {
            ExternalToolType type = (ExternalToolType)model.getElementAt(i);
            if (!type.getId().equals(typeId)) continue;
            model.setSelectedItem(type);
            break;
        }
    }

    private static class DisplayableComboRenderer
    extends BasicComboBoxRenderer {
        private DisplayableComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Displayable) {
                this.setText(((Displayable)value).getShortLabel());
            }
            return c;
        }
    }
}

