/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.HorizontalScroll;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.model.Item;

public class HorizontalPanel
extends IconPanel
implements MouseListener {
    private final JPanel _middlePanel = new JPanel();
    private final BorderLayout _borderLayout2 = new BorderLayout();
    private final JPanel _toolbar = new JPanel();
    private HorizontalScroll _scrollPane;
    private final GridBagLayout _gridBagLayout1 = new GridBagLayout();
    private ImageIcon _activeLeftArrowIcon = (ImageIcon)PaletteArb.getIcon(38);
    private ImageIcon _activeRightArrowIcon = (ImageIcon)PaletteArb.getIcon(36);
    private final JButton _leftBtn = new JButton(this._activeLeftArrowIcon);
    private final JButton _rightBtn = new JButton(this._activeRightArrowIcon);

    public HorizontalPanel(PalettePage palettePage) {
        super(palettePage);
        this._toolbar.addMouseListener(this);
        this._leftBtn.addMouseListener(this);
        this._rightBtn.addMouseListener(this);
        this._leftBtn.setToolTipText("Scroll Left");
        this._rightBtn.setToolTipText("Scroll Right");
        this._toolbar.setLayout(new BoxLayout(this._toolbar, 0));
        this._scrollPane = new HorizontalScroll(this._toolbar, this._leftBtn, this._rightBtn);
    }

    @Override
    public void setup(JComboBox box) {
        this._leftBtn.setBorderPainted(false);
        this._rightBtn.setBorderPainted(false);
        this._leftBtn.setMargin(new Insets(1, 1, 1, 1));
        this._rightBtn.setMargin(new Insets(1, 1, 1, 1));
        this._toolbar.setAutoscrolls(true);
        this._scrollPane.setBorder(null);
        this.setLayout(this._gridBagLayout1);
        this._middlePanel.setLayout(this._borderLayout2);
        this.add((Component)this._middlePanel, new GridBagConstraints(1, 0, 1, 1, 0.9, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._middlePanel.add((Component)this._leftBtn, "West");
        this._middlePanel.add((Component)this._scrollPane, "Center");
        this._middlePanel.add((Component)this._rightBtn, "East");
        this._leftBtn.setVisible(false);
    }

    @Override
    void removeChildren() {
        this._toolbar.removeAll();
    }

    @Override
    public void addIconLabels(boolean showLabel) {
        for (PaletteItemUI paletteBut : this.getIconList()) {
            if (showLabel) {
                paletteBut.setText(paletteBut.getItem().getShortLabel());
            } else {
                paletteBut.setText("");
            }
            this._toolbar.add(paletteBut);
        }
    }

    @Override
    public void useListView(boolean listView) {
        this.setListView(listView);
        Iterator iter = this.getIconList().iterator();
        if (listView) {
            this.getPalettePage().setView("list");
        } else {
            this.getPalettePage().setView("icon");
        }
        while (iter.hasNext()) {
            PaletteItemUI iconBtn = (PaletteItemUI)iter.next();
            PaletteItemImpl pi = iconBtn.getItem();
            if (listView) {
                iconBtn.setText(pi.getShortLabel());
                continue;
            }
            iconBtn.setText("");
        }
        this._toolbar.revalidate();
    }

    @Override
    public void addItem(Item item) {
        PaletteItemUI paletteItemUI = new PaletteItemUI(new PaletteItemImpl(item));
        this.getIconList().add(paletteItemUI);
        this._toolbar.add(paletteItemUI);
        this.useListView(this.getListView());
    }

    @Override
    public void removeItem(Item item) {
        for (PaletteItemUI uiItem : this.getIconList()) {
            if (uiItem.getItem().getItem() != item) continue;
            this._toolbar.remove(uiItem);
        }
    }

    @Override
    public void removeActiveItem() {
        this._toolbar.remove(this._controller.getPaletteUI().getActivePaletteItemUI());
        this._toolbar.repaint();
        this._toolbar.validate();
    }

    @Override
    public void validateScroll() {
    }
}

