/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGrapherLinkProperty;
import ilog.views.IlvGrapherObjectProperty;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvObjectProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvCrossingAwareLinkImage;
import ilog.views.internal.IlvIteratorGraphicEnumeration;
import ilog.views.internal.IlvUtility;
import ilog.views.internal.impl.IlvEmptyGraphicEnumeration;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvCachingLinkConnector;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;

public class IlvGrapher
extends IlvManager {
    private static final String a = "Origin or destination of the link is not a node";
    private static final String b = "getLowestCommonGrapher__";
    private boolean c;
    private boolean d;
    private int e = -1;
    private boolean f;
    private ArrayList g;
    private ArrayList h;
    private static final String i = "__VISIBLE_BRANCH_MARK";

    public IlvGrapher() {
        this(2);
    }

    public IlvGrapher(int n) {
        super(n);
    }

    public IlvGrapher(int n, int n2) {
        super(n, n2);
    }

    public IlvGrapher(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
    }

    public IlvGrapher(IlvGrapher ilvGrapher) {
        super(ilvGrapher);
        this.f = ilvGrapher.f;
    }

    @Override
    public IlvGraphic copy() {
        return new IlvGrapher(this);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
    }

    @Override
    public void writePrefix(IlvOutputStream ilvOutputStream, boolean bl) throws IOException {
        super.writePrefix(ilvOutputStream, bl);
    }

    @Override
    public void writeSuffix(IlvOutputStream ilvOutputStream, boolean bl) throws IOException {
        super.writeSuffix(ilvOutputStream, bl);
        if (this.f) {
            ilvOutputStream.write("crossingAwareLinksFrozen", this.f);
        }
    }

    @Override
    public void readPrefix(IlvInputStream ilvInputStream, boolean bl) throws IOException, IlvReadFileException {
        super.readPrefix(ilvInputStream, bl);
    }

    @Override
    public void readSuffix(IlvInputStream ilvInputStream, boolean bl) throws IOException, IlvReadFileException {
        super.readSuffix(ilvInputStream, bl);
        try {
            this.f = ilvInputStream.readBoolean("crossingAwareLinksFrozen");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.f = false;
        }
    }

    @Override
    public void addObject(IlvGraphic ilvGraphic, int n, boolean bl) {
        if (!this.d && ilvGraphic instanceof IlvLinkImage) {
            throw new IllegalArgumentException("IlvLinkImage objects must be added using addLink: " + ilvGraphic);
        }
        super.addObject(ilvGraphic, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(IlvGraphic ilvGraphic, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            this.addNode(ilvGraphic, this.getInsertionLayer(), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(IlvGraphic ilvGraphic, int n, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            this.c = true;
            try {
                super.addObject(ilvGraphic, n, bl);
            }
            finally {
                this.c = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLink(IlvLinkImage ilvLinkImage, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            this.addLink(ilvLinkImage, this.getLinksInsertionLayer(), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLink(IlvLinkImage ilvLinkImage, int n, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            boolean bl2;
            block19: {
                IlvGraphic ilvGraphic;
                IlvGraphic ilvGraphic2;
                block18: {
                    bl2 = false;
                    ilvGraphic2 = ilvLinkImage.getFrom();
                    ilvGraphic = ilvLinkImage.getTo();
                    if (ilvGraphic2 == null || ilvGraphic == null) {
                        throw new IllegalArgumentException("Link must have an origin and a destination node");
                    }
                    IlvGraphicBag ilvGraphicBag = ilvGraphic2.getGraphicBag();
                    IlvGraphicBag ilvGraphicBag2 = ilvGraphic.getGraphicBag();
                    if (ilvGraphicBag == null || ilvGraphicBag2 == null) {
                        throw new IllegalArgumentException("Origin and destination nodes must be already in a grapher");
                    }
                    if (ilvGraphicBag != this) break block18;
                    if (ilvGraphicBag2 == this) break block19;
                }
                if (ilvLinkImage.getProperty(b) == null) {
                    IlvManager ilvManager2 = IlvGrapher.getLowestCommonGrapher(ilvGraphic2, ilvGraphic);
                    if (ilvManager2 == null) {
                        throw new IllegalArgumentException("Origin and destination nodes of link should be in a same grapher hierarchy");
                    }
                    while (ilvManager2 != this && ilvManager2 != null) {
                        ilvManager2 = ilvManager2.bl;
                    }
                    if (ilvManager2 == null) {
                        throw new IllegalArgumentException("Origin and destination nodes are not in sub graphers of this grapher.");
                    }
                } else {
                    ilvLinkImage.setProperty(b, null);
                }
                bl2 = true;
            }
            this.d = true;
            try {
                if (bl2) {
                    this.c(ilvLinkImage);
                }
                super.addObject(ilvLinkImage, n, bl);
            }
            finally {
                this.d = false;
            }
        }
    }

    public final IlvGraphicEnumeration getExternalInterGraphLinks() {
        if (this.g == null) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return new IlvIteratorGraphicEnumeration(this.g.iterator());
    }

    public final int getExternalInterGraphLinksCount() {
        return this.g == null ? 0 : this.g.size();
    }

    private void a(IlvLinkImage ilvLinkImage) {
        if (this.g == null) {
            this.g = new ArrayList();
        }
        this.g.add(ilvLinkImage);
    }

    private boolean b(IlvLinkImage ilvLinkImage) {
        if (this.g == null) {
            return false;
        }
        boolean bl = this.g.remove(ilvLinkImage);
        if (bl && this.g.size() == 0) {
            this.g = null;
        }
        return bl;
    }

    public final IlvGraphicEnumeration getTreeExternalInterGraphLinks() {
        return new IlvGraphicEnumeration(){
            Stack a = new Stack();
            IlvGrapher b = IlvGrapher.this;
            IlvManager c = IlvGrapher.this;
            IlvGraphicEnumeration d = this.b.getExternalInterGraphLinks();
            IlvGraphic e;
            {
                this.a();
            }

            @Override
            public boolean hasMoreElements() {
                return this.e != null;
            }

            @Override
            public IlvGraphic nextElement() {
                if (this.e == null) {
                    throw new NoSuchElementException("getTreeExternalInterGraphLinks");
                }
                IlvGraphic ilvGraphic = this.e;
                this.a();
                return ilvGraphic;
            }

            private void a() {
                this.c();
                while (this.e == null) {
                    this.b();
                    if (this.c == null) break;
                    if (!(this.c instanceof IlvGrapher)) continue;
                    this.d = ((IlvGrapher)this.c).getExternalInterGraphLinks();
                    this.c();
                }
            }

            private void b() {
                IlvGraphicEnumeration ilvGraphicEnumeration = this.c.getManagers();
                if (ilvGraphicEnumeration.hasMoreElements()) {
                    this.c = (IlvManager)ilvGraphicEnumeration.nextElement();
                    this.a.push(ilvGraphicEnumeration);
                } else {
                    while (!this.a.empty()) {
                        ilvGraphicEnumeration = (IlvGraphicEnumeration)this.a.pop();
                        if (!ilvGraphicEnumeration.hasMoreElements()) continue;
                        this.c = (IlvManager)ilvGraphicEnumeration.nextElement();
                        this.a.push(ilvGraphicEnumeration);
                        return;
                    }
                    this.c = null;
                }
            }

            private void c() {
                this.e = null;
                while (this.d.hasMoreElements()) {
                    IlvLinkImage ilvLinkImage = (IlvLinkImage)this.d.nextElement();
                    if (this.b != this.c && !IlvUtility.isOutside(this.b, ilvLinkImage.getFrom()) && !IlvUtility.isOutside(this.b, ilvLinkImage.getTo())) continue;
                    this.e = ilvLinkImage;
                    return;
                }
            }
        };
    }

    public final int getTreeExternalInterGraphLinksCount() {
        return this.a(this, this);
    }

    private final int a(IlvManager ilvManager, IlvGrapher ilvGrapher) {
        Object object;
        Object object2;
        int n = 0;
        if (ilvManager == ilvGrapher) {
            n += ilvGrapher.getExternalInterGraphLinksCount();
        } else if (ilvManager instanceof IlvGrapher) {
            object2 = (IlvGrapher)ilvManager;
            object = ((IlvGrapher)object2).getExternalInterGraphLinks();
            while (object.hasMoreElements()) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)object.nextElement();
                if (!IlvUtility.isOutside(ilvGrapher, ilvLinkImage.getFrom()) && !IlvUtility.isOutside(ilvGrapher, ilvLinkImage.getTo())) continue;
                ++n;
            }
        }
        if (ilvManager.getManagersCount() != 0) {
            object2 = ilvManager.getManagers();
            while (object2.hasMoreElements()) {
                object = (IlvManager)object2.nextElement();
                n += this.a((IlvManager)object, ilvGrapher);
            }
        }
        return n;
    }

    public final IlvGraphicEnumeration getInterGraphLinks() {
        if (this.h == null) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return new IlvIteratorGraphicEnumeration(this.h.iterator());
    }

    public final int getInterGraphLinksCount() {
        return this.h == null ? 0 : this.h.size();
    }

    private void c(IlvLinkImage ilvLinkImage) {
        if (this.h == null) {
            this.h = new ArrayList();
        }
        this.h.add(ilvLinkImage);
    }

    private boolean d(IlvLinkImage ilvLinkImage) {
        if (this.h == null) {
            return false;
        }
        boolean bl = this.h.remove(ilvLinkImage);
        if (bl && this.h.size() == 0) {
            this.h = null;
        }
        return bl;
    }

    public static void addInterGraphLink(IlvLinkImage ilvLinkImage, boolean bl) {
        IlvGrapher ilvGrapher = IlvGrapher.getLowestCommonGrapher(ilvLinkImage.getFrom(), ilvLinkImage.getTo());
        if (ilvGrapher == null) {
            throw new IllegalArgumentException("Origin and destination nodes of link should be in a same grapher hierarchy");
        }
        ilvLinkImage.setProperty(b, Boolean.TRUE);
        ilvGrapher.addLink(ilvLinkImage, ilvGrapher.getLinksInsertionLayer(), bl);
        ilvLinkImage.setProperty(b, null);
    }

    public static IlvGrapher getLowestCommonGrapher(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        if (ilvGraphic2 == null || ilvGraphic == null) {
            throw new IllegalArgumentException("both objects should not be null");
        }
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        IlvGraphicBag ilvGraphicBag2 = ilvGraphic2.getGraphicBag();
        if (ilvGraphicBag == null || ilvGraphicBag2 == null || !(ilvGraphicBag instanceof IlvGrapher) || !(ilvGraphicBag2 instanceof IlvGrapher)) {
            return null;
        }
        if (ilvGraphicBag == ilvGraphicBag2) {
            return (IlvGrapher)ilvGraphicBag;
        }
        IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphicBag;
        IlvGrapher ilvGrapher2 = (IlvGrapher)ilvGraphicBag2;
        IlvManager ilvManager = ilvGrapher.bm;
        if (ilvManager != ilvGrapher2.bm) {
            return null;
        }
        int n = 0;
        IlvManager ilvManager2 = ilvGrapher;
        while (ilvManager2 != ilvManager) {
            ++n;
            ilvManager2 = ilvManager2.bl;
        }
        int n2 = 0;
        IlvManager ilvManager3 = ilvGrapher2;
        while (ilvManager3 != ilvManager) {
            ++n2;
            ilvManager3 = ilvManager3.bl;
        }
        ilvManager3 = ilvGrapher;
        IlvManager ilvManager4 = ilvGrapher2;
        if (n > n2) {
            do {
                ilvManager3 = ilvManager3.bl;
            } while (--n > n2 && ilvManager3 != null);
        } else if (n < n2) {
            do {
                ilvManager4 = ilvManager4.bl;
            } while (n < --n2 && ilvManager4 != null);
        }
        while (ilvManager3 != ilvManager4) {
            ilvManager3 = ilvManager3.bl;
            ilvManager4 = ilvManager4.bl;
        }
        while (ilvManager3 != null && !(ilvManager3 instanceof IlvGrapher)) {
            ilvManager3 = ilvManager3.bl;
        }
        return ilvManager3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObject(IlvGraphic ilvGraphic, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (ilvGraphic == null) {
                throw new IllegalArgumentException("object cannot be null");
            }
            if (ilvGraphic.getGraphicBag() != this) {
                throw new IllegalArgumentException("object is not in this grapher");
            }
            if (bl) {
                this.initReDraws();
            }
            this.b(bl);
            try {
                if (ilvGraphic instanceof IlvGrapher) {
                    IlvGrapher.a((IlvGrapher)ilvGraphic, (IlvGrapher)ilvGraphic, bl);
                }
                if (this.isNode(ilvGraphic)) {
                    this.removeNode(ilvGraphic, bl);
                } else if (this.isLink(ilvGraphic)) {
                    this.removeLink((IlvLinkImage)ilvGraphic, bl);
                } else {
                    super.removeObject(ilvGraphic, bl);
                }
            }
            finally {
                this.c(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLink(IlvLinkImage ilvLinkImage, boolean bl) {
        IlvManagerLayer ilvManagerLayer = null;
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (ilvLinkImage == null) {
                throw new IllegalArgumentException("object cannot be null");
            }
            if (ilvLinkImage.getGraphicBag() != this) {
                throw new IllegalArgumentException("object in not in this grapher " + ilvLinkImage);
            }
            if (bl) {
                this.initReDraws();
            }
            this.b(bl);
            try {
                IlvGraphic ilvGraphic;
                this.b();
                try {
                    super.removeObject(ilvLinkImage, bl);
                }
                finally {
                    ilvManagerLayer = this.c();
                }
                this.d(ilvLinkImage.getFrom(), ilvLinkImage);
                this.e(ilvLinkImage.getTo(), ilvLinkImage);
                boolean bl2 = false;
                IlvGraphic ilvGraphic2 = ilvLinkImage.getFrom();
                if (ilvGraphic2.getGraphicBag() != this && ilvGraphic2.getGraphicBag() instanceof IlvGrapher) {
                    IlvGrapher.a(ilvGraphic2, ilvLinkImage);
                    ((IlvGrapher)ilvGraphic2.getGraphicBag()).b(ilvLinkImage);
                    this.d(ilvLinkImage);
                    bl2 = true;
                }
                if ((ilvGraphic = ilvLinkImage.getTo()).getGraphicBag() != this && ilvGraphic.getGraphicBag() instanceof IlvGrapher) {
                    IlvGrapher.a(ilvGraphic, ilvLinkImage);
                    ((IlvGrapher)ilvGraphic.getGraphicBag()).b(ilvLinkImage);
                    if (!bl2) {
                        this.d(ilvLinkImage);
                    }
                }
                IlvCachingLinkConnector.LinkRemoved(ilvLinkImage);
            }
            finally {
                this.c(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
        this.a((IlvGraphic)ilvLinkImage, ilvManagerLayer);
    }

    private static void a(IlvGraphic ilvGraphic, IlvLinkImage ilvLinkImage) {
        IlvGraphicBag ilvGraphicBag = ilvLinkImage.getGraphicBag();
        IlvGraphicBag ilvGraphicBag2 = ilvGraphic.getGraphicBag();
        while (ilvGraphicBag2 != null && ilvGraphicBag2 != ilvGraphicBag) {
            IlvManager ilvManager = (IlvManager)ilvGraphicBag2;
            IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvManager);
            if (ilvLinkConnector != null) {
                ilvLinkConnector.linkRemoved(ilvLinkImage);
            }
            ilvGraphicBag2 = ilvManager.getGraphicBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(IlvGraphic ilvGraphic, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (ilvGraphic == null) {
                throw new IllegalArgumentException("object cannot be null");
            }
            if (ilvGraphic.getGraphicBag() != this) {
                throw new IllegalArgumentException("object in not in this grapher " + ilvGraphic);
            }
            if (bl) {
                this.initReDraws();
            }
            this.b(bl);
            try {
                IlvLinkImage ilvLinkImage;
                if (ilvGraphic instanceof IlvGrapher) {
                    IlvGrapher.a((IlvGrapher)ilvGraphic, (IlvGrapher)ilvGraphic, bl);
                }
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinksFrom(ilvGraphic);
                IlvGraphicEnumeration ilvGraphicEnumeration2 = this.getLinksTo(ilvGraphic);
                this.f(ilvGraphic);
                this.g(ilvGraphic);
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                    if (ilvLinkImage.getTo() == ilvGraphic) continue;
                    if (ilvLinkImage.getGraphicBag() != this) {
                        ilvLinkImage.getGraphicBag().removeObject(ilvLinkImage, bl);
                        continue;
                    }
                    this.removeLink(ilvLinkImage, bl);
                }
                while (ilvGraphicEnumeration2.hasMoreElements()) {
                    ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration2.nextElement();
                    if (ilvLinkImage.getGraphicBag() != this) {
                        ilvLinkImage.getGraphicBag().removeObject(ilvLinkImage, bl);
                        continue;
                    }
                    this.removeLink(ilvLinkImage, bl);
                }
                IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
                if (ilvLinkConnector != null) {
                    ilvLinkConnector.allLinksRemoved();
                }
                super.removeObject(ilvGraphic, bl);
            }
            finally {
                this.c(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    private static void a(IlvManager ilvManager, IlvGrapher ilvGrapher, boolean bl) {
        Serializable serializable;
        Object object;
        if (ilvManager instanceof IlvGrapher) {
            object = (IlvGrapher)ilvManager;
            if (((IlvGrapher)object).g != null) {
                serializable = ((IlvGrapher)object).g;
                ArrayList<IlvLinkImage> arrayList = null;
                ((IlvGrapher)object).g = null;
                int n = ((ArrayList)serializable).size();
                for (int i = 0; i < n; ++i) {
                    IlvLinkImage ilvLinkImage = (IlvLinkImage)((ArrayList)serializable).get(i);
                    if (ilvManager == ilvGrapher || IlvUtility.isOutside(ilvGrapher, ilvLinkImage.getFrom()) || IlvUtility.isOutside(ilvGrapher, ilvLinkImage.getTo())) {
                        IlvGraphicBag ilvGraphicBag = ilvLinkImage.getGraphicBag();
                        if (ilvGraphicBag == null || !(ilvGraphicBag instanceof IlvManager)) continue;
                        ilvGraphicBag.removeObject(ilvLinkImage, bl);
                        continue;
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<IlvLinkImage>();
                    }
                    arrayList.add(ilvLinkImage);
                }
                ((IlvGrapher)object).g = arrayList;
            }
        }
        if (ilvManager.getManagersCount() != 0) {
            object = ilvManager.getManagers();
            while (object.hasMoreElements()) {
                serializable = (IlvManager)object.nextElement();
                IlvGrapher.a((IlvManager)serializable, ilvGrapher, bl);
            }
        }
    }

    public final int getLinksInsertionLayer() {
        return this.e == -1 ? super.getInsertionLayer() : this.e;
    }

    public final void setLinksInsertionLayer(int n) {
        this.e = n;
    }

    @Override
    public void setLayer(IlvGraphic ilvGraphic, int n, boolean bl) {
        super.setLayer(ilvGraphic, n, bl);
    }

    @Override
    public void replaceObject(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        if (ilvGraphic == null || ilvGraphic2 == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (ilvGraphic == ilvGraphic2) {
            throw new IllegalArgumentException("Object " + ilvGraphic2 + ": " + "Cannot replace with same object");
        }
        if (ilvGraphic2.getGraphicBag() != null) {
            throw new IllegalArgumentException("Object " + ilvGraphic2 + ": " + "New object is already in a bag");
        }
        if (!this.isManaged(ilvGraphic)) {
            throw new IllegalArgumentException("Object " + ilvGraphic + " is not in this manager");
        }
        if (this.isNode(ilvGraphic)) {
            this.a(ilvGraphic, ilvGraphic2, bl);
        } else if (this.isLink(ilvGraphic) && ilvGraphic2 instanceof IlvLinkImage) {
            this.a((IlvLinkImage)ilvGraphic, (IlvLinkImage)ilvGraphic2, bl);
        } else {
            super.replaceObject(ilvGraphic, ilvGraphic2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (bl) {
                this.initReDraws();
            }
            this.b(bl);
            try {
                LinkInfo linkInfo;
                IlvLinkImage ilvLinkImage;
                int n;
                int n2;
                Object object;
                IlvGraphicVector ilvGraphicVector = null;
                IlvGraphicVector ilvGraphicVector2 = null;
                ArrayList<LinkInfo> arrayList = null;
                ArrayList<LinkInfo> arrayList2 = null;
                int n3 = this.getLinksToCount(ilvGraphic);
                if (n3 != 0) {
                    arrayList2 = new ArrayList<LinkInfo>(n3);
                    IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinksTo(ilvGraphic);
                    ilvGraphicVector = new IlvGraphicVector(n3);
                    while (ilvGraphicEnumeration.hasMoreElements()) {
                        object = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                        ilvGraphicVector.addElement((IlvGraphic)object);
                        arrayList2.add(new LinkInfo((IlvLinkImage)object));
                    }
                }
                if ((n2 = this.getLinksFromCount(ilvGraphic)) != 0) {
                    arrayList = new ArrayList<LinkInfo>(n2);
                    ilvGraphicVector2 = new IlvGraphicVector(n2);
                    object = this.getLinksFrom(ilvGraphic);
                    while (object.hasMoreElements()) {
                        IlvLinkImage ilvLinkImage2 = (IlvLinkImage)object.nextElement();
                        ilvGraphicVector2.addElement(ilvLinkImage2);
                        arrayList.add(new LinkInfo(ilvLinkImage2));
                    }
                }
                object = IlvLinkConnector.GetAttached(ilvGraphic);
                super.replaceObject(ilvGraphic, ilvGraphic2, bl);
                this.makeNode(ilvGraphic2);
                if (object != null) {
                    ((IlvLinkConnector)object).attach(ilvGraphic2, bl);
                }
                for (n = 0; n < n3; ++n) {
                    ilvLinkImage = (IlvLinkImage)ilvGraphicVector.elementAt(n);
                    ilvLinkImage.b = ilvGraphic2;
                }
                for (n = 0; n < n2; ++n) {
                    ilvLinkImage = (IlvLinkImage)ilvGraphicVector2.elementAt(n);
                    ilvLinkImage.a = ilvGraphic2;
                }
                for (n = 0; n < n3; ++n) {
                    ilvLinkImage = (IlvLinkImage)ilvGraphicVector.elementAt(n);
                    linkInfo = (LinkInfo)arrayList2.get(n);
                    ilvLinkImage.setVisible(linkInfo.g);
                    linkInfo.a.addLink(ilvLinkImage, linkInfo.b, bl);
                    if (linkInfo.d) {
                        linkInfo.a.setSelected((IlvGraphic)ilvLinkImage, true, bl);
                    }
                    linkInfo.a.setSelectable(ilvLinkImage, linkInfo.f);
                    linkInfo.a.setEditable(ilvLinkImage, linkInfo.e);
                    linkInfo.a.setMovable(ilvLinkImage, linkInfo.c);
                }
                for (n = 0; n < n2; ++n) {
                    ilvLinkImage = (IlvLinkImage)ilvGraphicVector2.elementAt(n);
                    if (ilvLinkImage.getGraphicBag() != null) continue;
                    linkInfo = (LinkInfo)arrayList.get(n);
                    ilvLinkImage.setVisible(linkInfo.g);
                    linkInfo.a.addLink(ilvLinkImage, linkInfo.b, bl);
                    if (linkInfo.d) {
                        linkInfo.a.setSelected((IlvGraphic)ilvLinkImage, true, bl);
                    }
                    linkInfo.a.setSelectable(ilvLinkImage, linkInfo.f);
                    linkInfo.a.setEditable(ilvLinkImage, linkInfo.e);
                    linkInfo.a.setMovable(ilvLinkImage, linkInfo.c);
                }
            }
            finally {
                this.c(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (bl) {
                this.initReDraws();
            }
            this.b(bl);
            try {
                IlvGraphic ilvGraphic = ilvLinkImage.getFrom();
                IlvGraphic ilvGraphic2 = ilvLinkImage.getTo();
                ilvLinkImage2.a = ilvGraphic;
                ilvLinkImage2.b = ilvGraphic2;
                String string = ilvLinkImage.getName();
                boolean bl2 = this.isMovable(ilvLinkImage);
                boolean bl3 = this.isEditable(ilvLinkImage);
                boolean bl4 = this.isSelectable(ilvLinkImage);
                boolean bl5 = this.isSelected(ilvLinkImage);
                boolean bl6 = ilvLinkImage.isVisible();
                int n = this.getLayer(ilvLinkImage);
                this.removeObject(ilvLinkImage, bl);
                ilvLinkImage2.setVisible(bl6);
                this.addLink(ilvLinkImage2, n, bl);
                if (bl5) {
                    this.setSelected((IlvGraphic)ilvLinkImage2, true, bl);
                }
                this.setSelectable(ilvLinkImage2, bl4);
                this.setEditable(ilvLinkImage2, bl3);
                this.setMovable(ilvLinkImage2, bl2);
                if (string != null) {
                    this.setObjectName(ilvLinkImage2, string);
                }
            }
            finally {
                this.c(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    public final IlvGraphicEnumeration getLinksFrom(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            if (ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode()) {
                return ilvGrapherObjectProperty.q();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    private final IlvGraphicVector d(IlvGraphic ilvGraphic) {
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        if (ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode()) {
            return ilvGrapherObjectProperty.r();
        }
        throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
    }

    public final int getLinksFromCount(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            if (ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode()) {
                return ilvGrapherObjectProperty.s();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    public final IlvGraphicEnumeration getLinksTo(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            if (ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode()) {
                return ilvGrapherObjectProperty.n();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    private final IlvGraphicVector e(IlvGraphic ilvGraphic) {
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        if (ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode()) {
            return ilvGrapherObjectProperty.o();
        }
        throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
    }

    public final int getLinksToCount(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            if (ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode()) {
                return ilvGrapherObjectProperty.p();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    public final IlvGraphicEnumeration getLinks(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            if (ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode()) {
                return ilvGrapherObjectProperty.t();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    public final int getLinksCount(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            if (ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode()) {
                return ilvGrapherObjectProperty.u();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    public final IlvGraphicEnumeration getNeighbors(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (this.isNode(ilvGraphic)) {
                return new IlvNeighborsEnumeration(ilvGraphic, this.getLinks(ilvGraphic));
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    public final IlvGraphicEnumeration getFromNeighbors(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (this.isNode(ilvGraphic)) {
                return new IlvNeighborsEnumeration(ilvGraphic, this.getLinksFrom(ilvGraphic));
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    public final IlvGraphicEnumeration getToNeighbors(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (this.isNode(ilvGraphic)) {
                return new IlvNeighborsEnumeration(ilvGraphic, this.getLinksTo(ilvGraphic));
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Not a node");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvGraphicEnumeration getLinksVisibleFrom(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            return new IlvGraphicEnumeration(){
                IlvGraphicEnumeration a = IlvGrapher.this.getLinksFrom(ilvGraphic2);
                IlvGraphicEnumeration b = null;
                IlvLinkImage c;
                HashSet d = null;
                {
                    if (ilvGraphic2 instanceof IlvGrapher && ((IlvGrapher)ilvGraphic2).isCollapsed()) {
                        this.b = ((IlvGrapher)ilvGraphic2).getTreeExternalInterGraphLinks();
                        this.d = new HashSet();
                    }
                    this.a();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.c != null;
                }

                @Override
                public IlvGraphic nextElement() {
                    if (this.c == null) {
                        throw new NoSuchElementException("getLinksVisibleFrom");
                    }
                    IlvLinkImage ilvLinkImage = this.c;
                    this.a();
                    return ilvLinkImage;
                }

                private void a() {
                    this.c = null;
                    while (this.a.hasMoreElements()) {
                        this.c = (IlvLinkImage)this.a.nextElement();
                        if (this.c.getVisibleFrom() != ilvGraphic2) continue;
                        if (this.d != null) {
                            this.d.add(this.c);
                        }
                        return;
                    }
                    if (this.b != null) {
                        while (this.b.hasMoreElements()) {
                            this.c = (IlvLinkImage)this.b.nextElement();
                            if (this.d.contains(this.c) || this.c.getVisibleFrom() != ilvGraphic2) continue;
                            return;
                        }
                    }
                    this.c = null;
                }
            };
        }
    }

    public final int getLinksVisibleFromCount(IlvGraphic ilvGraphic) {
        int n = 0;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinksVisibleFrom(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvGraphicEnumeration.nextElement();
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvGraphicEnumeration getLinksVisibleTo(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            return new IlvGraphicEnumeration(){
                IlvGraphicEnumeration a = IlvGrapher.this.getLinksTo(ilvGraphic2);
                IlvGraphicEnumeration b = null;
                IlvLinkImage c;
                HashSet d = null;
                {
                    if (ilvGraphic2 instanceof IlvGrapher && ((IlvGrapher)ilvGraphic2).isCollapsed()) {
                        this.b = ((IlvGrapher)ilvGraphic2).getTreeExternalInterGraphLinks();
                        this.d = new HashSet();
                    }
                    this.a();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.c != null;
                }

                @Override
                public IlvGraphic nextElement() {
                    if (this.c == null) {
                        throw new NoSuchElementException("getLinksVisibleTo");
                    }
                    IlvLinkImage ilvLinkImage = this.c;
                    this.a();
                    return ilvLinkImage;
                }

                private void a() {
                    this.c = null;
                    while (this.a.hasMoreElements()) {
                        this.c = (IlvLinkImage)this.a.nextElement();
                        if (this.c.getVisibleTo() != ilvGraphic2) continue;
                        if (this.d != null) {
                            this.d.add(this.c);
                        }
                        return;
                    }
                    if (this.b != null) {
                        while (this.b.hasMoreElements()) {
                            this.c = (IlvLinkImage)this.b.nextElement();
                            if (this.d.contains(this.c) || this.c.getVisibleTo() != ilvGraphic2) continue;
                            return;
                        }
                    }
                    this.c = null;
                }
            };
        }
    }

    public final int getLinksVisibleToCount(IlvGraphic ilvGraphic) {
        int n = 0;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinksVisibleTo(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvGraphicEnumeration.nextElement();
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isNode(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (ilvGraphic instanceof IlvLinkImage) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            return ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode() && ilvGraphic.getGraphicBag() == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLink(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (!(ilvGraphic instanceof IlvLinkImage)) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            return ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isLink() && ilvGraphic.getGraphicBag() == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isNodeOrLink(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            return ilvGrapherObjectProperty != null && (ilvGrapherObjectProperty.isNode() || ilvGrapherObjectProperty.isLink()) && ilvGraphic.getGraphicBag() == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInterGraphLink(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (this.isLink(ilvGraphic)) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
                return ilvLinkImage.getFrom().getGraphicBag() != this || ilvLinkImage.getTo().getGraphicBag() != this;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMarked(IlvGraphic ilvGraphic, boolean bl) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            if (ilvGrapherObjectProperty != null && ilvGraphic.getGraphicBag() == this) {
                ilvGrapherObjectProperty.h(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isMarked(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            return ilvGrapherObjectProperty != null && ilvGraphic.getGraphicBag() == this && ilvGrapherObjectProperty.m();
        }
    }

    private final void b(IlvGraphic ilvGraphic, IlvLinkImage ilvLinkImage) {
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        if (ilvGrapherObjectProperty == null) {
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Origin node of link " + ilvLinkImage + " is not in grapher");
        }
        if (!ilvGrapherObjectProperty.isNode()) {
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + a);
        }
        ilvGrapherObjectProperty.a(ilvLinkImage);
    }

    private void c(IlvGraphic ilvGraphic, IlvLinkImage ilvLinkImage) {
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        if (ilvGrapherObjectProperty == null) {
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + "Destination node of link " + ilvLinkImage + " is not in grapher");
        }
        if (!ilvGrapherObjectProperty.isNode()) {
            throw new IllegalArgumentException("Object " + ilvGraphic + ": " + a);
        }
        ilvGrapherObjectProperty.c(ilvLinkImage);
    }

    private final void d(IlvGraphic ilvGraphic, IlvLinkImage ilvLinkImage) {
        IlvLinkConnector ilvLinkConnector;
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        ilvGrapherObjectProperty.b(ilvLinkImage);
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        IlvManager ilvManager = ilvGraphicBag != this ? (IlvManager)ilvGraphicBag : this;
        if (!ilvManager.a() && !ilvGrapherObjectProperty.j().b() && (ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic)) != null) {
            ilvLinkConnector.linkRemoved(ilvLinkImage);
        }
    }

    private void f(IlvGraphic ilvGraphic) {
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        ilvGrapherObjectProperty.v();
    }

    private void g(IlvGraphic ilvGraphic) {
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        ilvGrapherObjectProperty.w();
    }

    private void e(IlvGraphic ilvGraphic, IlvLinkImage ilvLinkImage) {
        IlvLinkConnector ilvLinkConnector;
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        ilvGrapherObjectProperty.d(ilvLinkImage);
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        IlvManager ilvManager = ilvGraphicBag != this ? (IlvManager)ilvGraphicBag : this;
        if (!ilvManager.a() && !ilvGrapherObjectProperty.j().b() && (ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic)) != null) {
            ilvLinkConnector.linkRemoved(ilvLinkImage);
        }
    }

    @Override
    protected IlvObjectProperty makeObjectProperty(IlvGraphic ilvGraphic) {
        IlvGrapherObjectProperty ilvGrapherObjectProperty = null;
        if (this.c) {
            ilvGrapherObjectProperty = new IlvGrapherObjectProperty(true);
            this.c = false;
        } else if (this.d) {
            ilvGrapherObjectProperty = new IlvGrapherLinkProperty();
            this.d = false;
            IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
            IlvGraphic ilvGraphic2 = ilvLinkImage.getFrom();
            IlvGraphic ilvGraphic3 = ilvLinkImage.getTo();
            this.b(ilvGraphic2, ilvLinkImage);
            this.c(ilvGraphic3, ilvLinkImage);
            ilvGraphic.setMovable(false);
            ilvGrapherObjectProperty.a(true);
            if (ilvGraphic2.getGraphicBag() != this && ilvGraphic2.getGraphicBag() instanceof IlvGrapher) {
                ((IlvGrapher)ilvGraphic2.getGraphicBag()).a(ilvLinkImage);
            }
            if (ilvGraphic3.getGraphicBag() != this && ilvGraphic3.getGraphicBag() instanceof IlvGrapher) {
                ((IlvGrapher)ilvGraphic3.getGraphicBag()).a(ilvLinkImage);
            }
        } else {
            ilvGrapherObjectProperty = new IlvGrapherObjectProperty();
        }
        return ilvGrapherObjectProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean b(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            return ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isNode() ? ilvGrapherObjectProperty.u() > 0 : false;
        }
    }

    protected HashSet getBoundingBoxDependentObjects(IlvGraphic ilvGraphic, boolean bl) {
        IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage;
        IlvGraphic ilvGraphic2;
        HashSet<IlvGraphic> hashSet = null;
        if (this.isNode(ilvGraphic)) {
            hashSet = new HashSet<IlvGraphic>();
            this.a(ilvGraphic, hashSet, bl);
        } else if (ilvGraphic instanceof IlvGrapher && bl) {
            hashSet = new HashSet();
            this.a((IlvManager)ilvGraphic, (IlvGrapher)ilvGraphic, hashSet);
        }
        if (ilvGraphic instanceof IlvCrossingAwareLinkImage && (ilvGraphic2 = (ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)ilvGraphic).getCrossingGraphic()) != null && ilvGraphic2.getGraphicBag() != null) {
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.add(ilvGraphic2);
        }
        return hashSet;
    }

    private void a(IlvGraphic ilvGraphic, HashSet hashSet, boolean bl) {
        IlvLinkImage ilvLinkImage;
        int n;
        IlvGraphicVector ilvGraphicVector = this.e(ilvGraphic);
        int n2 = ilvGraphicVector == null ? 0 : ilvGraphicVector.size();
        for (n = 0; n < n2; ++n) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicVector.elementAt(n);
            if (hashSet.contains(ilvLinkImage)) continue;
            hashSet.add(ilvLinkImage);
        }
        ilvGraphicVector = this.d(ilvGraphic);
        n2 = ilvGraphicVector == null ? 0 : ilvGraphicVector.size();
        for (n = 0; n < n2; ++n) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicVector.elementAt(n);
            if (hashSet.contains(ilvLinkImage)) continue;
            hashSet.add(ilvLinkImage);
        }
        if (ilvGraphic instanceof IlvGrapher && bl) {
            this.a((IlvManager)ilvGraphic, (IlvGrapher)ilvGraphic, hashSet);
        }
    }

    private void a(IlvManager ilvManager, IlvGrapher ilvGrapher, HashSet hashSet) {
        Object object;
        IlvGrapher ilvGrapher2;
        int n;
        if (ilvManager instanceof IlvGrapher && (n = (ilvGrapher2 = (IlvGrapher)ilvManager).getExternalInterGraphLinksCount()) > 0) {
            object = ilvGrapher2.getExternalInterGraphLinks();
            while (object.hasMoreElements()) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)object.nextElement();
                if (ilvManager != ilvGrapher && !IlvUtility.isOutside(ilvGrapher, ilvLinkImage.getFrom()) && !IlvUtility.isOutside(ilvGrapher, ilvLinkImage.getTo()) || ilvLinkImage.getGraphicBag() == null || hashSet.contains(ilvLinkImage)) continue;
                hashSet.add(ilvLinkImage);
            }
        }
        int n2 = ilvManager.getLayersCount();
        for (n = 0; n < n2; ++n) {
            object = ilvManager.getManagerLayer(n).e();
            if (object == null) continue;
            int n3 = ((IlvGraphicVector)object).size();
            for (int i = 0; i < n3; ++i) {
                IlvManager ilvManager2 = (IlvManager)((IlvGraphicVector)object).elementAt(i);
                this.a(ilvManager2, ilvGrapher, hashSet);
            }
        }
    }

    @Override
    protected void beforeTransformObj(IlvGraphic ilvGraphic, boolean bl, boolean bl2, boolean bl3) {
        super.beforeTransformObj(ilvGraphic, bl, bl2, bl3);
        HashSet hashSet = this.getBoundingBoxDependentObjects(ilvGraphic, !bl2);
        if (hashSet != null && hashSet.size() != 0) {
            this.beforeTransformDependentObjs(hashSet, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterTransformObj(IlvGraphic ilvGraphic, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        HashSet hashSet;
        if (ilvGraphic instanceof IlvLinkImage) {
            IlvCachingLinkConnector.LinkChanged((IlvLinkImage)ilvGraphic);
        }
        if ((hashSet = this.getBoundingBoxDependentObjects(ilvGraphic, !bl2)) != null && hashSet.size() != 0) {
            this.afterTransformDependentObjs(hashSet, bl, bl2);
        } else {
            hashSet = null;
        }
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        if (ilvGrapherObjectProperty != null) {
            ilvGrapherObjectProperty.a(hashSet);
        }
        try {
            super.afterTransformObj(ilvGraphic, bl, bl2, bl3, bl4);
        }
        finally {
            if (ilvGrapherObjectProperty != null) {
                ilvGrapherObjectProperty.a((HashSet)null);
            }
        }
    }

    protected void beforeTransformDependentObjs(HashSet hashSet, boolean bl, boolean bl2) {
        for (IlvGraphic ilvGraphic : hashSet) {
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag != null && ilvGraphicBag instanceof IlvManager) {
                ((IlvManager)ilvGraphicBag).beforeTransform(ilvGraphic, bl, bl2, false);
                continue;
            }
            throw new Error("should not happen: bag = " + ilvGraphicBag);
        }
    }

    protected void afterTransformDependentObjs(HashSet hashSet, boolean bl, boolean bl2) {
        for (IlvGraphic ilvGraphic : hashSet) {
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag != null && ilvGraphicBag instanceof IlvManager) {
                ((IlvManager)ilvGraphicBag).afterTransform(ilvGraphic, bl, bl2, false, false);
                continue;
            }
            throw new Error("should not happen: bag = " + ilvGraphicBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void a(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        HashSet hashSet = null;
        IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
        if (ilvGrapherObjectProperty != null) {
            hashSet = ilvGrapherObjectProperty.l();
        }
        if (hashSet != null && hashSet.size() > 0) {
            this.setContentsAdjusting(true, true);
            try {
                this.a(ilvGraphic, ilvRect, bl, hashSet);
            }
            finally {
                this.setContentsAdjusting(false, true);
            }
        } else {
            this.a(ilvGraphic, ilvRect, bl, null);
        }
    }

    private void a(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl, HashSet hashSet) {
        if (hashSet != null) {
            for (IlvGraphic ilvGraphic2 : hashSet) {
                IlvGraphicBag ilvGraphicBag = ilvGraphic2.getGraphicBag();
                if (ilvGraphicBag == this) {
                    super.a(ilvGraphic2, (IlvRect)null, false);
                    continue;
                }
                if (ilvGraphicBag != null && ilvGraphicBag instanceof IlvManager) {
                    ((IlvManager)ilvGraphicBag).a(ilvGraphic2, (IlvRect)null, false);
                    continue;
                }
                throw new Error("should not happen: bag = " + ilvGraphicBag);
            }
        }
        super.a(ilvGraphic, ilvRect, bl);
    }

    public final boolean nodeHasSons(IlvGraphic ilvGraphic) {
        return this.getLinksFromCount(ilvGraphic) > 0;
    }

    public final boolean isLinkBetween(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        IlvLinkImage ilvLinkImage;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinksFrom(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
            if (ilvLinkImage.getTo() != ilvGraphic2) continue;
            return true;
        }
        ilvGraphicEnumeration = this.getLinksFrom(ilvGraphic2);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
            if (ilvLinkImage.getTo() != ilvGraphic) continue;
            return true;
        }
        return false;
    }

    public void makeNode(IlvGraphic ilvGraphic) {
        IlvGrapherObjectProperty ilvGrapherObjectProperty;
        if (!this.isNode(ilvGraphic) && !this.isLink(ilvGraphic) && (ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m()) != null && ilvGraphic.getGraphicBag() == this) {
            ilvGrapherObjectProperty.g(true);
        }
    }

    public void unmakeNode(IlvGraphic ilvGraphic) {
        if (this.isNode(ilvGraphic)) {
            if (this.getLinksCount(ilvGraphic) > 0) {
                throw new IllegalArgumentException("Node " + ilvGraphic + " cannot become non-node because it has links");
            }
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)ilvGraphic.m();
            if (ilvGrapherObjectProperty != null && ilvGraphic.getGraphicBag() == this) {
                ilvGrapherObjectProperty.g(false);
            }
        }
    }

    @Override
    final boolean a(IlvGraphic ilvGraphic) {
        if (!super.a(ilvGraphic)) {
            return false;
        }
        if (this.isLink(ilvGraphic)) {
            IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
            return this.isSelected(ilvLinkImage.getFrom()) && this.isMovable(ilvLinkImage.getFrom()) && this.isSelected(ilvLinkImage.getTo()) && this.isMovable(ilvLinkImage.getTo());
        }
        return true;
    }

    @Override
    boolean f() {
        return true;
    }

    @Override
    IlvGraphicVector a(IlvGraphicVector ilvGraphicVector) {
        IlvGraphicBag ilvGraphicBag;
        IlvGraphic ilvGraphic;
        int n;
        IlvGraphicVector ilvGraphicVector2 = new IlvGraphicVector();
        int n2 = ilvGraphicVector.size();
        for (n = 0; n < n2; ++n) {
            ilvGraphic = ilvGraphicVector.elementAt(n);
            ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (!(ilvGraphicBag instanceof IlvGrapher) || !((IlvGrapher)ilvGraphicBag).isNode(ilvGraphic)) continue;
            ilvGraphicVector2.addElement(ilvGraphic);
        }
        for (n = 0; n < n2; ++n) {
            ilvGraphic = ilvGraphicVector.elementAt(n);
            ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag instanceof IlvGrapher && ((IlvGrapher)ilvGraphicBag).isNode(ilvGraphic)) continue;
            ilvGraphicVector2.addElement(ilvGraphic);
        }
        return ilvGraphicVector2;
    }

    @Override
    IlvGraphic a(IlvGraphic ilvGraphic, HashMap hashMap) {
        Serializable serializable;
        Serializable serializable2;
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        IlvGraphic ilvGraphic2 = ilvGraphic.copy();
        if (ilvGraphic2 == null) {
            return null;
        }
        hashMap.put(ilvGraphic, ilvGraphic2);
        if (!(ilvGraphicBag instanceof IlvGrapher)) {
            return ilvGraphic2;
        }
        IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphicBag;
        if (ilvGrapher.isNode(ilvGraphic) && (serializable2 = this.a((IlvLinkConnector)(serializable = IlvLinkConnector.GetAttached(ilvGraphic)))) != null) {
            ((IlvLinkConnector)serializable2).attach(ilvGraphic2, false);
        }
        if (ilvGrapher.isLink(ilvGraphic)) {
            IlvRect ilvRect;
            IlvRect ilvRect2;
            Serializable serializable3;
            Serializable serializable4;
            serializable = ilvGrapher.getTopLevelTransformer();
            serializable2 = new IlvPoint();
            IlvPoint ilvPoint = new IlvPoint();
            IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
            ilvLinkImage.getConnectionPoints((IlvPoint)serializable2, ilvPoint, (IlvTransformer)serializable);
            IlvLinkImage ilvLinkImage2 = (IlvLinkImage)ilvGraphic2;
            IlvGraphic ilvGraphic3 = this.b(ilvLinkImage2.getFrom(), hashMap);
            if (ilvGraphic3 != null) {
                serializable4 = (IlvManager)ilvLinkImage2.getFrom().getGraphicBag();
                serializable3 = serializable4 == ilvGrapher ? serializable : ((IlvManager)serializable4).getTopLevelTransformer();
                ilvRect2 = ilvLinkImage2.getFrom().boundingBox((IlvTransformer)serializable3);
                serializable4 = (IlvManager)ilvGraphic3.getGraphicBag();
                serializable3 = serializable4 == ilvGrapher ? serializable : ((IlvManager)serializable4).getTopLevelTransformer();
                ilvRect = ilvGraphic3.boundingBox((IlvTransformer)serializable3);
                ilvLinkImage2.setFrom(ilvGraphic3);
                ((IlvPoint)serializable2).translate(ilvRect.x - ilvRect2.x, ilvRect.y - ilvRect2.y);
            }
            if ((ilvGraphic3 = this.b(ilvLinkImage2.getTo(), hashMap)) != null) {
                serializable4 = (IlvManager)ilvLinkImage2.getTo().getGraphicBag();
                serializable3 = serializable4 == ilvGrapher ? serializable : ((IlvManager)serializable4).getTopLevelTransformer();
                ilvRect2 = ilvLinkImage2.getTo().boundingBox((IlvTransformer)serializable3);
                serializable4 = (IlvManager)ilvGraphic3.getGraphicBag();
                serializable3 = serializable4 == ilvGrapher ? serializable : ((IlvManager)serializable4).getTopLevelTransformer();
                ilvRect = ilvGraphic3.boundingBox((IlvTransformer)serializable3);
                ilvLinkImage2.setTo(ilvGraphic3);
                ilvPoint.translate(ilvRect.x - ilvRect2.x, ilvRect.y - ilvRect2.y);
            }
            if ((serializable3 = this.a((IlvLinkConnector)(serializable4 = IlvLinkConnector.GetAttached(ilvLinkImage, true)))) != null) {
                ((IlvLinkConnector)serializable3).attach(ilvLinkImage2, true, false);
            }
            if ((serializable3 = this.a((IlvLinkConnector)(serializable4 = IlvLinkConnector.GetAttached(ilvLinkImage, false)))) != null) {
                ((IlvLinkConnector)serializable3).attach(ilvLinkImage2, false, false);
            }
            ((IlvTransformer)serializable).inverse((IlvPoint)serializable2);
            ((IlvTransformer)serializable).inverse(ilvPoint);
            ilvLinkImage2.movePoint(0, ((Point2D.Float)serializable2).x, ((Point2D.Float)serializable2).y, (IlvTransformer)serializable);
            ilvLinkImage2.movePoint(ilvLinkImage2.getPointsCardinal() - 1, ilvPoint.x, ilvPoint.y, (IlvTransformer)serializable);
        }
        return ilvGraphic2;
    }

    private IlvGraphic b(IlvGraphic ilvGraphic, HashMap hashMap) {
        if (ilvGraphic == null) {
            return null;
        }
        IlvGraphic ilvGraphic2 = (IlvGraphic)hashMap.get(ilvGraphic);
        if (ilvGraphic2 != null) {
            return ilvGraphic2;
        }
        if (!(ilvGraphic.getGraphicBag() instanceof IlvManager)) {
            return null;
        }
        IlvManager ilvManager = (IlvManager)ilvGraphic.getGraphicBag();
        IlvManager ilvManager2 = (IlvManager)this.b((IlvGraphic)ilvManager, hashMap);
        if (ilvManager2 != null) {
            int n = ilvManager.getLayer(ilvGraphic);
            if (n < 0 || n >= ilvManager.getLayersCount()) {
                return null;
            }
            int n2 = ilvManager.getManagerLayer(n).getIndex(ilvGraphic);
            if (n2 < 0) {
                return null;
            }
            if (n < 0 || n >= ilvManager2.getLayersCount()) {
                return null;
            }
            IlvManagerLayer ilvManagerLayer = ilvManager2.getManagerLayer(n);
            if (n2 >= ilvManagerLayer.getCardinal()) {
                return null;
            }
            return ilvManagerLayer.getObject(n2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IlvLinkConnector a(IlvLinkConnector ilvLinkConnector) {
        if (ilvLinkConnector == null) {
            return null;
        }
        if (!ilvLinkConnector.isPersistent()) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IlvOutputStream ilvOutputStream = this.createOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            ilvOutputStream.write("LC", ilvLinkConnector);
            ilvOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IlvInputStream ilvInputStream = this.createInputStream(byteArrayInputStream);
        ilvInputStream.setDocumentBase(this.ax);
        ilvInputStream.setCopyPasteMode();
        try {
            IlvLinkConnector ilvLinkConnector2 = (IlvLinkConnector)ilvInputStream.readPersistentObject("LC");
            if (ilvLinkConnector2 != null) {
                ilvLinkConnector2.detach(true);
            }
            IlvLinkConnector ilvLinkConnector3 = ilvLinkConnector2;
            return ilvLinkConnector3;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    @Override
    void a(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        if (this.isNode(ilvGraphic)) {
            this.addNode(ilvGraphic2, true);
        } else if (this.isLink(ilvGraphic)) {
            this.addLink((IlvLinkImage)ilvGraphic2, true);
        } else {
            super.a(ilvGraphic, ilvGraphic2);
        }
    }

    @Override
    public IlvGraphicEnumeration getSelectedMovingObjects(boolean[] blArray) {
        if (blArray[0]) {
            return this.a(blArray);
        }
        return super.getSelectedMovingObjects(blArray);
    }

    private IlvGraphicEnumeration a(boolean[] blArray) {
        Object object;
        Serializable serializable;
        boolean bl = blArray[2];
        IlvGraphicVector ilvGraphicVector = new IlvGraphicVector();
        HashSet<Serializable> hashSet = new HashSet<Serializable>();
        IlvGraphicEnumeration ilvGraphicEnumeration = super.getSelectedMovingObjects(blArray);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            serializable = ilvGraphicEnumeration.nextElement();
            ilvGraphicVector.addElement((IlvGraphic)serializable);
            hashSet.add(serializable);
        }
        serializable = new ArrayList();
        IlvGraphicEnumeration ilvGraphicEnumeration2 = ilvGraphicVector.elements();
        while (ilvGraphicEnumeration2.hasMoreElements()) {
            IlvGraphic ilvGraphic;
            IlvGrapher ilvGrapher;
            object = ilvGraphicEnumeration2.nextElement();
            IlvGraphicBag ilvGraphicBag = ((IlvGraphic)object).getGraphicBag();
            if (!(ilvGraphicBag instanceof IlvGrapher) || !(ilvGrapher = (IlvGrapher)ilvGraphicBag).isNode((IlvGraphic)object)) continue;
            IlvGraphicEnumeration ilvGraphicEnumeration3 = ilvGrapher.getLinksFrom((IlvGraphic)object);
            while (ilvGraphicEnumeration3.hasMoreElements()) {
                ilvGraphic = (IlvLinkImage)ilvGraphicEnumeration3.nextElement();
                if (!this.a((IlvLinkImage)ilvGraphic, hashSet, bl, false)) continue;
                ((ArrayList)serializable).add(ilvGraphic);
                hashSet.add(ilvGraphic);
            }
            if (!(object instanceof IlvGrapher)) continue;
            ilvGraphic = (IlvGrapher)object;
            ilvGraphicEnumeration3 = ((IlvGrapher)ilvGraphic).getTreeExternalInterGraphLinks();
            while (ilvGraphicEnumeration3.hasMoreElements()) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration3.nextElement();
                if (!this.a(ilvLinkImage, hashSet, bl, true)) continue;
                ((ArrayList)serializable).add(ilvLinkImage);
                hashSet.add(ilvLinkImage);
            }
        }
        object = ((ArrayList)serializable).iterator();
        while (object.hasNext()) {
            ilvGraphicVector.addElement((IlvGraphic)object.next());
        }
        return ilvGraphicVector.elements();
    }

    private boolean a(IlvLinkImage ilvLinkImage, HashSet hashSet, boolean bl, boolean bl2) {
        if (bl2 && !this.a(ilvLinkImage.getFrom(), hashSet)) {
            return false;
        }
        if (!this.a(ilvLinkImage.getTo(), hashSet)) {
            return false;
        }
        if (!this.a(ilvLinkImage, bl)) {
            return false;
        }
        return !hashSet.contains(ilvLinkImage);
    }

    private boolean a(IlvGraphic ilvGraphic, HashSet hashSet) {
        while (ilvGraphic != null) {
            if (hashSet.contains(ilvGraphic)) {
                return true;
            }
            ilvGraphic = (IlvGraphic)((Object)ilvGraphic.getGraphicBag());
        }
        return false;
    }

    private boolean a(IlvLinkImage ilvLinkImage, boolean bl) {
        if (bl) {
            IlvGraphicBag ilvGraphicBag = ilvLinkImage.getGraphicBag();
            while (ilvGraphicBag != null) {
                if (ilvGraphicBag == this) {
                    return true;
                }
                if (!(ilvGraphicBag instanceof IlvGraphic)) break;
                ilvGraphicBag = ((IlvGraphic)((Object)ilvGraphicBag)).getGraphicBag();
            }
            return false;
        }
        return ilvLinkImage.getGraphicBag() == this;
    }

    public void setCrossingAwareLinksFrozen(boolean bl) {
        this.f = bl;
    }

    public boolean isCrossingAwareLinksFrozen() {
        return this.f;
    }

    public void setVisibleBranch(IlvGraphic ilvGraphic, boolean bl, boolean bl2) {
        this.setVisibleBranch(ilvGraphic, 0, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleBranch(IlvGraphic ilvGraphic, int n, boolean bl, boolean bl2) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (!this.isNode(ilvGraphic)) {
                throw new IllegalArgumentException("node must be a node of this grapher");
            }
            this.setVisibleBranch(ilvGraphic, n, -1, bl, bl2, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleBranch(IlvGraphic ilvGraphic, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        IlvManager ilvManager = this.bm;
        synchronized (ilvManager) {
            if (IlvUtility.isOutside(this, ilvGraphic)) {
                throw new IllegalArgumentException("node must be nested inside this grapher");
            }
            IlvGraphic ilvGraphic2 = ilvGraphic;
            if (bl4 && !bl3) {
                ilvGraphic2 = this.i(ilvGraphic);
            }
            IlvGraphicVector ilvGraphicVector = new IlvGraphicVector(50);
            this.a(ilvGraphicVector, ilvGraphic, n2, bl2, bl3, bl4);
            IlvGraphic ilvGraphic3 = null;
            IlvGraphicEnumeration ilvGraphicEnumeration = null;
            IlvLinkImage ilvLinkImage = null;
            int n3 = ilvGraphicVector.size();
            for (int i = 0; i < n3; ++i) {
                IlvManager ilvManager2;
                ilvGraphic3 = ilvGraphicVector.elementAt(i);
                Integer n4 = (Integer)ilvGraphic3.getProperty(i);
                int n5 = n4;
                ilvGraphic3.setProperty(i, null);
                if (ilvGraphic3 == ilvGraphic || ilvGraphic3 == ilvGraphic2 || ilvGraphic3 instanceof IlvLinkImage || n5 <= n || n2 >= 0 && n5 >= n2) continue;
                IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphic3.getGraphicBag();
                ilvGrapher.setVisible(ilvGraphic3, bl, false);
                if (!ilvGrapher.isNode(ilvGraphic3)) continue;
                ilvGraphicEnumeration = ilvGrapher.getLinks(ilvGraphic3);
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                    if (bl && (!bl || !this.h(ilvLinkImage.getFrom()) || !this.h(ilvLinkImage.getTo()))) continue;
                    ilvManager2 = (IlvManager)ilvLinkImage.getGraphicBag();
                    ilvManager2.setVisible(ilvLinkImage, bl, false);
                }
                if (!(ilvGraphic3 instanceof IlvGrapher)) continue;
                ilvManager2 = (IlvGrapher)ilvGraphic3;
                ilvGraphicEnumeration = ((IlvGrapher)ilvManager2).getTreeExternalInterGraphLinks();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                    if (bl && (!bl || !this.h(ilvLinkImage.getFrom()) || !this.h(ilvLinkImage.getTo()))) continue;
                    IlvManager ilvManager3 = (IlvManager)ilvLinkImage.getGraphicBag();
                    ilvManager3.setVisible(ilvLinkImage, bl, false);
                }
            }
        }
    }

    private boolean h(IlvGraphic ilvGraphic) {
        while (ilvGraphic != null && ilvGraphic != this) {
            if (!ilvGraphic.isVisible()) {
                return false;
            }
            ilvGraphic = (IlvGraphic)((Object)ilvGraphic.getGraphicBag());
        }
        return true;
    }

    private IlvGraphic i(IlvGraphic ilvGraphic) {
        while (ilvGraphic != null && ilvGraphic != this) {
            if (ilvGraphic.getGraphicBag() == this) {
                return ilvGraphic;
            }
            ilvGraphic = (IlvGraphic)((Object)ilvGraphic.getGraphicBag());
        }
        return null;
    }

    private void a(IlvGraphicVector ilvGraphicVector, IlvGraphic ilvGraphic, int n, boolean bl, boolean bl2, boolean bl3) {
        IlvGraphic ilvGraphic2;
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        LinkedList<IlvGraphic> linkedList = new LinkedList<IlvGraphic>();
        ilvGraphicVector.addElement(ilvGraphic);
        ilvGraphic.setProperty(i, new Integer(0));
        linkedList.addLast(ilvGraphic);
        if (bl3 && !bl2 && (ilvGraphic2 = this.i(ilvGraphic)) != ilvGraphic) {
            ilvGraphicVector.addElement(ilvGraphic2);
            ilvGraphic2.setProperty(i, new Integer(0));
            linkedList.addLast(ilvGraphic2);
        }
        while (linkedList.size() > 0) {
            IlvGraphic ilvGraphic3;
            IlvLinkImage ilvLinkImage;
            IlvGraphicEnumeration ilvGraphicEnumeration;
            ilvGraphic = (IlvGraphic)linkedList.removeFirst();
            ilvGraphic2 = (IlvGrapher)ilvGraphic.getGraphicBag();
            Integer n2 = (Integer)ilvGraphic.getProperty(i);
            Integer n3 = new Integer(n2 + 1);
            int n4 = n3;
            IlvGraphicEnumeration ilvGraphicEnumeration2 = ilvGraphicEnumeration = bl ? ((IlvGrapher)ilvGraphic2).getLinksFrom(ilvGraphic) : ((IlvGrapher)ilvGraphic2).getLinksTo(ilvGraphic);
            while (ilvGraphicEnumeration.hasMoreElements()) {
                boolean bl4;
                ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                if (IlvUtility.isOutside(this, ilvLinkImage)) continue;
                IlvGraphic ilvGraphic4 = ilvGraphic3 = bl ? ilvLinkImage.getTo() : ilvLinkImage.getFrom();
                if (bl2) {
                    bl4 = true;
                    if (IlvUtility.isOutside(this, ilvGraphic3)) {
                        ilvGraphic3 = null;
                    }
                } else if (bl3) {
                    bl4 = true;
                    if (ilvGraphic3.getGraphicBag() != ilvGraphicBag) {
                        ilvGraphic3 = this.i(ilvGraphic3);
                    }
                } else {
                    boolean bl5 = bl4 = ilvLinkImage.getFrom().getGraphicBag() == ilvLinkImage.getTo().getGraphicBag();
                }
                if (!bl4) continue;
                if (ilvLinkImage.getProperty(i) != null) continue;
                ilvGraphicVector.addElement(ilvLinkImage);
                ilvLinkImage.setProperty(i, n2);
                if (ilvGraphic3 == null) continue;
                if (ilvGraphic3.getProperty(i) != null || n >= 0 && n4 >= n) continue;
                ilvGraphicVector.addElement(ilvGraphic3);
                ilvGraphic3.setProperty(i, n3);
                linkedList.addLast(ilvGraphic3);
            }
            if (!bl3 || !(ilvGraphic instanceof IlvGrapher)) continue;
            IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphic;
            ilvGraphicEnumeration = ilvGrapher.getTreeExternalInterGraphLinks();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                if (IlvUtility.isOutside(this, ilvLinkImage)) continue;
                if (bl) {
                    if (!IlvUtility.isOutside(ilvGrapher, ilvLinkImage.getTo())) continue;
                    ilvGraphic3 = ilvLinkImage.getTo();
                } else {
                    if (!IlvUtility.isOutside(ilvGrapher, ilvLinkImage.getFrom())) continue;
                    ilvGraphic3 = ilvLinkImage.getFrom();
                }
                if (bl2) {
                    if (IlvUtility.isOutside(this, ilvGraphic3)) {
                        ilvGraphic3 = null;
                    }
                } else {
                    ilvGraphic3 = this.i(ilvGraphic3);
                }
                if (ilvLinkImage.getProperty(i) != null) continue;
                ilvGraphicVector.addElement(ilvLinkImage);
                ilvLinkImage.setProperty(i, n2);
                if (ilvGraphic3 == null) continue;
                if (ilvGraphic3.getProperty(i) != null || n >= 0 && n4 >= n) continue;
                ilvGraphicVector.addElement(ilvGraphic3);
                ilvGraphic3.setProperty(i, n3);
                linkedList.addLast(ilvGraphic3);
            }
        }
    }

    private static final class IlvNeighborsEnumeration
    implements IlvGraphicEnumeration {
        private IlvGraphicEnumeration a;
        private IlvGraphic b;

        IlvNeighborsEnumeration(IlvGraphic ilvGraphic, IlvGraphicEnumeration ilvGraphicEnumeration) {
            this.b = ilvGraphic;
            this.a = ilvGraphicEnumeration;
        }

        @Override
        public final boolean hasMoreElements() {
            return this.a != null && this.a.hasMoreElements();
        }

        @Override
        public final IlvGraphic nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("IlvNeighborsEnumeration");
            }
            return ((IlvLinkImage)this.a.nextElement()).getOpposite(this.b);
        }
    }

    private static class LinkInfo {
        IlvGrapher a;
        int b;
        boolean c;
        boolean d;
        boolean e;
        boolean f;
        boolean g;

        LinkInfo(IlvLinkImage ilvLinkImage) {
            this.a = (IlvGrapher)ilvLinkImage.getGraphicBag();
            this.b = this.a.getLayer(ilvLinkImage);
            this.c = this.a.isMovable(ilvLinkImage);
            this.e = this.a.isEditable(ilvLinkImage);
            this.f = this.a.isSelectable(ilvLinkImage);
            this.d = this.a.isSelected(ilvLinkImage);
            this.g = ilvLinkImage.isVisible();
        }
    }
}

