/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.util.collections.IlvCollections;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class IlvGraphicVector
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8015494179570726991L;
    private static final int a = 10;
    private static final int b = 0;
    private static final String c = "Location of recent modification";
    private static final String d = "The IlvGraphicVector was modified while enumerating its contents. If you are using multiple threads, probably some synchronization is missing. Synchronize adding, removing, accessing and enumerating over elements.\n If you are using only a single thread, probably some objects were added or removed while enumerating over elements. In this case consider using ilog.views.IlvBufferedGraphicEnumeration.\n To debug this situation, check the cause of the exception in the stack trace.";
    private static final String e = "The IlvGraphicVector was modified while enumerating its contents. If you are using multiple threads, probably some synchronization is missing. Synchronize adding, removing, accessing and enumerating over elements.\n If you are using only a single thread, probably some objects were added or removed while enumerating over elements. In this case consider using ilog.views.IlvBufferedGraphicEnumeration.\n To debug this situation, set the static flag ilog.views.IlvGraphicVector.DEBUG to true and check the stack trace.";
    protected int capacityIncrement = 0;
    public static boolean checkConcurrentModification = true;
    public static boolean DEBUG;
    protected int elementCount;
    protected IlvGraphic[] elementData;
    transient int f = 0;
    private transient Exception g = null;

    public IlvGraphicVector() {
        this(10, 0);
    }

    public IlvGraphicVector(int n) {
        this(n, 0);
    }

    public IlvGraphicVector(int n, int n2) {
        this.capacityIncrement = n2;
        this.f = 0;
        this.elementData = new IlvGraphic[n];
        this.elementCount = 0;
    }

    final void a(Comparator<? super IlvGraphic> comparator) {
        Arrays.sort(this.elementData, 0, this.elementCount, comparator);
        this.a();
    }

    public final boolean contains(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic, 0) != -1;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean removeElement(IlvGraphic ilvGraphic) {
        int n = this.indexOf(ilvGraphic, 0);
        if (n == -1) {
            return false;
        }
        this.removeElementAt(n);
        this.a();
        return true;
    }

    public IlvGraphic elementAt(int n) {
        if (n < this.elementCount) {
            return this.elementData[n];
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public IlvGraphicEnumeration elements() {
        return new IlvGraphicEnumeration(){
            int a = 0;
            int b;
            {
                this.b = IlvGraphicVector.this.f;
            }

            @Override
            public boolean hasMoreElements() {
                return this.a < IlvGraphicVector.this.elementCount;
            }

            @Override
            public IlvGraphic nextElement() {
                IlvGraphicVector.this.a(this.b);
                if (this.a < IlvGraphicVector.this.elementCount) {
                    return IlvGraphicVector.this.elementData[this.a++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public final IlvGraphic firstElement() {
        if (this.elementCount > 0) {
            return this.elementData[0];
        }
        throw new NoSuchElementException();
    }

    public final IlvGraphic lastElement() {
        try {
            return this.elementData[this.elementCount - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    public final IlvGraphic setElementAt(IlvGraphic ilvGraphic, int n) {
        if (n < this.elementCount) {
            IlvGraphic ilvGraphic2 = this.elementData[n];
            this.elementData[n] = ilvGraphic;
            this.a();
            return ilvGraphic2;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public int indexOf(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic, 0);
    }

    public final int indexOf(IlvGraphic ilvGraphic, int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ilvGraphic != null) {
            for (int i = n; i < this.elementCount; ++i) {
                if (!ilvGraphic.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public final int lastIndexOf(IlvGraphic ilvGraphic) {
        return this.lastIndexOf(ilvGraphic, this.elementCount - 1);
    }

    public final int lastIndexOf(IlvGraphic ilvGraphic, int n) {
        if (n < this.elementCount) {
            if (ilvGraphic != null) {
                for (int i = n; i >= 0; --i) {
                    if (!ilvGraphic.equals(this.elementData[i])) continue;
                    return i;
                }
            } else {
                for (int i = n; i >= 0; --i) {
                    if (this.elementData[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public final int size() {
        return this.elementCount;
    }

    public final String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int n = this.elementCount - 1;
        StringBuffer stringBuffer = new StringBuffer(this.elementCount * 16);
        stringBuffer.append('[');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.elementData[i].toString());
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.elementData[n].toString());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void addElement(IlvGraphic ilvGraphic) {
        if (this.elementCount == this.elementData.length) {
            this.b();
        }
        this.elementData[this.elementCount++] = ilvGraphic;
        this.a();
    }

    public final void copyInto(IlvGraphic[] ilvGraphicArray) {
        if (ilvGraphicArray.length < this.elementCount) {
            throw new ArrayIndexOutOfBoundsException("Array parameter must hold at least " + this.elementCount + " elements.");
        }
        System.arraycopy(this.elementData, 0, ilvGraphicArray, 0, this.elementCount);
    }

    public void ensureCapacity(int n) {
        int n2 = this.f;
        if (this.elementData.length < n) {
            int n3;
            int n4;
            for (n3 = this.elementData.length; n3 < n; n3 += n4) {
                n4 = (int)Math.ceil((double)n3 * 0.5);
                if (n4 > 1) continue;
                n4 = 1;
            }
            this.b(n3);
        }
        this.a(n2);
    }

    public void insertElementAt(IlvGraphic ilvGraphic, int n) {
        if (0 <= n && n <= this.elementCount) {
            int n2;
            if (this.elementCount == this.elementData.length) {
                this.b();
            }
            if ((n2 = this.elementCount - n) > 0) {
                System.arraycopy(this.elementData, n, this.elementData, n + 1, n2);
            }
            this.elementData[n] = ilvGraphic;
            ++this.elementCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.a();
    }

    public final void removeAllElements() {
        Arrays.fill(this.elementData, 0, this.elementCount, null);
        this.elementCount = 0;
        this.a();
    }

    public void removeElementAt(int n) {
        if (0 <= n && n < this.elementCount) {
            --this.elementCount;
            int n2 = this.elementCount - n;
            if (n2 > 0) {
                System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.elementData[this.elementCount] = null;
        this.a();
    }

    public final void setSize(int n) {
        if (n == this.elementData.length) {
            return;
        }
        this.b(n);
    }

    public final void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.b(this.elementCount);
        }
    }

    public Object clone() {
        IlvGraphicVector ilvGraphicVector = new IlvGraphicVector(this.elementData.length, this.capacityIncrement);
        ilvGraphicVector.elementData = (IlvGraphic[])this.elementData.clone();
        ilvGraphicVector.elementCount = this.elementCount;
        return ilvGraphicVector;
    }

    final void a() {
        ++this.f;
        if (DEBUG) {
            this.g = new Exception(c);
        }
    }

    final void a(int n) {
        if (checkConcurrentModification && this.f != n) {
            String string = e;
            if (DEBUG) {
                string = d;
            }
            throw IlvCollections.concurrentModificationException(string, this.g);
        }
    }

    private void b() {
        int n = 0;
        n = this.capacityIncrement <= 0 ? (int)((double)this.elementData.length * 0.5) : this.capacityIncrement;
        if (n < 1) {
            n = 1;
        }
        this.b(this.elementData.length + n);
    }

    private void b(int n) {
        Object[] objectArray = new IlvGraphic[n];
        int n2 = Math.min(n, this.elementCount);
        System.arraycopy(this.elementData, 0, objectArray, 0, n2);
        if (n > this.elementCount) {
            Arrays.fill(objectArray, this.elementCount, n, null);
        }
        this.elementCount = n2;
        this.elementData = objectArray;
    }
}

